<?php if($this->permission->method('policies_add', 'create')->access()): ?>
<div class="form-group text-right">
    <a class="btn btn-success" href="<?= base_url() ?>incident/policies/add" role="button"><i class="fa fa-plus"
            aria-hidden="true"></i> Add Policy</a>
</div>
<?php endif?>
<div class="container-fluid">
    <table class="table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>Title</th>
                <th>Updated By</th>
                <th>Updated At</th>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/ckeditor.js"></script>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/adapters/jquery.js"></script>
<script>
    $(document).ready(function () {
        $("select").selectize();
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    beforeSend: function(){},
                    complete: function(){}
                },
                columns: [{
                        'data': 'id',
                    }, {
                        'data': 'title',
                    },
                    {
                        'data': 'updated_by',
                    }, {
                        'data': 'updated_at',
                    },
                    {
                        'data': 'action',
                        'sortable': false
                    },
                ],
                order: [
                    [0, 'asc']
                ]
            }
        ))
        $('#modalprintdiv').on('submit', 'form', function (e) {
            e.preventDefault()
            $form = $(this)
            divId = $form.find('select#selDiv').val();
            empId = $form.find('select#selEmp').val();
            elId = $form.find('input#id').val();
            $('body').append(
                `<iframe src="<?= base_url('incident/policies/print/') ?>${elId}/${divId}/${empId}" style="display:none" frameborder="0" onload="mycunasd(this)"></iframe>`
                );
            $form.trigger('reset')
            $form.find('select#selDiv').val('')
            $form.find('select#selEmp').val('')
            show_spinner()
        })
        $('#modalmaildiv').on('change', '#selDiv', function (e) {
            if (!this.value) {
                return
            }
            $sel = $(this)
            $modal = $('#modalmaildiv')
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/policies/get_div_from",
                data: {
                    id: this.value
                },
                beforeSend: function () {
                    $modal.find('.error').remove()
                },
                success: function (res) {
                    if (res.success) {
                        $modal.find('[name=efrom]').val(res.success.email_from)
                    } else if (res.error) {
                        $sel.closest('div').append(
                            `<span class="error" style="color:red">${res.error}</span>`)
                    } else {
                        alert('Unable to get division email setup');
                        console.log(res);
                    }
                }
            });
        })
        $('#modalmaildiv').on('change', '#selEmTemp', function (e) {
            if (!this.value) {
                return
            }
            $sel = $(this)
            $modal = $('#modalmaildiv')
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/policies/get_email_template",
                data: {
                    id: this.value
                },
                beforeSend: function () {
                    $modal.find('.error').remove()
                },
                success: function (res) {
                    if (res.success) {
                        $modal.find('[name=subject]').val(res.success.subject)
                        $modal.find('[name=body]').val(res.success.body)
                    } else if (res.error) {
                        $sel.closest('div').append(
                            `<span class="error" style="color:red">${res.error}</span>`)
                    } else {
                        alert('Unable to get email template');
                        console.log(res);
                    }
                }
            });
        })
        $('#modalmaildiv').on('submit', 'form', function (e) {
            e.preventDefault()
            $form = $(this)
            $modal = $('#modalmaildiv')
            if($form.find('[name=cc]').val() && !validateEmails($form.find('[name=cc]').val())){
                $form.find('[name=cc]').focus();
                alert('The \'CC\' field must have valid emails');return
            }
            if($form.find('[name=bcc]').val() && !validateEmails($form.find('[name=bcc]').val())){
                $form.find('[name=bcc]').focus();
                alert('The \'BCC\' field must have valid emails');return
            }
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/policies/send_email",
                data: $(this).serialize(),
                success: function (res) {
                    if (res.success) {
                        $modal.modal('hide')
                        alert(res.success)
                    }else if(res.errors){
                        res.errors.forEach(err => {
                            $form.find(`[name=${err[0]}]`).closest('div').append(`<span class="error" style="color:red">${err[1]}</span>`)
                        });
                    } else if (res.error) {
                        alert(res.error)
                    } else {
                        console.log(res);
                        alert('Unknown error, try again')
                    }
                }
            });
        })
    });

    function mycunasd(iframe) {
        iframe.focus()
        iframe.contentWindow.print();
        $('#modalprintdiv').modal('hide')
        hide_spinner()
    }
    $('table.table').on('click', '.btnprint', function (e) {
        e.preventDefault()
        $modal = $('#modalprintdiv')
        $modal.find('input#id').val($(this).data('id'))
        $modal.find('select#selDiv')[0].selectize.setValue('');
        $modal.find('select#selEmp')[0].selectize.setValue('');
        $modal.modal('show')
    })
    $('table.table').on('click', '.btnemail', function (e) {
        e.preventDefault()
        $modal = $('#modalmaildiv')
        $modal.find('form').trigger('reset')
        $modal.find('select#selDiv')[0].selectize.setValue('');
        $modal.find('select#selEmp')[0].selectize.setValue('');
        $modal.find('select#selEmTemp')[0].selectize.setValue('');
        $modal.find('textarea').val('')
        $modal.find('input#id').val($(this).data('id'))
        $modal.modal('show')
        $modal.find('textarea.editor').ckeditor();
    })
</script>
<div class="modal fade" id="modalprintdiv" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Select Options</h4>
            </div>
            <form method="post">
                <input type="hidden" id="id" value="">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="selDiv">Division</label>
                        <select class="form-control dont-select-me" name="division" id="selDiv" style="width: 100%;" required>
                            <option value="">Select One</option>
                            <?php foreach ($divisions as $division) :?>
                            <option value="<?= $division->id ?>"><?= $division->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="selEmp">Employee</label>
                        <select class="form-control dont-select-me" name="employee_id" id="selEmp" style="width: 100%;" required>
                            <option value="">Select One</option>
                            <?php foreach ($employees as $employee) :?>
                            <option value="<?= $employee->employee_id ?>"><?= $employee->first_name ?> <?= $employee->last_name ?> (<?= $employee->hrm_id ?>)</option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="modalmaildiv" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Prepare Email</h4>
            </div>
            <form method="post">
                <input type="hidden" name="policy_id" id="id" value="">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="selDiv">Division</label>
                        <select class="form-control dont-select-me" name="division" id="selDiv" style="width: 100%;" required>
                            <option value="">Select One</option>
                            <?php foreach ($divisions as $division) :?>
                            <option value="<?= $division->id ?>"><?= $division->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="selEmp">To</label>
                        <select class="form-control dont-select-me" name="employee_id" id="selEmp" style="width: 100%;" required>
                            <option value="">Select One</option>
                            <?php foreach ($employees as $employee) :?>
                                <option value="<?= $employee->employee_id ?>"><?= $employee->first_name ?> <?= $employee->last_name ?> (<?= $employee->hrm_id ?>)</option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="emFrom">From</label>
                        <input type="text" class="form-control" name="efrom" id="emFrom" required readonly>
                    </div>
                    <div class="form-group">
                        <label for="emCC">CC <small>(Comma-separated emails)</small></label>
                        <input type="text" class="form-control" name="cc" id="emCC">
                    </div>
                    <div class="form-group">
                        <label for="emBCC">BCC <small>(Comma-separated emails)</small></label>
                        <input type="text" class="form-control" name="bcc" id="emBCC">
                    </div>
                    <div class="form-group">
                        <label for="selEmTemp">Email Template</label>
                        <select class="form-control dont-select-me" name="email" id="selEmTemp" style="width: 100%;">
                            <option value="">Select One</option>
                            <?php foreach ($email_templates as $em_template) :?>
                            <option value="<?= $em_template->id ?>"><?= $em_template->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="emSubject">Subject</label>
                        <input type="text" class="form-control" name="subject" id="emSubject" required>
                    </div>
                    <div class="form-group">
                        <label for="txtBody">Body</label>
                        <textarea class="form-control editor" name="body" id="txtBody" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Send</button>
                </div>
            </form>
        </div>
    </div>
</div>