<style>
    .ck-editor__editable {
        min-height: 500px;
    }

    .mce-tinymce.mce-fullscreen {
        z-index: 9999;
    }

    .mce-tinymce button {
        background-color: #fff;
        color: #000;
    }

    .mce-btn.mce-active button,
    .mce-btn.mce-active:hover button,
    .mce-btn.mce-active i,
    .mce-btn.mce-active:hover i {
        color: #000;
    }
    ul#sortable{
        list-style: none;
    }
    ul#sortable .del-item{
        position: absolute;
        right: 25px;
    }
    ul#sortable .fa-arrows{
        cursor: pointer;
        margin-right: 10px;
    }
</style>
<div class="container-fluid">
    <form method="post">
        <div class="form-group">
            <label for="txtTitle">Title</label>
            <input type="text" name="title" id="txtTitle" class="form-control" placeholder="Letter title"
                value="<?= first_or_second($after_submit, set_value('title'), $letter->title) ?>">
        </div>
        <div class="form-group">
            <label for="selAuthor">Author Type</label>
            <select class="form-control dont-select-me" name="author_type" id="selAuthor" required>
                <option
                    <?= strtolower(first_or_second($after_submit, set_value('author_type'), $letter->author_type)) == 'hr' ? 'selected' : null ?>>
                    HR</option>
                <option
                    <?= strtolower(first_or_second($after_submit, set_value('author_type'), $letter->author_type)) == 'manager' ? 'selected' : null ?>>
                    Manager</option>
            </select>
        </div>
        <div class="form-group">
            <label for="txtFooterNote">Footer Note</label>
            <input type="text" class="form-control" name="footer_note" id="txtFooterNote" placeholder="Footer note" maxlength="145" value="<?= first_or_second($after_submit, set_value('footer_note'), $letter->footer_note) ?>">
            <small id="helpId" class="form-text text-muted">Leave empty to hide footer note</small>
        </div>
        <div class="form-check">
            <label class="form-check-label">
                <input type="checkbox" class="form-check-input" name="requires_admin_approval" value="1"
                    <?= first_or_second($after_submit, set_value('requires_admin_approval'), $letter->requires_admin_approval) == 1 ? 'checked' : null ?>>
                HR Manager Approval Required
            </label>
        </div>
        <br>
        <div class="form-group">
            <label>Questions</label> <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modelQuestions" style="margin: 10px"><i class="fa fa-plus" aria-hidden="true"></i> Add Question</button>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Tag</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="questions-body">
                    <?php foreach ($letter->input_structure as $question) :?>
                        <script>
                            if(!window.questions_list){
                                window.questions_list = []
                            }
                            window.questions_list.push(JSON.parse('<?= addslashes(json_encode($question)) ?>'))
                        </script>
                        <tr id="rr<?= bin2hex(random_bytes(5)) ?>">
                            <input type="hidden" name="question[]" value="<?= base64_encode(json_encode($question)) ?>">
                            <td class="title">
                                <?= $question['title'] ?>
                            </td>
                            <td class="slug" data-slug="<?= $question['name'] ?>">
                                {{input:<?= $question['name'] ?>}}
                            </td>
                            <td>
                                <button type="button" class="btn btn-primary btn-edit"><i class="fa fa-pencil" aria-hidden="true"></i></button>
                                <button type="button" class="btn btn-danger btn-remove"><i class="fa fa-trash" aria-hidden="true"></i></button>
                            </td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
            </table>
        </div>
        <div class="form-group">
            <label for="txtBody">Letter Body</label>
            <textarea class="form-control editor" name="body" id="txtBody"
                rows="15"><?= first_or_second($after_submit, set_value('body'), $letter->body) ?></textarea>
        </div>
        <div class="row pull-right">
            <div class="form-group">
                <button type="submit" class="btn btn-primary" style="margin-right: 15px;">Update</button>
            </div>
        </div>
    </form>
</div>
<script>
    $(document).ready(function () {
        $("select:not(.no-seletize)").selectize();
    });
</script>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/tinymce.php') ?>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/questions-modal.php') ?>