<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Letter extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('letter_model');
        $this->load->library('doc_reader');
    }
    public function all()
    {
        $this->permission->method('letters_list', 'read')->redirect();
        $data['title'] = 'Letters';
        $data['module'] = 'incident';
        $data['page'] = 'letter/list';
        $data['letters'] = $this->letter_model->get_all_letters();
        echo Modules::run('template/layout', $data);
    }
    public function add()
    {
        $this->permission->method('letters_add', 'create')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'trim|strip_tags|required|min_length[3]|max_length[255]',
                ),
                array(
                    'field' => 'footer_note',
                    'label' => 'Footer Note',
                    'rules' => 'trim|strip_tags|max_length[145]',
                ),
                array(
                    'field' => 'body',
                    'label' => 'Body',
                    'rules' => 'required',
                ),
                array(
                    'field' => 'author_type',
                    'label' => 'Author Type',
                    'rules' => 'trim|required|in_list[HR,Manager]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->letter_model->add($this->input->post())) {
                    $this->session->set_flashdata('success', 'Letter added successfully');
                } else {
                    $this->session->set_flashdata('exception', 'Unable to add letter, try again later');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Add Letter';
        $data['module'] = 'incident';
        $data['full_suggestions'] = $this->letter_model->get_tag_suggestions();
        $data['tables'] = $this->letter_model->get_table_names();
        $data['page'] = 'letter/add';
        echo Modules::run('template/layout', $data);
    }
    public function update($id)
    {
        $this->permission->method('letters_list', 'update')->redirect();
        $after_submit = false;
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'trim|strip_tags|required|min_length[3]|max_length[255]',
                ),
                array(
                    'field' => 'footer_note',
                    'label' => 'Footer Note',
                    'rules' => 'trim|strip_tags|max_length[145]',
                ),
                array(
                    'field' => 'body',
                    'label' => 'Body',
                    'rules' => 'required',
                ),
                array(
                    'field' => 'author_type',
                    'label' => 'Author Type',
                    'rules' => 'trim|required|in_list[HR,Manager]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->letter_model->update($id, $this->input->post())) {
                    $this->session->set_flashdata('success', 'Letter updated successfully');
                    redirect($_SERVER['HTTP_REFERER']);
                } else {
                    $this->session->set_flashdata('exception', 'Unable to save letter, try again later');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
        }
        $data['title'] = 'Update Letter';
        $data['module'] = 'incident';
        $data['tables'] = $this->letter_model->get_table_names();
        $data['full_suggestions'] = $this->letter_model->get_tag_suggestions();
        $data['page'] = 'letter/update';
        $data['after_submit'] = $after_submit;
        $data['letter'] = $this->letter_model->get_letter($id);
        if (!$data['letter']) {
            $this->session->set_flashdata('exception', 'Letter not found / Incorrect letter ID');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['letter']->input_structure = json_decode($data['letter']->input_structure, true);
        echo Modules::run('template/layout', $data);
    }
    public function delete($id)
    {
        $this->permission->method('letters_list', 'delete')->redirect();
        if ($id) {
            if ($this->letter_model->delete($id)) {
                $this->session->set_flashdata('success', 'Letter deleted successfully');
            } else {
                $this->session->set_flashdata('exception', 'Unable to delete letter, try again');
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->session->set_flashdata('exception', 'Unable to delete letter, try again');
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function settings($type)
    {
        $data['type_prefix'] = $type == strtolower('hr') ? 'hr' : 'manager';
        if ($this->input->post()) {
            if (($data['type_prefix'] == 'hr' && !$this->permission->method('pdf_settings', 'update')->access()) || ($data['type_prefix'] == 'manager' && !$this->permission->method('manager_pdf_settings', 'update')->access())) {
                redirect();
            }
            $rules_config = array(
                array(
                    'field' => $data['type_prefix'] . '_page_size',
                    'label' => 'Page Size',
                    'rules' => 'required',
                ),
                array(
                    'field' => $data['type_prefix'] . '_orientation',
                    'label' => 'Orientation',
                    'rules' => 'required',
                ),
                array(
                    'field' => $data['type_prefix'] . '_font_style',
                    'label' => 'Font Family',
                    'rules' => 'required',
                ),
                array(
                    'field' => $data['type_prefix'] . '_font_size',
                    'label' => 'Font Size',
                    'rules' => 'trim|required|greater_than_equal_to[1]|less_than_equal_to[72]',
                ),
                array(
                    'field' => $data['type_prefix'] . '_margin_top',
                    'label' => 'Margin Top',
                    'rules' => 'trim|required|numeric',
                ),
                array(
                    'field' => $data['type_prefix'] . '_margin_bottom',
                    'label' => 'Margin Bottom',
                    'rules' => 'trim|required|numeric',
                ),
                array(
                    'field' => $data['type_prefix'] . '_margin_left',
                    'label' => 'Margin Left',
                    'rules' => 'trim|required|numeric',
                ),
                array(
                    'field' => $data['type_prefix'] . '_margin_right',
                    'label' => 'Margin Right',
                    'rules' => 'trim|required|numeric',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->letter_model->save_settings($this->input->post())) {
                    $this->session->set_flashdata('success', 'PDF Settings saved successfully!');
                } else {
                    $this->session->set_flashdata('exception', 'Unable to save PDF Settings, try again later!');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        if (($data['type_prefix'] == 'hr' && !$this->permission->method('pdf_settings', 'read')->access()) || ($data['type_prefix'] == 'manager' && !$this->permission->method('manager_pdf_settings', 'read')->access())) {
            redirect();
        }
        $data['title'] = ucwords($data['type_prefix']) . ' Letter PDF Settings';
        $data['module'] = 'incident';
        $data['page'] = 'print/settings';
        $data['settings'] = $this->letter_model->get_tcpdf_settings();
        $data['img_path'] = $this->letter_model->get_image_path();
        $data['page_sizes'] = $this->letter_model->get_page_sizes();
        $data['divisions'] = getByWhere('divisions', 'id,name,prefix', [], ['name', 'ASC']);
        echo Modules::run('template/layout', $data);
    }
    public function removebg($key)
    {
        if ($this->letter_model->remove_setting($key)) {
            $this->session->set_flashdata('success', 'Background image removed successfully.');
        } else {
            $this->session->set_flashdata('exception', 'Unable to remove background image, try again.');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function test($id)
    {
        $this->letter_model->test($id);
    }
    public function get_columns()
    {
        if ($this->input->post('table_name') && $this->input->is_ajax_request()) {
            $fields = $this->letter_model->get_table_fields($this->input->post('table_name'));
            if ($fields) {
                sendJson(['success' => $fields]);
            }
            sendJson(['error' => 'No fields found']);
        }
    }
}
