<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hr_policy extends Loggedin_Controller {
  protected $method;
  public function __construct(){
		parent::__construct();
		$this->load->model(array(
			'Hr_policy_model'
		));	
		 $this->method = $this->uri->segment(3);	 
	}
	
  public function policy_methods($table){
      $hr_policy = $this->Hr_policy_model->policy_list($table);
      $data['title']    = display($table);
      $data['hr_policy'] = $hr_policy;
      $data['module']   = "hr_policy";
      $data['page']     = $table;   
      echo Modules::run('template/layout', $data); 

  }	
  public function employee_handbook(){
  
      $data['title']    = "handbook";
      $data['module']   = "hr_policy";
      $data['page']     = 'employee_handbook';   
      echo Modules::run('template/layout', $data); 
  }
  public function general_policy($id=null){
    if(isset($id)){
       $hr_policy = $this->Hr_policy_model->policy_list('general_policy',$id);
       echo json_encode($hr_policy);
    }else{
      return $this->policy_methods('general_policy');
    }
  }
  
  public function update_general_policy($id=null){
    $this->form_validation->set_rules('date','Date'  ,'required');
    $this->form_validation->set_rules('category','Category'  ,'required');
    $this->form_validation->set_rules('template','Text'  ,'required');
        $post = $this->input->post();
        $return = 0;
         $table            = $post['table'];
        if ($this->form_validation->run() === true) {
          $return           = 1;
          $data['date']     =  date("Y-m-d", strtotime($post['date']));
          $data['category'] = $post['category'];
          $data['text']     = $post['template'];
         
            if(isset($id)){
                $updateData = $this->db->where('id',$id)->update($table,$data);
            }else{
                $data['created_on'] = date('Y-m-d');
                $data['created_by'] = $this->session->userdata('id');   
                $updateData = $this->db->insert($table,$data);
            }
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Data Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/hr_policy/Hr_policy/$table");

        }else{
               $this->session->set_flashdata('exception',  display('please_try_again'));
             redirect("/hr_policy/Hr_policy/$table");
        }
    }


  public function social_media_policy($id = null){
    if(isset($id)){
       $hr_policy = $this->Hr_policy_model->policy_list('social_media_policy',$id);
       echo json_encode($hr_policy);
    }else{
      return $this->policy_methods('social_media_policy');
    }
  }
  
  public function compensation_benefits($id = null){
    if(isset($id)){
       $hr_policy = $this->Hr_policy_model->policy_list('compensation_benefits',$id);
       echo json_encode($hr_policy);
    }else{
      return $this->policy_methods('compensation_benefits');
    }
  }

  public function delete($table,$id){
        $this->db->where('id',$id)->delete($table);   
        $this->session->set_flashdata('message', "Data Deleted Successfully!");
        redirect("/hr_policy/Hr_policy/$table");
  }

   
}
