<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Temp_model extends CI_Model {
 
	private $table = "template_category";
	// private $table2 = "document_template";

	public function create($data,$tble_name=null)
	{	 
		if (isset($tble_name)) {
			$table_name = $tble_name;
			$this->activity->set_url('dashboard/temp/templates')->log([
				'document_template_inserted',
				$data['name']
			]);
		}else{
			$table_name = $this->table;
			$this->activity->set_url('dashboard/temp/category')->log([
				'temp_category_inserted',
				$data['name']
			]);
		}
		return $this->db->insert($table_name,$data);
	}
	public function create_email_settings($data,$tble_name= 'email_templates')
	{	 
		$table_name = $tble_name;
		$this->activity
		->set_url('dashboard/Email_settings/email_templates')
		->set_division($data['division_id'])
		->log('email_settings_inserted');
		return $this->db->insert($table_name,$data);
	}
 
	public function read($id=null)
	{
		$this->db->select("*")
			->from($this->table);
			if(isset($id)){
				$this->db->where('id',$id);
			}
		return 	$this->db->get()
			->result();
	} 

	public function match_category($name,$id){
		return $this->db->where('name',$name)
						->where('id != ',$id)
		->get($this->table)->result();
	}

	
  	public function update($id,$data,$tble_name=null)
	{
		if (isset($tble_name)) {
			$table_name = $tble_name;
			$this->activity->set_url('dashboard/temp/templates')->log([
				'document_template_updated',
				$data['name'],
				$id
			]);
		}else{
			$table_name = $this->table;
			$this->activity->set_url('dashboard/temp/category')->log([
				'temp_category_updated',
				$data['name'],
				$id
			]);
		}

		return $this->db->where('id',$id)->update($table_name,$data); 	
	
		
	} 
	
  	public function update_email_settings($id,$data,$tble_name= 'email_templates')
	{
		$table_name = $tble_name;
		
		$this->activity
		->set_url('dashboard/Email_settings/email_templates')
		->set_division($data['division_id'])
		->log('email_settings_updated');
		return $this->db->where('id',$id)->update($table_name,$data); 	
	
		
	} 
	
	
	public function delete($id,$tble_name=null){
		$chck = 0;
		if (isset($tble_name)) {
			$table_name = $tble_name;
			$rec = $this->db->where('id', $id)->get($table_name)->row();
			$this->activity->set_url('dashboard/temp/templates')->log([
				'document_template_deleted',
				$rec->name,
				$id
			]);
		}else{
			$table_name = $this->table;
			$rec = $this->db->where('id', $id)->get($table_name)->row();
			$this->activity->set_url('dashboard/temp/category')->log([
				'temp_category_deleted',
				$rec->name,
				$id
			]);
		}
		if($chck == 0){
		  return $this->db->where('id',$id)->delete($table_name);	
			
		}
		return null;
		
	}
	
	public function delete_email_settings($id,$tble_name= 'email_templates'){
		$table_name = $tble_name;
		$email_rec = $this->db->where('id', $id)->get($table_name)->row();
		
		$this->activity
		->set_url('dashboard/Email_settings/email_templates')
		->set_division($email_rec->division_id)
		->log('email_settings_deleted');
		return $this->db->where('id',$id)->delete($table_name);	
	}


	public function template_read($id=null)
	{
		$this->db->select("template_category.id as category_id,template_category.name as category, divisions.name as division,document_template.*")
			->from('document_template');
			$this->db->join('template_category','template_category.id=document_template.category_id');
			$this->db->join('divisions','divisions.id=document_template.division_id', 'left');
			if(isset($id)){
				$this->db->where('document_template.id',$id);
			}
		return 	$this->db->get()->result();
	} 



	public function email_template($id=null)
	{
		$this->db->select('divisions.id dv_id,divisions.name dv_name, et.id, et.division_id, et.isSMTP, et.username, et.host, et.port, et.email_from, et.email_hr');
		$this->db->join('divisions','et.division_id=divisions.id');
		if(isset($id)){
			$this->db->where('et.id',$id);	
		}
		return 	$this->db->get('email_templates et')->result();
	} 



}
