<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Cron extends MY_Controller
{
    private function Email()
    {
        $email_recs = $this->db->where(['status !=' => 'sent', 'retries <=' => 5])
            ->order_by('updated_at', 'asc')
            ->limit(20)->get('email_queue')->result();
        $total_emails = count($email_recs);
        $this->log(sprintf('Found %s emails queued', $total_emails), 'Email');
        if (!$email_recs) {
            return true;
        }
        $sent_emails = 0;
        $this->load->library(['TemplateMailer' => 'mailer']);
        foreach ($email_recs as $email_rec) {
            $email_rec->content = json_decode($email_rec->content, true);
            $update_rec = ['updated_at' => date('Y-m-d H:i:s')];
            if ($this->mailer->config($email_rec->division_id)->__send(explode(',', $email_rec->eto), $email_rec->efrom, $email_rec->subject, $email_rec->content['body'], explode(',', $email_rec->content['cc']), explode(',', $email_rec->content['bcc']), json_decode($email_rec->content['attachments'], true))) {
                $update_rec['status'] = 'sent';
                $sent_emails++;
            } else {
                $update_rec['status'] = 'failed';
                $update_rec['retries'] = $email_rec->retries + 1;
                $update_rec['total_retries'] = $email_rec->total_retries + 1;
            }
            $this->db->where('id', $email_rec->id)->update('email_queue', $update_rec);
        }
        $this->log(sprintf('%s/%s emails sent', $sent_emails, $total_emails), 'Email');
        return true;
    }
    private function Probation_notification()
    {
        $this->load->model(['Employee/Employees_model', 'department/department_model']);
        $this->load->library(['TemplateMailer' => 'mailer']);
        $this->db->trans_start();
        $recs = $this->Employees_model->get_expiring_probations();
        foreach ($recs as $rec) {
            if(empty($rec->probation_period)){
                continue;
            }
            $division = $this->department_model->get_division($rec->division_id);
            $this->notify
                ->department('hr', $rec->division_id)
                ->employee($rec->super_visor_id)
                ->send(
                    sprintf('%s\'s (%s) probation is about to end on %s',
                        implode(' ', [$rec->first_name, $rec->last_name]),
                        $rec->hrm_id,
                        formatted_date($rec->expires_on)
                    ),
                    'employee/Employees/update_employee_form/' . $rec->employee_id
                );
            $manager_emails = $this->db->select('business_email')->where_in('employee_id', [
                $rec->super_visor_id,
                $rec->indirect_super_visor_id,
            ])
            ->where('status', 'active')->get('employee_history')->result();
            $manager_emails = array_column($manager_emails, 'business_email');
            $manager_emails = array_filter($manager_emails);
            $this->mailer->send_to_hr(
                $rec->division_id,
                sprintf('Probation Ending: %s (%s)',
                    implode(' ', [$rec->first_name, $rec->last_name]),
                    $rec->hrm_id,
                    formatted_date($rec->expires_on)
                ),
                $this->load->view('cron/probation_email', ['employee' => $rec, 'division' => $division], true),
                $manager_emails,
                [],
                true
            );
            $this->db->where('emp_his_id', $rec->emp_his_id)->update('employee_history', ['probation_notified' => 1]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    private function New_employee_joining()
    {
        $this->load->model(['employee/employees_model' => 'employee']);
        $employees = $this->employee->get_todays_joining();

        $this->db->trans_start();
        foreach ($employees as $employee) {
            $division = $this->department_model->get_division($employee->division_id);
            $this->notify
                ->department('hr', $employee->division_id)
                ->send(
                    sprintf('%s\'s (%s) is joining today',
                        implode(' ', [$employee->first_name, $employee->last_name]),
                        $employee->hrm_id
                    ),
                    'recruitment/hired/list'
                );
            $this->mailer->send_to_hr(
                $employee->division_id,
                sprintf('New Joining Today: %s (%s)',
                    implode(' ', [$employee->first_name, $employee->last_name]),
                    $employee->hrm_id,
                    formatted_date($employee->expires_on)
                ),
                $this->load->view('cron/joining_email', ['employee' => $employee, 'division' => $division], true),
                [],
                [],
                true
            );
            $this->db->where('emp_his_id', $employee->emp_his_id)->update('employee_history', ['joining_notified' => 1]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    /**
     * Write your functions above this line
     */
    public function __construct()
    {
        parent::__construct();

    }
    public function index()
    {
        /**
         * Prevent parallel running of cron
         */
        $this->start = microtime();
        $time = @file_get_contents(APPPATH . '/cronlock');
        if ($time && $time - time() < 1800) {
            $this->log(sprintf('---- Cron already started at %s. Exiting.', date('Y-m-d H:i:sO', $time)));exit;
        }
        file_put_contents(APPPATH . '/cronlock', time());

        $this->log('---- Cron initiated');
        $methods = get_class_methods($this);
        foreach ($methods as $method) {
            $time_start = microtime();
            if (in_array($method, $this->class_functions)) {
                continue;
            }
            try {
                if (call_user_func([$this, $method])) {
                    $this->log(sprintf('Success: %s execution successful. Took %s', $method, $this->readabletime($time_start)));
                } else {
                    $this->log(sprintf('Error: %s execution failed. Took %s', $method, $this->readabletime($time_start)));
                }
            } catch (\Throwable $e) {
                $this->log(sprintf('Exception: %s execution crashed. Took %s. Message: %s', $method, $this->readabletime($time_start), $e->getMessage()));
            }

        }
        $this->log('---- Cron ended. Took ' . $this->readabletime($this->start));
        unlink(APPPATH . '/cronlock');
    }
    public function compresslogs()
    {
        $path = APPPATH . 'logs';
        $folders = [
            'cron' => '%s.log',
            'logins' => '%s.log',
            'mail' => '%s.log',
            'php' => 'log-%s.log',
        ];
        $date_formats = [
            'cron' => 'Ymd',
            'logins' => 'Ymd',
            'mail' => 'Ymd',
            'php' => 'Y-m-d',
        ];
        foreach ($folders as $key => $filename) {
            $todays_filename = sprintf($filename, date($date_formats[$key]));
            $files = scandir(array_to_path([$path, $key]));
            if (!$files) {
                continue;
            }
            foreach ($files as $file) {
                if (in_array($file, ['.', '..', $todays_filename]) || !preg_match('@.log$@', $file)) {
                    continue;
                }
                $full_filename = array_to_path([$path, $key, $file]);
                if ($this->gzCompressFile($full_filename)) {
                    @unlink($full_filename);
                }
            }
        }
    }
    private $logpath = APPPATH . 'logs/cron/';
    private $class_functions = [
        '__construct',
        'index',
        'log',
        '__get',
        'readabletime',
        'gzCompressFile',
        'compresslogs',
    ];
    private $start;
    private function readabletime($time1, $time2 = null)
    {
        if (!$time2) {
            $time2 = microtime();
        }
        $res = $time2 - $time1;
        if ($res < 0) {
            return '0msec';
        } elseif ($res < 1000) {
            return number_format($res, 6) . 'msec';
        } elseif ($res >= 1000) {
            return number_format($res / 1000, 3) . 'sec';
        }
    }
    private function gzCompressFile($source, $level = 9)
    {
        $dest = $source . '.gz';
        $mode = 'wb' . $level;
        $error = false;
        if ($fp_out = gzopen($dest, $mode)) {
            if ($fp_in = fopen($source, 'rb')) {
                while (!feof($fp_in)) {
                    gzwrite($fp_out, fread($fp_in, 1024 * 512));
                }

                fclose($fp_in);
            } else {
                $error = true;
            }
            gzclose($fp_out);
        } else {
            $error = true;
        }
        if ($error) {
            return false;
        } else {
            return $dest;
        }

    }
    private function log($message, $method = 'Cron')
    {
        @file_put_contents(
            $this->logpath . date('Ymd') . '.log',
            sprintf('%s | %s | %s', date('H:i:sO'), $method, $message) . "\n",
            FILE_APPEND
        );
    }
}
