
<style type="text/css">
  .status.present {
    background: lightgreen;
    color: #000;
  }
  .status_col span {
    margin: 6px 0px
  }
  .status.absent {
    background: lightblue;
    color: #000;
  }

  .status.late {
    background: #d9d95d;
    color: #000;
  }
  .status.earlyout {
    background: #aa84ff;
    color: #000;
  }

  .status {
    padding: 5px;
    border-radius: 5px;
    width: 200px;
  }

  .leave_holiday {
    background: lightgray;
    color: #000;
  }

  .payroll_holiday {
    background: pink;
    color: #000000;
  }

  .weekend {
    background: lightgreen;
    color: #444;
  }
  input[type=submit] {
    margin-top: 5px;
  }
  input.datepicker {
    width: 100% !important;
  }
</style>
<div class="row">
  <div class="col-sm-12 col-md-12">
    <div class="panel">
      <div class="panel-heading">
        <div class="panel-title">
        </div>
      </div>
      <div class="panel-body">
        <?=form_open('', array('class' => 'form-inline', 'method' => 'get'))?>
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label for="employee_id"><?=display('emp_id')?>:</label>
                <?=form_dropdown('employee_id[]', $userlist, null, 'class="form-control" multiple id="employee_id" style="width:100%"')?>
              </div>
            </div>
            <?php $dates = month_first_last_day(); ?>
            <div class="col-md-4">
              <div class="form-group">
                <label for="start_date"><?=display('start_date')?> :</label>
                <input type="text" required name="start_date" value="<?=$start ?? formatted_date($dates['first']) ?>" class="datepicker form-control" />
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="end_date"><?=display('end_date')?> :</label>
                <input type="text" required class="datepicker form-control" name="end_date" value="<?=$end ?? formatted_date($dates['last'])?>" />
              </div>
            </div>
            <?php if(count($userlist) > 1) : ?>
            <div class="col-md-4">
                <div class="form-group">
                  <label for="dept_id">Department:</label>
                  <?=form_dropdown('dept_id[]', $departments, null, 'class="form-control" multiple id="dept_id" style="width:100%"')?>
                </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="supervisorid">Supervisor:</label>
                <?=form_dropdown('supervisorid[]', $supervisors, null, 'class="form-control" multiple id="supervisorid" style="width:100%"')?>
              </div>
            </div>
            <?php if($this->permission->module('show_inactive_employees')->access()): ?>
            <div class="col-md-4">
              <div class="form-group">
                <label for="status">Employee Status:</label>
                <?=form_dropdown('status', ['active_only' => 'Active Only', 'all' => 'All'], [$_GET['status'] ?? 'active_only'], 'class="form-control" id="status" style="width:100%" required')?>
              </div>
            </div>
            <?php endif?>
            <?php endif ?>
            <div class="col-md-12">
              <div class="form-group pull-right">
                <div>&nbsp;&nbsp;</div>
                <button type="submit" class="btn btn-success"><?=display('search')?></button>
              </div>
            </div>
          </div>
        </div>
        <div class="text-right" id="print" style="margin: 20px">
          <button type="submit" class="btn btn-primary" name="download" value="csv">Download CSV</button>
          <button type="submit" class="btn btn-primary" name="download" value="xlx">Download Excel</button>
          <button type="button" class="btn btn-warning" id="btnPrint"><i class="fa fa-print"></i>
          </button>
        </div>
        <?=form_close()?>
      </div>
    </div>
  </div>
  <!--  table area -->
<?php if($attendence_data) : ?>
  <div class="col-sm-12">
    <div class="panel panel-default thumbnail">
      <div class="panel-body" id="result_data">
        <?php
foreach ($attendence_data as $key => $user_attendence) {

    ?>
        <table width="100%" class="table table-striped table-bordered table-hover">
          <tr>
            <th colspan="7" class="text-center">Attendance History of <?=$user_attendence['firstname'] . ' ' . $user_attendence['lastname']?>
            </th>
          </tr>
          <tr>
            <th><?=display('sl')?></th>
            <th><?=display('employee_name')?></th>
            <th><?=display('in_time')?></th>
            <th><?=display('out_time')?></th>
            <th>Worked Hour</th>
            <th>Date</th>
            <th>Status</th>
            <?php
// $admin = $this->session->userdata('isAdmin');
    // if($admin == 1){
    ?>
            <!--<th class="hideexport"><?=display('action')?></th>-->
            <?php
// }
    ?>
          </tr>
          <?php
// if($countsDate >= 1){
    $user_total_seconds = 0;
    for ($k = 0; $k <= $days_selected; $k++) {
        $full_date = date('Y-m-d', strtotime('+' . $k . ' day', strtotime($start)));
        ?>
          <?php
$att_in = null;
        if (isset($user_attendence['attendence'][$full_date])) {
            $att_in = $user_attendence['attendence'][$full_date];
        }
        $Today = date('l', strtotime('+' . $k . ' day', strtotime($start)));

        $payroll_holiday = get_public_holiday($full_date, $user_attendence['shift']);

        ?>
          <tr>
            <td><?=$k + 1?></td>
            <td>
            <?=$user_attendence['firstname'] . ' ' . $user_attendence['lastname']?>
            </td>
            <td>
              <?php
if ($att_in && $att_in['punchin_time']) {
            echo formatted_date($att_in['punchin_time'], true);
        }
        ?>
            </td>
            <td>
              <?php
if ($att_in && $att_in['punchout_time']) {
            echo formatted_date($att_in['punchout_time'], true);
        }
        ?>
            </td>
            <td>
              <?php
if ($att_in && $att_in['duration']) {
            $sep_time = secondsToTime($att_in['duration']);
            if ($sep_time['hours']) {
                echo $sep_time['hours'] . ' hours, ';
            }
            if ($sep_time['minutes']) {
                echo $sep_time['minutes'] . ' minutes, ';
            }
            if ($sep_time['seconds']) {
                echo $sep_time['seconds'] . ' seconds';
            }
            $total_seconds += $att_in['duration'];
            $user_total_seconds += $att_in['duration'];
        }
        ?>
            </td>
            <td>
              <?=formatted_date($full_date)?>
            </td>
            <td class="status_col">
              <?php
$paid_leave_status = 0;
        $payroll_holiday_status = 0;
        $weekend_status = 0;
        $absent_status = 0;
        $attence_status = $att_in['status'];
        $this->db->select('leave_appl_id')->from('leave_apply');
        $this->db->where([
          'employee_id' => $user_attendence['employee_id'],
          'leave_aprv_strt_date <= ' => $full_date,
          'leave_aprv_end_date >= ' => $full_date,
          'hr_status' => 'approved'
        ]);
        $leave = $this->db->get()->first_row();
        $wk_days = isset($weekend_days[$user_attendence['shift']]) ? $weekend_days[$user_attendence['shift']] : $weekend_days[0];
        if (in_array($Today, $wk_days)) {
            $weekend_status = 1;
            echo "<span class='status weekend' style='background-color:lightgrey;'>" . $Today . "</span>&nbsp;";
        } elseif ($payroll_holiday) {
            $payroll_holiday_status = 1;
            echo "<span class='status payroll_holiday'>" . $payroll_holiday->holiday_name . "</span>&nbsp;";
        } elseif ($leave) {
            $paid_leave_status = 1;
            echo "<span class='status leave_holiday'>Paid Leave</span>&nbsp;";
        } else {
            if (in_array('LA', $attence_status ?? [])) {
                echo "<span class='status late'>Late Arrival</span>&nbsp;";
            }
            if (in_array('FD', $attence_status ?? [])) {
                echo "<span class='status present'>Full Day</span>&nbsp;";
            } elseif (in_array('UH-D', $attence_status ?? []) && !in_array('OT', $attence_status ?? [])) {
                echo "<span class='status absent'>Unpaid Half-Day</span>&nbsp;";
            } elseif (in_array('A', $attence_status ?? [])) {
                echo "<span class='status absent'>Absent</span>&nbsp;";
            } elseif (in_array('P', $attence_status ?? [])) {
                echo "<span class='status present'>Present</span>&nbsp;";
            }
            if (empty($att_in)) {
                $absent_status = 1;
                echo "<span class='status absent'>Absent</span>&nbsp;";
            }
            if (in_array('OT', $attence_status ?? [])) {
                echo "<span class='status present'>Overtime</span>&nbsp;";
            }
        }
        ?>
            </td>
            <?php
if (($this->permission->full('attendance')->access() || $this->permission->method('atn_log_datewise', 'update')->access() || $this->session->userdata('supervisor')) && $paid_leave_status != 1 && $payroll_holiday_status != 1 && $weekend_status != 1 && $absent_status != 1) {?>
            <td class='details-button'>
              <a class="btn btn-info"
                href="<?=base_url('attendance/home/user_attendanc_details/' . $user_attendence['employee_id'] . '/' . $full_date)?>">
                <i class="fa fa-eye"></i>
                Details
              </a>
            </td>
            <?php }?>
          </tr>
          <?php
}
    // }
    ?>
    <tr>
      <td colspan="4" align="right"><strong>Total <?=$user_attendence['firstname'] . ' ' . $user_attendence['lastname']?> work time</strong></td>
      <?php $ch_seconds = secondsToTime($user_total_seconds);?>
      <td colspan="4">
        <?=$ch_seconds['hours']?> Hours,
        <?=$ch_seconds['minutes']?> Minutes,
        <?=$ch_seconds['seconds']?> Seconds
      </td>
    </tr>
        </table>
        <?php
}
?>
<?php if (count($attendence_data) > 1): ?>
        <table width="100%" class="table table-striped table-bordered table-hover">
          <tbody>
            <tr>
              <td colspan=6>
                <strong>Overall Total Worked time</strong>
              </td>
              <td>
                <?php
$total_spent_time = secondsToTime($total_seconds);
?>
                <?=$total_spent_time['hours']?> Hours,
                <?=$total_spent_time['minutes']?> Minutes,
                <?=$total_spent_time['seconds']?> Seconds
              </td>
            </tr>
          </tbody>
        </table>
<?php endif;?>
      </div>
    </div>
  </div>
  <?php endif?>
</div>


<script language="javascript">
  $(document).on('click','#btnPrint',function(){
    // alert();return false;
    $('.details-button').css('display','none');
    printDiv();
    setTimeout(function() {
          $('.details-button').css('display','block');
    }, 2000);
  });
  $(function () {
    $(".datepicker").datepicker({
      dateFormat: '<?=get_js_date_format()?>'
    });
    $('.datepicker').on('change', function(){
      if($('[name=start_date]').val() && $('[name=end_date]').val()){
        if(getDate($('[name=start_date]').val()).getTime() > getDate($('[name=end_date]').val()).getTime()){
          $(this).val("");
          alert("Start Date should be less than the End Date")
        }
      }
    })
    <?php if($user_id) :?>
      $("#employee_id").val(JSON.parse('<?=json_encode($user_id)?>')).trigger('change');
    <?php else: ?>
        $("#employee_id").val(<?= $this->session->userdata('employee_id') ?? 0 ?>).trigger('change');
    <?php endif ?>
    $("#dept_id").val(JSON.parse('<?=json_encode($selected_dept)?>'));
    $("#supervisorid").val(JSON.parse('<?=json_encode($selected_supervisor)?>'));
  });
</script>

<script type="text/javascript">
  function printDiv() {
    setTimeout(function() {
    var divName = "result_data";
    var printContents = document.getElementById(divName).innerHTML;
    var originalContents = document.body.innerHTML;
    document.body.innerHTML = printContents;
    // document.body.style.marginTop="-45px";
    window.print();
    document.body.innerHTML = originalContents;
      }, 2000);
  }
</script>

