<?php
class Attendence_model extends CI_Model
{
    public $enums = [
        'P' => 'Present',
        'LA' => 'Late Arrival',
        'EC' => 'Early Checkout',
        'UH-D' => 'Unpaid Half-Day',
        'A' => 'Absent',
        'FD' => 'Full Day',
        'OT' => 'Overtime',
    ];
    public function get_shift($id)
    {
        return $this->db->where('id', $id)->get('shift')->row();
    }
    public function get_shift_by_employee($uid)
    {
        return $this->db->where('employee_history.employee_id', $uid)->select('shift.*')->join('shift', 'employee_history.shift = shift.id', 'left')->get('employee_history')->row();
    }
    public function get_current_status($shift_id, $last_check_type, $punch_time = null, $punchout_time = null, $emp_id = null)
    {
        $shift = $this->get_shift($shift_id);
        if ($shift->flexible_shift) {
            return $this->get_current_status_flexible($shift, $last_check_type, $punch_time, $punchout_time, $emp_id);
        } else {
            return $this->get_current_status_fixed($shift, $last_check_type, $punch_time, $punchout_time, $emp_id);
        }
    }
    public function get_current_status_flexible($shift, $last_check_type, $punch_time, $punchout_time = null, $emp_id = null)
    {
        $status = null;
        switch ($last_check_type) {
            case "out":
                $status = [
                    'flag' => 'P',
                    'note_required' => false,
                ];
                break;
            case "in":
                $shift_percenage = $this->shift_percentage($shift, $punch_time, $punchout_time, $emp_id);
                if ($shift_percenage < 18) {
                    $status = [
                        'flag' => 'A',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 18 && $shift_percenage < 67) {
                    $status = [
                        'flag' => 'UH-D',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 67 && $shift_percenage <= 109) {
                    $status = [
                        'flag' => 'FD',
                        'note_required' => false,
                    ];
                }
                if ($shift_percenage > 109) {
                    $status = [
                        'flag' => 'OT',
                        'note_required' => false,
                    ];
                }
                break;
        }
        return $status;
    }
    public function get_current_status_fixed($shift, $last_check_type, $punch_time, $punchout_time = null, $emp_id = null)
    {
        $time = time();
        if ($punch_time) {
            $time = strtotime($punch_time);
        }

        //$todays_shift = $this->shift_to_time($shift);
        $shift_time = $this->shift_to_time($shift, $punch_time);

        $start = $shift_time['start'];

        $status = null;
        switch ($last_check_type) {
            case "out":
                /* if (strtotime($punch_time) >= $todays_shift['start'] && strtotime($punch_time) <= $todays_shift['end']) {
                $status = null;
                } else */
                $diff = $time - $start;
                if ($diff < 900) {
                    $status = [
                        'flag' => 'P',
                        'note_required' => false,
                    ];
                }
                if ($diff >= 900 && $diff < 28800) {
                    $status = [
                        'flag' => 'LA',
                        'note_required' => true,
                    ];
                }
                break;
            case "in":
                $shift_percenage = $this->shift_percentage($shift, $punch_time, $punchout_time, $emp_id);
                if ($shift_percenage < 18) {
                    $status = [
                        'flag' => 'A',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 18 && $shift_percenage < 67) {
                    $status = [
                        'flag' => 'UH-D',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 67 && $shift_percenage <= 109) {
                    $status = [
                        'flag' => 'FD',
                        'note_required' => false,
                    ];
                }
                if ($shift_percenage > 109) {
                    $status = [
                        'flag' => 'OT',
                        'note_required' => false,
                    ];
                }
                break;
        }
        return $status;
    }
    public function is_nightsift($shift)
    {
        if ($shift->flexible_shift) {
            return false;
        }
        $start = intval(str_replace(':', '', $shift->start));
        $end = intval(str_replace(':', '', $shift->end));

        if ($start > $end) {
            return true;
        }
        return false;
    }
    public function shift_to_time($shift, $punch_time = null)
    {
        if ($shift->flexible_shift) {
            return [];
        }
        if (!$punch_time) {
            $punch_time = date('Y-m-d h:i:s A');
        }

        $punch_date = explode(' ', $punch_time)[0] . ' ';

        if ($this->is_nightsift($shift)) {
            $start = strtotime($punch_date . $shift->start);

            $end = new DateTime($punch_date . $shift->end);
            $end = $end->modify('+1 day')->format('U');
        } else {
            $start = strtotime($punch_date . $shift->start);
            $end = strtotime($punch_date . $shift->end);
        }
        return [
            'start' => $start,
            'end' => $end,
        ];
    }
    public function get_current_worktime($employee_id)
    {
        if (!$employee_id) {
            return [
                'hours' => 0,
                'minutes' => 0,
                'seconds' => 0,
            ];
        }
        $last_punch = $this->db->select('*, TIMESTAMPDIFF(SECOND, punchin_time, \'' . date('Y-m-d H:i:s') . '\') as duration')
            ->where('uid', $employee_id)
            ->order_by('time', 'desc')
            ->get('attendance_history')
            ->row();
        if ($last_punch) {
            if ($last_punch->status != 'in') {
                return [
                    'hours' => 0,
                    'minutes' => 0,
                    'seconds' => 0,
                ];
            }
            return secondsToTime($last_punch->duration);
        } else {
            return [
                'hours' => 0,
                'minutes' => 0,
                'seconds' => 0,
            ];
        }
    }
    public function shift_percentage($shift, $punch_time, $punchout = null, $emp_id = null)
    {
        if ($shift->flexible_shift) {
            $shift_period = $shift->flexible_hours * 3600; //convert hours to seconds
        } else {
            $shift_time = $this->shift_to_time($shift, $punch_time);
            $shift_period = $shift_time['end'] - $shift_time['start'];
        }
        $time = $punchout ? strtotime($punchout) : time();
        $current_shift_period = $time - strtotime($punch_time);

        $current_shift_period += $this->previous_punch_sum($emp_id);

        $perc = ($current_shift_period / $shift_period) * 100;

        return is_finite($perc) && $perc >= 1 ? round($perc) : 0;
    }
    public function custom_punch($uid, $start, $end, $author)
    {
        $shift = $this->get_shift_by_employee($uid);
        $status_in = $this->get_current_status($shift->id, 'out', $start, null, $uid)['flag'];
        $percentage = $this->shift_percentage($shift, $start, $end);

        $group_no = $this->db->select('group_no')->order_by('group_no', 'DESC')->get('attendance_history')->first_row();

        if ($group_no) {
            $group_no = intval($group_no->group_no) + 1;
        } else {
            $group_no = 1;
        }
        $flag = '';
        if ($percentage < 18) {
            $flag = 'A';
        } elseif ($percentage >= 18 && $percentage < 67) {
            $flag = 'UH-D';
        } elseif ($percentage >= 67) {
            $flag = 'FD';
        }
        $attendence_data = [
            'group_no' => $group_no,
            'uid' => $uid,
            'id' => 0,
            'state' => 1,
            'time' => $start,
            'punch_author' => $author,
            'active' => 1,
        ];

        $insert_data = [
            array_merge($attendence_data, ['punchin_time' => $start, 'status' => 'in', 'flag' => $status_in]),
            array_merge($attendence_data, ['punchout_time' => $end, 'duration' => strtotime($end) - strtotime($start), 'status' => 'out', 'flag' => $flag]),
        ];

        foreach ($insert_data as $ins_data) {
            if($ins_data['status'] == 'out') {
                $ins_data['time'] = date('Y-m-d H:i:s', strtotime($ins_data['time'] . ' +30 seconds'));
            }
            $this->db->insert('attendance_history', $ins_data);
        }
        $this->activity->set_employee($uid)->set_url(sprintf('attendance/home/admin_attendance/%s/%s', $uid, date('d-m-Y', strtotime($start))))->log([
            'full_attendance_inserted',
            formatted_date($start, true),
            formatted_date($end, true)
        ]);
        return true;
    }
    public function previous_punch_sum($id = null)
    {
        if (!$id) {
            $id = $this->session->userdata('employee_id');
        }
        $res = $this->db->query("SELECT SUM(t.duration) as duration FROM (SELECT
            SUM(duration) AS duration,
            DATE(punchin_time) AS day
        FROM `attendance_history`
        WHERE `uid` = ?
        AND `active` = 1
        GROUP BY group_no
        HAVING day = ?) as t",
            [$id, date('Y-m-d')])
            ->row();
        if ($res) {
            return intval($res->duration);
        }
        return 0;
    }
    public function get_subordinates($employee_id = null, $employee_ids = null, $dept_ids = null, $supervisorids = null, $active_only = false)
    {
        if(is_null($employee_id)){
            $employee_id = $this->session->userdata('employee_id');
        }
        $query = "SELECT
            *
        FROM employee_history AS emp
            RIGHT JOIN (SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE employee_id = ?
            UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE indirect_super_visor_id = ?
            UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE super_visor_id = ?
            UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE employee_id IN (SELECT
                employee_id
                FROM employee_history
                WHERE super_visor_id IN (SELECT
                    employee_id
                FROM employee_history
                WHERE super_visor_id = ?
                OR indirect_super_visor_id = ?)) UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE employee_id IN (SELECT
                employee_id
                FROM employee_history
                WHERE indirect_super_visor_id IN (SELECT
                    employee_id
                FROM employee_history
                WHERE super_visor_id = ?
                OR indirect_super_visor_id = ?))) AS t
            ON t.employee_id = emp.employee_id";
        $query2 = [];
        if($employee_ids){
            $query2[] = "emp.employee_id IN ($employee_ids)";
        }
        if($dept_ids){
            $query2[] = "emp.dept_id IN ($dept_ids)";
        }
        if($supervisorids){
            $query2[] = "emp.super_visor_id IN ($supervisorids)";
        }
        if($active_only) {
            $query2[] = "emp.status = 'active'";
        }
        if(count($query2) > 0){
            $query .= " WHERE ";
            $query .= implode(' AND ', $query2);
        }
        return $this->db->query($query, array_fill(0, 7, intval($employee_id)))->result_array();
    }
    public function employeeAttendanceCheck($get)
    {
        $emp = [];
        if ($this->session->userdata('isAdmin') == 1 || $this->permission->full('attendance')->access() || $this->permission->method('atn_log_datewise', 'update')->access()) {
            if (!emptyArrayElements($get, ['employee_id', 'dept_id', 'supervisorid'])) {
                $this->db->group_start();
                if ($get['employee_id']) {
                    $this->db->where_in('employee_id', $get['employee_id']);
                }
                if ($get['dept_id']) {
                    $this->db->where_in('dept_id', $get['dept_id']);
                }
                if ($get['supervisorid']) {
                    $this->db->where_in('super_visor_id', $get['supervisorid']);
                }
                $this->db->group_end();
            }
            if(!$this->permission->module('show_inactive_employees')->access() || $get['status'] != 'all') {
                $this->db->where('status', 'active');
            } 
            $emp = $this->db->select('employee_id')->order_by('first_name', 'asc')->get('employee_history')->result_array();
            $emp = array_column($emp, 'employee_id');
        } elseif ($this->session->userdata('supervisor')) {
            $employee_ids = null;
            $dept_ids = null;
            $supervisorids = null;
            if (!emptyArrayElements($get, ['employee_id', 'dept_id', 'supervisorid'])) {
                if ($get['employee_id']) {
                    $employee_ids = implode(',', $get['employee_id']);
                }
                if ($get['dept_id']) {
                    $dept_ids = implode(',', $get['dept_id']);
                }
                if ($get['supervisorid']) {
                    $supervisorids = implode(',', $get['supervisorid']);
                }
            }
            $emp = array_column($this->get_subordinates(null, $employee_ids, $dept_ids, $supervisorids, !$this->permission->module('show_inactive_employees')->access() || $get['status'] != 'all'), 'employee_id');
        } else {
            $emp = [$this->session->userdata('employee_id')];
        }
        return $emp;
    }

    public function get_report($emp_ids, $start, $end)
    {
        if(empty($emp_ids)) {
            return [];
        }
        if (!empty($start)) {
            $start = sql_date($start);
        }
        if (!empty($end)) {
            $end = sql_date($end);
        }
        $emp_ids = $this->db
        ->select('employee_history.employee_id, first_name as firstname, last_name as lastname, hrm_id, employee_history.shift, shift.name as shift_name, department_name as department')
        ->from('employee_history')
        ->join('shift', 'employee_history.shift=shift.id', 'left')
        ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
        ->where_in('employee_id', $emp_ids)
        ->order_by('employee_history.hrm_id', 'asc')
        ->get()
        ->result_array();
        $emp_data = [];
        foreach ($emp_ids as $emp_details) {
            if ($emp_details) {
                $emp_details = [
                    'employee_id' => $emp_details['employee_id'],
                    'shift' => $emp_details['shift'],
                    'shift_name' => $emp_details['shift_name'],
                    'department' => $emp_details['department'],
                    'firstname' => $emp_details['firstname'],
                    'lastname' => $emp_details['lastname'],
                    'hrm_id' => $emp_details['hrm_id'],
                    'attendence' => [],
                ];
            }

            $attendence = $this->db->query('call get_attendance_in_range(?, ?, ?);', [
                $emp_details['employee_id'],
                $start,
                $end
            ])->result_array();
            $this->db->next_result();
            foreach ($attendence as $attn) {
                $attn['status'] = array_unique(explode(',', $attn['status']));
                $emp_details['attendence'][$attn['day']] = $attn;
            }
            $emp_data[] = $emp_details;
        }
        return $emp_data;
    }
    public function get_user_day_report($id, $date)
    {
        $emp_details = @getByWhereAsArray(
            'employee_history',
            'first_name as firstname, last_name as lastname, hrm_id',
            ['employee_id' => $id]
        )[0];
        if ($emp_details) {
            $emp_details = [
                'employee_id' => $id,
                'firstname' => $emp_details['firstname'],
                'lastname' => $emp_details['lastname'],
                'hrm_id' => $emp_details['hrm_id'],
                'attendence' => [],
            ];
        }

        $day_recs = $this->db->query(
            "SELECT
                `group_no`
            FROM `attendance_history`
            WHERE DATE(`punchin_time`) = ?
            AND `uid` = ?
            AND `active` = 1",
            [$date, $id]
        )->result_array();
        if ($day_recs) {
            $day_recs = array_column($day_recs, 'group_no');
            $day_recs = implode(',', $day_recs);
            $attendence = $this->db->query(
                "SELECT
                group_no,
                MIN(punchin_time) as punchin_time,
                MAX(punchout_time) as punchout_time,
                SUM(duration) as duration,
                DATE(COALESCE(punchin_time, punchout_time)) as day,
                GROUP_CONCAT( flag SEPARATOR ',') as flag,
                GROUP_CONCAT(remarks_in) as remarks_in,
                GROUP_CONCAT(remarks_out) as remarks_out
            FROM `attendance_history`
            WHERE `uid` = '$id'
            AND `active` = 1
            AND `group_no` IN ($day_recs)
            GROUP BY `group_no`
            ORDER BY punchin_time ASC"
            )->result_array();
            foreach ($attendence as $attn) {
                $attn['flag'] = array_unique(explode(',', $attn['flag']));
                $emp_details['attendence'][] = $attn;
            }
        }
        return $emp_details;
    }
    public function get_user_day_report2($id, $date)
    {
        $emp_details = @getByWhereAsArray(
            'employee_history',
            'first_name as firstname, last_name as lastname, hrm_id',
            ['employee_id' => $id]
        )[0];
        if ($emp_details) {
            $emp_details = [
                'employee_id' => $id,
                'firstname' => $emp_details['firstname'],
                'lastname' => $emp_details['lastname'],
                'hrm_id' => $emp_details['hrm_id'],
                'attendence' => [],
            ];
        }

        $day_recs = $this->db->query(
            "SELECT
                `group_no`
            FROM `attendance_history`
            WHERE DATE(`punchin_time`) = ?
            AND `uid` = ?
            AND `active` = 1",
            [$date, $id]
        )->result_array();
        if ($day_recs) {
            $day_recs = array_column($day_recs, 'group_no');
            $day_recs = implode(',', $day_recs);
            $attendence = $this->db->query(
                "SELECT
                group_no,
                MAX(punchin_time) as punchin_time,
                MAX(punchout_time) as punchout_time,
                MAX(duration) as duration,
                DATE(COALESCE(punchin_time, punchout_time)) as day
            FROM `attendance_history`
            WHERE `uid` = '$id'
            AND `active` = 1
            AND `group_no` IN ($day_recs)
            GROUP BY `group_no`
            ORDER BY punchin_time ASC"
            )->result_array();
            foreach ($attendence as $attn) {
                $attn['flag'] = array_unique(explode(',', $attn['flag']));
                $emp_details['attendence'][] = $attn;
            }
        }
        return $emp_details;
    }
    public function get_group($id)
    {
        $attendence = $this->db->query(
            "SELECT
            MAX(punchin_time) as punchin_time,
            MAX(punchout_time) as punchout_time
        FROM `attendance_history`
        WHERE `active` = 1
        AND `group_no` = '$id'
        GROUP BY `group_no`
        ORDER BY punchin_time ASC"
        )->row_array();
        $attendence['flag'] = array_unique(explode(',', $attendence['flag']));
        return $attendence;
    }
    public function delete_group($emp_id, $gid)
    {
        $group_date = $this->db
        ->select('MIN(DATE(punchin_time)) as date')
        ->where('group_no', $gid)
        ->get('attendance_history')
        ->row();
        $this->activity
        ->set_employee($emp_id)
        ->log([
            'attendance_group_deleted',
            formatted_date($group_date->date)
        ]);
        return $this->db->delete('attendance_history', [
            'group_no' => $gid,
            'uid' => $emp_id,
        ]);
    }
    public function update_group($id, $start, $end, $emp_id)
    {
        $start = date('Y-m-d H:i:s', strtotime($start));
        if ($end) {
            $end = date('Y-m-d H:i:s', strtotime($end));
        }
        $group_date = $this->db
        ->select('MIN(DATE(punchin_time)) as date')
        ->where('group_no', $id)
        ->get('attendance_history')
        ->row();
        $shift = $this->get_shift_by_employee($emp_id);
        $status_in = $this->get_current_status($shift->id, 'out', $start, null, $emp_id)['flag'];
        $this->db->trans_begin();
        $this->db->where([
            'group_no' => $id,
            'punchin_time !=' => null,
            'active' => 1,
        ])->update('attendance_history', [
            'punchin_time' => $start,
            'flag' => $status_in,
        ]);

        if($end){
            $this->activity->set_employee($emp_id)->set_url(sprintf('attendance/home/edit_group/%s/%s', $emp_id, $id))->log([
                'attendance_group_update',
                formatted_date($group_date->date),
                formatted_date($start, true),
                formatted_date($end, true)
            ]);            
        } else {
            $this->activity->set_employee($emp_id)->set_url(sprintf('attendance/home/edit_group/%s/%s', $emp_id, $id))->log([
                'attendance_group_update_in',
                formatted_date($group_date->date),
                formatted_date($start, true)
            ]);
        }
        if ($end) {
            $status = $this->get_current_status($shift->id, 'in', $start, $end, $emp_id)['flag'];
            $author = empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id');

            $old_punchout = $this->db->where([
                'group_no' => $id,
                'punchout_time !=' => null,
                'active' => 1,
            ])->get('attendance_history')->row();
            if ($old_punchout) {
                $this->db->where('atten_his_id', $old_punchout->atten_his_id)
                    ->update('attendance_history', [
                        'punchout_time' => $end,
                        'flag' => $status,
                        'duration' => strtotime($end) - strtotime($start),
                        'punch_author' => $author,
                    ]);
            } else {
                $this->db->insert('attendance_history', [
                    'group_no' => $id,
                    'uid' => $emp_id,
                    'id' => 0,
                    'state' => 1,
                    'time' => date('Y-m-d H:i:s'),
                    'punchout_time' => $end,
                    'duration' => strtotime($end) - strtotime($start),
                    'status' => 'out',
                    'punch_author' => $author,
                    'flag' => $status,
                ]);
            }
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return $this->db->trans_status();
    }
}
