<?php
require_once APPPATH . 'libraries/Mysql_type.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Better_excel
{
    private $CI = null;
    public function __construct()
    {
        $this->CI = &get_instance();
    }
    public function create($header, $rows, $meta = [], $sheet_info = [])
    {
        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()
            ->setCreator(@$sheet_info['author'])
            ->setLastModifiedBy(@$sheet_info['modifier'])
            ->setTitle(@$sheet_info['title'])
            ->setSubject(@$sheet_info['subject'])
            ->setDescription(@$sheet_info['description']);
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle(@$sheet_info['sheet_title']);

        //Set Header
        foreach ($header as $column => $value) {
            $column += 1;
            $cell = $sheet->getCellByColumnAndRow($column, 1);
            $cell->setValueExplicit(
                $value,
                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
            );
            $sheet->getColumnDimension($cell->getColumn())->setWidth(20);
        }
        $sheet->freezePane('A2');

        $encrypted_cols = @$this->CI->config->item('encrypted_columns_types')['employee_history'];
        if (!empty($meta) && !empty($encrypted_cols)) {
            foreach ($meta as $f_meta) {
                if (isset($encrypted_cols[$f_meta->name])) {
                    $f_meta->type = $encrypted_cols[$f_meta->name];
                }
            }
        }
        //Set Data
        foreach ($rows as $row => $columns) {
            $row += 2;
            foreach ($columns as $column => $value) {

                $cell = $sheet->getCellByColumnAndRow($column + 1, $row);

                if (empty($meta)) {
                    $cell->setValue($value);
                } else {
                    $mysql_types = new Mysql_type();
                    $mysql_type = $meta[$column]->type;
                    if (in_array($mysql_type, [
                        $mysql_types::$DECIMAL,
                        $mysql_types::$TINY,
                        $mysql_types::$SHORT,
                        $mysql_types::$LONG,
                        $mysql_types::$FLOAT,
                        $mysql_types::$DOUBLE,
                        $mysql_types::$LONGLONG,
                        $mysql_types::$INT24,
                    ])) {
                        $cell->setValueExplicit(
                            floatval($value),
                            \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                        );
                        $cell->getStyle()->getNumberFormat()->setFormatCode('#,##0');
                    } elseif ($mysql_type == $mysql_types::$DATE) {
                        $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                        if(!$timestamp) {
                            $cell->setValueExplicit(
                                $value,
                                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                            );
                        } else {
                            $cell->setValue($timestamp);
                            $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DDMMYYYY);
                        }
                    } elseif ($mysql_type == $mysql_types::$DATETIME) {
                        $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                        if(!$timestamp) {
                            $cell->setValueExplicit(
                                $value,
                                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                            );
                        } else {
                            $cell->setValue($timestamp);
                            $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DATETIME);
                        }
                    } else {
                        $cell->setValueExplicit(
                            $value,
                            \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                        );
                    }
                }
            }
        }

        return $spreadsheet;
    }
    public function download($header, $rows, $meta = [], $sheet_info = [])
    {
        $writer = new Xlsx($this->create($header, $rows, $meta, $sheet_info));
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename=adhoc-report.xlsx');
        header('Content-Transfer-Encoding: binary');

        $writer->save('php://output');
    }
}
