<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

if (!function_exists('emp_mapping_result')) {
    function emp_mapping_result($object = null, $behavior = null)
    {
        $mapping_result[] = array('objective' => 1, 'behavior' => 1, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 2, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 3, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 4, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 5, 'result' => "Unacceptable");

        for ($a = 2; $a <= 5; $a++) {
            $mapping_result[] = array('objective' => $a, 'behavior' => 1, 'result' => "Unacceptable");
        }

        for ($b = 2; $b <= 5; $b++) {
            $mapping_result[] = array('objective' => $b, 'behavior' => 2, 'result' => "Needs Improvement");
        }

        for ($c = 3; $c <= 5; $c++) {
            $mapping_result[] = array('objective' => 2, 'behavior' => $c, 'result' => "Needs Improvement");
        }

        for ($d = 3; $d <= 5; $d++) {
            $mapping_result[] = array('objective' => $d, 'behavior' => 3, 'result' => "Fully Effective");
        }

        $mapping_result[] = array('objective' => 3, 'behavior' => 4, 'result' => "Fully Effective");
        $mapping_result[] = array('objective' => 3, 'behavior' => 5, 'result' => "Fully Effective");
        $mapping_result[] = array('objective' => 4, 'behavior' => 4, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 5, 'behavior' => 4, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 4, 'behavior' => 5, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 5, 'behavior' => 5, 'result' => "Exceptional");

        if ($object != null && $behavior != null) {
            foreach ($mapping_result as $key => $value) {
                if (($object == intval($value['objective'])) && ($behavior == intval($value['behavior']))) {
                    return $value['result'];
                }
            }
        } else {
            return "No Value Found";
        }
    }
}
if (!function_exists('get_public_holiday')) {
    function get_public_holiday($full_date,$shift_id)
    {
        $ci = &get_instance();
        $ci->db->select('payroll_holiday.holiday_name');
        $ci->db->join('payroll_holiday', 'payroll_holiday.payrl_holi_id=payroll_holiday_shift_wise.payrl_holi_id', 'left');

        $ci->db->where('payroll_holiday.start_date <=', $full_date);
        $ci->db->where('payroll_holiday.end_date   >=', $full_date);
        $ci->db->where('payroll_holiday_shift_wise.shift_id',$shift_id);
        return $ci->db->get('payroll_holiday_shift_wise')->first_row();
            
    }
}
if (!function_exists('get_document_fields')) {
    function get_document_fields($id)
    {
        $ci = &get_instance();
        $ci->load->database();

        $ci->db->select("
            d.department_name
        ")
            ->from('employee_document_fields df')
            ->join('department d', 'df.department_id = d.dept_id');
        $ci->db->order_by('d.department_name', 'asc');
        $ci->db->where("df.employee_document_id", $id);

        return $ci->db->get()->result();
    }
}

if (!function_exists('print_rr')) {
    function print_rr($data = [])
    {
        echo '<pre>' . print_r($data, true) . '</pre>';
    }
}
if (!function_exists('secondsToTime')) {
    function secondsToTime($seconds)
    {
        if (empty($seconds)) {
            return [
                'hours' => 0,
                'minutes' => 0,
                'seconds' => 0,
            ];
        }
        $dtF = new DateTime('@0');
        $dtT = new DateTime("@$seconds");
        $dtT = $dtF->diff($dtT);
        return [
            'hours' => intval($dtT->format('%h')) + (intval($dtT->format('%a')) * 24),
            'minutes' => intval($dtT->format('%i')),
            'seconds' => intval($dtT->format('%s')),
        ];
    }
}
if (!function_exists('get_weekend')) {
    function get_weekend()
    {
        $ci =& get_instance();
        if(!$data = $ci->cache->get('application.weekend.by.shift')) {
            $weekend_days = getByWhereAsArray('weekly_holiday', '*');
            $res = [];
            foreach ($weekend_days as $wk_h) {
                $res[$wk_h['shift_id']] = explode(',', $wk_h['dayname']);
            }
            $ci->cache->save('application.weekend.by.shift', $res, 500);
            return $res;
        }
        return $data;
    }
}

if (!function_exists('daysBetween')) {
    function daysBetween($dt1, $dt2)
    {
        return date_diff(date_create($dt2), date_create($dt1))->format('%a');
    }
}

if(!function_exists('get_js_date_format')){
    function get_js_date_format()
    {
        return 'dd-mm-yy';
    }
}

if(!function_exists('formatted_date')){
    function formatted_date($date_string = '', $time = false)
    {
        $format = 'd-m-Y';
        if($time){
            $format .= ' h:i:s A';
        }
        if(empty($date_string) || $date_string == '0000-00-00'){
            return '';
        }else{
            return date($format, strtotime($date_string));
        }
    }
}
if(!function_exists('formatted_date_now')){
    function formatted_date_now($date_string = '', $time = false)
    {
        $format = 'd-m-Y';
        if($time){
            $format .= ' h:i:s A';
        }
        if(empty($date_string) || $date_string == '0000-00-00'){
            return date($format);
        }else{
            return date($format, strtotime($date_string));
        }
    }
}
if (!function_exists('formatted_time_now')) {
    function formatted_time_now($time_string = '', $time = false)
    {
        $format = 'h:i:s A';
        if (empty($time_string) || $time_string == '00:00:00') {
            return date($format);
        } else {
            return date($format, strtotime($time_string));
        }
    }
}
if (!function_exists('formatted_time')) {
    function formatted_time($time_string = '', $time = false)
    {
        $format = 'h:i:s A';
        if (empty($time_string) || $time_string == '00:00:00') {
            return '';
        } else {
            return date($format, strtotime($time_string));
        }
    }
}

if(!function_exists('slug_to_readable')){
    function slug_to_readable($str)
    {
        $str = str_replace(['_', '-'], ' ', $str);
        return ucwords($str);
    }
}
if (!function_exists('text_to_slug')) {
    function text_to_slug($str)
    {
        return preg_replace('~[^\w\d]+~', '_', trim($str));
    }
}

if(!function_exists('convert_excel_date')){
    function convert_excel_date($date, $format = 'Y-m-d')
    {
        if(empty(trim($date))){
            return null;
        }
        $date = preg_replace('#\D#is', '/', $date);
        $src_fmt = 'd/m/Y';
        if(strlen($date) == 8){
            $src_fmt = 'd/m/y';
        }
        $datetime = DATETIME::createFromFormat($src_fmt, $date);
        return $datetime ? $datetime->format($format) : '';
    }
}
if(!function_exists('first_or_second')){
    function first_or_second($type, $item1, $item2)
    {
        return $type ? $item1 : $item2;
    }
}

if(!function_exists('generate_hrm_id')){
    function generate_hrm_id($division_id = null)
    {
        $CI = get_instance();
        if(empty($division_id)) {
            $division_id = $CI->session->userdata('division_id');
        }
        if($division_id) {
            $division_id = $CI->db->where('id', $division_id)->get('divisions')->row();
        }
        $rec = $CI->db->where('division_id', $division_id->id)->get('hrm_ids')->row();
        $hrm_num = 0;
        if(!$rec) {
            $CI->db->insert('hrm_ids', [
                'division_id' => $division_id->id,
                'hrm_id' => 0
            ]);
        } else {
            $hrm_num = $rec->hrm_id;
        }
        $CI->db->trans_start();
        do {
            $hrm_num++;
            $hrm_id = $division_id->prefix . '-' . str_pad($hrm_num, 4, '0', STR_PAD_LEFT);
            $hrm_exists = $CI->db->where('hrm_id', $hrm_id)->get('employee_history')->row();
            if($hrm_exists) {
                $CI->db->where('division_id', $division_id->id)->update('hrm_ids', [
                    'hrm_id' => $hrm_num
                ]);
            }
        } while ($hrm_exists);
        $CI->db->trans_complete();
        return str_pad($hrm_num, 4, '0', STR_PAD_LEFT);
    }
}

if(!function_exists('increment_hrm_id')) {
    function increment_hrm_id($division_id, $hrm_id)
    {
        $CI =& get_instance();
        $rec = $CI->db->where('division_id', $division_id)->get('hrm_ids')->row();
        if(abs($rec->hrm_id - $hrm_id) === 1) {
            $CI->db->where('division_id', $division_id)->update('hrm_ids', [
                'hrm_id' => $hrm_id
            ]);
        }
    }
}

if(!function_exists('encrypt_employee_data')){
    function encrypt_employee_data($data, $additional_cols = [])
    {
        $CI = get_instance();
        $cols_to_encrypt = $CI->config->item('encrypted_columns')['employee_history'];
        $cols_to_encrypt = array_merge($cols_to_encrypt, $additional_cols);
        $is_array = is_array($data);
        $data = $is_array ? $data : (array) $data;
        foreach ($data as $col_key => $col_value) {
            if(in_array($col_key, $cols_to_encrypt) && !empty($col_value)){
                $data[$col_key] = $CI->encryption->encrypt($col_value);
            }
        }
        return $is_array ? $data : (object) $data;
    }
}

if(!function_exists('decrypt_employee_data')){
    function decrypt_employee_data($data, $additional_cols = [], $bypass = false)
    {
        $CI = get_instance();
        $cols_to_decrypt = $CI->config->item('encrypted_columns')['employee_history'];
        $still_encrypted = [];

        if(!$bypass) {
            if(!($CI->permission->method('employee_salary_permission', 'read')->access() || $CI->permission->method('employee_salary_permission', 'update')->access())){
                $still_encrypted = [
                    'rate',
                    'current_salary',
                    'hired_salary',
                     'first_salary',
                    'second_salary',
                    'third_salary'
                ];
            }
        }
        $cols_to_decrypt = array_filter($cols_to_decrypt, function($val) use ($still_encrypted) {
            return !in_array($val, $still_encrypted);
        });
        $cols_to_decrypt = array_merge($cols_to_decrypt, $additional_cols);
        $is_array = is_array($data);
        $data = $is_array ? $data : (array) $data;
        foreach ($data as $col_key => $col_value) {
            if(in_array($col_key, $cols_to_decrypt) && !empty($col_value)){
                $data[$col_key] = $CI->encryption->decrypt($col_value);
            }
            if(in_array($col_key, $still_encrypted)) {
                $data[$col_key] = '[Encrypted]';
            }
        }
        return $is_array ? $data : (object) $data;
    }

}
if(!function_exists('can_decrypt_employee_column')){
    function can_decrypt_employee_column($col_name)
    {
        $CI = get_instance();        
        $cols_to_decrypt = $CI->config->item('encrypted_columns')['employee_history'];

        $cols_to_decrypt2 = [];

        foreach ($cols_to_decrypt as $col) {
            $cols_to_decrypt2[$col] = true;
        }
        if(!($CI->permission->method('employee_salary_permission', 'read')->access() || $CI->permission->method('employee_salary_permission', 'update')->access())){
            $sal_perms = [
	            'rate',
	            'current_salary',
	            'hired_salary',
                'first_salary',
	            'second_salary',
            	'third_salary'
        	];
            foreach ($sal_perms as $sal_perm) {
                $cols_to_decrypt2[$sal_perm] = false;
            }
        }
        return !isset($cols_to_decrypt2[$col_name]) ||  $cols_to_decrypt2[$col_name];
    }

}
function encode_img_base64($img_path = false, $img_type = 'png')
{
    if( $img_path ){
        //convert image into Binary data
        $img_data = fopen ( $img_path, 'rb' );
        $img_size = filesize ( $img_path );
        $binary_image = fread ( $img_data, $img_size );
        fclose ( $img_data );

        //Build the src string to place inside your img tag
        $img_src = "data:image/".$img_type.";base64,".str_replace ("\n", "", base64_encode($binary_image));

        return $img_src;
    }
	return false;
}

if (!function_exists('array_to_path')) {
    function array_to_path($arr)
    {
        return implode(DIRECTORY_SEPARATOR, $arr);
    }
}

//generate slug
if (!function_exists('str_slug')) {
    function str_slug($str)
    {
        return url_title(convert_accented_characters($str), "-", true);
    }
}

if (!function_exists('get_enum_values')) {
    function get_enum_values( $table, $field )
    {
        $CI =& get_instance();
        $type = $CI->db->query( "SHOW COLUMNS FROM {$table} WHERE Field = '{$field}'" )->row( 0 )->Type;
        preg_match("#^enum\(\'(.*)\'\)$#is", $type, $matches);
        $enums = explode("','", $matches[1]);
        $data = [];
        foreach ($enums as $enum) {
            $data[$enum] = ucwords(preg_replace('#\W+#is', ' ', $enum));
        }
        return $data;
    }
}

if(!function_exists('cnic_with_dashes')){
    function cnic_with_dashes($str, $combo = [5, 13])
    {
        $str = trim(strval($str));
        if(empty($str)){
            return '';
        }
        $str = substr_replace($str, '-', $combo[0], 0);
        $str = substr_replace($str, '-', $combo[1], 0);
        return $str;
    }
}

if(!function_exists('get_module_name')){
    function get_module_name(){
        return CI::$APP->router->fetch_module();
    }
}
if(!function_exists('month_first_last_day')){
    function month_first_last_day($month = null, $year = null)
    {
        if(is_null($month)){
            $month = date('m');
        }
        if(is_null($year)){
            $year = date('Y');
        }
        $first = strtotime("{$year}-{$month}-01");
        
        $last = strtotime("{$year}-{$month}-01");
        $last = strtotime('-1 second', strtotime('+1 month', $last));

        return [
            'first' => date('Y-m-d', $first),
            'last' => date('Y-m-d', $last)
        ];
    }
}
if(!function_exists('sql_date')){
    function sql_date($date, $time = false)
    {
        $fmt = 'Y-m-d';
        if($time){
            $fmt .= ' H:i:s';
        }
        return date($fmt, strtotime($date));
    }
}
if(!function_exists('array_diff_multi')){
    function array_diff_multi($old, $new, $key)
    {
        $data['added'] = array_udiff($new, $old, function($a, $b) use ($key)
        {
            return $a[$key] <=> $b[$key];
        });
        $data['removed'] = array_udiff($old, $new, function($a, $b) use ($key)
        {
            return $a[$key] <=> $b[$key];
        });
        return $data;
    }
}
if(!function_exists('file_time_append')) {
    function file_time_append($filename)
    {
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $name = pathinfo($filename, PATHINFO_FILENAME);

        return $name.'-'.time().'.'.$ext;
    }
}
if(!function_exists('current_date')) {
    function current_date($time = false)
    {
        $fmt = 'Y-m-d';
        if($time) {
            $fmt .= ' H:i:s';
        }
        return date($fmt);
    }
}
if(!function_exists('isEmptyArray')) {
    function isEmptyArray($arr = [])
    {
        if(!is_array($arr)) {
            return null;
        }
        foreach ($arr as $value) {
            if(!empty(trim(strval($value)))) {
                return false;
            }
        }
        return true;
    }
}
if(!function_exists('get_settings')) {
    function get_settings()
    {
        $ci =& get_instance();
        $ci->load->database();
        if(!$data = $ci->cache->get('application.setting')) {
            $settings = $ci->db->get('setting')->row();
            $ci->cache->save('application.setting', $settings, 900);
            return $settings;
        }
        return $data;
    }
}
if(!function_exists('percentage_to_amount')) {
    function percentage_to_amount($amount, $percentage)
    {
        return ($amount * ($percentage / 100));
    }
}
if(!function_exists('user_option')) {
    function user_option($key, $check_value = null)
    {
        $value = $_SESSION['user_options'][$key];
        if(!$value) {
            return false;
        }
        if($check_value) {
            return $value == $check_value;
        }
        return $value;
    }
}
if(!function_exists('get_ip_address')) {
    function get_ip_address()
    {
        $ipaddress = '';
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } else if (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }

        return $ipaddress;
    }
}