<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;

class User extends BaseController
{
    public function login()
    {
        $data = [];

        if ($this->request->getMethod() == 'post') {

            $rules = [
              'email' => 'required|min_length[6]|max_length[50]|valid_email',
              'password' => 'required|max_length[255]|validateUser[email,password]',
            ];

            $errors = [
                'password' => [
                    'validateUser' => "Email or Password don't match",
                ],
            ];

            if (!$this->validate($rules, $errors)) {

                return view('login', [
                    "validation" => $this->validator,
                ]);

            } else {
                $model = new UserModel();
                $user = $model->where('email', $this->request->getVar('email'))
                    ->first();
                $roles_permission = [];
                if($user['id'] != 1){
                   $role_result = $this->db->table('user_roles')->select('*')->where('user_id',$user['id'])->get()->getResult();
                       foreach($role_result as $key=>$value){
                           $roles_permission = $this->db->table('roles_permission')->select('modules.name,modules.url,modules.parent,roles_permission.*')->join('modules','modules.id=roles_permission.module')->where('roles_permission.role_id',$value->role_id)->get()->getResult();
                       }
                }    
                $data = [
                    'id' => $user['id'],
                    'name' => $user['name'],
                    'phone_no' => $user['phone_no'],
                    'email' => $user['email'],
                    'isLoggedIn' => true
                ];
                        
                $data['roles_permission'] = $roles_permission;
                // echo '<pre>';
                // print_r($data);die;
                session()->set($data);
                // Redirecting to dashboard after login
                return redirect()->to(base_url('home'));

            }
        }
        return view('login');
    }

    private function setUserSession($user)
    {   
   
        $data = [
            'id' => $user['id'],
            'name' => $user['name'],
            'phone_no' => $user['phone_no'],
            'email' => $user['email'],
            'isLoggedIn' => true
        ];
        

        session()->set($data);
        return true;
    }


    public function users(){
        
            $model = new UserModel();
            $results = $model->getUsers();
            $data['result'] =  $results;
            return view('users',$data);
    }

    public function last_id(){
            $model = new UserModel();
            $results = $model->lastID();
            echo $results;
    }
    public function get_roles(){
        $model = new UserModel();
            $results = $model->getRoles();
            echo json_encode($results);
    }
    public function roles(){
        $result =   $this->db->query('select * from roles order by id desc limit 1')->getResult();
        echo $result[0]->id+1;
    }
    
    public function permission_update(){
        
        if ($this->request->getMethod() == 'post') {
            //let's do the validation here
            $rules = [
                'name' => 'required|min_length[3]|max_length[20]'
            ];

            if (!$this->validate($rules)) {
                return $this->validator->listErrors();
            } else {
                $user = $this->request->getVar('id');
                $newData = ['name'=>$this->request->getVar('name')];
                $foundResult = $this->db->table('roles')->select('*')->where('id',$this->request->getVar('id'))->get()->getResult();
                if($foundResult){
                    $role_name = (string) $this->request->getVar('name');
                    $this->db->query('update roles set name = "'.$role_name.'" where id = '.$this->request->getVar('id'));
                }else{
                     $this->db->table('roles')->insert($newData);
                }
                return 'success'; 
            }
            
        }
    }
    
    public function register()
    {
        $data = [];

        if ($this->request->getMethod() == 'post') {
            //let's do the validation here
            $rules = [
                'name' => 'required|min_length[3]|max_length[20]',
                'phone_no' => 'required|min_length[9]|max_length[20]',
                'email' => 'required|min_length[6]|max_length[50]|valid_email|is_unique[users.email]',
                'password' => 'required|min_length[8]|max_length[255]',
                'password_confirm' => 'matches[password]',
                'role_id' => 'required',
            ];

            if (!$this->validate($rules)) {

                return view('register', [
                    "validation" => $this->validator,
                ]);
            } else {
                $model = new UserModel();
				$options=['cost'=>11];
                $newData = [
                    'name' => $this->request->getVar('name'),
                    'phone_no' => $this->request->getVar('phone_no'),
                    'email' => $this->request->getVar('email'),
                    'password' => password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options),
                ];
                $model->save($newData);
                // $user_id = $model->getInsertID();
                // $this->db->table('user_roles')->insert(['user_id'=>$user_id,'role_id'=>$this->request->getVar('role_id')]);   
                $session = session();
                $session->setFlashdata('success', 'Successful Registration');
                return redirect()->to(base_url('register'));
            }
        }
        $data['roles'] = $this->db->table('roles')->select('*')->get()->getResult();
        return view('register',$data);
    }
    
    
    public function update(){
    
       
        $data = [];

        if ($this->request->getMethod() == 'post') {
            //let's do the validation here
            $rules = [
                'name' => 'required|min_length[3]|max_length[20]',
                'phone_no' => 'required|min_length[9]|max_length[20]',
                'email' => 'required|min_length[6]|max_length[50]|valid_email',
                // 'password' => 'required|min_length[8]|max_length[255]',
                'role_id' => 'required',
            ];
                    $model = new UserModel();
             $result = $model->getUsers($this->request->getVar('id'));
             if($result){
                 
             }else{
                $rules['password'] = 'required|min_length[4]|max_length[255]';
             }
             
            if (!$this->validate($rules)) {
                return $this->validator->listErrors();
            } else {
        
				$options=['cost'=>11];
                $newData = [
                    'name' => $this->request->getVar('name'),
                    'phone_no' => $this->request->getVar('phone_no'),
                    'email' => $this->request->getVar('email'),
                    'password' => password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options),
                ];
                $result = $model->getUsers($this->request->getVar('id'));
                $user_id = $this->request->getVar('id');
                if($result){
                    $update = $model->update($this->request->getVar('id'), $newData);     
                }else{
                    $model->insert($newData);    
                    $user_id = $model->insertID();
                }
                $rolesResult = $this->db->table('roles')->select('id')->where('name',$this->request->getVar('role_id'))->get()->getResult();
                $userRoleResult = $this->db->table('user_roles')->select('user_id')->where('user_id',$this->request->getVar('id'))->get()->getResult();
                if($userRoleResult){
                    $this->db->query('update user_roles set role_id='.$rolesResult[0]->id.' where user_id = '.$this->request->getVar('id'));	
                }else{
                    $this->db->table('user_roles')->insert(['user_id'=>$user_id,'role_id'=>$rolesResult[0]->id]);
                }
                return 'success'; 
            }
        }
      
    }
    
    
    
    public function delete(){
        // print_r($this->request->getMethod());die;
         if ($this->request->getMethod() == 'post') {
            	$post = $this->request->getPost();
                $this->db->query('delete from user_roles where user_id = '.$post['id'])->getResult();
                $this->db->query('delete from users where id = '.$post['id'])->getResult();
         }
    }
    
    public function role_delete(){
         // print_r($this->request->getMethod());die;
         if ($this->request->getMethod() == 'post') {
            	$post = $this->request->getPost();
                $this->db->query('delete from roles where id = '.$post['id'])->getResult();
                $this->db->query('delete from roles_permission where role_id = '.$post['id'])->getResult();
         }
    }
    
    public function profile()
    {

        $data = [];
        $model = new UserModel();

        $data['user'] = $model->where('id', session()->get('id'))->first();
        return view('profile', $data);
    }

    public function rest_password(){
    	 $data = [];

        if ($this->request->getMethod() == 'post') {
            //let's do the validation here
            $rules = [
                'password' => 'required|min_length[8]|max_length[255]',
                'password_confirm' => 'matches[password]',
            ];

            if (!$this->validate($rules)) {

                // return view('profile', [
                //     "validation" => $this->validator,
                // ]);


                $data = [];
		        $model = new UserModel();

		        $data['user'] = $model->where('id', session()->get('id'))->first();
		        $data["validation"] = $this->validator;
		        return view('profile', $data);

            } else {
                $model = new UserModel();
				$options=['cost'=>11];
                // $newData = [
                //     'password' => password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options),
                // ];

  				$session = session();
             	$id = $session->get('id');
             	$model->set('password', password_hash($this->request->getVar('password'),PASSWORD_BCRYPT,$options));
				$model->where('id', $id);
				$model->update();

                // $model->save($newData);
              
                $session->setFlashdata('success', 'Password updated successfully!');
                return redirect()->to(base_url('profile'));
            }
        }
        return view('register');
    }


    
    public function permissions(){
       $roles = $this->db->table('roles')->select('roles.id as roles_id,roles.name as role_name')->get()->getResult();
       $data['result'] = $roles;
       return view('permissions',$data);
    }
    
    public function get_all_modules($id){
       $modules= $this->db->table('modules')->select('*')->get()->getResultArray();       
       $module_permission = $this->db->table('roles_permission')->select('*')->where('role_id',$id)->get()->getResult();
       $data['found'] = 0;
       if($module_permission){
        $data['found'] = 1;
       }else{
           
       }
       $data['modules'] = $modules;
       $data['modules_permission'] = $module_permission;
        return json_encode($data);
    }
    
    public function update_modules_permission(){
        $data = [];
        if ($this->request->getMethod() == 'post') {
            $datas = [];
   
            foreach($this->request->getVar('module') as $key=>$value){
                foreach($value as $keys=>$values){
                    
                    $data['module'] = $key;
                    $data['role_id'] = $this->request->getVar('role_id');
                    $data['edit'] = $values['edit'];
                    $data['delete'] = $values['delete'];
                    $data['add'] = $values['add'];
                    $data['view'] = $values['view'];
                    $data['import'] = $values['import'];
                    $data['export'] = $values['export'];
                    $datas[] = $data;
                }
            }
            $this->db->query('delete from roles_permission where role_id = '.$this->request->getVar('role_id'));
            $this->db->transStart();
            $this->db->table('roles_permission')->insertBatch($datas);
            $this->db->transComplete();
	        $message['message']='success';
	        echo json_encode($message);
        }
    }
    
    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }
}