<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;

// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
class Activecollectorstargetdetailspicollections extends BaseController
{


    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over
     */
   
function workingDays($year,$month){

	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
	$j = 1;
		$countWorkingDays = 0;
		for($i =0;$i<$days;$i++){
			$newDate = date('Y-m-d', strtotime(date('Y-m-d'). ' + '.$j.' days'));
			if(date("D", strtotime($newDate)) !='Sat' && date("D", strtotime($newDate)) !='Sat'){
					$countWorkingDays+=1;
			}
			$j++;
		}
		return $countWorkingDays;
}

public function all_record(){
		if($_GET){
			$months = $_GET['month'];	
		}else{
			$months = date('Y-m');	
		}

		$post_month = date('m',strtotime($months));
		$current_month = date('m');
		$next_month = (int)date('m')+1;
		$data_found = 0;

			$found_hrm = 0;
		if($post_month > $next_month){
			$data_found =0;
		}else{
			$data_found =1;
			$records = $this->db->table('pi_collections_target_list')->select('*')->where('date',$months)->get()->
			getResult();
			if($records){
				$data['record']	 = $records;

			}else{
				// echo 'here';die;
				$found_hrm = 1;
				$results =  $this->db2->table('employee_history')
											->select('position.position_name designation,employee_history.*,concat(employee_history.first_name," ",employee_history.last_name) real_name,employee_history.hrm_id as employee_id,0 as days_worked,0 as daily_target,0 as weekly_target,"" as paper,"" as alias,user.status emp_status,divisions.name div_name,department.department_name dept_name')
									    	->join('position','employee_history.pos_id=position.pos_id')
									    	->join('user','employee_history.email=user.email')
									    	->join('divisions','employee_history.division_id=divisions.id')
									    	->join('department','employee_history.dept_id=department.dept_id')
									    	->where('employee_history.dept_id',18)
									    	->get()->getResult();
							$data['record'] = $results;
				
			}

		}

		$data['found_hrm'] = $found_hrm;
		// $post_month = date('m',strtotime($months));
		// $post_month = date('m',strtotime($months));

		$data['days'] = intval($this->workingDays(date('Y',strtotime($months)),date('m',strtotime($months))));
		$data['weeks']  =intval($this->workingDays(date('Y',strtotime($months)),date('m',strtotime($months)))/5);

		$data['months'] = $months;
		$data['data_found'] = $data_found;
		$data['db'] = $this->db;
		return $data;
}


	public function index()
	{
		$data = $this->all_record();
  		return view('details_pi_collections/index',$data);
	}

	public function update($table){
	    if ($this->request->getMethod() == 'post') {
	    		$post = $this->request->getPost();
	    		$json_post = json_decode($post['json_save']);
	    		$array_posts = [];
	    		$total_array = [];
	    		$collection = new Collections();
            
	    		foreach($json_post as $key=>$value){
	    			if($table == 'active_collectors_target_details_pi_collections'){

		    			if(empty($value[1]) && empty($value[2])  && empty($value[3])  && empty($value[4])  && empty($value[5])  && empty($value[6])  && empty($value[7])  && empty($value[8])  && empty($value[9])  && empty($value[10])  && empty($value[11])  && empty($value[12])  && empty($value[13])  && empty($value[14]) ){
		    			}else{
								$mult_array['week_no'] = $value[1];
			    				$mult_array['week_start'] = trim($value[2]);
			    				$mult_array['week_end'] = trim($value[3]);
			    				$mult_array['days_worked'] = trim($value[4]);
			    				$mult_array['real_name'] = trim($value[5]);
			    				$mult_array['alias'] = $value[6];
			    				$mult_array['employee_id'] = $value[7];
			    				$mult_array['employee_status'] = $value[8];
			    				$mult_array['daily_target'] = $value[9];
			    				$mult_array['weekly_target'] = $value[10];
			    				$mult_array['paper'] = $value[11];
			    				$mult_array['team_manager'] = $value[12];
			    				$mult_array['center'] = $value[13];
			    				$mult_array['designation'] = $value[14];
			    				$mult_array['department'] = $value[15];
			    				$mult_array['date'] = $post['date'];
			    				$total_array[] = $mult_array;
		    			}
	    			}elseif($table == 'manager_list' || $table == 'active_collectors_target_details_pi_collections_manager_list'){
	    				$table = 'active_collectors_target_details_pi_collections_manager_list';
	    						$mult_array['Team_Manager'] = $value[1];
	    						$mult_array['Center'] = $value[2];
	    						$mult_array['Floor_Manager'] = $value[3];
	    						$mult_array['Status'] = $value[4];
			    				$total_array[] = $mult_array;
		    		}else if($table == 'primary_alias_list' || $table == 'active_collectors_target_details_pi_collections_primary_list'){
	    				$table = 'active_collectors_target_details_pi_collections_primary_list';
		    			
		    			$mult_array['Alias'] = $value[1];
	    				$mult_array['Employement_ID'] = $value[2];
	    				$mult_array['Employement_Status'] = $value[3];
	    				$mult_array['Center'] = $value[4];
	    				$mult_array['Designation'] = $value[5];
	    				$mult_array['Department'] = $value[6];
			    		$total_array[] = $mult_array;
		    		}
	    		}
	    		
	  
	   // 	if(count($total_array)<=0){
	    		        
    // 	    		if($table == 'manager_list'){
    // 	    			$table = 'active_collectors_target_details_pi_collections_manager_list';
    // 	    			$table1 = 'active_collectors_target_details_pi_collections_manager_list';
    	    				
	   // 	    $this->db->table($table1)->truncate();
    // 	    		}
    	    		
    // 	    		if($table == 'primary_alias_list'){
    // 	    			$table = 'active_collectors_target_details_pi_collections_primary_list';
    // 	    			$table1 = 'active_collectors_target_details_pi_collections_primary_list';
    	    		
	   // 	    $this->db->table($table1)->truncate();
    // 	    		}
    	    		
                
	   // 		}

                 $table1  = "";
	    		if($table == 'active_collectors_target_details_pi_collections'){
	    		    $table1 = 'pi_collections_target_list';
					$this->db->query("delete from ".$table1.' where date = "'.$post['date'].'" ');
	    			$redirect= base_url('active_collectors_target_details_pi_collections/');
	    		}else if($table == 'manager_list' || $table == 'active_collectors_target_details_pi_collections_manager_list'){
	    		     $table1 = 'pi_collections_managers_list';
					$this->db->query("delete from ".$table1);
	    			$redirect= base_url('active_collectors_target_details_pi_collections/manager_list');
	    		}else if($table == 'primary_alias_list' || $table=="active_collectors_target_details_pi_collections_primary_list"){
	    		     $table1 = 'pi_collections_alias_list';
	    		    $this->db->query("delete from ".$table1);
	    		    $redirect= base_url('active_collectors_target_details_pi_collections/primary_alias_list');
	    		}
	    	
	           	$this->db->transStart();
            	$this->db->table($table1)->insertBatch($total_array);
            	$this->db->transComplete();
            	return redirect()->to($redirect);
        }    
    }

    public function importSheet(){
    					$session = session();
    		$post = $this->request->getPost();
    	if ($this->request->getMethod() == "post") {
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                        return redirect()->to(base_url('active_collectors_target_details_pi_collections/'));
                    }
                    
					if('csv' == $extension){
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					} else {
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					}
					$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
					$sheetData = $spreadsheet->getActiveSheet()->toArray();
					if($sheetData){
					    $table_descriptions = $this->db->query('describe pi_collections_target_list')->getResult();
                        if($table_descriptions){
                            $table_fields = count($table_descriptions)-1;
                            $sheet_columns = count($sheetData[0]);
                            if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
                                $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                return redirect()->to(base_url('active_collectors_target_details_pi_collections/'));
                            }
                        }
						$total_array = [];
						foreach($sheetData as $key=>$value){
							if($key>0){
	
								$mult_array['week_no'] = $value[1];
			    				$mult_array['week_start'] = date("Y-m-d", strtotime(trim($value[2])));
			    				$mult_array['week_end'] = date("Y-m-d", strtotime(trim($value[3])));;
			    				$mult_array['days_worked'] = trim($value[4]);
			    				$mult_array['real_name'] = trim($value[5]);
			    				$mult_array['alias'] = $value[6];
			    				$mult_array['employee_id'] = $value[7];
			    				$mult_array['employee_status'] = $value[8];
			    				$mult_array['daily_target'] = $value[9];
			    				$mult_array['weekly_target'] = $value[4] *  $value[9];
			    				$mult_array['paper'] = $value[11];
			    				$mult_array['team_manager'] = $value[12];
			    				$mult_array['center'] = $value[13];
			    				$mult_array['designation'] = $value[14];
			    				$mult_array['department'] = $value[15];
			    				$mult_array['date'] = $post['date'];
			    				
			    				// $total_array,$mult_array);
			    				$total_array[] = $mult_array;

							}
					
						}
						if($total_array){
						
							$this->db->table('pi_collections_target_list')->where('date', $post['date'])->delete();
				            $this->db->transStart();
				            $this->db->table('pi_collections_target_list')->insertBatch($total_array);
				            $this->db->transComplete();
				            $session->setFlashdata('success', 'Data Imported Successfully'); 
				            return redirect()->to(base_url('active_collectors_target_details_pi_collections/'));    
						}else{
						    $session->setFlashdata('error', 'Something went wrong'); 
				            return redirect()->to(base_url('active_collectors_target_details_pi_collections/'));
						}
						
					}else{

					}
					// echo "<pre>";
					// print_r($sheetData);
					// }
					}

   			
        }

public function downloadExcelReportManagerList(){
		// echo 'here';die;
	// $result = $this->all_record();
		$fileName = 'team_manager_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setCellValue('A1', 'ID');
		$sheet->setCellValue('B1', 'Team Manager');
		$sheet->setCellValue('C1', 'Center');
		$sheet->setCellValue('D1', 'Floor Manager');
		$sheet->setCellValue('E1', 'Status');
		$rows = 2;
		
		$record = $this->db->table('pi_collections_managers_list')->select('*')->get()->getResult();
		$k= 1;
		foreach ($record as $key=>$value) {
			$sheet->setCellValue('A' . $rows, $k);
			$sheet->setCellValue('B' . $rows, $value->Team_Manager); 
			$sheet->setCellValue('C' . $rows, $value->Center); 
			$sheet->setCellValue('D' . $rows, $value->Floor_Manager); 
			$sheet->setCellValue('E' . $rows, $value->Status); 
			$rows++;
			$k++;
		}

		$writer = new Csv($spreadsheet);

		// file inside /public folder
		$filepath = $fileName;

		$writer->save($filepath);

		header("Content-Type: application/vnd.ms-excel");
		header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');

		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filepath));
		flush(); // Flush system output buffer
		readfile($filepath);

		exit;
}

    public function importSheetManagerList(){
        		$session = session();
    		$post = $this->request->getPost();
    	if ($this->request->getMethod() == "post") {
					
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
					
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                         return redirect()->to(base_url('active_collectors_target_details_mlcr_collections/manager_list'));
                    }
                    
					if('csv' == $extension){
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					} else {
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					}
					$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
					$sheetData = $spreadsheet->getActiveSheet()->toArray();
					if($sheetData){
					       	       
					    $table_descriptions = $this->db->query('describe pi_collections_managers_list')->getResult();
                        if($table_descriptions){
                            $table_fields = count($table_descriptions);
                            $sheet_columns = count($sheetData[0]);
                            if($sheet_columns > $table_fields || $sheet_columns < $table_fields){    
                                $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                return redirect()->to(base_url('active_collectors_target_details_pi_collections/manager_list'));
                            }
                        }
						$total_array = [];
						foreach($sheetData as $key=>$value){

							if($key>0){
								$mult_array['Team_Manager'] = $value[1];
								$mult_array['Center'] = $value[2];
								$mult_array['Floor_Manager'] = $value[3];
								$mult_array['Status'] = $value[4];
								$total_array[] = $mult_array;							}
					
						}
                        if($total_array){
                         
							$this->db->query("delete from pi_collections_managers_list");
				            $this->db->transStart();
				            $this->db->table('pi_collections_managers_list')->insertBatch($total_array);
				            $this->db->transComplete();
				            $session->setFlashdata('success', 'Data Imported Successfully');
				            return redirect()->to(base_url('active_collectors_target_details_pi_collections/manager_list'));   
                        }else{
                            $session->setFlashdata('error', 'Something went wrong');
				            return redirect()->to(base_url('active_collectors_target_details_pi_collections/manager_list'));   
                        }
					}else{

					}

					}

   			
        }

	
	public function downloadExcelReport()
	{
		$result = $this->all_record();
		$fileName = 'active_colletion_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setCellValue('A1', 'ID');
		$sheet->setCellValue('B1', 'Week No');
		$sheet->setCellValue('C1', 'Week Start');
		$sheet->setCellValue('D1', 'Week End');
		$sheet->setCellValue('E1', 'Days Worked');
		$sheet->setCellValue('F1', 'Real Name');
		$sheet->setCellValue('G1', 'Alias');
		$sheet->setCellValue('H1', 'Employee ID');
		$sheet->setCellValue('I1', 'Employee Status');
		$sheet->setCellValue('J1', 'Daily Target');
		$sheet->setCellValue('K1', 'Weekly Target');
		$sheet->setCellValue('L1', 'Paper');
		$sheet->setCellValue('M1', 'Team Manager');
		$sheet->setCellValue('N1', 'Center');
		$sheet->setCellValue('O1', 'Designation');
		$sheet->setCellValue('P1', 'Department');
		$rows = 2;
		$rows2 = 2;
		$j = 1; 
		$k = 1;

		if($result['data_found'] != 1){

		} else{

		foreach ($result['record'] as $key=>$value) {
			$start = 0;
			$days_increment = 5; 
			$end = 3; 
			$weeks = intval(date("t")/5);
			if($result['found_hrm'] == 1): 
				$month = date("m", strtotime($result['months']));
				// echo $result['weeks'];die;
						$week_no_ = 1; 
				for($i=1;$i<=$result['weeks'];$i++):
						$sheet->setCellValue('A' . $rows2, $j);
						$sheet->setCellValue('B' . $rows2, $week_no_); 
						$startDate =  date('Y-m-d', strtotime(($result['months'].'-'.$start. ' + 1 days')));
						if(date("D", strtotime($startDate))=='Sun'){
							$startDate =  date('Y-m-d', strtotime(($result['months'].'-'.$start. ' + 2 days')));
							$sheet->setCellValue('C' . $rows2, $startDate); 
							$start = $start+1;
						}else{
							$startDate =  date('Y-m-d', strtotime(($result['months'].'-'.$start. ' + 1 days')));
							$sheet->setCellValue('C' . $rows2, $startDate); 
						}
						$l = 0;
						$WeekDaysArray = [];
						for($k=1;$k<7;$k++){
							$endDate = date('Y-m-d', strtotime(($result['months'].'-'.$start. ' + '.($k).' days')));
							$weekend_check = date("D", strtotime($endDate));	
							if($weekend_check == 'Sat' || $weekend_check == 'Sun'){
								break;
							}
							if(date("m", strtotime($endDate)) == $month){
								$WeekDaysArray[] = $endDate;
							}
						}
						$countIncrement = count($WeekDaysArray);
						if(date("m", strtotime($endDate)) !=$month){
							// end($WeekDaysArray);
							$sheet->setCellValue('D' . $rows2, end($WeekDaysArray)); 
						}else{
							// echo end($WeekDaysArray);
							$sheet->setCellValue('D' . $rows2, end($WeekDaysArray)); 
						}

						// $earlier = new DateTime($startDate);
						// $later = new DateTime($endDate);
						//  $diff = $later->diff($earlier)->format("%a");
						$sheet->setCellValue('E' . $rows2, $countIncrement); 
						// echo $value->real_name
						$sheet->setCellValue('F' . $rows2, $value->real_name); 
						$alias =  $this->db->table('pi_collections_alias_list')->where('Employement_ID',$value->employee_id)->get()->getResult();
						if($alias){
							// echo $alias[0]->Alias;
							$sheet->setCellValue('G' . $rows2, $alias[0]->Alias); 

						}else{
							
							$sheet->setCellValue('G' . $rows2, ''); 
						}
						
						$sheet->setCellValue('H' . $rows2, $value->employee_id); 
						$sheet->setCellValue('I' . $rows2, ($value->emp_status == 1 ? 'Active' : 'InActive')); 
						$sheet->setCellValue('J' . $rows2, $value->daily_target); 
						$sheet->setCellValue('K' . $rows2, $value->weekly_target); 
						$sheet->setCellValue('L' . $rows2, $value->paper); 
						$sheet->setCellValue('M' . $rows2, ""); 
						$sheet->setCellValue('N' . $rows2, ($value->city)); 
						$sheet->setCellValue('O' . $rows2, $value->designation); 
						$sheet->setCellValue('P' . $rows2, $value->dept_name); 

					$start += ($countIncrement+2); 
					$week_no_++;
					  $j++; 
					  $rows2++; 
				
							endfor;
				else:
				$sheet->setCellValue('A' . $rows, $k);
				$sheet->setCellValue('B' . $rows, $value->week_no); 
				$sheet->setCellValue('C' . $rows, $value->week_start); 
				$sheet->setCellValue('D' . $rows, $value->week_end); 
				$sheet->setCellValue('E' . $rows, $value->days_worked); 
				$sheet->setCellValue('F' . $rows, $value->real_name); 
				$sheet->setCellValue('G' . $rows, $value->alias); 
				$sheet->setCellValue('H' . $rows, $value->employee_id); 
				$sheet->setCellValue('I' . $rows, $value->employee_status);
				$sheet->setCellValue('J' . $rows, $value->daily_target); 
				$sheet->setCellValue('K' . $rows, $value->weekly_target); 
				$sheet->setCellValue('L' . $rows, $value->paper); 
				$sheet->setCellValue('M' . $rows, $value->team_manager); 
				$sheet->setCellValue('N' . $rows, $value->center);
				$sheet->setCellValue('O' . $rows, $value->designation); 
				$sheet->setCellValue('P' . $rows, $value->department); 
				endif;

													$k++;
															$rows++;
		}
		}

		$writer = new Csv($spreadsheet);

		// file inside /public folder
		$filepath = $fileName;

		$writer->save($filepath);

		header("Content-Type: application/vnd.ms-excel");
		header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');

		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filepath));
		flush(); // Flush system output buffer
		readfile($filepath);

		exit;
	}


public function downloadExcelReportAliasList(){
	// $result = $this->all_record();
	// echo 'hdfdf';die;
		$fileName = 'primary_alias_list_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setCellValue('A1', 'ID');
		$sheet->setCellValue('B1', 'Alias');
		$sheet->setCellValue('C1', 'Employement ID');
		$sheet->setCellValue('D1', 'Employement Status');
		$sheet->setCellValue('E1', 'Center');
		$sheet->setCellValue('F1', 'Designation');
		$sheet->setCellValue('G1', 'Department');
		$rows = 2;
		
		$record = $this->db->table('pi_collections_alias_list')->select('*')->get()->getResult();
		$k= 1;
		foreach ($record as $key=>$value) {
			$sheet->setCellValue('A' . $rows, $k);
			$sheet->setCellValue('B' . $rows, $value->Alias); 
			$sheet->setCellValue('C' . $rows, $value->Employement_ID); 
			$sheet->setCellValue('D' . $rows, $value->Employement_Status); 
			$sheet->setCellValue('E' . $rows, $value->Center); 
			$sheet->setCellValue('F' . $rows, $value->Designation); 
			$sheet->setCellValue('G' . $rows, $value->Department); 
			$rows++;
			$k++;
		}

		$writer = new Csv($spreadsheet);

		// file inside /public folder
		$filepath = $fileName;

		$writer->save($filepath);

		header("Content-Type: application/vnd.ms-excel");
		header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');

		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filepath));
		flush(); // Flush system output buffer
		readfile($filepath);

		exit;
}

    public function importSheetAliasList(){
           		$session = session();
    		$post = $this->request->getPost();
    	if ($this->request->getMethod() == "post") {
					
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                        return redirect()->to(base_url('active_collectors_target_details_pi_collections/primary_alias_list'));
                    }
                    
					if('csv' == $extension){
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					} else {
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					}
					$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
					$sheetData = $spreadsheet->getActiveSheet()->toArray();
					if($sheetData){
					    $table_descriptions = $this->db->query('describe pi_collections_alias_list')->getResult();
                        if($table_descriptions){
                            $table_fields = count($table_descriptions);
                            $sheet_columns = count($sheetData[0]);
                            if($sheet_columns > $table_fields || $sheet_columns < $table_fields){                
                      
                                $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                return redirect()->to(base_url('active_collectors_target_details_pi_collections/primary_alias_list'));
                            }
                        }
						$total_array = [];
						foreach($sheetData as $key=>$value){
							if($key>0){
								$mult_array['Alias'] = $value[1];
			    				$mult_array['Employement_ID'] = $value[2];
			    				$mult_array['Employement_Status'] = $value[3];
			    				$mult_array['Center'] = $value[4];
			    				$mult_array['Designation'] = $value[5];
			    				$mult_array['Department'] = $value[6];
					    		$total_array[] = $mult_array;
							}
						}
						if($total_array){
						    $this->db->query("delete from pi_collections_alias_list");
				            $this->db->transStart();
				            $this->db->table('pi_collections_alias_list')->insertBatch($total_array);
				            $this->db->transComplete();
				            $session->setFlashdata('success', 'Data Imported Successfully');  
				            return redirect()->to(base_url('active_collectors_target_details_pi_collections/primary_alias_list'));
						}else{
						    $session->setFlashdata('error', 'Something went wrong');  
				            return redirect()->to(base_url('active_collectors_target_details_pi_collections/primary_alias_list'));
						}
							
					}else{

					}
					
					}

   			
        }
  	public function manager_list(){

	 if($_GET){
		$months = $_GET['month'];	
	 }else{
		$months = date('Y-m');	
	 }
	 $data['record'] = $this->db->table('pi_collections_managers_list')->select('*')->get()->getResult();
  	 return view('details_pi_collections/manager_list',$data);
	}

	public function manager_list_get(){
		$result = $this->db->table('pi_collections_managers_list')->select('*')->get()->getResult();
		if($result){
			echo json_encode($result);
		}else{
			echo 0;
		}
	}


	// public function agent_campaigns(){
		
	// }

  	public function alias_list(){
	 if($_GET){
		$months = $_GET['month'];	
	 }else{
		$months = date('Y-m');	
	 }
	 $data['record'] = $this->db->table('pi_collections_alias_list')->select('*')->get()->getResult();
  	 return view('details_pi_collections/primary_alias_list',$data);
	}

	public function alias_list_get(){
		$result = $this->db->table('pi_collections_alias_list')->select('*')->get()->getResult();
		if($result){
			echo json_encode($result);
		}else{
			echo 0;
		}
	}


}
