<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\DailyQualityWorkModel;
// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
class Activecollectorsdailyqualityworkbook extends BaseController
{


    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over
     */
   
function workingDays($year,$month){

	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
	$j = 1;
		$countWorkingDays = 0;
		for($i =0;$i<$days;$i++){
			$newDate = date('Y-m-d', strtotime(date('Y-m-d'). ' + '.$j.' days'));
			if(date("D", strtotime($newDate)) !='Sat' && date("D", strtotime($newDate)) !='Sat'){
					$countWorkingDays+=1;
			}
			$j++;
		}
		return $countWorkingDays;
}

public function all_record(){
	$records = $this->db->table('mlcr_settlement_data')->select('*')->get()->getResult();
    $data['record'] = $records;
    return $data;
}
public function lastID(){
    $result =   $this->db->query('select * from mlcr_settlement_data order by id desc limit 1')->getResult();
    echo $result[0]->id+1;
}


public function index()
{
    // $data = $this->all_record();
    $model = new DailyQualityWorkModel();
    $data = [
        'record' => $model->paginate(100),
        'pager' => $model->pager
    ];

  	return view('daily_quality_work_mlcr/index',$data);
}

    public function update($table){
	    if ($this->request->getMethod() == 'post') {
	    		$post = $this->request->getPost();
                $result = $this->db->table('mlcr_settlement_data')->select('*')->where('id',$post['id'])->get()->getResult();
                
                    $model = new DailyQualityWorkModel();   
                
                if($result){
            
                    $update = $model->update($post['id'], $post);        
                }else{
                    $this->db->transStart();
				    // $update = $this->db->table('Daily_Quality_Workbook_ML_CR')->insertBatch($post);
				    $update = $model->insert($post);
				    $this->db->transComplete();
				            
                }
                
                if($update){
                    echo 1;
                }else{
                    echo 0;
                }
        }    
    }

    public function delete($table){
         if ($this->request->getMethod() == 'post') {
            	$post = $this->request->getPost();
 
                $model = new DailyQualityWorkModel();   
                $this->db->query('delete from mlcr_settlement_data where id = '.$post['id'])->getResult();
                // if($update == 1){
                //     echo 1;
                // }else{
                //     echo 0;
                // }
             
         }
    }
    
    public function importSheet(){
    		$post = $this->request->getPost();
    					$session = session();
    	if ($this->request->getMethod() == "post") {
					
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
								
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                        return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
                    }
                    
					if('csv' == $extension){
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					} else {
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					}
					$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
					$sheetData = $spreadsheet->getActiveSheet()->toArray();
					if($sheetData){
						$total_array = [];
                        $table_descriptions = $this->db->query('describe mlcr_settlement_data')->getResult();
                    
                        if($table_descriptions){
                            $table_fields = count($table_descriptions)-1;
                            $sheet_columns = count($sheetData[0]);
                            if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
                                $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
                            }
                        }
                
						foreach($sheetData as $key=>$value){
							if($key>0){
                                $mult_array['Settlement_Date'] = trim($value[0]);
			    				$mult_array['Collector_Real_Name'] = $value[1];
			    				$mult_array['Pseudo'] = $value[2];
			    				$mult_array['Team_Manager'] = $value[3];
			    				$mult_array['Provider'] = $value[4];
			    				$mult_array['Settlement_Type'] = $value[5];
			    				$mult_array['MRN'] = $value[6];
			    				$mult_array['Orders'] = $value[7];
			    				$mult_array['Bill_ID_Invoice'] = $value[8];
			    				$mult_array['Patient_Name'] = $value[9];
			    				$mult_array['Billed_Amount'] = $value[10];
			    				$mult_array['Paid_Amount'] = $value[11];
			    				$mult_array['Outstanding_Amount'] = $value[12];
			    				$mult_array['Settlement_Amount'] = $value[13];
			    				$mult_array['Settlement'] = $value[14];
			    				$mult_array['Check_Number'] = $value[15];
			    				$mult_array['Check_Date'] = $value[16];
			    			    $mult_array['Post_Date'] = $value[17];
			    				$mult_array['Available_on_SP'] = $value[18];
			    				$mult_array['QA_Status'] = $value[19];
			    				$mult_array['Timestamp'] = $value[20];
			    				$total_array[] = $mult_array;
							}
						}

						if($total_array){
						    $this->db->query('delete from mlcr_settlement_data')->getResult();
				            $this->db->transStart();
				            // $collection = new Collections;
				            $this->db->table('mlcr_settlement_data')->insertBatch($total_array);
				            $this->db->transComplete();
				            
				            $session->setFlashdata('success', 'Data Imported Successfully');
				            return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
						}else{
						    $session->setFlashdata('error', 'Something went wrong');
				            return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
						}
							
					}else{

					}
					}

   			
        }

	
	function generate_csv($data,$fileName)
    {
        // $data = generate($tables, $columns, $where);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$fileName);
        header('Content-Transfer-Encoding: binary');
    
        $f = fopen('php://output', 'w');
        fwrite($f, chr(0xEF).chr(0xBB).chr(0xBF));
        fputcsv($f, $data['header']);
 
        foreach ($data['rows'] as $row) {
            unset($row->id);
            fputcsv($f, (array)$row); 
        }
        
        exit;
    }
	
	public function downloadExcelReport()
	{
		$result = $this->all_record();
		$fileName = 'active_colletion_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
// 		$sheet->setCellValue('A1', 'Settlement Date');
// 		$sheet->setCellValue('B1', 'Collector Real Name');
// 		$sheet->setCellValue('C1', 'Pseudo');
// 		$sheet->setCellValue('D1', 'Team Manager');
// 		$sheet->setCellValue('E1', 'Provider');
// 		$sheet->setCellValue('F1', 'Settlement Type');
// 		$sheet->setCellValue('G1', 'MRN');
// 		$sheet->setCellValue('H1', 'Order');
// 		$sheet->setCellValue('I1', 'Bill ID Invoice');
// 		$sheet->setCellValue('J1', 'Patient Name');
// 		$sheet->setCellValue('K1', 'Billed Amount');
// 		$sheet->setCellValue('L1', 'Paid Amount');
// 		$sheet->setCellValue('M1', 'Outstanding Amount');
// 		$sheet->setCellValue('N1', 'Sattlement Amount');
// 		$sheet->setCellValue('O1', 'Sattlement');
// 		$sheet->setCellValue('P1', 'Check Number');
// 		$sheet->setCellValue('Q1', 'Check Date');
// 		$sheet->setCellValue('R1', 'Post Date');
// 		$sheet->setCellValue('S1', 'Available On SP');
// 		$sheet->setCellValue('T1', 'QA Status');
// 		$sheet->setCellValue('U1', 'Timestamp');


		$data['header'][] = 'Settlement Date';
		$data['header'][] = 'Collector Real Name';
		$data['header'][] = 'Pseudo';
		$data['header'][] = 'Team Manager';
		$data['header'][] = 'Provider';
		$data['header'][] = 'Settlement Type';
		$data['header'][] = 'MRN';
		$data['header'][] = 'Order';
		$data['header'][] = 'Bill ID Invoice';
		$data['header'][] = 'Patient Name';
		$data['header'][] = 'Billed Amount';
		$data['header'][] = 'Paid Amount';
		$data['header'][] = 'Outstanding Amount';
		$data['header'][] = 'Sattlement Amount';
		$data['header'][] = 'Sattlement';
		$data['header'][] = 'Check Number';
		$data['header'][] = 'Check Date';
		$data['header'][] = 'Post Date';
		$data['header'][] = 'Available On SP';
		$data['header'][] = 'QA Status';
		$data['header'][] = 'Timestamp';
		$data['rows'] =$result['record'];

		 return $this->generate_csv($data,$fileName);
// 		$rows = 2;
// 		$rows2 = 2;
// 		$j = 1; 
// 		$k = 1;

// 		foreach ($result['record'] as $key=>$value) {
// 			$start = 0;
// 			$days_increment = 5; 
// 			$end = 3; 
// 			$weeks = intval(date("t")/5);
// 				$sheet->setCellValue('A' . $rows, $value->Settlement_Date);
// 				$sheet->setCellValue('B' . $rows, $value->Collector_Real_Name); 
// 				$sheet->setCellValue('C' . $rows, $value->Pseudo); 
// 				$sheet->setCellValue('D' . $rows, $value->Team_Manager); 
// 				$sheet->setCellValue('E' . $rows, $value->Provider); 
// 				$sheet->setCellValue('F' . $rows, $value->Settlement_Type); 
// 				$sheet->setCellValue('G' . $rows, $value->MRN); 
// 				$sheet->setCellValue('H' . $rows, $value->Orders); 
// 				$sheet->setCellValue('I' . $rows, $value->Bill_ID_Invoice); 
// 				$sheet->setCellValue('J' . $rows, $value->Patient_Name);
// 				$sheet->setCellValue('K' . $rows, $value->Billed_Amount); 
// 				$sheet->setCellValue('L' . $rows, $value->Paid_Amount); 
// 				$sheet->setCellValue('M' . $rows, $value->Outstanding_Amount); 
// 				$sheet->setCellValue('N' . $rows, $value->Settlement_Amount); 
// 				$sheet->setCellValue('O' . $rows, $value->Settlement);
// 				$sheet->setCellValue('P' . $rows, $value->Check_Number); 
// 				$sheet->setCellValue('Q' . $rows, $value->Check_Date); 
// 				$sheet->setCellValue('R' . $rows, $value->Post_Date); 
// 				$sheet->setCellValue('S' . $rows, $value->Available_on_SP); 
// 				$sheet->setCellValue('T' . $rows, $value->QA_Status); 
// 				$sheet->setCellValue('U' . $rows, $value->Timestamp); 
// 			$k++;
// 			$rows++;
// 		}


// 		$writer = new Csv($spreadsheet);

// 		// file inside /public folder
// 		$filepath = $fileName;

// 		$writer->save($filepath);

// 		header("Content-Type: application/vnd.ms-excel");
// 		header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');

// 		header('Expires: 0');
// 		header('Cache-Control: must-revalidate');
// 		header('Pragma: public');
// 		header('Content-Length: ' . filesize($filepath));
// 		flush(); // Flush system output buffer
// 		readfile($filepath);

// 		exit;
	}


}
