<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once("Secure_Controller.php");

class Home extends Secure_Controller 
{
	public function __construct()
	{
		parent::__construct();	
		
        $this->load->library('session');
		if($this->session->userdata('receptionist_login') == 1 || $this->session->userdata('doctor_login') == 1)
		{
			redirect(str_replace('pharmacy/public','',site_url()));
		}
	}

	public function index()
	{
		$this->load->view('home');
	}

	public function requests()
	{
		$this->load->view('requests');
	}

	public function view_request($id = 0)
	{
		$data['id'] = $id;
		$this->load->view('view_request', $data);
	}

	public function logout()
	{
		$this->Employee->logout();

		/*if($this->config->item('statistics') == TRUE)
		{
			$this->load->library('tracking_lib');

			$this->tracking_lib->track_page('logout', 'logout');
		}*/
	}
}
?>