<?php
$username = htmlentities($user['firstname']). " " . htmlentities($user['lastname']);
if($username == " ") {
	$username = $user['email_id'];
}

$user_pic = $user['profile_pic'];
if($user_pic == "") {
	$user_pic = ASSETS_URL."images/avatar.png";
}
?>
<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
        <h4 class="modal-title booking-profile-popup" id="myModalLabel">Rate and Review us</h4>
      </div>
      <form id="ratingsForm">
        <div class="modal-body">
          <div class="booking-profile-popup-content">
            <div class="booking-profile-popup-content-ratting" style="top:0;">
              <h3>How much will you rate us?</h3>
              <br>
              <div class="booking-profile-popup-starss">
                <div id="rating" class="raty" data-read="false" data-rate="0"></div>
              </div>
            </div>
            <br>
            <!-- -->
            <br>
            <div class="booking-profile-popup-content-review">
              <input type="hidden" name="booking_id" id="booking_id" value="" />
              <input type="hidden" name="shop_id" id="shop_id" value="" />
              <textarea id="review" class="booking-profile-popup-content-review-textarea" name="comments" rows="2" cols="50" placeholder="Add your valuable comments and feedbacks.."></textarea>
            </div>
          </div>
          <div class="message"> </div>
        </div>
        <div class="modal-footer align-center"> <a href="javascript:void(0);" class="btn booking-profile-popup-button feedback">Submit</a> </div>
      </form>
    </div>
  </div>
</div>

<div class="container">
  <div class="row">
    <div class="profile-main">
      <div class="profile-main-bg">
        <div class="col-md-2">
          <div class="prfl-pic" style="background-image:url(<?php echo $user_pic; ?>)"> </div>
        </div>
        <div class="col-md-9">
          <div class="booking-profile">
            <div class="row">
              <div class="booking-profile-name"><?php echo $username; ?></div>
            </div>
            <div class="row">
              <div class="booking-profile-number"><?php echo $user['phone_no']; ?></div>
            </div>
          </div>
        </div>
        <div class="col-md-1">
          <div class="booking-profile-logo"><img src="<?php echo ASSETS_URL;?>/images/bms-white-logo.png"></div>
        </div>
      </div>
    </div>
  </div>
  <?php
	if($data) {
	foreach($data as $booking) {
		$rating = 0;
		$review = '';
		if($booking->rating) {
			$rating = $booking->rating;
		}
		if($booking->comments) {
			$review = $booking->comments;
		}
	?>
  <li>
    <div class="row">
      <div class="booking-profile-wrap">
        <div class="col-md-5">
          <div class="booking-profile-shop-ratting" style="background-image:url(<?php echo $booking->shop_image; ?>)"> 
            <a href="javascript:void(0);">
            	<div class="overlay">
                  <div class="booking-profile-shop-image">
                  <?php if($booking->status == 'Completed'){ ?>
                    <button type="button" class="btn btn-primary btn-lg position_absolute transparent booking-profile-shop-ratting-button rate-us" data-toggle="modal" data-target="<?php echo '#myModal_'.$booking->booking_id;?>" data-booking="<?php echo $booking->booking_id;?>">
                        <div class="ratting-image"> <img src="<?php echo ASSETS_URL;?>/images/rattingpopup.png"></div>
                        <br>Rate us
                    </button>
                  <?php }?>  
                  </div>
            	</div>
          	</a> 
          </div>
         </div>
        <div class="col-md-5 padding0">
          <div class="booking-profile-shop-details">
            <div class="row">
              <div class="booking-profile-shop-name"> <a href="<?php echo BASE_URL."shop/view/".str_replace(" ","-",strtolower($booking->shop_name))."-".$booking->shop_id; ?>"><?php echo $booking->shop_name; ?></a> </div>
              <div class="booking-profile-time-date"> <?php echo date('h:i A', strtotime($booking->booking_time)); ?> | <?php echo date("D, jS M, Y", strtotime($booking->booking_date)); ?> </div>
              <div class="booking-profile-time-date">
                <h4 style="font-size:25px; display:inline-block; float:left;">Booking ID : <?php echo $booking->booking_order_id; ?></h4>
                <?php $label = 'success';
						if($booking->status == 'Booked' || $booking->status == 'Tentative'){
							$label = 'info';
						}elseif($booking->status == 'Cancelled'){
							$label = 'danger';
						}?>
                <a href="javascript:;" style="margin:19px 0px 0 7px; float:left;" class="label label-md label-<?php echo $label;?>"><?php echo $booking->status; ?></a>
              </div>
            </div>
          </div>
          <div class="booking-profile-shop-services" style="margin-top:20px;">
            <div class="row">
              <?php if(!empty($booking->services)) {
					  $services = explode("<=>",$booking->services);
					  foreach($services as $service){?>
              <div class="booking-profile-service1"><?php echo $service; ?></div>
              <?php } } ?>
            </div>
          </div>          
        </div>
        <div class="col-md-2 padding0">
          <div class="booking-profile-amount" style="top:20px; font-size:16px;">Total PKR <?php echo $booking->total; ?>/- </div>
        </div>
      </div>
    </div>
    
    <div class="modal fade" id="<?php echo 'myModal_'.$booking->booking_id;?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
            <h4 class="modal-title booking-profile-popup" id="myModalLabel">How much will you rate us?</h4>
          </div>
          <form id="<?php echo 'ratings_form_'.$booking->booking_id;?>" action="" method="post">
            <div class="modal-body pull-left">
              <div class="pull-left">
                <div class="col-md-12">
                	<table class="table table-striped">
                      <thead>                        
                        <tr>
                          <th width="40%">Service name</th>
                          <th width="60%">Reviews</th>
                        </tr>
                      </thead>
                      <tbody>
                      <?php if(!empty($booking->my_services)){
						  		foreach($booking->my_services as $_service){
									 $services_id = explode("<=>",$booking->services_id);
									if(!in_array(trim($_service->service_id),$services_id)){continue;}?>
                        <tr>
                          <td><?php echo $_service->service_name;?></td>
                          <td style="padding-right:0;">
                          	<div class="booking-profile-popup-starss">
            					<div id="<?php echo 'rating_'.$_service->service_id;?>" data-id="<?php echo $_service->service_id;?>" class="raty" data-read="false" data-rate="1" style="cursor: pointer;"></div>
         					</div>
            				<input type="hidden" class="service_id" name="service_id[]" value="<?php echo $_service->service_id;?>" />
                          </td>
                        </tr>
                        <?php }}?>
                      </tbody>
                      <tfoot>
                      	<tr>
                        	<td colspan="2"><textarea class="booking-profile-popup-content-review-textarea" id="<?php echo 'comments_'.$booking->booking_id;?>" name="comments" rows="2" cols="50" placeholder="Add your valuable comments and feedbacks.."><?php echo '';//$booking->review; ?></textarea></td>
                        </tr>
                      </tfoot>
                    </table>
                </div>                    
              </div>
              <div class="col-md-12">
              	<div class="message pull-left" id="<?php echo 'message_'.$booking->booking_id;?>"> </div>
              </div>  
            </div>
            <input type="hidden" name="shop_id" value="<?php echo $booking->shop_id;?>" />
            <input type="hidden" name="booking_id" value="<?php echo $booking->booking_id;?>" />
            <div class="modal-footer align-center">
            	<a href="javascript:void(0);" class="btn booking-profile-popup-button" onclick="submit_form('<?php echo $booking->booking_id;?>')">Submit</a>
            </div>
          </form>
        </div>
      </div>
  </div>
  
  </li>
  <?php } } else{?>
  <br />
  <br />
  <div class="message">
    <div class="error">
      <div> No bookings found </div>
    </div>
  </div>
  <?php } ?>
</div>
<script type="text/javascript">
var xhr;
function submit_form(form_id)
{
	var review = $('#comments_'+form_id).val();
	var access = true;
	var error = '';
	if($.trim(review) == '') 
	{
		access = false;
		error = '<div> Please write your comment</div>';
	}
	console.log(review);
	if(access == true) 
	{
		$('#message_'+form_id).html('');
		var value = $('#ratings_form_'+form_id).serialize();
		if(xhr && xhr.readyState != 4){
			xhr.abort();
		}
		xhr = $.ajax({
			type: "POST",
			url: base_url+"user/rating_shops",
			data: value,
			success: function(response) {
				//location.reload();
				//alert(response);
				xhr = null;
				$('#message_'+form_id).html(response.html);
				var booking_id = response.booking_id;
				//$(".review-"+booking_id).val(review);
				//$(".rating-"+booking_id).val(score);
				$('#myModal_'+form_id).modal('hide');
				
			},
			error: function(response) {
				var error = '<div class="error"><div>Sorry, Error occured. Please try again</div></div>';
				//alert('error');
				xhr = null;
				$('#message_'+form_id).html(error);
			}
		});
	}
	else 
	{
		error = '<div class="error">'+error+'</div>';
		$('#message_'+form_id).html(error);
	}
}
</script>
<style type="text/css">
th, td{
	padding:8px 15px !important;
}
</style>