<?php 

class Offers_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
 	}
	
	function get_service() {
		$query = $this->db->get('main_services');
		$result = $query->result();
		return $result;
	}
	
	function save_offers($data) 
	{
		$shop_id = $data['shop_id'];
		$service_id = $data['service_id'];
		$this->db->where('shop_id', $shop_id);
		$this->db->where('service_id', $service_id);
		$this->db->from('shop_services');
		$count = $this->db->count_all_results();		
		if($count > 0) 
		{
			$this->db->where('shop_id', $shop_id);
			$this->db->where('service_id', $service_id);
			$result = $this->db->update('shop_services', $data); 
			if($result) {
				return "Success";
			}
			else 
			{
				return "Error";
			}
		}
		else 
		{
			$data['price'] = $data['offer_price'];
			$result = $this->db->insert('shop_services', $data); 
		
			if($result) {
				return "Success";
			}
			else 
			{
				return "Error";
			}
		}
	}
	
	function update_offers($data, $id) 
	{
		$this->db->where('id', $id);
		$result = $this->db->update('offers', $data); 
		
		if($result) {
			return "Success";
		}
		else {
		 	return "Error";
		}
	}
	
	function delete_offers($id) {
		
		$this->db->where('id', $id);
		$result = $this->db->update('shop_services', array('has_offer' => 0)); 
		
		if($result) 
		{
			return "Success";
		}
		else 
		{
			return "Error";
		}
	}
	
  	function get_offers() 
	{		
		$this->db->select('ss.shop_name,  shop_services.*, main_services.service_name');
		$this->db->from('shop_details as ss');
		$this->db->join('shop_services', 'shop_services.shop_id = ss.id'); 
		$this->db->join('main_services', 'main_services.id = shop_services.service_id'); 
		$this->db->where('has_offer', 1);
		$query = $this->db->get();
		$result = $query->result();
		return $result;
	}  
	
	function get_single_offers($id) 
	{
		$query = $this->db->where('offers.id', $id);
		$menu = $this->session->userdata('admin');
		if($menu!='1'){
			$user = $this->session->userdata('id');
			$this->db->where('shop_details.created_user', $user);
			$this->db->join('shop_details', 'shop_details.id = offers.shop_id','left');
		}
		$query = $this->db->get('offers');
		$result = $query->row();
		return $result;
	}	
}