<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Karachi");
		$this->load->model('user_model');
		$this->load->model('service_model');
		$this->load->model('shop_model');
		if(!$this->session->userdata('logged_in')) {
			redirect(BASE_URL);
		}
		else {
			$profile = $this->router->fetch_method();
			if($profile != 'profile') {
			$menu = $this->session->userdata('admin');
			 if( $menu != 1 && $menu != 3  && $menu != 4 ) {
				 $this->session->set_flashdata('message', array('message' => "You don't have permission to access user page.",'class' => 'danger'));
				 redirect(BASE_URL.'dashboard');
			 }
			}
		}
 	}
	
	public function profile() {
		
		$template['page'] = 'User/profile';
		$template['page_title'] = "User Profile";
		$id = $this->session->userdata('logged_in')['id'];
		$template['data'] = $this->user_model->get_single_profile($id);
		if($_POST) {
			$data = $_POST;
			unset($data['submit']);
			
			if(isset($_FILES['profile_pic'])) {
				$config = $this->set_upload_options();
			
				$this->load->library('upload');
				$this->upload->initialize($config);
				
				if ( ! $this->upload->do_upload('profile_pic')) {
					unset($data['profile_pic']);
				}
				else {
					$data['profile_pic'] = $config['upload_path']."/".$_FILES['profile_pic']['name'];
				}
			}
			
			$result = $this->user_model->update_user($data, $id);
			if($result == "Exist") {
			$this->session->set_flashdata('message', array('message' => 'Customer already exist','class' => 'danger'));
			   }
				
			else {	
			array_walk($data, "remove_html");
			$this->session->set_flashdata('message', array('message' => 'Profile Updated Successfully','class' => 'success'));
			   }
			
			
     		redirect(BASE_URL.'user/profile');
		}
		else {
   			$this->load->view('template', $template);
		}
		
	}

  	public function view_user() {
		$template['page'] = 'User/view-user';
		$template['page_title'] = "View User";
		$template['data'] = $this->user_model->get_user();
		$this->load->view('template',$template);
	}
	
	public function view_single_user() {
		$id = $_POST['id'];
		$template['data'] = $this->user_model->get_single_user($id);
		$this->load->view('User/view-user-popup',$template);
	}
	
	private function set_upload_options() {   
		//upload an image options
		$config = array();
		$config['upload_path'] = 'assets/uploads/profile_pic';
		$config['allowed_types'] = 'gif|jpg|png';
		$config['max_size'] = '5000';
		$config['overwrite'] = FALSE;
	
		return $config;
	}
	
	public function view_employees()
	{
		$template['page'] = 'User/view-emp';
		$template['page_title'] = "View Employees";
		$template['data'] = $this->user_model->get_emp();
		//echo '<pre>';print_r($template);exit;
		$this->load->view('template', $template);
	}
	
	public function add_employee() 
	{	
		$template['page'] 		= 'User/add-emp';
		$template['page_title'] = "Add Employee";
		$template['shops'] 		= $this->shop_model->get_shops();
	      
		if($_POST)
		{
			$data 	= $_POST;
			unset($data['submit']);
			unset($data['shop_id']);
			//echo '<pre>';print_r($data);exit;
			$config = $this->set_upload_options();
			
			$this->load->library('upload');
			$this->upload->initialize($config);
			
			if(!isset($_POST['shop_id']))
			{
				$this->session->set_flashdata('message', array('message' => 'Please assign branch to the employee','class' => 'danger'));	
				$this->load->view('template', $template);			
			}
			else if ( ! $this->upload->do_upload('profile_pic')) 
			{
				$this->session->set_flashdata('message', array('message' => 'Error Occured While Uploading Files','class' => 'danger'));
				$this->load->view('template', $template);
			}
			else 
			{			
				$upload_data = $this->upload->data();
				$data['profile_pic'] = MAIN_URL.$config['upload_path']."/".$upload_data['file_name'];
				
				$result = $this->user_model->save_employees($data);
				
				if($result == "alreadyexist") 
				{
					$this->session->set_flashdata('message', array('message' => 'Email ID already exist','class' => 'danger'));
					$this->load->view('template', $template);
				}
				else 
				{
					if(!empty($_POST['shop_id']))
					{
						foreach($_POST['shop_id']as $shop_id)
						{
							$info['emp_id']		= $result;
							$info['shop_id']	= $shop_id;
							$this->shop_model->assign_employees($info);
							unset($info);
						}
					}
					$this->session->set_flashdata('message', array('message' => 'Employee Saved successfully','class' => 'success'));
					redirect(BASE_URL.'user/view_employees');
				}				
			}
		}
		else 
		{
   			$this->load->view('template', $template);
		}
	}
	
	public function edit_employee() 
	{	
		$template['page'] = 'User/edit-emp';
		$template['page_title'] = "Edit Employee";
		
		$id = $this->uri->segment(3);
		$template['data'] 	= $this->user_model->get_single_employee($id);
		$template['shops']	= $this->shop_model->get_shops();
		$employee_shops		= $this->user_model->get_emp_shops($id);
		$template['emps']	= array();
		if(!empty($employee_shops))
		{
			foreach($employee_shops as $employee_shop)
			{
				$template['emps'][]	= $employee_shop->shop_id;
			}
		}
		//echo '<pre>';print_r($employee_shops);exit;
		if($_POST) 
		{
			$data = $_POST;
			unset($data['submit']);
			unset($data['shop_id']);
			unset($data['pre_emps']);
			if(isset($_FILES['profile_pic'])) 
			{
				$config = $this->set_upload_options();
			
				$this->load->library('upload');
				$this->upload->initialize($config);
				
				if ( ! $this->upload->do_upload('profile_pic')) 
				{
					unset($data['profile_pic']);
				}
				else 
				{
					$upload_data = $this->upload->data();
					$data['profile_pic'] = MAIN_URL.$config['upload_path']."/".$upload_data['file_name'];
				}
			}
			
			$result = $this->user_model->update_emp($data, $id);
			
			if($result == "Exist") 
			{
				$this->session->set_flashdata('message', array('message' => 'Email id already exist','class' => 'danger'));
			}
			else if($result == "Already Exist") 
			{
				$this->session->set_flashdata('message', array('message' => 'Email id already exist','class' => 'danger'));
			}
			else
			{
				$pre_emps 	= $_POST['pre_emps'];
				$diff 		= array_diff($pre_emps, $_POST['shop_id']);				
				if(!empty($diff))
				{
					foreach($diff as $d_shop_id)
					{
						$this->shop_model->delete_employee('shop_id = '.$d_shop_id.' AND employee_id = '.$id);
					}
				}
				
				if(!empty($_POST['shop_id']))
				{
					foreach($_POST['shop_id']as $shop_id)
					{
						$info['emp_id']		= $id;
						$info['shop_id']	= $shop_id;
						$this->shop_model->assign_employees($info);
						unset($info);
					}
				}
				$this->session->set_flashdata('message', array('message' => 'Employee Updated Successfully','class' => 'success'));
			}
			
     		redirect(BASE_URL.'user/view_employees');
		}
		else {
   			$this->load->view('template', $template);
		}
	}
	
 	public function delete_employee() 
	{
		$id = $this->uri->segment(3);
		$result = $this->user_model->delete_employee($id);
		$this->session->set_flashdata('message', array('message' => 'Employee Deleted Successfully','class' => 'success'));
     	redirect(BASE_URL.'user/view_employees');
	}
		
	public function assign_services()
	{
		$id = $this->uri->segment(3);
		$template['services'] = $this->service_model->get_service();
		$template['data'] = $this->user_model->get_single_employee($id);
		
		if($_POST) 
		{
			$data = $_POST;
			unset($data['submit']);
			
			$result 	= $this->user_model->assign_service($data);
			if($result == "Exist") 
			{
				$this->session->set_flashdata('message', array('message' => 'Service already assigned for selected employee','class' => 'danger'));
			}
			else if($result == "ErrorService") 
			{
				$this->session->set_flashdata('message', array('message' => 'No service selected!!!','class' => 'danger'));
			}
			else 
			{
				if($result == 0)
				{
					$this->session->set_flashdata('message', array('message' => 'No service has been assigned for selected employee','class' => 'danger'));
				}
				else
				{
					$txt = $result > 1 ? 'services' : 'service';
					$this->session->set_flashdata('message', array('message' => $result.' '.$txt.' assigned successfully.','class' => 'success'));
				}
			}
		}
		
		$employee_services = $this->user_model->get_employee_services($id);
		$template['page'] = 'User/assign_service';
		$template['page_title'] = "Assign Service";
		$template['employee_services'] = array();
		if(!empty($employee_services))
		{
			foreach($employee_services as $employee_service)
			{
				$template['employee_services'][] = $employee_service->service_id;
			}
		}
		//echo '<pre>';print_r($template);exit;
		$this->load->view('template', $template);
	}
}