<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Shop extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		
		$this->load->model('shop_model');
		$this->load->model('service_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(BASE_URL);
		}
 	}
	
	public function add_shop() 
	{		
		$template['page'] = 'Shops/add-shop';
		$template['page_title'] = "Add Branch";
		if($_POST) {
			$data = $_POST;
			
			$shop_name = preg_replace('/\s+/', ' ',$data['shop_name']);
			$data['shop_name'] = preg_replace('/[^a-zA-Z0-9\s]/', '', $shop_name);
			
			unset($data['submit']);
			$data['created_user'] = $this->session->userdata('logged_in');
			$data['created_user'] = $data['created_user']['id'];
			 $config = $this->set_upload_options();
			
			$this->load->library('upload');
			$this->upload->initialize($config);
			
			if ( ! $this->upload->do_upload('image')) 
			{
				//$result = array('error' => $this->upload->display_errors());
				//echo $this->upload->display_errors();
				$this->session->set_flashdata('message', array('message' => $this->upload->display_errors().'Error Occured While Uploading Files','class' => 'danger'));
			}
			else 
			{
				$upload_data = $this->upload->data();
				$data['image'] = MAIN_URL.$config['upload_path']."/".$upload_data['file_name'];
				$result = $this->shop_model->save_shop($data);
				array_walk($data, "remove_html");
				$this->session->set_flashdata('message', array('message' => 'Branch Saved successfully','class' => 'success'));
			}
			
     		redirect(BASE_URL.'shop/view_shops');
		}	
		else 
		{
   			$this->load->view('template', $template);
		}
	}
	
	public function assign_employees() 
	{		
		$id = $this->uri->segment(3);
	  	$template['page'] 		= 'Shops/assign_employees';
		$template['page_title'] = "Assign Employees";
		$template['shop_id'] 	= $id;
		
		if($_POST) 
		{
			$data = $_POST;
			unset($data['submit']);
			
			$result 	= $this->shop_model->assign_employees($data);
			if($result == "Exist") 
			{
				$this->session->set_flashdata('message', array('message' => 'Employee already assigned for selected branch','class' => 'danger'));
			}
			else if($result == "ErrorService") 
			{
				$this->session->set_flashdata('message', array('message' => 'No employee selected!!!','class' => 'danger'));
			}
			else 
			{
				if($result == 0)
				{
					$this->session->set_flashdata('message', array('message' => 'No employee has been assigned for selected branch','class' => 'danger'));
				}
				else
				{
					$this->session->set_flashdata('message', array('message' => 'Employee assigned successfully.','class' => 'success'));
				}
			}
		}
		
		$template['data']		= $this->shop_model->get_emp_by_shop($id);
		$id = '0';
		foreach($template['data'] as $tem)
		{
			$id .= ','.$tem->employee_id; 
		}
		$template['employees']	= $this->shop_model->get_emp('id NOT IN ('.$id.')');
		//echo '<pre>';print_r($template);exit;
		
		
   		$this->load->view('template', $template);
	}
	
	
 	public function delete_shop_employee() 
	{
		$emp_id	= $this->uri->segment(3);
		$shop_id = $this->uri->segment(4);
		$result = $this->shop_model->delete_employee('shop_id = '.$shop_id.' AND employee_id = '.$emp_id);
		$this->session->set_flashdata('message', array('message' => 'Employee Deleted Successfully','class' => 'success'));
     	redirect(BASE_URL.'shop/assign_employees/'.$shop_id);
	}
	
	
	public function assign_service() 
	{
	  	$template['page'] 		= 'Shops/assign-service';
		$template['page_title'] = "Assign Service";
		$template['shops'] 		= $this->shop_model->get_shops();
		$template['services'] 	= $this->service_model->get_service();
		
		if($_POST) 
		{
			$data = $_POST;
			unset($data['submit']);
			
			$result 	= $this->shop_model->assign_service($data);
			if($result == "Exist") 
			{
				$this->session->set_flashdata('message', array('message' => 'Service already assigned for selected shop','class' => 'danger'));
			}
			else if($result == "shoperror") 
			{
				$this->session->set_flashdata('message', array('message' => 'No branch selected!!!','class' => 'danger'));
			}
			else if($result == "ErrorService") 
			{
				$this->session->set_flashdata('message', array('message' => 'No service selected!!!','class' => 'danger'));
			}
			else 
			{
				if($result == 0)
				{
					$this->session->set_flashdata('message', array('message' => 'No service has been assigned for selected shop','class' => 'danger'));
				}
				else
				{
					$txt = $result > 1 ? 'services' : 'service';
					$this->session->set_flashdata('message', array('message' => $result.' '.$txt.' assigned successfully.','class' => 'success'));
				}
			}
		}
		
   		$this->load->view('template', $template);
	}	
	
	public function edit_shop() 
	{		
		$template['page'] = 'Shops/edit-shop';
		$template['page_title'] = "Edit Branch";
		
		$id = $this->uri->segment(3);
		$template['data'] = $this->shop_model->get_single_shop($id);
		if(!empty($template['data'])) 
		{
			if($_POST) 
			{
				$data = $_POST;
				
				$shop_name = preg_replace('/\s+/', ' ',$data['shop_name']);
				$data['shop_name'] = preg_replace('/[^a-zA-Z0-9\s]/', '', $shop_name);
				
				unset($data['submit']);
				
				if(isset($_FILES['image'])) {
					$config = $this->set_upload_options();
				
					$this->load->library('upload');
					$this->upload->initialize($config);
					
					if ( ! $this->upload->do_upload('image')) {
						unset($data['image']);
					}
					else {
						$upload_data = $this->upload->data();
						$data['image'] = MAIN_URL.$config['upload_path']."/".$upload_data['file_name'];
					}
				}
				
				$data['created_user'] = $this->session->userdata('logged_in');
				$data['created_user'] = $data['created_user']['id'];
				$result = $this->shop_model->update_shop($data, $id);
				array_walk($data, "remove_html");
				$this->session->set_flashdata('message', array('message' => 'Branch Updated Successfully','class' => 'success'));
				redirect(BASE_URL.'shop/view_shops');
			}
			else 
			{
				$this->load->view('template', $template);
			}
		}
		else 
		{
			$this->session->set_flashdata('message', array('message' => "You don't have permission to access.",'class' => 'danger'));
			redirect(BASE_URL.'shop/view_shops');
		}
	}
	
	public function delete_shop() 
	{
		$id = $this->uri->segment(3);
		$result = $this->shop_model->delete_shop($id);
		$this->session->set_flashdata('message', array('message' => 'Branch Deleted Successfully','class' => 'success'));
     	redirect(BASE_URL.'shop/view_shops');
	}
	
	public function view_shops() 
	{
		$template['page'] = 'Shops/view-shop';
		$template['page_title'] = "View Branches";
		$template['data'] = $this->shop_model->get_shops();
		$this->load->view('template',$template);
	}
	
	public function gallery() 
	{
		$template['page'] = 'Shops/gallery';
		$template['page_title'] = "Gallery";
		$template['data'] = $this->shop_model->get_shops();
		
		if($_POST) 
		{
			$data = $_POST;
			$data['user_id'] = $this->session->userdata('logged_in');
			$data['user_id'] = $data['user_id']['id'];
			$files = $_FILES;
			$cpt = count($_FILES['shopimage']['name']);
			
			for($i=0; $i<$cpt; $i++) 
			{
				$_FILES['shopimage']['name']= $data['user_id']."-".$files['shopimage']['name'][$i];
				$_FILES['shopimage']['type']= $files['shopimage']['type'][$i];
				$_FILES['shopimage']['tmp_name']= $files['shopimage']['tmp_name'][$i];
				$_FILES['shopimage']['error']= $files['shopimage']['error'][$i];
				$_FILES['shopimage']['size']= $files['shopimage']['size'][$i];  
				
				$config = $this->set_upload_options();
				
				//$data['image_path'] = MAIN_URL.$config['upload_path']."/".$_FILES['shopimage']['name'];
				
				$this->load->library('upload');
				$this->upload->initialize($config);
				
				if ( ! $this->upload->do_upload('shopimage')) {
					//$result = array('error' => $this->upload->display_errors());
					$this->session->set_flashdata('message', array('message' => 'Error Occured While Uploading Files','class' => 'danger'));
				}
				else {
					$upload_data = $this->upload->data();
					$data['image_path'] = MAIN_URL.$config['upload_path']."/".$upload_data['file_name'];
					array_walk($data, "remove_html");
					$this->session->set_flashdata('message', array('message' => 'Images Uploaded Successfully','class' => 'success'));
					$result = $this->shop_model->save_gallery($data);
					
					//$result = array('upload_data' => $this->upload->data());
				}
			}
			redirect(BASE_URL.'shop/gallery');
		}
		$template['gallery'] = $this->shop_model->get_gallery();
		//var_dump($template['gallery']);
		$this->load->view('template',$template);
	}
	
	public function view_shop_gallery() {
		
		$id = $this->uri->segment(3);
		$template['page'] = 'Shops/view-shop-gallery';
		$template['page_title'] = "Branch Gallery";
		$template['data'] = $this->shop_model->get_shop_gallery($id);
		//echo $this->db->last_query();exit;
		if(!empty($template['data'])) {
			$this->load->view('template',$template);
		}
		else {
			//$this->session->set_flashdata('message', array('message' => "You don't have permission to access.",'class' => 'danger'));
			// redirect(BASE_URL.'shop/gallery');
			$this->load->view('template',$template);
		}
	}
	
	private function set_upload_options() {   
		//upload an image options
		$config = array();
		$config['upload_path'] = 'assets/uploads';
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		$config['max_size']      = '5000';
		$config['overwrite']     = FALSE;
	
		return $config;
	}
	
	// Ajax Funciton
	public function view_single_shop() {
		$id = $_POST['id'];
		$template['data'] = $this->shop_model->get_single_shop($id);
		$template['services'] = $this->shop_model->get_shop_services($id);
		$this->load->view('Shops/view-shop-popup',$template);
	}
	
	public function get_shop_services($id) {
		$template['services'] = $this->shop_model->get_shop_services($id);
		//echo $this->db->last_query();
		echo json_encode($template);
	}
	
	public function delete_gallery_image() {
		$id = $_POST['id'];
		$result = $this->shop_model->delete_gallery_image($id);
		echo $result;
	}
	
	public function remove_shop_service() {
		$id = $_POST['id'];
		$result = $this->shop_model->remove_shop_service($id);
		echo $result;
	}
}
