<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Service extends CI_Controller {


	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('service_model');
		if(!$this->session->userdata('logged_in')) {
			redirect(BASE_URL);
		}
		else {
			$menu = $this->session->userdata('admin');
			 if( $menu != 1 && $menu != 3 ) {
				 $this->session->set_flashdata('message', array('message' => "You don't have permission to access service page.",'class' => 'danger'));
				 redirect(BASE_URL.'dashboard');
			 }
		}
 	}
	
	public function index() {
		$template['page'] = 'Shops/services';
		$template['page_title'] = "Services";
		$upload_dir = 'assets/uploads/services';
		if($_POST) 
		{
			$data = $_POST;
			unset($data['submit']);
			if(isset($_FILES['image']))
			{
				$config = array();
				$config['upload_path']	= $upload_dir;
				$config['allowed_types']= 'gif|jpg|png|jpeg';
				$config['max_size']		= '50000';
				$config['overwrite']	= FALSE;
				
				$this->load->library('upload');
				$this->upload->initialize($config);
				
				if ( ! $this->upload->do_upload('image')) {
					//$result = array('error' => $this->upload->display_errors());
					$this->session->set_flashdata('message', array('message' => $this->upload->display_errors().'Error Occured While Uploading Files','class' => 'danger'));
					//echo $this->upload->display_errors();
				}
				else 
				{
					$upload_data = $this->upload->data();
					$data['image'] = MAIN_URL.$upload_dir."/".$upload_data['file_name'];
				}
			}
			//echo '<pre>';print_r($data);exit;
			$result = $this->service_model->save_service($data);
			$this->session->set_flashdata('message', array('message' => 'Service Saved successfully','class' => 'success'));
			redirect(BASE_URL.'service');
		}
		else 
		{
			$template['data'] = $this->service_model->get_service();
			$this->load->view('template', $template);
		}
	}
	
	public function edit_service() {
		
		$template['page'] = 'Shops/edit-service';
		$template['page_title'] = "Edit Service";
		
		$id = $this->uri->segment(3);
		$template['data'] = $this->service_model->get_single_service($id);;
		if($_POST) {
			$data = $_POST;
			unset($data['submit']);
			if(isset($_FILES))
			{
				$config = array();
				$config['upload_path']	= 'assets/uploads/services';
				$config['allowed_types']= 'gif|jpg|png|jpeg';
				$config['max_size']		= '50000';
				$config['overwrite']	= FALSE;
				
				$this->load->library('upload');
				$this->upload->initialize($config);
				
				if ( ! $this->upload->do_upload('image')) {
					//$result = array('error' => $this->upload->display_errors());
					$this->session->set_flashdata('message', array('message' => $this->upload->display_errors().'Error Occured While Uploading Files','class' => 'danger'));
					//echo $this->upload->display_errors();
					//echo '<pre>';print_r($this->upload->display_errors());exit;
				}
				else 
				{
					$upload_data = $this->upload->data();
					$data['image'] = MAIN_URL.$config['upload_path']."/".$upload_data['file_name'];
					//echo '<pre><b>';print_r($data);exit;
				}
			}
			
			$result = $this->service_model->update_service($data, $id);
			$this->session->set_flashdata('message', array('message' => 'Service Updated successfully','class' => 'success'));
     		redirect(BASE_URL.'service');
		}
		else {
   			$this->load->view('template', $template);
		}
	}
	
	public function delete_service() {
		$id = $this->uri->segment(3);
		$result = $this->service_model->delete_service($id);
		$this->session->set_flashdata('message', array('message' => 'Service Deleted Successfully','class' => 'success'));
     	redirect(BASE_URL.'service');
	}
}
