<?php
if($this->session->flashdata('message')) {
  $message = $this->session->flashdata('message');?>
<div class="alert alert-<?php echo $message['class']; ?>">
  <button class="close" data-dismiss="alert" type="button">×</button>
  <?php echo $message['message']; ?> </div>
<?php }?>
<div class="row">
  <div class="box col-md-12">
    <div class="box-inner">
      <div class="box-header well" data-original-title="">
        <h2><i class="glyphicon glyphicon-pencil"></i> <?php echo $page_title; ?></h2>
      </div>
      <div class="box-content">
        <form role="form" method="post" class="validate" enctype="multipart/form-data">
          <div class="form-group">
          	<div class="col-xs-4" style="padding:0">
            	<label class="control-label" for="shop_name">Select Branch</label>
                <div class="controls">
                  <select id="selectError" class="col-md-3" data-rel="chosen" onchange="get_shop_services(this.value)" name="shop_id">
                  	<option value="">Please Select Branch</option>	
                    <?php foreach($shops as $shop) {
                            echo "<option value='".$shop->id."'>".$shop->shop_name."</option>";
                        }?>
                  </select>
                </div>
            </div>
          </div>
          
          <div class="form-group">
          	<div class="col-xs-4" style="padding:0;">
            	<label class="control-label">Service Name</label>
            </div>
            <div class="col-xs-6">
            	<label class="control-label" for="price">Price</label>
            </div>
          </div>      
          <?php foreach($services as $service) {?>
          <div class="form-group">
          	<div class="col-xs-4" style="padding:0;">
            	<div class="controls">
              		<input type="checkbox" class="chk-box" value="<?php echo $service->id;?>" id="<?php echo $service->id;?>" name="service_id[<?php echo $service->id;?>]" />
                    <label class="control-label" style="font-weight:normal;" for="<?php echo $service->id;?>"><?php echo $service->service_name;?></label>
            	</div>
            </div>
            <div class="col-xs-6">
            	<div class="controls">
                    <input type="text" name="price[<?php echo $service->id;?>]" id="<?php echo 'price_'.$service->id;?>" class="form-control price" placeholder="Enter Price">
                </div>
          	</div>
          </div>
          <?php }?>
          <button type="submit" class="btn btn-custom"><i class="glyphicon glyphicon-plus"></i> Save</button>
        </form>
      </div>
    </div>
  </div>  
</div>
<script type="text/javascript">
	function get_shop_services(id)
	{
		//console.log(id);
		$.ajax({
			type : "GET",
			url : '<?php echo BASE_URL.'shop/get_shop_services/';?>'+id,
			dataType : "json",
			success: function(data) {
				//console.log(data);
				$('.price').val('');
				$('.chk-box').prop('checked', false);
				for(var i = 0; i < data.services.length; i++)
				{
					//console.log(data.services[i]);
					$('#'+data.services[i].ms_id).prop('checked', true);
					$('#price_'+data.services[i].ms_id).val(data.services[i].price);
				}
			},
			error : function() {
				alert("Sorry, The requested property could not be found.");
			}
		});
	}
</script>
<style type="text/css">
	.chosen-container{
		width:100% !important;
	}
	.form-group{
		float:left;
		width:100% !important;
	}
	input[type="checkbox"]{
		float:left;
		margin-right:5px;
	}
	label{
		cursor:pointer;
	}
</style>