<?php

	defined('BASEPATH') OR exit('No direct script access allowed');
	

	class App_user extends My_model{
		
		//protected $_table = "users";
		protected $primary_key = "id";
		protected $return_type = "array";
		
		public $has_many = array('booking_history_model');
		
		
		protected $after_get = array( "remove_sensitive_data" );
		protected $before_create = array( "prep_data" );
		
		protected function remove_sensitive_data($user){
			
			//unset( $user['password'] );
			//unset( $user['id'] );
			
			return $user;
			
		}
		
		protected function prep_data($user){
			$user['password'] = md5( $user['password'] );
			/*
			$user['ip_address'] 	= $this->input->ip-address();
			$user['created_date'] = date('Y-m-d H:i');
			*/
			return $user;
		}
		
		public function login($login_data)
    {
        $this->db->where("(email_id = '$login_data[username]')");
		$this->db->where('password', md5($login_data['password']));
    	$this->db->from('users');


       $result = $this->db->get()->row();
       return $result;
    }
	
	public function insert_services($services) {
		$this->db->insert_batch('mytable', $services); 
		return $this;
	}
	
	public function getbranchlist(){
		$query = $this->db->query("SELECT a.id AS Brach_id,a.shop_name AS Branch_Name,a.description,
         a.working_time,a.location,a.city,a.state,a.country,a.phone_no,a.image, 
           ifnull(CAST(AVG(b.rating) as decimal(10,2)),0) as rating
           FROM shop_details a 
           left outer join rating b on a.id=b.shop_id
           group by a.id");
		$result = $query->result();
		return $result;
	}
 
    public function checkuseremail($emailid){
    	$this->db->select('*');
    	$this->db->from('users');
    	$this->db->where('email_id',$emailid);
    	$result = $this->db->get()->result();
		if (empty($result)) {
			return true;
		}else{
			return false;
		}
    		
    }

    public function update_profile($id,$data){
    	$this->db->where('id',$id);
    	$this->db->update('users', $data);
    	return true;
    }

    public function insert_booking($data){
    	$this->db->insert('booking_history', $data); 
		$this->db->last_query();
		return $this->db->insert_id();
    }


	public function insert_details($data){
    	$this->db->insert('booking_details', $data); 
		return true;
    }
    

    public function service_duration($id){
    	$this->db->select('duration');
    	$this->db->from('main_services');
    	$this->db->where('id',$id);
		$result = $this->db->get()->row();
    	return $result->duration;
    }

    public function check_booking($date,$time){
    	$this->db->select('*');
    	$this->db->from('booking_history');
    	$this->db->where('booking_date',$date);
    	$this->db->where('booking_time',$time);
    
    	$result = $this->db->get()->result();
		if (empty($result)) {
			return 'Booked';
		}else{
			return 'Tentative';
		}
    }

    public function order_history($id){

		$query = $this->db->query("SELECT bd.id,ms.service_name,CONCAT(bh.booking_date,' ',bh.booking_time) booking_time,bd.service_id,bh.shop_id,bd.price,bh.status    
                  FROM booking_history bh 
                  JOIN booking_details bd ON bd.booking_id=bh.id
                  JOIN main_services ms ON ms.id=bd.service_id
                  AND bh.user_id=$id
                  ORDER BY bd.id DESC");
		$result = $query->result();
		return $result;
    }

    public function populate_rating(){

    	$query = $this->db->query("SELECT r.shop_id,AVG(r.rating) AS BranchRating,sd.shop_name
							        FROM rating r
							        JOIN shop_details sd 
							        GROUP BY r.shop_id");
		$result = $query->result();
		return $result;
    }


    public function service_rating($id){
    	$query = $this->db->query("SELECT shop_id,service_id,avg(rating) from rating
       							 where shop_id='$id'
        						GROUP BY service_id");
		$result = $query->result();
		return $result;
    }

    public function service_listing($id){

    	$query = $this->db->query("SELECT ss.shop_id as branch_id,ss.service_id, ms.service_name,concat(ms.duration,' ',ms.type) as duration,ms.image,ss.price,
          ifnull(CAST(AVG(r.rating) as decimal(10,2)),0) as rating
               from shop_services ss 
               join main_services ms on ms.id=ss.service_id
               left outer join rating r on r.service_id=ms.id and r.shop_id=ss.shop_id
               where ss.shop_id=$id
               GROUP BY ms.id;");
		$result = $query->result();
		return $result;
    }

    public function booked_rating($data){
    	$this->db->insert('rating',$data);
    	return true;
    }

    public function get_profile($id){
		
		$this->db->select('username,password,email_id,phone_no');
    	$this->db->from('users');
    	$this->db->where('id',$id);
		$result = $this->db->get()->row();
    	return $result;
    }

    public function employee_listing($shop_id,$service_id){

    	$query = $this->db->query("SELECT e.id as employee_id,es.shop_id,phone_no,email_id,
              concat(e.firstname,' ',e.lastname) as Name,e.profile_pic,ms.id as service_id,ms.service_name,ss.price,eser.rating
             from employees e 
             join emp_shops es 		on es.employee_id=e.id
             join emp_services eser on eser.employee_id=e.id
             join main_services ms 	on ms.id=eser.service_id
             join shop_services ss 	on ss.service_id=ms.id and ss.shop_id=es.shop_id
             where es.shop_id=$shop_id
             and ms.id=$service_id");
		$result = $query->result();

		return $result;

    }

    public function booking_slots($shop_id,$service_id,$bookingdate,$bookingtime){
    	$query = $this->db->query("SELECT bh.id,ms.service_name,bh.booking_time AS Booking_From, bh.end_time AS Booking_Till,bh.booking_date 
               FROM booking_history bh
               JOIN booking_details bd ON bh.id=bd.booking_id
               JOIN shop_services ss ON ss.id=bd.service_id
               JOIN main_services ms ON ss.service_id=ms.id
               WHERE bh.booking_date='$bookingdate' AND bh.booking_time='$bookingtime'
               AND bd.service_id='$service_id'  AND bh.shop_id='$shop_id'
               ORDER BY Booking_From");
		$result = $query->row();
		return $result;
    }


    public function shop_hours($id){
      $query = $this->db->query("SELECT SUBSTRING_INDEX(working_time, '-', 1) AS OpeningHour,
                                SUBSTRING_INDEX(working_time,'-',-1) AS ClosingHour
                                -- SUBSTRING_INDEX(Name, ' ', -1) as lname FROM mytable;
                                  from shop_details
                                  where id='$id'");
    $result = $query->result();
    return $result;
    }


    public function special_offer($shopid){
		$query = $this->db->query("SELECT ss.shop_id as branch_id,ms.service_name, 
           							ss.offer_price as price, 
            						ms.id as service_id,ms.type, ms.image, concat(ms.duration,' ',ms.type) as duration
      								from shop_services ss 
      								join main_services ms on ss.service_id=ms.id
      								where  ss.shop_id=$shopid
      								and ss.has_offer=1");
					$result = $query->result();
					return $result;
    }

     public function img_gallery(){
      $this->db->order_by('id', 'RANDOM');
    	$this->db->limit(5);
      $query = $this->db->get('shop_gallery')->result();
    	return $query;
    }

    public function insertuser($data){

    	$this->db->insert('users',$data);
    	return true;
    } 
		
	}
	
	
	
?>