<?php

defined('BASEPATH') OR exit('No direct script access allowed');

 // Allow from any origin
	if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }

	// Access-Control headers are received during OPTIONS requests
	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
			header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
			header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

		exit(0);
	}



// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH . '/libraries/REST_Controller.php';

class Api_App extends REST_Controller {

    function __construct()
    {
        // Construct the parent class
        parent::__construct();
				
				$this->load->library('form_validation');
				//$this->load->helper('JWT');
    }
		
	public function signUpApp_post(){

		$this->form_validation->set_data($this->post());
				
				if($this->form_validation->run('signupapp') !== false){
					
					$this->load->model('web_services/App_user');

					$ans 	= $this->App_user->checkuseremail($this->input->post('email_id'));//check email existence

					if ($ans == true) {
					
					$data = array('username'	=> $this->input->post('username'),
									'password' 	=> md5($this->input->post('password')),
									'phone_no' 	=> $this->input->post('phone_no'),
									'status' 	=> 1,
									'email_id' 	=> $this->input->post('email_id'));

					$this->App_user->insertuser($data);

					$result =  array('status'=>'success','message'=> 'User Created Successfully');

					$this->response($result);

					}else{

					$result =  array('status'=>'failure','message'=> 'This email already exists');	
					$this->response($result);

					}
				
				}else{
					$result =  array('status'=>'failure', 'message'=>  validation_errors());
													 
					$this->response($result);			
					}
	
	}


/* 		SignIn POST
========================================================================*/
		public function login_post(){
				$login_data = $this->post();
				
			$x = new stdClass();
				
				$this->form_validation->set_data($login_data);
				if( $this->form_validation->run('signIn') !== false){
					
					$this->load->model('web_services/App_user');
					
					$result = $this->App_user->login($login_data);
					//$this->response($result);die;
					
					
					$message = "Invalid ID or Password"; 
					if(!$result){
							
							$message = [];
							
							$this->response([ 'status' => 'failure', 'message' => $message ,'profile'=>$x], REST_Controller::HTTP_OK); 
					
					}else{


							
							$response =  array( 'status'=>'success',  'message'=> 'SignIn Successfully completed',
																	 'profile'=>$result);	
							
							$this->response( $response );
							//$this->response( $result );
							
					}
				
				}else{
					$result =  array('status'=>'failure', 
														'message'=> 'Empty Parameters','profile'=>$x);
					$this->response($result ,REST_Controller::HTTP_OK );
				
				}
		}



		public function shophours_post(){
		
	
			if (!empty($this->input->post('id'))) {

			$this->load->model('web_services/App_user');
			$result = $this->App_user->shop_hours($this->input->post('id'));
	
			$resp =  array('status'=>'success','message'=> $result);

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'ID is required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
				
		}



		public function branchlisting_get(){
		
	
			$this->load->model('web_services/App_user');
			$result = $this->App_user->getbranchlist();
	
			$resp =  array('status'=>'success','message'=>$result);

			$this->response($resp);
				
				
		}


		public function servicelisting_post(){
		
			if (!empty($this->input->post('id'))) {

			$this->load->model('web_services/App_user');
			$result = $this->App_user->service_listing($this->input->post('id'));
	
			$resp =  array('status'=>'success','message'=> $result);

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'Service ID is required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
			
				
				
		}


		public function updateprofile_post(){

			if (!empty($this->input->post('id')) && !empty($this->input->post('username')) && !empty($this->input->post('email_id')) && !empty($this->input->post('phone_no'))) {

				if (empty($this->input->post('password'))) {
					
					$data = array('username' 		=> $this->input->post('username'),
								'email_id' 		=> $this->input->post('email_id'),
								'phone_no' 		=> $this->input->post('phone_no'));

				}else{

			  	$data = array('username' 		=> $this->input->post('username'),
								'email_id' 		=> $this->input->post('email_id'),
								'password'		=> md5($this->input->post('password')),
								'phone_no' 		=> $this->input->post('phone_no'));
					
				}
				

			$this->load->model('web_services/App_user');
			$result = $this->App_user->update_profile($this->input->post('id'),$data);

			if ($result == true){
			$resp =  array('status'=>'Success','message'=> 'Successfully Updated');

			}else{

			$resp =  array('status'=>'failure','message'=> 'User Update failed');
			}

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'All Parameters equired');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
		}

		public function populaterating_get(){
			$this->load->model('web_services/App_user');

			$result = $this->App_user->populate_rating();
			if (empty($result)) {

			$resp =  array('status'=>'success','message'=> array(new stdClass));

			}
			else{
				$resp =  array('status'=>'success','message'=> $result);
			}
			$this->response($resp);
		}

		public function servicerating_post(){
			$this->load->model('web_services/App_user');
			if (!empty($this->input->post('id'))) {
				# code...
			
			$result = $this->App_user->service_rating($this->input->post('id'));

			if (empty($result)) {

			$resp =  array('status'=>'success','message'=> array(new stdClass));
			$this->response($resp);
			}
			else{
			
			$resp =  array('status'=>'success','message'=> $result);
			$this->response($resp);
			}

		}else{
			
			$result =  array('status'=>'failure','message'=> 'Both Parameter required');
					$this->response( $result ,REST_Controller::HTTP_OK );	
		}
			
		}
		

		public function employeelisting_post(){
			
			if (!empty($this->input->post('shop_id') && !empty($this->input->post('service_id')))) {

			$this->load->model('web_services/App_user');
			$result = $this->App_user->employee_listing($this->input->post('shop_id'),$this->input->post('service_id'));

			if (empty($result)){

			$resp =  array('status'=>'failure','message'=> array(new stdClass));

			}else{

			$resp =  array('status'=>'success','message'=> $result);
			}

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'Both Parameter required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
					
		}



	    public function getprofile_post(){

		if (!empty($this->input->post('id'))){

			$this->load->model('web_services/App_user');
			$result = $this->App_user->get_profile($this->input->post('id'));
			

			if (empty($result)){

			$resp =  array('status'=>'failure','message'=> array(new stdClass));

			}else{

			$resp =  array('status'=>'success','message'=> $result);
			
			}

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'ID is required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
    }



	    public function orderhistory_post(){

		if (!empty($this->input->post('id'))){

			$this->load->model('web_services/App_user');
			$result = $this->App_user->order_history($this->input->post('id'));
	
			$resp =  array('status'=>'success','message'=> $result);

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'ID is required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
    }




	    public function imggallery_get(){

			$this->load->model('web_services/App_user');

			$result = $this->App_user->img_gallery();
			if (empty($result)) {
			
			$resp =  array('status'=>'success','message'=> array(new stdClass));

			}else{

			$resp =  array('status'=>'success','message'=> $result);
			}

			$this->response($resp);

    }


		public function submitorder_post(){

				$this->form_validation->set_data($this->post());
				
				if($this->form_validation->run('submitorder') !== false){


				$this->load->model('web_services/App_user');
				$status 			= $this->App_user->check_booking($this->input->post('booking_date'),$this->input->post('booking_time'));
				$serviceduration 	= $this->App_user->service_duration($this->input->post('service_id'));
				$end_time 			= date("H:i:s", strtotime('+'.$serviceduration.' hours'));
				$maildata 		 	= array('price' => $this->input->post('price'),'serviceid' => $this->input->post('service_id'));

				$data = array('booking_id'		=> 'PG'.time(),
								'user_id' 		=> $this->input->post('user_id'),
								'shop_id' 		=> $this->input->post('shop_id'),
								'booking_date' 	=> $this->input->post('booking_date'),
								'booking_time' 	=> $this->input->post('booking_time'),
								'total' 		=> $this->input->post('price'),
								'booked_date' 	=> date('Y-m-d h:i:s'),
								'status' 		=> $status,
								'end_time' 		=> $end_time);

				$insertbooking = $this->App_user->insert_booking($data);

				$bookingdetails = array('booking_id' => $insertbooking,'service_id' => $this->input->post('service_id'),'price' =>$this->input->post('price'));

				$insertdetails = $this->App_user->insert_details($bookingdetails);

				if ($insertdetails == true) {
					$config = Array(
						    'protocol' 	=> 'smtp',
						    'smtp_host' => 'mail.protegeglobal.com',
						    'smtp_port' => 587,
						    'smtp_user' => 'talha.masood@protegeglobal.com',
						    'smtp_pass' => '@TALHA123@masood',
						    'mailtype'  => 'html', 
						    'charset'   => 'iso-8859-1'
						);

					$this->load->library('email',$config);



					$this->email
							->from("no-reply@pgsalons.com", "PG Salons")
							->to('protegeglobalisl@gmail.com')
							->subject('Welcome to PG Salons')
							->message($this->load->view('submit-order-email', $maildata, true))
							->set_mailtype('html');


					/*$this->email->from("no-reply@pgsalons.com", "PG Salons");
					$this->email->to('talha.masood@protegeglobal.com');
					$this->email->subject('Welcome to PG Salons');
					$this->email->message($this->load->view('submit-order-email',$maildata, true));
					$this->email->set_mailtype('html');
					$this->email->send();
					*/

					if (!$this->email->send())
					{
						if($status == "Tentative"){
		
						$result =  array('status'=>'success', 'message'=> 'Saloon Representative will contact you shortly for appointment confirmation','Mail status'=>'failed');

						}
						else{

						$result =  array('status'=>'success', 'message'=> 'Your order is booked succesfully','Mail status'=>'failed');
						
						}

					}else{

					if($status == "Tentative"){
		
						$result =  array('status'=>'success', 'message'=> 'Saloon Representative will contact you shortly for appointment confirmation','Mail status'=>'success');

						}
						else{

						$result =  array('status'=>'success', 'message'=> 'Your appointment is booked succesfully','Mail status'=>'success');
						
						}
					
					}

				}
				else{
				$result =  array('status'=>'failure', 'message'=> 'problems during insertion');
				}

				$this->response($result);			

				
				}else{
					$result =  array('status'=>'failure', 
										'message'=>  validation_errors());
													 
					$this->response($result);			
					}
					
		}

		public function bookingslots_post(){
			
			if (!empty($this->input->post('service_id') && !empty($this->input->post('shop_id')) && !empty($this->input->post('booking_date'))&& !empty($this->input->post('booking_time')))) {

			$this->load->model('web_services/App_user');

			$result = $this->App_user->booking_slots($this->input->post('shop_id'),$this->input->post('service_id'),$this->input->post('booking_date'),$this->input->post('booking_time'));
			
			if (empty($result)) {

			$resp =  array('status'=>'failure','message' => new stdClass,'error'=> 'All booking slots are open, please proceed to book your service');

			}else{

			$resp =  array('status'=>'failure','message' => new stdClass,'error'=> 'Customer Representative will call you shortly for your booking confirmation.');

			}

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> 'All Parameter required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
					
		}

		public function submitrating_post(){
			if (!empty($this->input->post('booking_id') && !empty($this->input->post('user_id')) && !empty($this->input->post('shop_id')) && !empty($this->input->post('service_id')) && !empty($this->input->post('rating')))) {


				$data = array('added_on'		=> date('Y-m-d h:i:s'),
								'booking_id' 	=> $this->input->post('booking_id'),
								'user_id' 		=> $this->input->post('user_id'),
								'shop_id' 		=> $this->input->post('shop_id'),
								'service_id' 	=> $this->input->post('service_id'),
								'rating' 		=> $this->input->post('rating'));

				$this->load->model('web_services/App_user');
				$ans = $this->App_user->booked_rating($data);
				if ($ans ==  true) {

					$result =  array('status'=>'success','message' => 'Rating Submitted');
					$this->response( $result ,REST_Controller::HTTP_OK );
				}
			}else{
				$result =  array('status'=>'failure','message' => 'All Parameter required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}

		}

		public function specialoffer_post(){
			
			if (!empty($this->input->post('shop_id'))){

			$this->load->model('web_services/App_user');

			$result = $this->App_user->special_offer($this->input->post('shop_id'));
			
			if (empty($result)) {

			$resp =  array('status'=>'failure','message'=> array(new stdClass),'error'=> 'No Special Offer is currently available at selected branch');

			}else{

			$resp =  array('status'=>'success','message'=> $result,'error'=> '');

			}

			$this->response($resp);
				
			}else{
				$result =  array('status'=>'failure','message'=> array(new stdClass),'error'=> 'shop ID is required');
					$this->response( $result ,REST_Controller::HTTP_OK );
				
			}
					
		}








}
