<?php
$doctor_info    = $this->db->get('doctor')->result_array();
$room_info    	= $this->db->get('rooms')->result_array();
?>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-primary" data-collapsed="0">
      <div class="panel-heading">
        <div class="panel-title">
          <h3><?php echo get_phrase('add_appointment'); ?></h3>
        </div>
      </div>
      <div class="panel-body">
        <form role="form" class="form-horizontal form-groups-bordered col-xs-12 pull-left" enctype="multipart/form-data" action="<?php echo base_url(); ?>index.php?receptionist/appointment/create" method="post">
          <div class="form-group" style="display:none;">
            <label for="field-1" class="col-sm-3 control-label"><?php echo get_phrase('date'); ?></label>
            <div class="col-sm-7">
              <div class="date-and-time">
                <input type="text" name="date_timestamp" id="date_timestamp" readonly class="form-control datepicker" data-format="D, dd MM yyyy" placeholder="Date here" value="<?php echo date('Y-m-d');?>">
                <input type="text" name="time_timestamp" id="time_timestamp" readonly class="form-control timepicker" data-template="dropdown" data-show-seconds="false" data-default-time="<?php echo date('h:i A');?>" value="<?php echo date('h:i A');?>" data-show-meridian="false" data-minute-step="15"  placeholder="time here">
              </div>
            </div>
          </div>   
          <div class="form-group">
            <label for="field-ta" class="col-sm-3 control-label"><?php echo get_phrase('doctor'); ?></label>
            <div class="col-sm-7">
              <select name="doctor_id" id="doctor_id" required class="select2">
                <option value=""><?php echo get_phrase('select_doctor'); ?></option>
                <?php foreach ($doctor_info as $row) { ?>
                <option value="<?php echo $row['doctor_id']; ?>"><?php echo $row['name']; ?></option>
                <?php } ?>
              </select>
              <span class="doctor_info"></span>
            </div>
          </div>
          <div class="form-group" style="display:none;">
            <label for="field-ta" class="col-sm-3 control-label">Available Rooms</label>
            <div class="col-sm-7">
              <select name="room">
                <option value="">Select Room</option>   
                <?php foreach ($room_info as $row) { ?>
                <option value="<?php echo $row['room_id']; ?>" selected="selected"><?php echo $row['title']; ?></option>
                <?php } ?>             
              </select>
            </div>
          </div>  
          <div class="form-group" style="display:none;">
            <label for="field-12" class="col-sm-3 control-label">Customer</label>
            <div class="col-sm-7">
              <select name="customer_id" id="customer_id" class="form-control">
                <option value="0">No Customer</option>
                <?php $customers = $this->common_model->getTableData('customer', 'customer_id,name,email','');
                    if(!empty($customers)){
                        foreach ($customers as $customer) {?>
                <option value="<?php echo $customer->customer_id;?>"><?php echo $customer->name.' ('.$customer->email.')';?></option>	        
                <?php }}?>          
              </select>
            </div>
          </div>
          <div class="form-group" style="display:none;">
            <label for="field-ta" class="col-sm-3 control-label"><?php echo get_phrase('patient'); ?></label>
            <div class="col-sm-7">
              <input name="patient_id[]" id="patient_id" value="<?php echo $param2;?>">
            </div>
          </div>
          <div class="form-group" style="display:none;">
            <label for="field-1" class="col-sm-3 control-label">Duration</label>
            <div class="col-sm-7">
              <div class="date-and-time">
                <input type="number" name="duration" required class="form-control" value="15" placeholder="Duration in Minutes...">
              </div>
            </div>
          </div>   
          <div class="form-group" style="display:none;">
            <label for="field-1" class="col-sm-3 control-label">Remarks</label>
            <div class="col-sm-7">
              <div class="date-and-time">
                <textarea name="remarks" class="form-control" placeholder="Remarks..."></textarea>
              </div>
            </div>
          </div>
          <div class="col-sm-3 control-label col-sm-offset-2">
          <input type="hidden" value="1" name="walk_in">
            <input type="submit" class="btn btn-success" value="Submit">
          </div>
        </form>
        <div class="col-xs-12 pull-left" style="margin-top:10px; padding:0;" id="apt-html"></div>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
	$(document).ready(function(e) {
		$("#doctor_id").select2("destroy");
		$("#doctor_id").select2();
    });
</script>
