<?php $patient = $this->db->get_where('patient', array('patient_id' => $param3))->row();
$form_data = $this->db->get_where('form_data', array('patient_id' => $param3, 'apt_id' => $param2, 'lab_form_id' => 173))->row();
$fields_data = !empty($form_data) ? json_decode($form_data->form_values) : array();
$results_data = !empty($form_data) && $form_data->result_val != '' ? json_decode($form_data->result_val) : array();
//echo '<pre>';print_r($form_data);exit;?>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-primary" data-collapsed="0">
            <div class="panel-heading">
                <div class="panel-title text-center" style="float: none;">
                    <h3>Laboratory Request &amp; Report Form</h3>
                    <h4>For Transfusion Unit Only</h4>
                </div>
            </div>
            <div class="panel-body">
                <form role="form" class="form-horizontal" style="width:100%;" method="post">
                    <div class="form-group">
                        <div class="col-xs-6 no-pad">
                            <div class="col-xs-6">
                                <label class="col-xs-12">Specimen:</label>
                                <p class="col-xs-12"><?php echo !empty($fields_data) ? $fields_data->specimen : '';?>"</p>
                            </div>
                            <div class="col-xs-6 no-padl">
                                <label class="col-xs-12">Sex:</label>
                                <p class="col-xs-12"><?php echo ucwords($patient->sex);?></p>
                            </div>
                        </div>
                        <div class="col-xs-3 no-pad">
                            <label class="col-xs-12">Name:</label>
                            <p class="col-xs-12"><?php echo ucwords($patient->surname);?> <?php echo ucwords($patient->given_name);?></p>
                        </div>
                        <div class="col-xs-3">
                            <label class="col-xs-12">Hosp. No:</label>
                            <p class="col-xs-12"><?php echo !empty($fields_data) ? $fields_data->hospital : '';?></p>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-xs-7 no-pad">
                            <div class="col-xs-6">
                                <label class="col-xs-12">Date &amp; Time Spec. Taken:</label>
                                <div class="col-xs-12"><?php echo !empty($fields_data) ? $fields_data->date_recvd: '';?> <?php echo !empty($fields_data) ? $fields_data->time_recvd : '09:00 AM';?>"</div>
                            </div>
                            <div class="col-xs-6 no-padl">
                                <label class="col-xs-12">DOB:</label>
                  				<p class="col-xs-9"><?php echo date('d M, Y',$patient->birth_date);?></p>
                            </div>
                        </div>
                        <div class="col-xs-3 no-pad">
                            <label class="col-xs-12">Address:</label>
                  			<div class="col-xs-12"><?php echo $patient->address;?></div>
                        </div>
                        <div class="col-xs-2">
                            <label class="col-xs-12">Ward:</label>
                            <p class="col-xs-12"><?php echo !empty($fields_data) ? $fields_data->ward : '';?></p>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-xs-12 no-pad">
                            <div class="row no-margin">
                                <div class="col-xs-3 no-padl">
                                    <label class="col-xs-12">Examination Requested:</label>
                                    <?php if(!empty($fields_data) && $fields_data->priority == 1){?>
                                    <p class="col-xs-12">Urgent</p>
                                    <?php }else{?>
                                    <p class="col-xs-12">Routine</p>
                                    <?php }?>
                                </div>
                                
                                <div class="col-xs-4 no-pad">
                                    <label class="col-xs-12">Clinical Particulars</label>
                                    <p class="col-xs-12"><?php echo !empty($fields_data) ? $fields_data->clinical_particulars : '';?></p>
                                </div>
                                <div class="col-xs-4 no-padl">
                                    <label class="col-xs-12">Doctor's Sgd. &amp; Date:</label>
                                    <p class="col-xs-12">&nbsp;</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-xs-12 no-pad">
                            <div class="row no-margin">
                            	<?php if(!empty($fields_data) && (isset($fields_data->txt_rbft1) || isset($fields_data->txt_rbft2) || isset($fields_data->txt_rbft3) || isset($fields_data->txt_rbft4) || isset($fields_data->txt_rbft5) || isset($fields_data->txt_rbft6) || isset($fields_data->txt_rbft7) || isset($fields_data->txt_rbft8) || isset($fields_data->txt_rbft9))){?>
                                <div class="col-xs-12 col-xs-3 no-padl">
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft1)){?>
                                    <label class="col-xs-12">
                                    	<span class="pull-left no-show">HIV </span>&nbsp;<?php echo !empty($results_data) ? $results_data->txt_rbft1 : '';?>
                                    </label>
                                    <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft2)){?>
                                    <label class="col-xs-12">
                                    	<span class="pull-left no-show">HBsAG</span>&nbsp;<?php echo !empty($results_data) ? $results_data->txt_rbft2 : '';?>
                                    </label>
                                    <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft3)){?>
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">RPR (Syphillis)</span>&nbsp;<?php echo !empty($results_data) ? $results_data->txt_rbft3 : '';?>
									</label>
                                    <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft4)){?>
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">HCV</span>&nbsp;
                                        <?php echo !empty($results_data) ? $results_data->txt_rbft4 : '';?>
                                    </label><?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft5)){?>
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">DCT</span>&nbsp;<?php echo !empty($results_data) ? $results_data->txt_rbft5 : '';?>
                                    </label>
                                    <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft6)){?>
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">Antibody Screening</span>&nbsp;<?php echo !empty($results_data) ? $results_data->txt_rbft6 : '';?></label>
                                     <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft7)){?>    
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">ABO Grouping</span>
                                        <?php echo !empty($results_data) ? $results_data->txt_rbft7 : '';?>
                                    </label>
                                     <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft8)){?>    
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">Hold Serum</span>
                                        <?php echo !empty($results_data) ? $results_data->txt_rbft8 : '';?>
                                    </label>
                                    <?php }?> 
                                	<?php if(!empty($fields_data) && isset($fields_data->txt_rbft9)){?>    
                                    <label class="col-xs-12">
                                        <span class="pull-left no-show">Others</span>
										<?php echo !empty($results_data) ? $results_data->txt_rbft9 : '';?>
									</label>
                                    <?php }?>
                                </div>
                                <?php }?>
                                <div class="col-xs-12 col-xs-4 no-pad">
                                    <div class="col-xs-12">
                                    	<div class="row" style="margin:0">
                                			<label class="col-xs-6">Requested Blood For Transfusion:</label>
                                        	<label class="col-xs-6">Units Required:</label>                                            
                                        </div>
                                        <div class="row" style="margin:0">
                                            <label class="col-xs-6">PACK CELL</label>
                                            <p class="col-xs-6"><?php echo !empty($fields_data) ? $fields_data->packcell : '';?></p>
                                        </div>
                                        <div class="row" style="margin:0">
                                            <label class="col-xs-6">WHOLE BLOOD</label>
                                            <p class="col-xs-6"><?php echo !empty($fields_data) ? $fields_data->wholeblood : '';?></p>
                                        </div>
                                        <div class="row" style="margin:0">
                                            <label class="col-xs-6">FFP</label>
                                            <p class="col-xs-6"><?php echo !empty($fields_data) ? $fields_data->ffp : '';?></p>
                                        </div>
                                        <div class="row" style="margin:0">
                                            <label class="col-xs-6">PLATELETS</label>
                                            <p class="col-xs-6"><?php echo !empty($fields_data) ? $fields_data->platelets : '';?></p>
                                        </div>
                                        <div class="row" style="margin:0">
                                            <label class="col-xs-6">OTHERS</label>
                                            <p class="col-xs-6"><?php echo !empty($fields_data) ? $fields_data->others_2 : '';?></p>
                                        </div>
                                    </div>
                                    <label class="col-xs-12">COMMENTS:</label>
                                    <p class="col-xs-12"><?php echo !empty($fields_data) ? $fields_data->comments : '';?></p>
                                </div>
                                <div class="col-xs-12 col-xs-5 no-pad">
                                    <label class="col-xs-12">&nbsp;</label>
                                    <p class="col-xs-12 text-center">&nbsp;</p>
                                    <?php if(!empty($fields_data) && isset($fields_data->txt_rbft15)){?>    
                                    <label class="col-xs-12">
                                    	<p class="col-xs-12">Intermediate transfusion ABO &amp; D typing no cross-matching (15-mins)</p>
                                        <p class="col-xs-12"><?php echo !empty($results_data) ? $results_data->txt_rbft15 : '';?></p>
                                    </label>
                                    <?php }?>
                                    <?php if(!empty($fields_data) && isset($fields_data->txt_rbft16)){?>    
                                    <label class="col-xs-12">
                                        <p class="col-xs-12">Urgent transfusion including cross-matching (45-min)</p>
                                        <p class="col-xs-12"><?php echo !empty($results_data) ? $results_data->txt_rbft16 : '';?></p>
                                    </label>
                                    <?php }?>
                                    <?php if(!empty($fields_data) && isset($fields_data->txt_rbft17)){?>    
                                    <label class="col-xs-12">
                                        <p class="col-xs-12">&nbsp;Non-urgent transfusion. Blood not required under 2 hours</p>
                                        <p class="col-xs-12"><?php echo !empty($results_data) ? $results_data->txt_rbft17 : '';?></p>
                                    </label>
                                    <?php }?>
                                    <?php if(!empty($fields_data) && isset($fields_data->txt_rbft18)){?>    
                                    <label class="col-xs-12">
                                        <p class="col-xs-12">&nbsp;Full cross-match 1 1/4 hr</p>
                                        <p class="col-xs-12"><?php echo !empty($results_data) ? $results_data->txt_rbft18 : '';?></p>
									</label>
                                    <?php }?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-xs-12 no-pad">
                            <div class="row no-margin">
                                <div class="col-xs-3 no-pad">
                                    <label class="col-xs-6">Lab No.:</label>
                                    <div class="col-xs-6"><?php echo !empty($fields_data) ? $fields_data->lab_no : '';?></div>
                                </div>
                                <div class="col-sm-3 no-pad">
                                    <label class="col-xs-6">Date/Time Recd:</label>
                                    <div class="col-xs-6"><?php echo !empty($results_data) ? $results_data->Date_Time : '';?></div>
                                </div>
                                <div class="col-sm-3 no-pad">
                                    <label class="col-xs-6">Processed:</label>
                                    <div class="col-xs-6"><?php echo !empty($results_data) ? $results_data->Processed : '';?></div>
                                </div>
                                <div class="col-sm-3 no-pad">
                                    <label class="col-xs-6">Reported:</label>
                                    <div class="col-xs-6"><?php echo !empty($results_data) ? $results_data->Reported : '';?></div>
                                </div>
                            </div>
                        </div>    
                    </div>
                </form>
            </div>
        </div>
        <div class="col-xs-12 no-pad" id="hide-print">
            <button type="button" class="btn btn-success btn-sm pull-right" onclick="CallPrint('print');">Print</button>
        </div>
    </div>
</div>
<link rel="stylesheet" href="assets/css/bootstrap.css" media='screen,print'>
<link rel="stylesheet" href="assets/css/neon-core.css" media='screen,print'>
<link rel="stylesheet" href="assets/css/neon-theme.css" media='screen,print'>
<link rel="stylesheet" href="assets/css/neon-forms.css" media='screen,print'>
<style type="text/css">
    .form-group [class^="col"] {
        padding: 4px 7px;
        margin-bottom: 5px;
    }

    .no-margin {
        margin: 0;
    }

    .no-pad {
        padding: 0 !important;
    }

    .no-padr {
        padding-right: 0 !important;
    }

    .no-padl {
        padding-left: 0 !important;
    }

    label {
        font-weight: 600;
    }

    .form-horizontal .form-group {
        margin: 0;
    }

    .bb {
        border-bottom: 1px solid #eee;
        margin-bottom: 4px !important;
    }
	input[type="checkbox"],input[type="radio"]{
		margin-top:10px;
		margin-right:5px;
	}
	.width-50{
		width:50%;
	}
	span.pull-left{
		margin-top:7px;
		font-weight:400;
	}
	.no-show{
		display: block;
		width: 80%;
		font-weight: 600 !important;
	}
	@media print {
		#hide-print{
			display:none;
		}
		.form-group [class^="col"]{
			margin-bottom:0 !important; 
		}
	}
	@media screen and (min-width: 768px) {
		.modal-dialog {
			width:85%;
		}
	}
</style>
<script type="application/javascript">
	window.print();
	function CallPrint(strid) 
	{
		window.print();
	}
</script>