<?php
$patient_info   = $this->db->get('patient')->result_array();
$doctor_info    = $this->db->get('doctor')->result_array();
$room_info    	= $this->db->get('rooms')->result_array();
?>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-primary" data-collapsed="0">
      <div class="panel-heading">
        <div class="panel-title">
          <h3><?php echo get_phrase('add_appointment'); ?></h3>
        </div>
      </div>
      <div class="panel-body">
        <form role="form" class="form-horizontal form-groups-bordered col-xs-12 pull-left" enctype="multipart/form-data" action="<?php echo base_url(); ?>index.php?receptionist/appointment/create" method="post">
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label"><?php echo get_phrase('date'); ?></label>
            <div class="col-sm-7">
              <div class="date-and-time">
                <input type="text" name="date_timestamp" required id="date_timestamp" readonly value="<?php echo date('D, d F Y');?>" class="form-control" data-format="D, dd MM yyyy" placeholder="Date here" style="width:70%; float:left;">
                <input type="text" name="time_timestamp" id="time_timestamp" readonly class="form-control timepicker" data-template="dropdown" data-show-seconds="false" data-default-time="09:00 AM" data-show-meridian="false" data-minute-step="15"  placeholder="time here">
              </div>
            </div>
          </div>   
          <div class="form-group">
            <label for="field-ta" class="col-sm-3 control-label"><?php echo get_phrase('doctor'); ?></label>
            <div class="col-sm-7">
              <select name="doctor_id" id="doctor_id" required class="select2">
                <option value=""><?php echo get_phrase('select_doctor'); ?></option>
                <?php foreach ($doctor_info as $row) { ?>
                <option value="<?php echo $row['doctor_id']; ?>"><?php echo $row['name']; ?></option>
                <?php } ?>
              </select>
              <span class="doctor_info"></span>
            </div>
          </div>
          <div class="form-group">
            <label for="field-ta" class="col-sm-3 control-label">Available Rooms</label>
            <div class="col-sm-7">
              <select name="room" required class="select2">
                <option value="">Select Room</option>   
                <?php foreach ($room_info as $row) { ?>
                <option value="<?php echo $row['room_id']; ?>"><?php echo $row['title']; ?></option>
                <?php } ?>             
              </select>
            </div>
          </div>  
          <div class="form-group">
            <label for="field-12" class="col-sm-3 control-label">Customer</label>
            <div class="col-sm-7">
              <select name="customer_id" id="customer_id" class="form-control">
                <option value="0">No Customer</option>
                <?php $customers = $this->common_model->getTableData('customer', 'customer_id,name,email','');
                    if(!empty($customers)){
                        foreach ($customers as $customer) {?>
                <option value="<?php echo $customer->customer_id;?>"><?php echo $customer->name.' ('.$customer->email.')';?></option>	        
                <?php }}?>          
              </select>
            </div>
          </div>
          <div class="form-group patient_id">
            <label for="field-ta" class="col-sm-3 control-label"><?php echo get_phrase('patient'); ?></label>
            <div class="col-sm-7">
              <select name="patient_id[]" required id="patient_id" class="select2">
                <option value=""><?php echo get_phrase('select_patient'); ?></option>
                <?php foreach ($patient_info as $row) { ?>
                <option value="<?php echo $row['patient_id']; ?>"><?php echo $row['given_name'].' '.$row['surname']; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label">Duration</label>
            <div class="col-sm-7">
              <div class="date-and-time">
                <input type="number" name="duration" required class="form-control" placeholder="Duration in Minutes...">
              </div>
            </div>
          </div>   
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label">Remarks</label>
            <div class="col-sm-7">
              <div class="date-and-time">
                <textarea name="remarks" class="form-control" required placeholder="Remarks..."></textarea>
              </div>
            </div>
          </div>                    
          <?php /*?><div class="form-group">
            <div class="col-sm-7 col-sm-offset-3">
              <input type="checkbox" id="notify" name="notify" value="checked" checked>
              <label class="control-label" for="notify"><?php echo get_phrase('notify_patient_with_') . 'SMS'; ?></label>
            </div>
          </div><?php */?>
          <div class="col-sm-3 control-label col-sm-offset-2">
            <input type="submit" class="btn btn-success" value="Submit">
          </div>
        </form>
        <div class="col-xs-12 pull-left" style="margin-top:10px; padding:0;" id="apt-html"></div>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
	$(document).ready(function(e) {
		$("#patient_id").select2("destroy");
		$("#patient_id").select2();
						
		$("#date_timestamp").datepicker({
			autoclose: true,
			todayHighlight: true,
			format: "D, dd MM yyyy",
			minDate: new Date(),
			clearBtn: true,
			multidate: false,
			startDate: new Date(),
			toggleActive: true
		});
		
        $('#date_timestamp, #doctor_id, #time_timestamp').change(function(e) {
            
			var doctor_id = $.trim($('#doctor_id').val());
			var date_timestamp = $.trim($('#date_timestamp').val());
			var time_timestamp = $.trim($('#time_timestamp').val());
			if(doctor_id == '') return false;
			
			var data = 'doctor_id='+doctor_id+'&date_timestamp='+date_timestamp+'&time_timestamp='+time_timestamp;
			$.ajax({
				url: '<?php echo base_url(); ?>index.php?receptionist/chk_appointments',
				type : "POST",
				data:data,
				dataType:'json',
				success: function(response)
				{
					if(response.success == false)
					{
						$('.doctor_info').html('<span class="alert alert-danger" style="float:left; padding:4px 7px; margin-top:5px; margin-bottom:0;">'+response.message+'</span>').fadeIn(150).delay(5000).fadeOut(150);
					}
					$('#apt-html').html(response.html);
				}
			});
        });
		
		$('#customer_id').change(function(e) {
			var customer_id = $(this).val();
			var data = 'customer_id='+customer_id;
			$.ajax({
				url: '<?php echo base_url(); ?>index.php?receptionist/load_patients',
				type : "POST",
				data:data,
				dataType:'json',
				success: function(response)
				{
					if(customer_id != 0){
						$('#patient_id').attr('multiple','multiple');
					}else{
						$('#patient_id').removeAttr('multiple');
					}
					
					$('#patient_id').html(response.html);
					
					$("#patient_id").select2("destroy");
					$("#patient_id").select2();
				}
			});
        });
		
		$('#patient_id').change(function(e) {
			var customer_id = $('#customer_id').val();
			var patient_id = $(this).val();
			if(customer_id == '0' && patient_id != '')
			{
				var data = 'patient_id='+patient_id;
				$.ajax({
					url: '<?php echo base_url(); ?>index.php?receptionist/chk_existing_apt',
					type : "POST",
					data:data,
					dataType:'json',
					success: function(response)
					{
						if(response.success == false)
						{
							$('#apt-html').html('<span class="alert alert-danger" style="float:left; padding:4px 7px; margin-top:5px; margin-bottom:0;">'+response.message+'</span>').fadeIn(150);
						}
					}
				});
			}
        });
		
    });
</script>
