<?php 
$form_data = $this->db->query('SELECT * FROM `form_data` WHERE status IN (1,2) ORDER BY `id` DESC ')->result();
$form_types = array(175 => 'Microbiology Request / Report', 172 => 'Laboratory Request And Report (Clinical Haematology)', 171 => 'XRAY Request', 173 => 'Laboratory Request And Report',174 => 'Clinical Chemistry Request And Report');
$test_status = array('<span class="btn btn-xs btn-orange">Sent for Print</span>', '<span class="btn btn-xs btn-blue">Sent for Lab Test</span>', '<span class="btn btn-xs btn-success">Result Recieved</span>', '<span class="btn btn-xs btn-danger">Print Out Given</span>','<span class="btn btn-xs btn-blue">In Process</span>');
$form_pages = array(175 => 'micro', 172 => 'clinical_haematology_form', 171 => 'xray', 173 => 'laboratory_request_report_form',174 => 'clinical_chemistry_form');?>
<table class="table table-bordered table-striped" id="table-2">
    <thead>
        <tr>
            <th style="display:none;"><?php echo ('#'); ?></th>
            <th><?php echo ('Title'); ?></th>
            <th class="text-center"><?php echo ('Patient'); ?></th>
            <th class="text-center"><?php echo ('Appointment ID'); ?></th>
            <th class="text-center"><?php echo ('Precribed By'); ?></th>
            <th class="text-center"><?php echo ('Status'); ?></th>
            <th class="text-center"><?php echo ('Date'); ?></th>
            <th class="text-center"><?php echo ('Actions'); ?></th>
        </tr>
    </thead>

    <tbody>
        <?php foreach ($form_data as $row) { 
				$patient = $this->db->get_where('patient', array('patient_id' => $row->patient_id))->row();
				$doctor = $this->db->get_where('doctor', array('doctor_id' => $row->added_by))->row();?>
            <tr id="<?php echo $row->id;?>">
                <td style="display:none;"><?php echo 99999 - $row->id;?></td>
                <td><?php echo $form_types[$row->lab_form_id];?></td>
                <td class="text-center"><?php echo $patient->surname.' '.$patient->given_name ?></td>
                <td class="text-center"><?php echo $row->apt_id;?></td>
                <td class="text-center"><?php echo $doctor->name;?></td>
                <td class="text-center"><?php echo $test_status[$row->status];?></td>
                <td class="text-center"><?php echo date('M d, Y',strtotime($row->added_on));?></td>
                <td class="text-center"><a class="btn btn-xs btn-info" href="javascript:;" onclick="showAjaxModal('<?php echo base_url();?>index.php?modal/popup/<?php echo $form_pages[$row->lab_form_id];?>/<?php echo $row->apt_id . '/' . $row->patient_id ?>')">Update Results</a></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
<style>
/* The Modal (background) */
.modal-backdrop{
	position:relative;
}
.modal {
	display: none; /* Hidden by default */
	position: fixed; /* Stay in place */
	z-index: 3; /* Sit on top */
	padding-top: 100px; /* Location of the box */
	left: 0;
	top: 0;
	width: 100%; /* Full width */
	height: 100%; /* Full height */
	overflow: auto; /* Enable scroll if needed */
	background-color: rgb(0,0,0); /* Fallback color */
	background-color: rgba(0,0,0,0.2); /* Black w/ opacity */
}
/* Modal Content (image) */
	.modal-content {
	margin: auto;
	display: block;
	max-width:70%;
}
#modal_ajax .modal-content{
	max-width:100%;
}
/* The Close Button */
	.close {
	position: absolute;
	top: 15px;
	right: 35px;
	color: #f1f1f1;
	font-size: 40px;
	font-weight: bold;
	transition: 0.3s;
}
.close:hover,  .close:focus {
	color: #bbb;
	text-decoration: none;
	cursor: pointer;
}
	
@media only screen and (max-width: 700px) {
.modal-content {
	width: 100%;
}
}
.my-form .form-group {
	width:50%;
	float:left;
	padding-top:5px !important;
	margin-left: 0;
	margin-right: 0;
	padding-left:2px;
}
.panel-body {
	padding:15px 0;
}
.panel-body form {
	float:left;
	padding:0;
}
.col-sm-5.control-label {
	padding-left:0;
}
.my-form input {
	border:1px solid #ebebeb !important;
}
textarea {
	resize:none;
}
thead {
	font-weight:700;
}
.alert {
	float: right;
	padding:5px 10px;
	margin-top:5px;
}
.tpl_title_info.alert {
	margin-top:0;
	margin-right:5px;
}
.form-control[readonly] {
	background-color:#fff;
}
td {
	vertical-align:middle !important;
}
 @media screen and (min-width: 768px) {
.modal-dialog {
	width:85%;
}
}
</style>
<script type="text/javascript">
    jQuery(window).load(function ()
    {
        var $ = jQuery;

        $("#table-2").dataTable({
            "sPaginationType": "bootstrap",
            "sDom": "<'row'<'col-xs-3 col-left'l><'col-xs-9 col-right'<'export-data'T>f>r>t<'row'<'col-xs-3 col-left'i><'col-xs-9 col-right'p>>"
        });

        $(".dataTables_wrapper select").select2({
            minimumResultsForSearch: -1
        });

        // Highlighted rows
        $("#table-2 tbody input[type=checkbox]").each(function (i, el)
        {
            var $this = $(el),
                    $p = $this.closest('tr');

            $(el).on('change', function ()
            {
                var is_checked = $this.is(':checked');

                $p[is_checked ? 'addClass' : 'removeClass']('highlight');
            });
        });

        // Replace Checboxes
        $(".pagination a").click(function (ev)
        {
            replaceCheckboxes();
        });
    });
</script>