<?php $patient = $this->db->get_where('patient', array('patient_id' => $param3))->row();
$form_data = $this->db->get_where('form_data', array('patient_id' => $param3, 'apt_id' => $param2, 'lab_form_id' => 175))->row();
$field_data = !empty($form_data) ? json_decode($form_data->form_values) : array();
$fields_data = !empty($form_data) && $form_data->result_val != '' ? json_decode($form_data->result_val) : array();
//echo '<pre>';print_r($form_data);exit;?>
<div class="row">
  <div class="col-xs-12">
    <div class="panel panel-primary" data-collapsed="0">
      <div class="panel-heading text-center">
        <div class="panel-title" style="float: none;">
          <h3 class="">Microbiology Request / Report</h3>
        </div>
      </div>
      <div class="panel-body">
        <form role="form" class="form-horizontal form-groups-bordered" style="width:100%;" method="post">
          <div class="form-group">
            <div class="col-xs-3 no-pad border">
                <div class="col-xs-12 no-padl">
                	<label class="col-xs-12">Name:</label>
                	<p class="col-xs-12 is_colored"><?php echo $patient->given_name;?> <?php echo $patient->surname;?></p>
                </div>
            </div>
            <div class="col-xs-2 no-pad border">
                <label class="col-xs-12">Gender:</label>
                <p class="col-xs-12 is_colored"><?php echo ucwords($patient->sex);?></p>
            </div>
            <div class="col-xs-2 no-pad border">
                <label class="col-xs-12">D.O.B:</label>
                <p class="col-xs-12 is_colored"><?php echo date('d M, Y',$patient->birth_date);?></p>
            </div>
            <div class="col-xs-3 no-pad border">
                <label class="col-xs-12">Address:</label>
                <p class="col-xs-12 is_colored"><?php echo $patient->address;?></p>
            </div>
            <div class="col-xs-2 no-pad border">
                <label class="col-xs-12">Ward:</label>
				<p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->ward : '';?></p>
            </div>
          </div>
          <div class="form-group">
            <div class="col-xs-8 no-pad border">
            	<div class="row no-margin bb">
                    <div class="col-xs-5 no-padl">
                        <label class="col-xs-12">Specimen:</label>
                        <p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->specimen : '';?></p>
                    </div>
                    <div class="col-xs-4 no-padl">
                        <label class="col-xs-12">Date/Time Collected:</label>
                        <p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->date_collected : '';?> <?php echo !empty($field_data) ? $field_data->time_collected : '09:00 AM';?></p>
                    </div>
                    <div class="col-xs-3 no-padl">
                    	<label class="col-xs-12 colored"><?php echo !empty($field_data) && $field_data->priority == 1 ? 'Urgent' : 'Routine';?></label>
                    </div>
                </div>
                <div class="row no-margin">
                    <div class="col-xs-5 no-padl">
                        <label class="col-xs-12">Examination Requested:</label>
                        <p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->examination_requested : '';?></p>
                    </div>
                    <div class="col-xs-4 no-padl">
                        <label class="col-xs-12">Doctor's Sigd. - Date:</label>
                        <p class="col-xs-12">&nbsp;</p>
                    </div>
                    <div class="col-xs-3 no-padl">
                        <label class="col-xs-12">Hospital No:</label>
                        <p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->hospital_no : '';?></p>
                    </div>
                </div>
            </div>
            <div class="col-xs-4 no-pad border">
                <label class="col-xs-12">Clinical Particulars</label>
				<p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->clinical_particulars : '';?></p>
            </div>
          </div>
          
          <div class="form-group">
          	<div class="col-xs-3 br">
            	<h5 class="col-xs-12 no-pad"><b>MICROSCOPY</b></h5>
				<p class="col-xs-12 bb-dashed no-pad"><b>Gram's Stain</b></p>
				<p class="col-xs-12 no-pad"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->gram_stain : '';?></span></p>
				<p class="col-xs-12 bb-dashed no-pad"><b>ZN Stain</b></p>
				<p class="col-xs-12 no-pad"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->zn_stain : '';?></span></p>
				<p class="col-xs-12 bb-dashed no-pad"><b>Wet Prep</b></p>
				<p class="col-xs-12 no-pad"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->wet_prep : '';?></span></p>
				<p class="col-xs-12 bb-dashed no-pad"><b>20% KOH</b></p>
				<p class="col-xs-12 no-pad"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->koh : '';?></span></p>
            </div>
            <div class="col-xs-9 bb">
            	<b>Comments:</b>
            </div>
            <div class="col-xs-9 no-pad">
            	<div class="col-xs-3 no-pad br">
                	<h5 class="col-xs-12"><b>URINE</b></h5>
                    <p class="col-xs-12"><b>Leukocytes:</b> <span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->leukocytes : '';?></span> (/HPF)</p>
                    <p class="col-xs-12"><b>EPI Cells:</b> <span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->epi_cells : '';?></span> (/HPF)</p>
                    <p class="col-xs-12"><b>RBCs:</b> <span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->rbc : '';?></span> (/HPF)</p>
                    <p class="col-xs-12"><b>Casts</b> <span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->casts : '';?></span></p>
                    <p class="col-xs-12"><b>Bacteria</b> <span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->bacteria : '';?></span></p>
                    <?php if(!empty($fields_data) && $fields_data->others != ''){?>
                    <p class="col-xs-12"><b>Others</b></p>
                    <p class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->others : '';?></p>
                    <?php }?>
                </div>
                <div class="col-xs-6 no-pad br">                
                	<div class="col-xs-5 no-padr">
                    	<div class="col-xs-12 br bb">
                        	<h5 class="col-xs-12"><b>FAECES</b></h5>
                            <div class="col-xs-12">Worm: </div>
                   			<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->worm : '';?></div>
                            <div class="col-xs-12">Ova: </div>
                   			<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->ova : '';?></div>
                            <div class="col-xs-12">Cyst: </div>
                   			<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->cyst : '';?></div>
                            <div class="col-xs-12">Occult Bld: </div>
                   			<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->cccult_bld : '';?></div>
                        </div>
                		<h5 class="col-xs-12"><b>CSF</b></h5>
                        <label class="col-xs-12 is_colored"><?php echo !empty($fields_data) && $fields_data->blood_color == 2 ? 'Blood-Stained' : 'Clear/Colourless';?></label>
                    </div>
                    <div class="col-xs-7 no-padr">
                        <label class="col-xs-12 is_colored"><?php echo !empty($field_data) && isset($field_data->turbid) ? 'Turbid' : '';?> </label>
                        <label class="col-xs-12 is_colored"><?php echo !empty($field_data) && isset($field_data->xanthochromic) ? 'Xanthochromic' : '';?> </label>
                        <div class="col-xs-12"><b>RBC:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->rbc_2 : '';?></span> x10<sup>6</sup>/L</span></div>
                        <div class="col-xs-12"><b>WBC:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->wbc_2 : '';?></span> x10<sup>6</sup>/L</span></div>
                        <div class="col-xs-12"><b>Lymph:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->lymph : '';?></span> %</span></div>
                        <div class="col-xs-12"><b>Neutroph:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->neutroph : '';?></span> %</span></div>
                        <?php if(!empty($fields_data) && $fields_data->others_2 != ''){?>
                        <div class="col-xs-12"><b>Others:</b></div>
                   		<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->others_2 : '';?></div>
                        <?php }?>
                    </div>
                </div>
                <div class="col-xs-3 no-pad">
                	<h5 class="col-xs-12"><b>SEMINAL FLUID</b></h5>
                    <div class="col-xs-12"><b>Volume:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->volume : '';?></span> mL</span></div>
                    <div class="col-xs-12"><b>Motility:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->motility : '';?></span> %</span></div>
                    <div class="col-xs-12"><b>Viscosity:</b> <span class="is_colored pull-right"><?php echo !empty($fields_data) ? $fields_data->viscosity : '';?></span></div>
                    <div class="col-xs-12"><b>Sperm Count:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->sperm_count : '';?></span> x10<sup>6</sup>/mL</span></div>
                    <div class="col-xs-12"><b>Morphology:</b> <span class="pull-right"><span class="is_colored"><?php echo !empty($fields_data) ? $fields_data->morphology : '';?></span> %morm.</span></div>
                </div>
            </div>
          </div>
          <div class="form-group">
          	<div class="col-xs-4 no-pad br">
                <h5 class="col-xs-12"><b>CULTURE</b></h5>
                <div class="col-xs-12 no-pad">
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->no_growth) ? 'No Growth' : '';?></p> 
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->no_b_huemolytic) ? 'No B-huemolytic strep.' : '';?></p> 
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->no_ngonorrhoeae) ? 'No N.gonorrhoeae' : '';?></p> 
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->no_candida_spp) ? 'No Candida spp.' : '';?></p>                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->commensals) ? 'Commensals Only' : '';?></p> 
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->salmolnella) ? 'No Salmolnella' : '';?></p> 
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->shigella) ? 'No Shigella' : '';?></p> 
                    <p class="col-xs-6 is_colored"><?php echo !empty($field_data) && isset($field_data->afb) ? 'No AFB' : '';?></p> 
                </div>
                <label class="col-xs-12 pull-left">Urine colony count/mL:</label>
                <p class="col-xs-4 is_colored"><?php echo !empty($fields_data) && $fields_data->urine_colony_count == 2 ? '< 10<sup>4</sup> - 10<sup>5</sup>' : (!empty($fields_data) && $fields_data->urine_colony_count == 1 ? '< 10<sup>4</sup>' : (!empty($fields_data) && $fields_data->urine_colony_count == 3 ? '> 10<sup>5</sup>' : ''));?></p>
              </div>
              <div class="col-xs-8 no-pad" id="th-block">
              	<table class="table table-bordered table-striped">
                	<tr>
                        <th class="first-th">
                            <h5 class="col-xs-12"><b>SENSITIVITY TESTS</b></h5>	
                            <p class="col-xs-12">S = Sensitivity</p>
                            <p class="col-xs-12">R = Resistant</p>
                            <p class="col-xs-12">I = Intermediate</p>	
                            <p class="col-xs-12">Organisms Indentified</p>	
                        </th>
                        <?php for($i = 1; $i <= 13; $i++){?>
                        <th class="second-th"><img src="<?php echo base_url(); ?>assets/micro/<?php echo $i;?>.png"></th>
                        <?php }?>
                    </tr>
                    <tr>
                        <td class="first-th"><?php echo !empty($fields_data) ? $fields_data->field_01 : '&nbsp;';?></td>
                        <?php for($i = 1; $i <= 13; $i++){
								$index = 'dd_'.$i;?>
                        <td class="second-th">
                        	<?php echo !empty($fields_data) ? $fields_data->$index : '&nbsp;';?>
                        </td>
                        <?php }?>
                        <!--<td class="second-th">&nbsp;</td>-->
                    </tr>
                    <tr>
                        <td class="first-th"><?php echo !empty($fields_data) ? $fields_data->field_02 : '&nbsp;';?></td>
                        <?php for($i = 1; $i <= 13; $i++){
								$index = 'dd1_'.$i;?>
                        <td class="second-th">                        	
                        	<?php echo !empty($fields_data) ? $fields_data->$index : '&nbsp;';?>
                        </td>
                        <?php }?>
                        <!--<td class="second-th">&nbsp;</td>-->
                    </tr>
                    <tr>
                        <td class="first-th"><?php echo !empty($fields_data) ? $fields_data->field_03 : '&nbsp;';?></td>
                        <?php for($i = 1; $i <= 13; $i++){
								$index = 'ddl_'.$i;?>
                        <td class="second-th">                        	
                        	<?php echo !empty($fields_data) ? $fields_data->$index : '&nbsp;';?>
                        </td>
                        <?php }?>
                        <!--<td class="second-th">&nbsp;</td>-->
                    </tr>
                </table>
              </div>
          </div>
          <div class="form-group">
              <div class="col-xs-2 br">
              	<label class="col-xs-12">Lab No. </label>
                <p class="col-xs-12 is_colored"><?php echo !empty($field_data) ? $field_data->lab_no : '';?></p>
              </div>
              <div class="col-xs-2 br">
              	<label class="col-xs-12">Date/Time Rec'd: </label>
              	<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->DateTimeRecd : '';?></div>
              </div>
              <div class="col-xs-2 br">
              	<label class="col-xs-12">Processed By: </label>
              	<p class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->ProcessedBy : '';?></p>
              </div>
              <div class="col-xs-2 br">
              	<label class="col-xs-12">Read By: </label>
              	<p class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->ReadBy : '';?></p>
              </div>
              <div class="col-xs-2 br">
              	<label class="col-xs-12">Checked By: </label>
              	<p class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->CheckedBy : '';?></p>
              </div>
              <div class="col-xs-2 br">
              	<label class="col-xs-12">Date/Time Reported: </label>              	
              	<div class="col-xs-12 is_colored"><?php echo !empty($fields_data) ? $fields_data->DateTimeReported : '';?></div>
              </div>         	
          </div>   
        </form>
      </div>
    </div>
    <div class="col-xs-12" style="padding:5px 0" id="hide-print">
    	<button type="button" class="btn btn-success btn-sm pull-right" onclick="CallPrint('print');">Print</button>
    </div>   
  </div>
</div>
<link rel="stylesheet" href="assets/css/bootstrap.css" media='screen,print'>
<link rel="stylesheet" href="assets/css/neon-core.css" media='screen,print'>
<link rel="stylesheet" href="assets/css/neon-theme.css" media='screen,print'>
<link rel="stylesheet" href="assets/css/neon-forms.css" media='screen,print'>
<style type="text/css">
.form-group [class^="col"]{
	padding:0 7px;
	margin-bottom:5px;
}
.border{
	/*border-top:1px solid #eee;
	border-left:1px solid #eee;*/
}
.no-margin{
	margin:0;
}
.no-pad{
	padding:0 !important;
}
.no-padr{
	padding-right:0 !important;
}
.no-padl{
	padding-left:0 !important;
}
label{
	font-weight:600;
}
.form-horizontal .form-group{
	margin:0;
	padding-top:10px;
	padding-bottom:10px;
}
.bb{
	border-bottom:1px solid #eee;
	margin-bottom:4px !important;
}
.br{
	border-right:1px solid #eee;
}
.bb-dashed{
	border-bottom:1px dashed #ccc;
	margin-bottom:4px !important;
}
h5{
	text-decoration:underline;
	margin-top:0 !important;
	margin-bottom:20px !important;
}
.rotate-txt{
	-ms-transform: rotate(270deg) !important;
	-moz-transform: rotate(270deg) !important; 
	-webkit-transform: rotate(270deg) !important;
	-o-transform: rotate(270deg) !important;
	transform: rotate(270deg) !important;
	display:block;
	line-height:22px;
	/*position:absolute;*/
}
.second-th, .first-th{
	padding:3px !important;
	position:relative;
	background-color:#fff !important;
	border-color: #eee !important;
	vertical-align:middle !important;
	height:30px;
}
.day, .bootstrap-timepicker-widget *{
	color:#fff !important;
}

input[type="checkbox"],input[type="radio"]{
	margin-top:10px;
	margin-right:5px;
}
.width-50{
	width:50%;
}
span.pull-left{
	margin-top:7px;
	font-weight:400;
}
.no-show{
	display: block;
	width: 80%;
	font-weight: 600 !important;
}
td{
	font-size:11px;
}
#hide-print{
	display:none;
}
@media print {
#hide-print{
	display:none;
}
.form-group [class^="col"]{
	margin-bottom:0 !important; 
}
}
@media screen and (min-width: 768px) {
.modal-dialog {
	width:85%;
}
}
.colored{
	color:#a62828;
}
</style>
<script type="application/javascript">
$(document).ready(function(e) {
    $('.is_colored').each(function() {
		var $this = $(this);
		if($.trim($this.html()) != '')
		{
			$this.addClass('colored');
		}
	});
});
function CallPrint(strid) 
{
	window.print();
}
</script>