<style>
.myImg {
	border-radius: 5px;
	cursor: pointer;
	transition: 0.3s;
}
.myImg:hover {
	opacity: 0.7;
}
/* The Modal (background) */
.modal-backdrop{
	position:relative;
}
.modal {
	display: none; /* Hidden by default */
	position: fixed; /* Stay in place */
	z-index: 1; /* Sit on top */
	padding-top: 100px; /* Location of the box */
	left: 0;
	top: 0;
	width: 100%; /* Full width */
	height: 100%; /* Full height */
	overflow: auto; /* Enable scroll if needed */
	background-color: rgb(0,0,0); /* Fallback color */
	background-color: rgba(0,0,0,0.2); /* Black w/ opacity */
}
/* Modal Content (image) */
	.modal-content {
	margin: auto;
	display: block;
	max-width:70%;
}
#modal_ajax .modal-content{
	max-width:100%;
}
.dropdown-menu > li > a{
	color:#fff;
	margin:0;
	padding:4px 10px;
}

.dropdown-menu > li{
	border-bottom:#006933 1px solid;
}
.dropdown-menu{
	background-color:#00a651; 
	border:1px solid #006933;
}
@-webkit-keyframes zoom {
 from {
-webkit-transform:scale(0)
}
to {
	-webkit-transform:scale(1)
}
}
 @keyframes zoom {
 from {
transform:scale(0)
}
to {
	transform:scale(1)
}
}
/* The Close Button */
	.close {
	position: absolute;
	top: 15px;
	right: 35px;
	color: #f1f1f1;
	font-size: 40px;
	font-weight: bold;
	transition: 0.3s;
}
.close:hover,  .close:focus {
	color: #bbb;
	text-decoration: none;
	cursor: pointer;
}
	
	/* 100% Image Width on Smaller Screens */
	@media only screen and (max-width: 700px) {
.modal-content {
	width: 100%;
}
}
.my-form .form-group {
	width:50%;
	float:left;
	padding-top:5px !important;
	margin-left: 0;
	margin-right: 0;
	padding-left:2px;
}
.panel-body {
	padding:15px 0;
}
.panel-body form {
	float:left;
	padding:0;
}
.col-sm-5.control-label {
	padding-left:0;
}
.my-form input {
	border:1px solid #ebebeb !important;
}
textarea {
	resize:none;
}
thead {
	font-weight:700;
}
.alert {
	float: right;
	padding:5px 10px;
	margin-top:5px;
}
.tpl_title_info.alert {
	margin-top:0;
	margin-right:5px;
}
.form-control[readonly] {
	background-color:#fff;
}
td {
	vertical-align:middle !important;
}
 @media screen and (min-width: 768px) {
.modal-dialog {
	width:85%;
}
}
</style>
<?php $patient_history = $this->db->get_where('patient_history', array('appointment_id' => $appointment_id))->row();
	$patient_history = (array) $patient_history;
	$diagnosis = $this->db->get('diagnostics')->result_array();	
	$consultion_tmps = $this->db->get_where('consultion',array('apt_id' => '-1'))->result_array();	
	$patient_tmps = $this->db->get_where('consultion',array('patient_id' => $patient_id))->result_array();	
	
	$items = $this->db->get_where('ospos_items',array('doctor_id' => 0))->result_array();
	$data['consultion_tmps'] = $data['consultion_images'] = array();
	if($appointment_id != '-1'){
		$data['consultion_tmps'] = $this->db->get_where('consultion',array('apt_id' => $appointment_id))->result_array();
		$data['consultion_images'] = $this->db->get_where('consultion_images',array('consultation_id' => $data['consultion_tmps'][0]['id']))->result_array();
	}
?>
<div class="row">
  <div class="col-md-12" id="my-container" style="padding:0 5px;">
    <div class="panel panel-primary" data-collapsed="0">
      <div class="panel-body">
        <div class="col-sm-12" style="border-bottom:1px solid #e5e5e5; margin-bottom:15px; float:left; padding-bottom:10px;">
          <div class="col-sm-8">
          	<p><b>Patient Remarks:</b> <?php echo $patient_history['remarks-2'];?> </p>
          	<p><b>Body Temp (C<sup>o</sup>):</b> <?php echo $patient_history['body-temp'];?></p> 
          </div>
          <div class="col-sm-4">
          	<div class="dropdown">
                <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">Laboratory Tests
                <span class="caret"></span></button>
                <ul class="dropdown-menu">
                  <li><a href="javascript:;" onclick="showAjaxModal('<?php echo base_url();?>index.php?modal/popup/xray/<?php echo $appointment_id . '/' . $patient_id ?>')">XRAY Form</a></li>
                  <li><a href="javascript:;" onclick="showAjaxModal('<?php echo base_url(); ?>index.php?modal/popup/clinical_haematology_form/<?php echo $appointment_id . '/' . $patient_id ?>')">Laboratory REQ &amp; RES Form(Clinical Haematology)</a></li>
                  <li><a href="javascript:;" onclick="showAjaxModal('<?php echo base_url(); ?>index.php?modal/popup/laboratory_request_report_form/<?php echo $appointment_id . '/' . $patient_id ?>')">Laboratory Request &amp; Report Form</a></li>
                  <li><a href="javascript:;" onclick="showAjaxModal('<?php echo base_url(); ?>index.php?modal/popup/clinical_chemistry_form/<?php echo $appointment_id . '/' . $patient_id ?>')">Clinical Chemistry Request &amp; Report Form</a></li>
                  <li><a href="javascript:;"onclick="showAjaxModal('<?php echo base_url(); ?>index.php?modal/popup/micro/<?php echo $appointment_id . '/' . $patient_id ?>')">Microbiology Request / Report</a></li>
                </ul>
            </div>
          </div>
        </div>
        <form class="form-horizontal form-groups-bordered col-xs-12 my-form" enctype="multipart/form-data" id="con_form" method="post" style=" display:none;">
          <div class="form-group" style="width:100%;">
            <div class="col-xs-4">
              <select class="form-control" name="consultion_tmps" id="consultion_tmps">
                <option value="">Select a Consultation Template</option>
                <?php foreach($consultion_tmps as $consultion_tmp){?>
                <option value="<?php echo $consultion_tmp['id'];?>"><?php echo $consultion_tmp['title'];?></option>
                <?php }?>
              </select>
            </div>
            <div class="col-xs-4">
              <select class="form-control" name="patient_tmps" id="patient_tmps">
                <option value="">Copy from Previous</option>
                <?php foreach($patient_tmps as $patient_tmp){?>
                <option value="<?php echo $patient_tmp['id'];?>"><?php echo 'Appointment Date: '.date('M d, Y', strtotime($patient_tmp['added_on']));?></option>
                <?php }?>
              </select>
            </div>
          </div>
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label">Symptoms:</label>
            <div class="col-sm-7">
              <textarea class="form-control" name="symptoms"></textarea>
              <span class="symptoms_info"></span> </div>
          </div>
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label">Observations:</label>
            <div class="col-sm-7">
              <textarea class="form-control" name="observations"></textarea>
              <span class="observations_info"></span> </div>
          </div>
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label">Assessment:</label>
            <div class="col-sm-7">
              <textarea class="form-control" name="assessment"></textarea>
              <span class="assessment_info"></span> </div>
          </div>
          <div class="form-group">
            <label for="field-1" class="col-sm-3 control-label">Plan:</label>
            <div class="col-sm-7">
              <textarea class="form-control" name="plan"></textarea>
              <span class="plan_info"></span> </div>
          </div>
          <div class="form-group" style="width:100%;">
            <table class="table table-bordered table-striped" style="margin-bottom:0;">
              <thead>
                <tr>
                  <td width="10%"><a href="javascript:;" class="btn btn-xs btn-success" id="plus"><i class="entypo-plus"></i></a></td>
                  <td width="45%">Diagnosis</td>
                  <td width="45%">Remarks</td>
                </tr>
              </thead>
              <tbody id="tbody">
                <tr class="first-row">
                  <td width="10%"><a href="javascript:;" class="btn btn-xs btn-danger" onclick="tr_remove($(this))"><i class="entypo-minus"></i></a></td>
                  <td width="45%"><select class="form-control" name="diagnosis[]">
                      <option value="">Please Select</option>
                      <?php foreach($diagnosis as $dia){?>
                      <option value="<?php echo $dia['diagnostics_id'];?>"><?php echo $dia['code'].' '.$dia['name'];?></option>
                      <?php }?>
                    </select></td>
                  <td width="45%"><input type="text" class="form-control" placeholder="Remarks..." value="" name="remarks[]"></td>
                </tr>
              </tbody>
            </table>
          </div>
          
          <div class="form-group" style="width:100%;">
            <table class="table table-bordered table-striped" style="margin-bottom:0;">
              <thead>
                <tr>
                  <td width="5%"><a href="javascript:;" class="btn btn-xs btn-success" id="item-plus"><i class="entypo-plus"></i></a></td>
                  <td width="17%">Item</td>
                  <td width="7%">Q/T</td>
                  <td width="7%">Unit</td>
                  <td width="7%">T/D</td>
                  <td width="7%">Days</td>
                  <td width="7%">Qty</td>
                  <td width="10%">Instructions</td>
                  <td width="10%">Advisory</td>
                  <td width="10%">Remarks</td>
                  <td width="7%">Unit Price</td>
                  <td width="6%">Amount</td>
                </tr>
              </thead>
              <tbody id="item-body">
                <tr class="first-item">
                  <td><a href="javascript:;" class="btn btn-xs btn-danger" onclick="item_remove($(this))"><i class="entypo-minus"></i></a></td>
                  <td><select name="item[]" onchange="get_item_info($(this));" class="form-control">
                      <option value="">Prescribe Medicine</option>
                      <?php foreach($items as $item){?>
                      <option value="<?php echo $item['item_id'];?>"><?php echo $item['name'];?></option>
                      <?php }?>
                    </select></td>
                  <td class="qt"><input type="text" class="form-control" placeholder="Q/T..." value="" name="qt[]"></td>
                  <td class="unit"><input type="text" class="form-control" placeholder="Units..." value="" name="unit[]"></td>
                  <td class="td"><input type="text" class="form-control" placeholder="T/D..." value="" name="td[]"></td>
                  <td class="days"><input type="text" class="form-control" placeholder="Days..." value="" name="days[]"></td>
                  <td class="qty"><input type="text" class="form-control qty_field" onchange="total_amount($(this))" placeholder="Qty..." value="1" name="qty[]"></td>
                  <td class="instructions"><input type="text" class="form-control" placeholder="Instructions..." value="" name="my_instructions[]"></td>
                  <td><input type="text" class="form-control" placeholder="Advisory..." name="advisory[]"></td>
                  <td class="remarks"><input type="text" class="form-control" placeholder="Remarks..." value="" name="my_remarks[]"></td>
                  <td class=""><input type="text" class="form-control unit_price" readonly name="unit_price[]">
                    <input type="hidden" name="standard_cost[]" class="standard_cost" value=""></td>
                  <td class="amount">&nbsp;</td>
                </tr>
              </tbody>
            </table>
          </div>
          <div class="form-group" style="width:100%;">
            <div class="col-xs-4">
              <select class="form-control" name="consultion_items_tmps" id="consultion_items_tmps">
                <option value="">Select a Consultation Template</option>
                <?php foreach($consultion_tmps as $consultion_tmp){?>
                <option value="<?php echo $consultion_tmp['id'];?>"><?php echo $consultion_tmp['title'];?></option>
                <?php }?>
              </select>
            </div>
            <div class="col-xs-4">
              <select class="form-control" name="patient_items_tmps" id="patient_items_tmps">
                <option value="">Copy from Previous</option>
                <?php foreach($patient_tmps as $patient_tmp){?>
                <option value="<?php echo $patient_tmp['id'];?>"><?php echo 'Appointment Date: '.date('M d, Y', strtotime($patient_tmp['added_on']));?></option>
                <?php }?>
              </select>
            </div>
          </div>
          <?php if(!empty($data['consultion_images'])){?>
          <div class="col-sm-12 pull-left" style="margin-top:15px;">
            <?php foreach($data['consultion_images'] as $img){?>
            <a href="<?php echo base_url().'consultion_images/'.$img['filename'];?>" target="_blank"><img class="my-Img" src="<?php echo base_url().'consultion_images/'.$img['filename'];?>" style="width:100px; margin:0 15px 15px 0;"></a>
            <?php }?>
          </div>
          <!-- The Modal -->
          <div id="myModal" class="modal"> <span class="close">&times;</span> <img class="modal-content" id="img01"> </div>
          <?php }?>
          <div class="col-sm-6 control-label pull-left" style="margin-top:15px;">
            <div class="form-group">
              <label for="field-1" class="col-sm-3 control-label" style="padding-top:3px;">Images:</label>
              <div class="col-sm-7">
                <input type="file" multiple="multiple" name="file[]">
              </div>
            </div>
          </div>
          <div class="col-sm-6 control-label pull-left" style="margin-top:15px;">
            <input type="button" class="btn btn-info btn-sm pull-right" onclick="submitForm_to('<?php echo base_url().'index.php?doctor/add_consultation/draft';?>', '', 'con_form')" value="Save as Template">
            <input type="text" class="form-control" name="tpl_title" style="width:50%; float:right; margin-right:5px;" placeholder="Template Title...">
            <span class="tpl_title_info"></span> </div>
          <div class="col-sm-12 control-label pull-left">
            <input type="hidden" name="appointment_id" value="<?php echo $appointment_id;?>">
            <input type="hidden" name="patient_id" value="<?php echo $patient_id;?>">
            <input type="button" class="btn btn-blue" onclick="location.reload();" value="Reset">
            <?php if(!empty($data['consultion_tmps'])){?>
            <input type="hidden" id="consultion_id" name="consultion_id" value="<?php echo $data['consultion_tmps'][0]['id'];?>">
            <?php }?>
            <input type="button" class="btn btn-success" onclick="submitForm_to('<?php echo base_url(); ?>index.php?doctor/add_consultation/save', '<?php echo base_url(); ?>index.php?doctor/appointment_list', 'con_form')" value="Submit">
          </div>
        </form>
        <div class="col-xs-12 pull-left" id="msgs_con_form"></div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modal_ajax">
      <div class="modal-dialog" >
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Clinic Management System</h4>
          </div>
          <div class="modal-body" style="height:500px; overflow:auto;"> </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          </div>
        </div>
      </div>
    </div>

  <table style="display:none;">
    <?php foreach($items as $item){?>
    <tr id="<?php echo $item['item_id']?>">
      <td class="qt"><?php echo $item['dosage']?></td>
      <td class="unit"><?php echo $item['units']?></td>
      <td class="td"><?php echo $item['frequency']?></td>
      <td class="instructions"><?php echo $item['instructions']?></td>
      <td class="remarks"><?php echo $item['remarks']?></td>
      <td class="unit_price"><?php echo $item['unit_price']?></td>
      <td class="standard_cost"><?php echo $item['standard_cost']?></td>
    </tr>
    <?php }?>
  </table>
  <script src="assets/js/jquery.form.js"></script> 
  <script>
	// Get the modal
	var modal = document.getElementById('myModal');
	
	var modalImg = document.getElementById("img01");
	$('.myImg').click(function(e) {
		$(window).scrollTop(0);
       	modal.style.display = "block";
		modalImg.src = $(this).attr('src'); 
    });
	
	// Get the <span> element that closes the modal
	var span = document.getElementsByClassName("close")[0];
	
	// When the user clicks on <span> (x), close the modal
	/*span.onclick = function() { 
		modal.style.display = "none";
	}*/
	
  	$(document).ready(function(e) {
        var tpl = $('.first-row').html(); 
        var item_tpl = $('.first-item').html(); 
		
		$('#plus').click(function(e) {
            $('#tbody').append('<tr>'+tpl+'</tr>');
        });
		
		$('#item-plus').click(function(e) {
            $('#item-body').append('<tr>'+item_tpl+'</tr>');
        });
    });
	
	function get_item_info($this)
	{
		var val = $this.val();
		//console.log($this.closest('tr').find('.qt').html());
		$this.closest('tr').find('.qt input').val($('#'+val+' .qt').html());
		$this.closest('tr').find('.unit input').val($('#'+val+' .unit').html());
		$this.closest('tr').find('.td input').val($('#'+val+' .td').html());
		$this.closest('tr').find('.instructions input').val($('#'+val+' .instructions').html());
		$this.closest('tr').find('.remarks input').val($('#'+val+' .remarks').html());
		$this.closest('tr').find('.unit_price').val($('#'+val+' .unit_price').html());
		$this.closest('tr').find('.standard_cost').val($('#'+val+' .standard_cost').html());
		
		var qty_field = $this.closest('tr').find('.qty_field').val();
		var unit_price = parseInt($('#'+val+' .unit_price').html()) * parseInt(qty_field);
		
		$this.closest('tr').find('.amount').html(unit_price);
	}
	
	function total_amount($this)
	{
		var val = $this.val();
		var unit_price = parseInt($this.closest('tr').find('.unit_price').val()) * parseInt(val);
		$this.closest('tr').find('.amount').html(unit_price);
	}
	
	function submitForm_to(post_to,locate_to,form_id)
	{
		$('#msgs_'+form_id).html('<span class="alert alert-success">Saving information...</span>').fadeIn(150);
		$('#'+form_id).ajaxForm({
			type: "POST",   
			url: post_to,
			dataType: 'json',
			success: function(data)
			{
				if (!data.success) 
				{
					$('#msgs_'+form_id).html('<span class="alert alert-danger">Error, Please provide all required fields.</span>');
					//console.log(data.errors.length);
					for(var i = 0; i < data.errors.length; i++)
					{
						if(data.errors[i].error)
						{
							if(data.errors[i].field)
							{
								$('#'+data.errors[i].field).addClass('has-error');
								$('.'+data.errors[i].field+'_info').addClass('alert').addClass('alert-danger').html(data.errors[i].error).fadeIn(150).delay(5000).fadeOut(150);
							}
							else
							{
								$('#msgs_'+form_id).html('<span class="alert alert-danger">'+data.errors[i].error+'</span>').fadeIn(150).delay(5000).fadeOut(150);
							}
						}
					}
					setTimeout(function(){ $('#msgs_'+form_id).html(''); }, 5000);
				} 
				else 
				{
					if(data.message)
					{
						$('#msgs_'+form_id).html('<span class="alert alert-success">'+data.message +'</span>').fadeIn(150).delay(5000).fadeOut(150);					
					}	

					if(locate_to != '')
					{
						window.location = locate_to;
					}
				}
			}
		}).submit();
		return false;
	}
	
		
	function tr_remove($this)
	{
		$this.closest('tr').remove();
	}
		
	function item_remove($this)
	{
		$this.closest('tr').remove();
	}
	
	$(document).ready(function(e) {
        $('#consultion_tmps, #patient_tmps').change(function(e) {
            var val = $(this).val();
			//console.log('a');
			if(val != '')
			{
				$.ajax({
					type : "POST",
					url : '<?php echo base_url().'index.php?doctor/consultation_info/';?>'+val+'/',
					dataType : "json",
					success: function(response) {
						$('textarea[name="symptoms"]').val(response.consultion_tmps[0].symptoms);
						$('textarea[name="observations"]').val(response.consultion_tmps[0].observations);
						$('textarea[name="assessment"]').val(response.consultion_tmps[0].assessment);
						$('textarea[name="plan"]').val(response.consultion_tmps[0].plan);
						//console.log(response);
						
						$('#tbody').html(response.consultion_diagnosis);
						$('#item-body').html(response.consultion_items);
					}	
				});
			}
        });
		
		$('#consultion_items_tmps, #patient_items_tmps').change(function(e) {
            var val = $(this).val();
			//console.log('a');
			if(val != '')
			{
				$.ajax({
					type : "POST",
					url : '<?php echo base_url().'index.php?doctor/consultation_info/';?>'+val+'/',
					dataType : "json",
					success: function(response) {
						$('#item-body').html(response.consultion_items);
					}	
				});
			}
        });
		
		<?php if(!empty($data['consultion_tmps'])){?>
		$.ajax({
			type : "POST",
			url : '<?php echo base_url().'index.php?doctor/consultation_info/'.$data['consultion_tmps'][0]['id'];?>',
			dataType : "json",
			success: function(response) {
				$('#con_form').css('display','block');
				$('textarea[name="symptoms"]').val(response.consultion_tmps[0].symptoms);
				$('textarea[name="observations"]').val(response.consultion_tmps[0].observations);
				$('textarea[name="assessment"]').val(response.consultion_tmps[0].assessment);
				$('textarea[name="plan"]').val(response.consultion_tmps[0].plan);
				//console.log(response);
				
				$('#tbody').html(response.consultion_diagnosis);
				$('#item-body').html(response.consultion_items);
			}	
		});
		<?php }else{?>
			$('#con_form').css('display','block');
		<?php }?>		
    });
  </script> 
</div>
