<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Crud_model extends CI_Model {

    function __construct() {
        parent::__construct();
	  	$this->load->model('common_model');
    }

    function clear_cache() {
        $this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');
    }

    function get_type_name_by_id($type, $type_id = '', $field = 'name') {
        $this->db->where($type . '_id', $type_id);
        $query = $this->db->get($type);
        $result = $query->result_array();
        foreach ($result as $row)
            return $row[$field];
        //return	$this->db->get_where($type,array($type.'_id'=>$type_id))->row()->$field;	
    }



    // Create a new invoice.
    function create_invoice() 
    {
        $data['title']              = $this->input->post('title');
        $data['invoice_number']     = $this->input->post('invoice_number');
        $data['patient_id']         = $this->input->post('patient_id');
        $data['creation_timestamp'] = $this->input->post('creation_timestamp');
        $data['due_timestamp']      = $this->input->post('due_timestamp');
        $data['vat_percentage']     = $this->input->post('vat_percentage');
        $data['discount_amount']    = $this->input->post('discount_amount');
        $data['status']             = $this->input->post('status');

        $invoice_entries            = array();
        $descriptions               = $this->input->post('entry_description');
        $amounts                    = $this->input->post('entry_amount');
        $number_of_entries          = sizeof($descriptions);
        
        for ($i = 0; $i < $number_of_entries; $i++)
        {
            if ($descriptions[$i] != "" && $amounts[$i] != "")
            {
                $new_entry          = array('description' => $descriptions[$i], 'amount' => $amounts[$i]);
                array_push($invoice_entries, $new_entry);
            }
        }
        $data['invoice_entries']    = json_encode($invoice_entries);

        $this->db->insert('invoice', $data);
    }
    
    function select_invoice_info()
    {
        return $this->db->get('invoice')->result_array();
    }
    
    function select_invoice_info_by_patient_id()
    {
        $patient_id = $this->session->userdata('login_user_id');
        return $this->db->get_where('invoice', array('patient_id' => $patient_id))->result_array();
    }

    function update_invoice($invoice_id)
    {
        $data['title']              = $this->input->post('title');
        $data['invoice_number']     = $this->input->post('invoice_number');
        $data['patient_id']         = $this->input->post('patient_id');
        $data['creation_timestamp'] = $this->input->post('creation_timestamp');
        $data['due_timestamp']      = $this->input->post('due_timestamp');
        $data['vat_percentage']     = $this->input->post('vat_percentage');
        $data['discount_amount']    = $this->input->post('discount_amount');
        $data['status']             = $this->input->post('status');

        $invoice_entries            = array();
        $descriptions               = $this->input->post('entry_description');
        $amounts                    = $this->input->post('entry_amount');
        $number_of_entries          = sizeof($descriptions);
        
        for ($i = 0; $i < $number_of_entries; $i++)
        {
            if ($descriptions[$i] != "" && $amounts[$i] != "")
            {
                $new_entry          = array('description' => $descriptions[$i], 'amount' => $amounts[$i]);
                array_push($invoice_entries, $new_entry);
            }
        }
        $data['invoice_entries']    = json_encode($invoice_entries);

        $this->db->where('invoice_id', $invoice_id);
        $this->db->update('invoice', $data);
    }

    function delete_invoice($invoice_id)
    {
        $this->db->where('invoice_id', $invoice_id);
        $this->db->delete('invoice');
    }

    function calculate_invoice_total_amount($invoice_number)
    {
        $total_amount           = 0;
        $invoice                = $this->db->get_where('invoice', array('invoice_number' => $invoice_number))->result_array();
        foreach ($invoice as $row)
        {
            $invoice_entries    = json_decode($row['invoice_entries']);
            foreach ($invoice_entries as $invoice_entry)
                $total_amount  += $invoice_entry->amount;

            $vat_amount         = $total_amount * $row['vat_percentage'] / 100;
            $grand_total        = $total_amount + $vat_amount - $row['discount_amount'];
        }

        return $grand_total;
    }

  

    //////system settings//////
    function update_system_settings() {
        $data['description'] = $this->input->post('system_name');
        $this->db->where('type', 'system_name');
        $this->db->update('settings', $data);
		
        $info['value'] = $this->input->post('system_name');
        $this->db->where('key', 'company');
        $this->db->update('ospos_app_config', $info);
		unset($info);

        $data['description'] = $this->input->post('system_title');
        $this->db->where('type', 'system_title');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('address');
        $this->db->where('type', 'address');
        $this->db->update('settings', $data);
		
        $info['value'] = $this->input->post('address');
        $this->db->where('key', 'address');
        $this->db->update('ospos_app_config', $info);
		unset($info);

        $data['description'] = $this->input->post('phone');
        $this->db->where('type', 'phone');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('paypal_email');
        $this->db->where('type', 'paypal_email');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('currency');
        $this->db->where('type', 'currency');
        $this->db->update('settings', $data);
		
        $info['value'] = $this->input->post('currency');
        $this->db->where('key', 'currency_symbol');
        $this->db->update('ospos_app_config', $info);
		unset($info);

        $data['description'] = $this->input->post('system_email');
        $this->db->where('type', 'system_email');
        $this->db->update('settings', $data);
		
        $info['value'] = $this->input->post('system_email');
        $this->db->where('key', 'email');
        $this->db->update('ospos_app_config', $info);
		unset($info);

        $data['description'] = $this->input->post('buyer');
        $this->db->where('type', 'buyer');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('system_name');
        $this->db->where('type', 'system_name');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('purchase_code');
        $this->db->where('type', 'purchase_code');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('language');
        $this->db->where('type', 'language');
        $this->db->update('settings', $data);

        $data['description'] = $this->input->post('text_align');
        $this->db->where('type', 'text_align');
        $this->db->update('settings', $data);
    }
    
    // SMS settings.
    function update_sms_settings() {
        
        $data['description'] = $this->input->post('clickatell_user');
        $this->db->where('type', 'clickatell_user');
        $this->db->update('settings', $data);
        
        $data['description'] = $this->input->post('clickatell_password');
        $this->db->where('type', 'clickatell_password');
        $this->db->update('settings', $data);
        
        $data['description'] = $this->input->post('clickatell_api_id');
        $this->db->where('type', 'clickatell_api_id');
        $this->db->update('settings', $data);
    }

    /////creates log/////
    function create_log($data) {
        $data['timestamp'] = strtotime(date('Y-m-d') . ' ' . date('H:i:s'));
        $data['ip'] = $_SERVER["REMOTE_ADDR"];
        $location = new SimpleXMLElement(file_get_contents('http://freegeoip.net/xml/' . $_SERVER["REMOTE_ADDR"]));
        $data['location'] = $location->City . ' , ' . $location->CountryName;
        $this->db->insert('log', $data);
    }

    ////////BACKUP RESTORE/////////
    function create_backup($type) {
        $this->load->dbutil();


        $options = array(
            'format' => 'txt', // gzip, zip, txt
            'add_drop' => TRUE, // Whether to add DROP TABLE statements to backup file
            'add_insert' => TRUE, // Whether to add INSERT data to backup file
            'newline' => "\n"               // Newline character used in backup file
        );


        if ($type == 'all') {
            $tables = array('');
            $file_name = 'system_backup';
        } else {
            $tables = array('tables' => array($type));
            $file_name = 'backup_' . $type;
        }

        $backup = & $this->dbutil->backup(array_merge($options, $tables));


        $this->load->helper('download');
        force_download($file_name . '.sql', $backup);
    }

    /////////RESTORE TOTAL DB/ DB TABLE FROM UPLOADED BACKUP SQL FILE//////////
    function restore_backup() {
        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/backup.sql');
        $this->load->dbutil();


        $prefs = array(
            'filepath' => 'uploads/backup.sql',
            'delete_after_upload' => TRUE,
            'delimiter' => ';'
        );
        $restore = & $this->dbutil->restore($prefs);
        unlink($prefs['filepath']);
    }

    /////////DELETE DATA FROM TABLES///////////////
    function truncate($type) {
        if ($type == 'all') {
            $this->db->truncate('student');
            $this->db->truncate('mark');
            $this->db->truncate('teacher');
            $this->db->truncate('subject');
            $this->db->truncate('class');
            $this->db->truncate('exam');
            $this->db->truncate('grade');
        } else {
            $this->db->truncate($type);
        }
    }

    ////////IMAGE URL//////////
    function get_image_url($type = '', $id = '') {
        if (file_exists('uploads/' . $type . '_image/' . $id . '.jpg'))
            $image_url = base_url() . 'uploads/' . $type . '_image/' . $id . '.jpg';
        else
            $image_url = base_url() . 'uploads/user.jpg';

        return $image_url;
    }
    
    function save_department_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['description']    = $this->input->post('description');
        
        $this->db->insert('department',$data);
    }
    
    function select_department_info()
    {
        return $this->db->get('department')->result_array();
    }
    
    function update_department_info($department_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['description'] 	= $this->input->post('description');
        
        $this->db->where('department_id',$department_id);
        $this->db->update('department',$data);
    }
    
    function delete_department_info($department_id)
    {
        $this->db->where('department_id',$department_id);
        $this->db->delete('department');
    }
    
    function save_doctor_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['password']       = sha1($this->input->post('password'));
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        $data['department_id'] 	= $this->input->post('department_id');
        $data['profile'] 	= $this->input->post('profile');
        
        $this->db->insert('doctor',$data);
        $doctor_id  =   $this->db->insert_id();
		
		$info['doctor_id'] 	= $doctor_id;
		$info['active'] 	= 1;
		$info['unit_price']	= $info['cost_price'] = $info['standard_cost'] = 0;
		$info['name'] 		= $info['generic_name'] = $info['category'] = 'Consultation Fees';		
		$this->db->insert('ospos_items',$info);
		
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/doctor_image/" . $doctor_id . '.jpg');
    }
    
    function select_doctor_info()
    {
        return $this->db->get('doctor')->result_array();
    }
    
    function update_doctor_info($doctor_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        $data['department_id'] 	= $this->input->post('department_id');
        $data['profile'] 	= $this->input->post('profile');

        if(!empty(trim($this->input->post('password'))) && trim($this->input->post('password')) != ""){
            $data['password'] = sha1($this->input->post('password'));
        }
        
        $this->db->where('doctor_id',$doctor_id);
        $this->db->update('doctor',$data);
        
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/doctor_image/" . $doctor_id . '.jpg');
    }
    
    function delete_doctor_info($doctor_id)
    {
        $this->db->where('doctor_id',$doctor_id);
        $this->db->delete('doctor');
    }

    
    function save_customer_info()
    {
        $data['name'] = $this->input->post('name');
        $data['email'] = $this->input->post('email');
        $data['address'] = $this->input->post('address');
        $data['phone'] = $this->input->post('phone');

        $this->db->insert('customer', $data);
        $customer_id = $this->db->insert_id();
    }

    function select_customer_info()
    {
        return $this->db->get('customer')->result_array();
    }

    function update_customer_info($customer_id)
    {
        $data['name'] = $this->input->post('name');
        $data['email'] = $this->input->post('email');
        $data['address'] = $this->input->post('address');
        $data['phone'] = $this->input->post('phone');

        $this->db->where('customer_id', $customer_id);
        $this->db->update('customer', $data);
    }

    function delete_customer_info($customer_id)
    {
        $this->db->where('customer_id', $customer_id);
        $this->db->delete('customer');
    }

    
    
    function save_patient_info()
    {
		$data = $_POST;
		unset($data['dd_lists']);
        $data['name'] 			= '';//$this->input->post('name');
        $data['password']       = sha1('redhat@123');//$this->input->post('password'));
        $data['phone']          = '';//$this->input->post('phone');
        $data['birth_date']     = strtotime($this->input->post('birth_date'));
        $data['blood_group'] 	= '';//$this->input->post('blood_group');
        $this->db->trans_start();
		/** add pos cuttomer and people tbl data **/
		$person_data = array(
			'first_name' => $this->input->post('given_name'),
			'last_name' => $this->input->post('surname'),
			'gender' => ($this->input->post('sex') == 'm' ? 1 : 0),
			'email' => $this->input->post('email'),
			'phone_number' => $this->input->post('mobile'),
			'address_1' => $this->input->post('address')			
		);
		
		$this->db->insert('ospos_people', $person_data);
		$person_data['person_id'] = $this->db->insert_id();
		
		$customer_data = array('account_number' => NULL,'company_name' => NULL,'discount_percent' => 0.00,'taxable' => 0);
		$customer_data['person_id'] = $person_data['person_id'];
		$this->db->insert('ospos_customers', $customer_data);		
		/** add pos cuttomer and people tbl data ends**/
		$data['patient_id'] = $person_data['person_id'];
        if($data['patient_number'] == '')
		{
			$data['patient_number'] 	= 'PN'.$data['patient_id'];
		}
		
		$this->db->insert('patient',$data);
        $this->db->trans_complete();
		
		$patient_id = $data['patient_id'];
		
		if(!empty($_POST['dd_lists']))
		{
			foreach($_POST['dd_lists'] as $key => $val)
			{
				$medical_bg['patient_id']	  = $patient_id;
				$medical_bg['dd_category_id'] = $key;
				$medical_bg['dd_sub_category_id'] = $val;
			
				$this->db->insert('medical_bg',$medical_bg);				
			}
		}
        //move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/patient_image/" . $patient_id . '.jpg');
    }
    
    function select_patient_info()
    {
        return $this->db->get('patient')->result_array();
    }
    
    function select_patient_info_by_patient_id( $patient_id = '' )
    {
        return $this->db->get_where('patient', array('patient_id' => $patient_id))->result_array();
    }
            
    function update_patient_info($patient_id)
    {
        $data['name'] 		= '';//$this->input->post('name');
        $data['phone']		= '';//$this->input->post('phone');
        $data['age']        = '';//$this->input->post('age');
        $data['blood_group']= '';//$this->input->post('blood_group');
        $data = $_POST;
		unset($data['dd_lists']);
        $data['birth_date'] = strtotime($data['birth_date']);
		if($data['patient_number'] == '')
		{
			$info['patient_number'] 	= 'PN'.$patient_id;
		}
		
        $this->db->where('patient_id',$patient_id);
        $this->db->update('patient',$data);
        
		$person_data = array(
			'first_name' => $this->input->post('given_name'),
			'last_name' => $this->input->post('surname'),
			'gender' => ($this->input->post('sex') == 'm' ? 1 : 0),
			'email' => $this->input->post('email'),
			'phone_number' => $this->input->post('mobile'),
			'address_1' => $this->input->post('address')			
		);
		
        $this->db->where('person_id',$patient_id);
		$this->db->update('ospos_people', $person_data);
		
		$customer_data = array('account_number' => NULL,'company_name' => NULL,'discount_percent' => 0.00,'taxable' => 0);
        $this->db->where('person_id',$patient_id);
		$this->db->update('ospos_customers', $customer_data);		
		
		$this->db->where('patient_id',$patient_id);
		$this->db->delete('medical_bg');
		
		if(!empty($_POST['dd_lists']))
		{
			foreach($_POST['dd_lists'] as $key => $val)
			{
				$medical_bg['patient_id']	  = $patient_id;
				$medical_bg['dd_category_id'] = $key;
				$medical_bg['dd_sub_category_id'] = $val;
			
				$this->db->insert('medical_bg',$medical_bg);				
			}
		}
		
        //move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/patient_image/" . $patient_id . '.jpg');
    }
    
    function delete_patient_info($patient_id)
    {
        $this->db->where('patient_id',$patient_id);
        $this->db->delete('patient');
    }
    
    function save_nurse_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['password']       = sha1($this->input->post('password'));
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        
        $this->db->insert('nurse',$data);
        
        $nurse_id  =   $this->db->insert_id();
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/nurse_image/" . $nurse_id . '.jpg');
    }
    
    function select_nurse_info()
    {
        return $this->db->get('nurse')->result_array();
    }
    
    function update_nurse_info($nurse_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');

        if(!empty(trim($this->input->post('password'))) && trim($this->input->post('password')) != ""){
            $data['password'] = sha1($this->input->post('password'));
        }
        
        
        $this->db->where('nurse_id',$nurse_id);
        $this->db->update('nurse',$data);
        
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/nurse_image/" . $nurse_id . '.jpg');
    }
    
    function delete_nurse_info($nurse_id)
    {
        $this->db->where('nurse_id',$nurse_id);
        $this->db->delete('nurse');
    }

    //ROOM BY CHM-FM STARTS
    function save_room_info()
    {
        $data['title'] 		= $this->input->post('title');
        $data['room_no'] 	= $this->input->post('room_no');
        $data['added_on']   = date('Y-m-d H:i:s');
        $data['added_by']   = $this->session->userdata('login_user_id');
        
        $this->db->insert('rooms',$data);
        $room_id  =   $this->db->insert_id();
    }
    
    function select_room_info()
    {
        return $this->db->get('rooms')->result_array();
    }
    
    function update_room_info($room_id)
    {
        $data['title'] 		= $this->input->post('title');
        $data['room_no'] 	= $this->input->post('room_no');
        $data['added_on']   = date('Y-m-d H:i:s');
        $data['added_by']   = $this->session->userdata('login_user_id');
        
        $this->db->where('room_id',$room_id);
        $this->db->update('rooms',$data);
    }
    
    function delete_room_info($room_id)
    {
        $this->db->where('room_id', $room_id);
        $this->db->delete('rooms');
    }
    //ROOM BY CHM-FM ENDS
    //UNIT BY CHM-FM STARTS
    function save_unit_info()
    {
        $data['title'] 	= $this->input->post('unit_name');
        
        $this->db->insert('ospos_units',$data);
        $unit_id  =   $this->db->insert_id();
    }
    
    function select_unit_info()
    {
        return $this->db->get('ospos_units')->result_array();
    }
    
    function update_unit_info($unit_id)
    {
        $data['title'] 	= $this->input->post('unit_name');
        
        $this->db->where('id',$unit_id);
        $this->db->update('ospos_units',$data);
    }
    
    function delete_unit_info($unit_id)
    {
        $this->db->where('id', $unit_id);
        $this->db->delete('ospos_units');
    }
    //UNIT BY CHM-FM ENDS
    //DIAGNOSTICS BY CHM-FM STARTS
    function save_diagnostics_info()
    {
        $data['code'] 	    = $this->input->post('code');
        $data['name'] 	    = $this->input->post('diagnostics_name');
        $data['added_on']   = date('Y-m-d H:i:s');
        $data['added_by']   = $this->session->userdata('login_user_id');
        
        $this->db->insert('diagnostics',$data);
        $diagnostics_id  =   $this->db->insert_id();
    }
    
    function select_diagnostics_info()
    {
        return $this->db->get('diagnostics')->result_array();
    }
    
    function update_diagnostics_info($diagnostics_id)
    {
        $data['name'] 		= $this->input->post('diagnostics_name');
        $data['code'] 	= $this->input->post('code');
        $data['added_on']   = date('Y-m-d H:i:s');
        $data['added_by']   = $this->session->userdata('login_user_id');
        
        $this->db->where('diagnostics_id',$diagnostics_id);
        $this->db->update('diagnostics',$data);
    }
    
    function delete_diagnostics_info($diagnostics_id)
    {
        $this->db->where('diagnostics_id', $diagnostics_id);
        $this->db->delete('diagnostics');
    }
    //DIAGNOSTICS BY CHM-FM ENDS
    
    function save_pharmacist_info()
    {
		$this->db->trans_start();
		
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['password']	= sha1($this->input->post('password'));
        $data['address'] 	= $this->input->post('address');
        $data['phone']      = $this->input->post('phone');
        		
		$person_data = array(
						'first_name' => $this->input->post('name'),
						'last_name' => '',
						'gender' => 1,
						'email' => $this->input->post('email'),
						'phone_number' => $this->input->post('phone'),
						'address_1' => $this->input->post('address'),
						'address_2' => '',
						'city' => '',
						'state' => '',
						'zip' => '',
						'country' => '',
						'comments' => ''
					);
					
		$this->db->insert('ospos_people', $person_data);
		$person_data['person_id'] = $this->db->insert_id();
							
		$employee_data = array(
			'username' => $this->input->post('email'),
			'password' => md5($this->input->post('password')),
			'hash_version' => 1
		);
		
		$employee_data['person_id'] = $employee_id = $person_data['person_id'];
		$success = $this->db->insert('ospos_employees', $employee_data);
				
		$data['pharmacist_id'] = $employee_id;
        $this->db->insert('pharmacist',$data);	
		
		$this->db->trans_complete();
		
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/pharmacist_image/" . $pharmacist_id . '.jpg');
    }
    
    function select_pharmacist_info()
    {
        return $this->db->get('pharmacist')->result_array();
    }
    
    function update_pharmacist_info($pharmacist_id)
    {
		$this->db->trans_start();
		
        $data['name'] 	= $this->input->post('name');
        $data['email'] 	= $this->input->post('email');
        $data['address']= $this->input->post('address');
        $data['phone']	= $this->input->post('phone');
        
        $this->db->where('pharmacist_id',$pharmacist_id);
        $this->db->update('pharmacist',$data);
        
		$person_data['first_name'] 	= $this->input->post('name');
        $person_data['email'] 		= $this->input->post('email');
        $person_data['address_1']	= $this->input->post('address');
        $person_data['phone_number']= $this->input->post('phone');

        if(!empty(trim($this->input->post('password'))) && trim($this->input->post('password')) != ""){
            $data['password'] = sha1($this->input->post('password'));
        }
		
		$this->db->where('person_id',$pharmacist_id);
        $this->db->update('ospos_people',$person_data);
							
		$employee_data = array('username' => $this->input->post('email'));
		$this->db->where('person_id',$pharmacist_id);
        $this->db->update('ospos_employees',$employee_data);
		
		$this->db->trans_complete();
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/pharmacist_image/" . $pharmacist_id . '.jpg');
    }
    
    function delete_pharmacist_info($pharmacist_id)
    {
        $this->db->where('pharmacist_id',$pharmacist_id);
        $this->db->delete('pharmacist');
    }
    
    function save_laboratorist_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['password']       = sha1($this->input->post('password'));
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        
        $this->db->insert('laboratorist',$data);
        
        $laboratorist_id  =   $this->db->insert_id();
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/laboratorist_image/" . $laboratorist_id . '.jpg');
    }
    
    function select_laboratorist_info()
    {
        return $this->db->get('laboratorist')->result_array();
    }
    
    function update_laboratorist_info($laboratorist_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');

        if(!empty(trim($this->input->post('password'))) && trim($this->input->post('password')) != ""){
            $data['password'] = sha1($this->input->post('password'));
        }
        
        $this->db->where('laboratorist_id',$laboratorist_id);
        $this->db->update('laboratorist',$data);
        
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/laboratorist_image/" . $laboratorist_id . '.jpg');
    }
    
    function delete_laboratorist_info($laboratorist_id)
    {
        $this->db->where('laboratorist_id',$laboratorist_id);
        $this->db->delete('laboratorist');
    }
    
    function save_accountant_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['password']       = sha1($this->input->post('password'));
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        
        $this->db->insert('accountant',$data);
        
        $accountant_id  =   $this->db->insert_id();
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/accountant_image/" . $accountant_id . '.jpg');
    }
    
    function select_accountant_info()
    {
        return $this->db->get('accountant')->result_array();
    }
    
    function update_accountant_info($accountant_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        
        $this->db->where('accountant_id',$accountant_id);
        $this->db->update('accountant',$data);
        
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/accountant_image/" . $accountant_id . '.jpg');
    }
    
    function delete_accountant_info($accountant_id)
    {
        $this->db->where('accountant_id',$accountant_id);
        $this->db->delete('accountant');
    }
    
    function save_receptionist_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['password']       = sha1($this->input->post('password'));
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');
        
        $this->db->insert('receptionist',$data);
        
        $receptionist_id  =   $this->db->insert_id();
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/receptionist_image/" . $receptionist_id . '.jpg');
    }
    
    function select_receptionist_info()
    {
        return $this->db->get('receptionist')->result_array();
    }
    
    function update_receptionist_info($receptionist_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['email'] 		= $this->input->post('email');
        $data['address'] 	= $this->input->post('address');
        $data['phone']          = $this->input->post('phone');

        if(!empty(trim($this->input->post('password'))) && trim($this->input->post('password')) != ""){
            $data['password'] = sha1($this->input->post('password'));
        }
        
        $this->db->where('receptionist_id',$receptionist_id);
        $this->db->update('receptionist',$data);
        
        move_uploaded_file($_FILES["image"]["tmp_name"], "uploads/receptionist_image/" . $receptionist_id . '.jpg');
    }
    
    function delete_receptionist_info($receptionist_id)
    {
        $this->db->where('receptionist_id',$receptionist_id);
        $this->db->delete('receptionist');
    }
    
    function save_bed_allotment_info()
    {
        $data['bed_id']                 = $this->input->post('bed_id');
        $data['patient_id'] 		    = $this->input->post('patient_id');
        $data['allotment_timestamp'] 	= strtotime($this->input->post('allotment_timestamp'));
        $data['discharge_timestamp']    = strtotime($this->input->post('discharge_timestamp'));
        
        $this->db->insert('bed_allotment',$data);
    }
    
    function select_bed_allotment_info()
    {
        return $this->db->get('bed_allotment')->result_array();
    }
    
    function update_bed_allotment_info($bed_allotment_id)
    {
        $data['bed_id']                 = $this->input->post('bed_id');
        $data['patient_id'] 		= $this->input->post('patient_id');
        $data['allotment_timestamp'] 	= strtotime($this->input->post('allotment_timestamp'));
        $data['discharge_timestamp']    = strtotime($this->input->post('discharge_timestamp'));
        
        $this->db->where('bed_allotment_id',$bed_allotment_id);
        $this->db->update('bed_allotment',$data);
    }
    
    function delete_bed_allotment_info($bed_allotment_id)
    {
        $this->db->where('bed_allotment_id',$bed_allotment_id);
        $this->db->delete('bed_allotment');
    }
    
    function select_blood_bank_info()
    {
        return $this->db->get('blood_bank')->result_array();
    }
    
    function update_blood_bank_info($blood_group_id)
    {
        $data['status']    = $this->input->post('status');
        
        $this->db->where('blood_group_id',$blood_group_id);
        $this->db->update('blood_bank',$data);
    }
    
    function save_report_info()
    {
        $data['type'] 		= $this->input->post('type');
        $data['description']    = $this->input->post('description');
        $data['timestamp']      = strtotime($this->input->post('timestamp'));
        $data['patient_id']     = $this->input->post('patient_id');
        
        $login_type             = $this->session->userdata('login_type');
        if($login_type=='nurse')
            $data['doctor_id']  = $this->input->post('doctor_id');
        else $data['doctor_id'] = $this->session->userdata('login_user_id');
        
        $this->db->insert('report',$data);
    }
    
    function select_report_info()
    {
        return $this->db->get('report')->result_array();
    }
    
    function update_report_info($report_id)
    {
        $data['type'] 		= $this->input->post('type');
        $data['description']    = $this->input->post('description');
        $data['timestamp']      = strtotime($this->input->post('timestamp'));
        $data['patient_id']     = $this->input->post('patient_id');
        
        $login_type             = $this->session->userdata('login_type');
        if($login_type=='nurse')
            $data['doctor_id']  = $this->input->post('doctor_id');
        else $data['doctor_id'] = $this->session->userdata('login_user_id');
        
        $this->db->where('report_id',$report_id);
        $this->db->update('report',$data);
    }
    
    function delete_report_info($report_id)
    {
        $this->db->where('report_id',$report_id);
        $this->db->delete('report');
    }
    
    function save_bed_info()
    {
        $data['bed_number']     = $this->input->post('bed_number');
        $data['type'] 		= $this->input->post('type');
        $data['description']    = $this->input->post('description');
        
        $this->db->insert('bed',$data);
    }
    
    function select_bed_info()
    {
        return $this->db->get('bed')->result_array();
    }
    
    function update_bed_info($bed_id)
    {
        $data['bed_number']     = $this->input->post('bed_number');
        $data['type'] 		= $this->input->post('type');
        $data['description']    = $this->input->post('description');
        
        $this->db->where('bed_id',$bed_id);
        $this->db->update('bed',$data);
    }
    
    function delete_bed_info($bed_id)
    {
        $this->db->where('bed_id',$bed_id);
        $this->db->delete('bed');
    }
    
    function save_blood_donor_info()
    {
        $data['name']                       = $this->input->post('name');
        $data['email']                      = $this->input->post('email');
        $data['address']                    = $this->input->post('address');
        $data['phone']                      = $this->input->post('phone');
        $data['sex']                        = $this->input->post('sex');
        $data['age']                        = $this->input->post('age');
        $data['blood_group']                = $this->input->post('blood_group');
        $data['last_donation_timestamp']    = strtotime($this->input->post('last_donation_timestamp'));
        
        $this->db->insert('blood_donor',$data);
    }
    
    function select_blood_donor_info()
    {
        return $this->db->get('blood_donor')->result_array();
    }
    
    function update_blood_donor_info($blood_donor_id)
    {
        $data['name']                       = $this->input->post('name');
        $data['email']                      = $this->input->post('email');
        $data['address']                    = $this->input->post('address');
        $data['phone']                      = $this->input->post('phone');
        $data['sex']                        = $this->input->post('sex');
        $data['age']                        = $this->input->post('age');
        $data['blood_group']                = $this->input->post('blood_group');
        $data['last_donation_timestamp']    = strtotime($this->input->post('last_donation_timestamp'));
        
        $this->db->where('blood_donor_id',$blood_donor_id);
        $this->db->update('blood_donor',$data);
    }
    
    function delete_blood_donor_info($blood_donor_id)
    {
        $this->db->where('blood_donor_id',$blood_donor_id);
        $this->db->delete('blood_donor');
    }
    
    function save_medicine_category_info()
    {
        $data['name'] 		= $this->input->post('name');
        $data['description']    = $this->input->post('description');
        
        $this->db->insert('medicine_category',$data);
    }
    
    function select_medicine_category_info()
    {
        return $this->db->get('medicine_category')->result_array();
    }
    
    function update_medicine_category_info($medicine_category_id)
    {
        $data['name'] 		= $this->input->post('name');
        $data['description'] 	= $this->input->post('description');
        
        $this->db->where('medicine_category_id',$medicine_category_id);
        $this->db->update('medicine_category',$data);
    }
    
    function delete_medicine_category_info($medicine_category_id)
    {
        $this->db->where('medicine_category_id',$medicine_category_id);
        $this->db->delete('medicine_category');
    }
    
    function save_medicine_info()
    {
        $data['name']                   = $this->input->post('name');
        $data['medicine_category_id']   = $this->input->post('medicine_category_id');
        $data['description']            = $this->input->post('description');
        $data['price']                  = $this->input->post('price');
        $data['manufacturing_company']  = $this->input->post('manufacturing_company');
        $data['status'] 		= $this->input->post('status');
        
        $this->db->insert('medicine',$data);
    }
    
    function select_medicine_info()
    {
        return $this->db->get('medicine')->result_array();
    }
    
    function update_medicine_info($medicine_id)
    {
        $data['name']                   = $this->input->post('name');
        $data['medicine_category_id']   = $this->input->post('medicine_category_id');
        $data['description']            = $this->input->post('description');
        $data['price']                  = $this->input->post('price');
        $data['manufacturing_company']  = $this->input->post('manufacturing_company');
        $data['status'] 		= $this->input->post('status');
        
        $this->db->where('medicine_id',$medicine_id);
        $this->db->update('medicine',$data);
    }
    
    function delete_medicine_info($medicine_id)
    {
        $this->db->where('medicine_id',$medicine_id);
        $this->db->delete('medicine');
    }
    
    function save_appointment_info()
    {
		//echo '<pre>';print_r($_POST);exit;
		$patient_id = $this->input->post('patient_id');
		
		//$this->db->where('patient_id = '.$patient_id[0].' AND (status != "visit-complete" AND status != "cancelled")');
		//$apt_info = $this->db->get('appointment')->row();
		if(1 != 1)//!empty($apt_info) && $this->input->post('customer_id') == 0)
		{
			$this->session->set_flashdata('message', 'Appointment already exist for this patient!!!');
            redirect(base_url() . 'index.php?'.$this->session->userdata('login_type').'/appointment_list');
		}
		else
		{
			$data['durations'] 	= (int) trim($this->input->post('duration'));
			$data['timestamp']  = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
			$data['end_time']  	= strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp').' +'.$data['durations'].' Min' );
			$data['from_time']  = date('Y-m-d H:i:s',$data['timestamp']);
			$data['apt_end_tme']= date('Y-m-d H:i:s',$data['end_time']);
			$data['status']     = 'approved';//($this->session->userdata('nurse_login') == 1) ? 'in-queue' : 'approved';
			//$data['patient_id'] = $this->input->post('patient_id');
			$data['remarks'] 	= $this->input->post('remarks');
			$data['room'] 		= $this->input->post('room');
			
			/*if($this->session->userdata('login_type') == 'doctor')
				$data['doctor_id']  = $this->session->userdata('login_user_id');
			else
				$data['doctor_id']  = $this->input->post('doctor_id');*/
			$data['doctor_id']  = $this->input->post('doctor_id');
			//echo '<pre>';print_r($data);exit;
			unset($data['customer_id']);
			if($this->input->post('customer_id') != 0)
			{
				//$patients = $this->common_model->getTableData('patient', 'patient_id','customer_id = '.$this->input->post('customer_id'));
				if(!empty($patient_id)){
					foreach ($patient_id as $patient) 
					{
						$data['patient_id'] = $patient;
						$this->db->insert('appointment',$data);
					}
				}
			}
			else
			{
				if(isset($_POST['walk_in']) && $_POST['walk_in'] == 1)
				{
					$data['status'] = 'in-queue';
				}
				$data['patient_id'] = $patient_id[0];
				//echo '<pre>';print_r($data);exit;
				$this->db->insert('appointment',$data);
			}
			//echo '<pre>';print_r($data);exit;
			// Notify patient with sms.
			$notify = $this->input->post('notify');
			if($notify != '') 
			{
				$patient_name   =   $this->db->get_where('patient',
									array('patient_id' => $data['patient_id']))->row()->name;
				$doctor_name    =   $this->db->get_where('doctor',
									array('doctor_id' => $data['doctor_id']))->row()->name;
				$date           =   date('l, d F Y', $data['timestamp']);
				$time           =   date('g:i a', $data['timestamp']);
				$message        =   $patient_name . ', you have an appointment with doctor ' . $doctor_name . ' on ' . $date . ' at ' . $time . '.';
				$receiver_phone =   $this->db->get_where('patient',
									array('patient_id' => $data['patient_id']))->row()->phone;
				
				$this->sms_model->send_sms($message, $receiver_phone);
			}
		}
    }
    
    function save_requested_appointment_info()
    {
        $data['timestamp']  = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
        $data['doctor_id']  = $this->input->post('doctor_id');
        $data['patient_id'] = $this->session->userdata('login_user_id');
        $data['status']     = 'pending';
        
        $this->db->insert('appointment',$data);
    }
    
    function select_appointment_info_by_doctor_id()
    {
        $doctor_id = $this->session->userdata('login_user_id');
        
        $this->db->where('doctor_id' , $doctor_id);
        $this->db->where('status' , 'in-queue');
        $this->db->order_by('appointment_id' , 'desc');
        
        return $this->db->get('appointment')->result_array();
    }
    
    function select_appointments_by_doctor_id()
    {
        $doctor_id = $this->session->userdata('login_user_id');
        
        $this->db->where('doctor_id' , $doctor_id);
        $this->db->where('(status = "in-queue" OR status = "visit-complete" OR status = "confirmed")');
        $this->db->order_by('appointment_id' , 'desc');
        
        return $this->db->get('appointment')->result_array();
    }
    
    function select_appointments_for_nurse($doctor_id = 'all', $start_timestamp = '', $end_timestamp = '')
    {
		$response = array();
       	if($doctor_id != 'all') 
		{        
        	$this->db->where('doctor_id' , $doctor_id);
		}
		
		if($this->session->userdata('nurse_login') == 1)
		{
        	$this->db->where('status = "in-queue" OR status = "visit-complete" OR status = "confirmed"');
		}
		$this->db->order_by('appointment_id' , 'desc');
        
        $appointments = $this->db->get('appointment')->result_array();
		foreach ($appointments as $row) {
			if($row['timestamp'] >= $start_timestamp && $row['timestamp'] <= $end_timestamp)
				array_push ($response, $row);
		}
		
		return $response;
    }
    
    function select_appointment_info_by_patient_id()
    {
        $patient_id = $this->session->userdata('login_user_id');
        return $this->db->get_where('appointment', array('patient_id' => $patient_id, 'status' => 'approved'))->result_array();
    }
    
    function select_appointment_info($doctor_id = '', $start_timestamp = '', $end_timestamp = '')
    {
        $response = array();
        if($doctor_id == 'all') 
		{
            ///$this->db->order_by('doctor_id', 'asc');
            $this->db->order_by('appointment_id', 'desc');
            if($this->session->userdata('nurse_login') == 1 || $this->session->userdata('receptionist_login') == 1) 
			{
				$appointments = $this->db->get_where('appointment', array('status' => 'in-queue'))->result_array();
			}
			else
			{
				$appointments = $this->db->get('appointment')->result_array();
			}
            foreach ($appointments as $row) {
                if($row['timestamp'] >= $start_timestamp && $row['timestamp'] <= $end_timestamp)
                    array_push ($response, $row);
            }
        }
        else 
		{
            $this->db->order_by('appointment_id', 'desc');
			if($this->session->userdata('nurse_login') == 1 || $this->session->userdata('receptionist_login') == 1) 
			{
           		$appointments = $this->db->get_where('appointment', array('doctor_id' => $doctor_id, 'status' => 'in-queue'))->result_array();
			}
			else
			{
				$appointments = $this->db->get_where('appointment', array('doctor_id' => $doctor_id))->result_array();
			}
			
            foreach ($appointments as $row) 
			{
                if($row['timestamp'] >= $start_timestamp && $row['timestamp'] <= $end_timestamp)
                    array_push ($response, $row);
            }
        }
        return $response;
    }
    
    function select_pending_appointment_info_by_patient_id()
    {
        $patient_id = $this->session->userdata('login_user_id');
        return $this->db->get_where('appointment', array('patient_id' => $patient_id, 'status' => 'pending'))->result_array();
    }
    
    function select_requested_appointment_info_by_doctor_id()
    {
        $doctor_id = $this->session->userdata('login_user_id');
        return $this->db->get_where('appointment', array('doctor_id' => $doctor_id, 'status' => 'pending'))->result_array();
    }
    
    function select_requested_appointment_info()
    {
        $this->db->order_by('doctor_id', 'asc');
        return $this->db->get_where('appointment', array('status' => 'pending'))->result_array();
    }
    
    function select_patient_info_by_doctor_id()
    {
        $doctor_id = $this->session->userdata('login_user_id');
        
        $this->db->group_by('patient_id');
        return $this->db->get_where('patient', array('responsible_doctor' => $doctor_id))->result_array();
    }
    
    function select_appointments_between_loggedin_patient_and_doctor()
    {
        $patient_id = $this->session->userdata('login_user_id');
        
        $this->db->group_by('doctor_id');
        return $this->db->get_where('appointment', array('patient_id' => $patient_id, 'status' => 'approved'))->result_array();
    }
    
    function select_appointments_patient($patient_id)
    {
        return $this->db->get_where('appointment', array('patient_id' => $patient_id, 'status' => 'visit-complete'))->result_array();
    }
    
    function update_appointment_info($appointment_id)
    {
        if($this->input->post('get_type') == "updated"){
            $data['doctor_id'] = $this->input->post('doctor_id');
            $data['patient_id'] = $this->input->post('patient_id');
            $this->db->where('appointment_id',$appointment_id);
            $this->db->update('appointment',$data);
            // echo $appointment_id. "<pre>"; print_r($_POST); die;
            // return true;
        }else{
            $data['timestamp']  = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
            $this->db->where('appointment_id',$appointment_id);
            $this->db->update('appointment',$data);
            
            // Notify patient with sms.
            $notify = $this->input->post('notify');
            if($notify != '') {
                $doctor_id      =   $this->session->userdata('login_user_id');
                $patient_name   =   $this->db->get_where('patient',
                                    array('patient_id' => $data['patient_id']))->row()->name;
                $doctor_name    =   $this->db->get_where('doctor',
                                    array('doctor_id' => $doctor_id))->row()->name;
                $date           =   date('l, d F Y', $data['timestamp']);
                $time           =   date('g:i a', $data['timestamp']);
                $message        =   $patient_name . ', your appointment with doctor ' . $doctor_name . ' has been updated to ' . $date . ' at ' . $time . '.';
                $receiver_phone =   $this->db->get_where('patient',
                                    array('patient_id' => $data['patient_id']))->row()->phone;
                
                $this->sms_model->send_sms($message, $receiver_phone);
            }
        }
    }
    
    function approve_appointment_info($appointment_id)
    {
        $data['timestamp']  = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
        $data['status']     = 'approved';
        
        if($this->session->userdata('login_type') == 'receptionist')
            $data['doctor_id'] = $this->input->post('doctor_id');
        
        $this->db->where('appointment_id',$appointment_id);
        $this->db->update('appointment',$data);
        
        // Notify patient with sms.
        $notify = $this->input->post('notify');
        if($notify != '') {
            $doctor_id      =   $this->db->get_where('appointment',
                                array('appointment_id' => $appointment_id))->row()->doctor_id;
            $patient_id     =   $this->db->get_where('appointment',
                                array('appointment_id' => $appointment_id))->row()->patient_id;
            $patient_name   =   $this->db->get_where('patient',
                                array('patient_id' => $patient_id))->row()->name;
            $doctor_name    =   $this->db->get_where('doctor',
                                array('doctor_id' => $doctor_id))->row()->name;
            $date           =   date('l, d F Y', $data['timestamp']);
            $time           =   date('g:i a', $data['timestamp']);
            $message        =   $patient_name . ', your requested appointment with doctor ' . $doctor_name . ' on ' . $date . ' at ' . $time . ' has been approved.';
            $receiver_phone =   $this->db->get_where('patient',
                                array('patient_id' => $patient_id))->row()->phone;
            
            $this->sms_model->send_sms($message, $receiver_phone);
        }
    }
    
    function delete_appointment_info($appointment_id)
    {
        $this->db->where('appointment_id',$appointment_id);
        $this->db->delete('appointment');
    }
    
    function save_prescription_info()
    {
        $data['timestamp']      = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
        $data['patient_id']     = $this->input->post('patient_id');
        $data['case_history']   = $this->input->post('case_history');
        $data['medication']     = $this->input->post('medication');
        $data['note']           = $this->input->post('note');
        $data['doctor_id']      = $this->session->userdata('login_user_id');
        
        $this->db->insert('prescription',$data);
    }
    
    function select_prescription_info_by_doctor_id()
    {
        $doctor_id = $this->session->userdata('login_user_id');
        return $this->db->get_where('prescription', array('doctor_id' => $doctor_id))->result_array();
    }
    
    function select_medication_history( $patient_id = '' )
    {
        return $this->db->get_where('prescription', array('patient_id' => $patient_id))->result_array();
    }
    
    function select_prescription_info_by_patient_id()
    {
        $patient_id = $this->session->userdata('login_user_id');
        return $this->db->get_where('prescription', array('patient_id' => $patient_id))->result_array();
    }
    
    function update_prescription_info($prescription_id)
    {
        $data['timestamp']      = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
        $data['patient_id']     = $this->input->post('patient_id');
        $data['case_history']   = $this->input->post('case_history');
        $data['medication']     = $this->input->post('medication');
        $data['note']           = $this->input->post('note');
        $data['doctor_id']      = $this->session->userdata('login_user_id');
        
        $this->db->where('prescription_id',$prescription_id);
        $this->db->update('prescription',$data);
    }
    
    function delete_prescription_info($prescription_id)
    {
        $this->db->where('prescription_id',$prescription_id);
        $this->db->delete('prescription');
    }
    
    function save_diagnosis_report_info()
    {
        $data['timestamp']          = strtotime($this->input->post('date_timestamp').' '.$this->input->post('time_timestamp') );
        $data['report_type']        = $this->input->post('report_type');
        $data['file_name']          = $_FILES["file_name"]["name"];
        $data['document_type']      = $this->input->post('document_type');
        $data['description']        = $this->input->post('description');
        $data['prescription_id']    = $this->input->post('prescription_id');
        
        $this->db->insert('diagnosis_report',$data);
        
        $diagnosis_report_id        = $this->db->insert_id();
        move_uploaded_file($_FILES["file_name"]["tmp_name"], "uploads/diagnosis_report/" . $_FILES["file_name"]["name"]);
    }
    
    function select_diagnosis_report_info()
    {
        return $this->db->get('diagnosis_report')->result_array();
    }
    
    function delete_diagnosis_report_info($diagnosis_report_id)
    {
        $this->db->where('diagnosis_report_id',$diagnosis_report_id);
        $this->db->delete('diagnosis_report');
    }
    
    function save_notice_info()
    {
        $data['title']              = $this->input->post('title');
        $data['description']        = $this->input->post('description');
        if($this->input->post('start_timestamp') != '')
            $data['start_timestamp']    = strtotime($this->input->post('start_timestamp'));
        else 
            $data['start_timestamp']    = '';
        if($this->input->post('end_timestamp') != '')
            $data['end_timestamp']      = strtotime($this->input->post('end_timestamp'));
        else
            $data['end_timestamp']      = $data['start_timestamp'];
        
        $this->db->insert('notice',$data);
    }
    
    function select_notice_info()
    {
        return $this->db->get('notice')->result_array();
    }
    
    function update_notice_info($notice_id)
    {
        $data['title']              = $this->input->post('title');
        $data['description']        = $this->input->post('description');
        if($this->input->post('start_timestamp') != '')
            $data['start_timestamp']    = strtotime($this->input->post('start_timestamp'));
        else 
            $data['start_timestamp']    = '';
        if($this->input->post('end_timestamp') != '')
            $data['end_timestamp']      = strtotime($this->input->post('end_timestamp'));
        else
            $data['end_timestamp']      = $data['start_timestamp'];
        
        $this->db->where('notice_id',$notice_id);
        $this->db->update('notice',$data);
    }
    
    function delete_notice_info($notice_id)
    {
        $this->db->where('notice_id',$notice_id);
        $this->db->delete('notice');
    }
    
    ////////private message//////
    function send_new_private_message() {
        $message    = $this->input->post('message');
        $timestamp  = strtotime(date("Y-m-d H:i:s"));

        $reciever   = $this->input->post('reciever');
        $sender     = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');

        //check if the thread between those 2 users exists, if not create new thread
        $num1 = $this->db->get_where('message_thread', array('sender' => $sender, 'reciever' => $reciever))->num_rows();
        $num2 = $this->db->get_where('message_thread', array('sender' => $reciever, 'reciever' => $sender))->num_rows();

        if ($num1 == 0 && $num2 == 0) {
            $message_thread_code                        = substr(md5(rand(100000000, 20000000000)), 0, 15);
            $data_message_thread['message_thread_code'] = $message_thread_code;
            $data_message_thread['sender']              = $sender;
            $data_message_thread['reciever']            = $reciever;
            $this->db->insert('message_thread', $data_message_thread);
        }
        if ($num1 > 0)
            $message_thread_code = $this->db->get_where('message_thread', array('sender' => $sender, 'reciever' => $reciever))->row()->message_thread_code;
        if ($num2 > 0)
            $message_thread_code = $this->db->get_where('message_thread', array('sender' => $reciever, 'reciever' => $sender))->row()->message_thread_code;


        $data_message['message_thread_code']    = $message_thread_code;
        $data_message['message']                = $message;
        $data_message['sender']                 = $sender;
        $data_message['timestamp']              = $timestamp;
        $this->db->insert('message', $data_message);

        return $message_thread_code;
    }

    function send_reply_message($message_thread_code) {
        $message    = $this->input->post('message');
        $timestamp  = strtotime(date("Y-m-d H:i:s"));
        $sender     = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');


        $data_message['message_thread_code']    = $message_thread_code;
        $data_message['message']                = $message;
        $data_message['sender']                 = $sender;
        $data_message['timestamp']              = $timestamp;
        $this->db->insert('message', $data_message);
    }

    function mark_thread_messages_read($message_thread_code) {
        // mark read only the oponnent messages of this thread, not currently logged in user's sent messages
        $current_user = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');
        $this->db->where('sender !=', $current_user);
        $this->db->where('message_thread_code', $message_thread_code);
        $this->db->update('message', array('read_status' => 1));
    }

    function count_unread_message_of_thread($message_thread_code) {
        $unread_message_counter = 0;
        $current_user = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');
        $messages = $this->db->get_where('message', array('message_thread_code' => $message_thread_code))->result_array();
        foreach ($messages as $row) {
            if ($row['sender'] != $current_user && $row['read_status'] == '0')
                $unread_message_counter++;
        }
        return $unread_message_counter;
    }
}
