<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Common_model extends CI_Model 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
	}
	
	public function getTableData($tbl, $cols, $whr = '', $order_by = '', $dir = '', $join_tbl = '', $join_val = '', $join_type = '', $group_by = '', $limit = 0, $offset = 0)
	{
		$this->db->select($cols, false);
		
		if($join_tbl != '' && $join_val != '')
		{
			if($join_type == '')
			{
				$this->db->join($join_tbl,$join_val);
			}
			else
			{
				$this->db->join($join_tbl,$join_val,$join_type);
			}
		}
		
		if($order_by != '')
		{
			$dir = ($dir == '') ? 'DESC' : $dir;
			$this->db->order_by($order_by, $dir); 
		}
		
		if($limit != 0 && $offset == 0)
		{
			$this->db->limit($limit);
			if($group_by != '')
			{
				$this->db->group_by($group_by); 
			}
		}
		else if($limit != 0 && $offset != 0)
		{
			$this->db->limit($limit, $offset);
			if($group_by != '')
			{
				$this->db->group_by($group_by); 
			}
		}
		
		if($whr != '')
		{
			$this->db->where($whr);
		}		
		$query = $this->db->get($tbl);	
		return $query->result();
	}
	
	public function insert_data($info,$table) // add single admin info 
	{
		if ($this->db->insert($table,$info))
		{
			return $this->db->insert_id(); //insertion success
		}
		else
		{
			return 0; // fail
		}		
	}
	
	public function update_data($info,$table,$where) // update single user info 
	{
		$this->db->where($where);
		if ($this->db->update($table,$info))
		{
			return 1; //insertion failed
		}
		else
		{
			return 0; // success
		}		
	}
	
	public function delete($tablename,$col_name,$id)
	{		
		$this->db->where($col_name,$id);
		if($this->db->delete($tablename))
		{
			return true;
		}
		
		return false;
	}
	
	public function delete_data($tablename,$where)
	{
		$this->db->where($where);
		if($this->db->delete($tablename))
		{
			return true;
		}
		
		return false;
	}
	
	public function ExecQuery($query) 
	{
		$result = $this->db->query($query);
		return $result->result_array();		
	}
	
	public function NoExecQuery($query) 
	{
		$result = $this->db->query($query);
	}
}
?>