<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Receptionist extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
    }

    function index() {
        if ($this->session->userdata('receptionist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $data['page_name'] = 'dashboard';
        $data['page_title'] = get_phrase('receptionist_dashboard');
        $this->load->view('backend/index', $data);
    }

	function print_invoice()
	{
		$this->load->model('common_model');
		$invoices 	= array();
		if(!empty($_POST['patient_id']))
		{
			$patient_id = trim(implode(',',$_POST['patient_id']),',');			
			$customer_id = trim($_POST['customer_id']);
			
			$query = 'SELECT sales.sale_time,sales.apt_id,item_cost_price,ospos_items.name,surname,given_name
						FROM ospos_sales sales 
						JOIN ospos_sales_items items ON items.sale_id = sales.sale_id
						JOIN ospos_items ON ospos_items.item_id = items.item_id
						JOIN patient ON patient.patient_id = sales.customer_id
						WHERE is_lab_test = 1 AND processed = 0 AND sales.customer_id IN ('.$patient_id.')';
			$invoices 	= $this->db->query($query)->result();
			
			$customer 	= $this->db->query('SELECT * FROM customer WHERE customer_id = '.$customer_id)->result();
		}
		//echo '<pre>';print_r($invoices);exit;
		$data['invoices'] = $invoices;
		$data['customer'] = $customer;
		$data['param'] = $_POST['param'];
		$this->load->view('backend/receptionist/print_invoice', $data);
	}

    function micro($task = "", $form_id = "") 
	{
		$this->load->model('common_model');
	
		if(isset($_POST['id']))
		{
			$info['patient_id']	= $_POST['patient_id'];
			$info['apt_id']		= $_POST['apt_id'];
			$info['customer_id']= $_POST['customer_id'];
			$info['lab_form_id']= $_POST['lab_form_id'];
			$info['result_val']	= json_encode($_POST);
			$info['status']		= 2;
			$info['updated_by']	= $this->session->userdata('login_user_id');
			$info['updated_on']	= date('Y-m-d H:i:s');
			$info['updated_by_type'] = $this->session->userdata('login_type');
			$this->common_model->update_data($info,'form_data','id = '.trim($_POST['id']));
			$this->session->set_flashdata('message', 'Updated successfully');  
		}
		else
		{	
			$info['patient_id']	= $_POST['patient_id'];
			$info['apt_id']		= $_POST['apt_id'];
			$info['customer_id']= $_POST['customer_id'];
			$info['lab_form_id']= $_POST['lab_form_id'];
			$info['result_val']	= json_encode($_POST);
			$info['status']		= 2;
			$info['added_by']	= $this->session->userdata('login_user_id');
			$info['added_on']	= date('Y-m-d H:i:s');
			$info['added_by_type']	= $this->session->userdata('login_type');
			$this->common_model->insert_data($info,'form_data');
			
			
			$apt_id = $info['apt_id'];
			if($apt_id != -1)
			{
				unset($info);
				$info['sale_time']	= date('Y-m-d H:i:s');
				$info['customer_id']= trim($_POST['patient_id']);
				$info['employee_id']= 1;
				$info['comment']	= 'Appointment No. '.trim($apt_id);
				$info['reason']		= 'Appointment No. '.trim($apt_id);
				$info['apt_id']		= trim($apt_id);
				$sale_id = $this->common_model->insert_data($info,'ospos_sales');
				unset($info);					

				$fees = $this->db->get_where('ospos_items', array('item_id' => trim($_POST['lab_form_id'])))->result_array();
				
				$info['item_id']	= !empty($fees) ? $fees[0]['item_id'] : 0;
				$info['sale_id']	= $sale_id;
				$info['quantity_purchased']	= 1;
				$info['item_unit_price']	= !empty($fees) ? $fees[0]['standard_cost'] : 0;;
				$info['item_cost_price']	= !empty($fees) ? $fees[0]['standard_cost'] : 0;;
				$info['item_location']		= 1;
				$this->common_model->insert_data($info,'ospos_sales_items');
				unset($info);
			}
			
			$this->session->set_flashdata('message', 'Added successfully');  
		}
		//echo '<pre>';print_r($_POST);exit;   
		redirect(base_url() . 'index.php?laboratorist/tests/');
	}

    function tests($task = "", $blood_group_id = "") 
	{
		$this->load->model('common_model');

        $data['page_name'] = 'tests';
        $data['page_title'] = 'Laboratory Tests';
        $this->load->view('backend/index', $data);
    }

    function documents($patient_id, $task = "", $document_id = "0") 
	{
		if($task == 'add')
		{
			if(isset($_FILES['file']))
			{
				$file = $_FILES['file'];
				
				if(is_uploaded_file($file['tmp_name'])) 
				{	
					$sourcePath 	= $file['tmp_name'];//$_FILES['userFile']['tmp_name']; 
					$ext			= (explode('.',$file['name']));
					$ext			= $ext[count($ext) - 1];
					$fileName 		= preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext,'',$file['name'])).date('ymdhis').'.'.$ext;
					
					if($fileName != '')
					{
						$targetPath 	= $_SERVER['DOCUMENT_ROOT']."/uploads/diagnosis_report/";
						
						$today_dir		= $patient_id;
						if(!file_exists($targetPath.$today_dir))
						{
							mkdir($targetPath.$today_dir,0777);
						}
						$targetPath		= $targetPath.$today_dir.'/';
						$targetPath 	= $targetPath.$fileName;
						$insertedOn 	= date('Y-m-d H:i:s',time());	
						
						if(move_uploaded_file($sourcePath,$targetPath)) 
						{
							$info['title'] = trim($_POST['name']);
							$info['orig_filename'] = $file['name'];
							$info['filename'] = $fileName;
							$info['patient_id'] = $patient_id;
							$info['added_on'] = $insertedOn;
							$this->db->insert('documents', $info);
							$this->session->set_flashdata('message', ('Document added successfuly'));
						}
						//echo '<pre>';print_r($info);exit;
						redirect(base_url().'index.php?receptionist/documents/'.$patient_id);
					}
				}
			}
		}
		else if($task == 'delete')
		{
			$this->db->query('DELETE FROM `documents` WHERE id = '.$document_id);
			$this->session->set_flashdata('message', ('Document delete successfuly'));
			redirect(base_url().'index.php?receptionist/documents/'.$patient_id);
		}
		
        $data['documents'] 	= $this->db->query('SELECT * FROM `documents` WHERE patient_id = '.$patient_id)->result_array();
        $data['patient'] 	= $this->db->query('SELECT * FROM `patient` WHERE patient_id = '.$patient_id)->row();
        $data['page_name'] 	= 'documents';
        $data['page_title'] = !empty($data['patient']) ? $data['patient']->given_name.' '.$data['patient']->sur_name.'`s Documents' : 'Patient Documents';
        $data['patient_id']	= $patient_id;
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }

    function sales($task = "", $sale_id = "0") 
	{
        if ($task == "process") 
		{
			$this->db->query('UPDATE `ospos_sales` SET processed = 1 WHERE sale_id = '.$sale_id);
        }

        $data['sales'] = $this->db->query('SELECT ospos_sales.sale_id,ospos_sales.sale_time, ospos_sales.apt_id, patient.patient_id, patient.customer_id as cus_id, surname,given_name, mobile, ospos_sales_payments.payment_amount FROM `ospos_sales` JOIN ospos_sales_payments ON ospos_sales_payments.sale_id = ospos_sales.sale_id JOIN patient ON patient.patient_id = ospos_sales.customer_id WHERE processed = 0 LIMIT 0, 1000')->result_array();
        $data['page_name'] = 'sales';
        $data['page_title'] = 'Manage Sales';
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }

    function invoices($task = "", $sale_id = "0") 
	{
        if ($task == "process") 
		{
			//$this->db->query('UPDATE `ospos_sales` SET processed = 1 WHERE sale_id = '.$sale_id);
        }

        $data['invoices'] = $this->db->query('SELECT ospos_sales.sale_id,ospos_sales.sale_time,ospos_sales.apt_id,patient.patient_id,surname,given_name,mobile,	processed,ospos_sales_payments.payment_amount,customer.`name`,customer.email FROM `ospos_sales` JOIN ospos_sales_payments ON ospos_sales_payments.sale_id = ospos_sales.sale_id JOIN patient ON patient.patient_id = ospos_sales.customer_id JOIN form_data ON form_data.apt_id = ospos_sales.apt_id LEFT JOIN customer ON customer.customer_id = form_data.customer_id WHERE is_lab_test = 1 ORDER BY sale_id DESC')->result_array();
        $data['page_name'] = 'invoices';
        $data['page_title'] = 'Manage Invoices';
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }

    function patient($task = "", $patient_id = "") {
        if ($this->session->userdata('receptionist_login') != 1) {
            //$this->session->set_userdata('last_page', current_url());
            //redirect(base_url(), 'refresh');
        }


        if ($task == "create") {
            $email = $_POST['email'];
            $patient = $this->db->get_where('patient', array('email' => $email))->row()->name;
            if ($patient == null) {
                $this->crud_model->save_patient_info();
                $this->session->set_flashdata('message', get_phrase('patient_info_saved_successfuly'));
            } else {
                $this->session->set_flashdata('message', get_phrase('duplicate_email'));
            }
            redirect(base_url() . 'index.php?receptionist/patient');
        }

        if ($task == "update") {
                $this->crud_model->update_patient_info($patient_id);
                $this->session->set_flashdata('message', get_phrase('patient_info_updated_successfuly'));
                redirect(base_url() . 'index.php?receptionist/patient');
        }

        if ($task == "delete") {
            $this->crud_model->delete_patient_info($patient_id);
            redirect(base_url() . 'index.php?receptionist/patient');
        }

        $data['patient_info'] = $this->crud_model->select_patient_info();
        $data['page_name'] = 'manage_patient';
        $data['page_title'] = get_phrase('patient');
        $this->load->view('backend/index', $data);
    }

	function chk_appointments()
	{
        $this->load->model('common_model');
		$doctor_id = $this->input->post('doctor_id');
		$date_timestamp = $this->input->post('date_timestamp');
		$where = 'doctor_id = '.$doctor_id.'';
		$html = '<h3 style="font-size:18px; border-top:1px solid #ebebeb; padding-top:10px;">Scheduled Appointments:</h3>';
		
		if($date_timestamp != '')
		{
			$date_timestamp = date('Y-m-d',strtotime($date_timestamp));
			$where .= ' AND from_unixtime(appointment.`timestamp`, "%Y-%m-%d") = "'.$date_timestamp.'"';
		}
		$appointments = $this->common_model->getTableData('appointment', '`timestamp`, surname, given_name, durations, room', $where, 'appointment_id', 'DESC', 'patient','patient.patient_id = appointment.patient_id');
		if(!empty($appointments))
		{
			foreach($appointments as $appointment)
			{
				$rooms = $this->common_model->getTableData('rooms', '*', 'room_id = '.$appointment->room);
				$rooms = !empty($rooms) ? $rooms[0]->title : 'N/A';
				$html .= '<a href="javascript:;" style="margin-right:5px;" class="btn btn-info">'.$appointment->given_name.' '.$appointment->surname.'<br>'.date('M d, Y h:i A',$appointment->timestamp).'<br>Duration:'.$appointment->durations.' Minutes<br>Room #: '.$rooms.'</a>';
			}
		}
		else
		{
			$html = '';
		}
		
		$data['success'] = TRUE;
		if($date_timestamp != '')
		{
			$datetime = date('Y-m-d',strtotime($date_timestamp)).' '.date('H:i',strtotime($this->input->post('time_timestamp')));
			$available = $this->common_model->getTableData('appointment', 'COUNT(1) as total', 'doctor_id = '.$doctor_id.' AND "'.$datetime.'" BETWEEN from_time AND apt_end_tme');
			//echo $this->db->last_query();exit;
			if($available[0]->total > 0){
				$data['success'] = FALSE;
				$data['message'] = 'Selected time slot not available!!!';
			}
		}
		
		$data['html'] = $html;
		echo json_encode($data);
	}	
	
	function confirm_apt($apt_id) 
	{
		$data['status'] = trim($this->input->post('status'));
		$this->db->where('appointment_id', $apt_id);
		$this->db->update('appointment', $data);
		redirect(base_url() . 'index.php?receptionist/appointment_list');
	}
	
    function appointment($task = "", $doctor_id = 'all', $start_timestamp = "", $end_timestamp = "") 
	{
        if ($this->session->userdata('receptionist_login') != 1 && $this->session->userdata('nurse_login') != 1) {
            //$this->session->set_userdata('last_page', current_url());
            //redirect(base_url(), 'refresh');
        }

        if ($task == 'filter') {
            $doctor_id = $this->input->post('doctor_id');
            $start_timestamp = strtotime($this->input->post('start_timestamp'));
            $end_timestamp = strtotime($this->input->post('end_timestamp'));
            redirect(base_url() . 'index.php?'.$this->session->userdata('login_type').'/appointment/search/' . $doctor_id . '/' . $start_timestamp . '/' . $end_timestamp);
        }

        if ($task == "create") 
		{
            $this->crud_model->save_appointment_info();
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?'.$this->session->userdata('login_type').'/appointment_list');
        }

        if ($task == "update") {
            $this->crud_model->update_appointment_info($doctor_id);
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?receptionist/appointment_list');
        }

        $data['doctor_id'] = $doctor_id;
        if ($start_timestamp == '')
            $data['start_timestamp'] = strtotime('today - 30 days');
        else
            $data['start_timestamp'] = $start_timestamp;
        if ($end_timestamp == '')
            $data['end_timestamp'] = strtotime('today + 3 days');
        else
            $data['end_timestamp'] = $end_timestamp;

        $data['appointment_info'] = $this->crud_model->select_appointment_info($doctor_id, $data['start_timestamp'], $data['end_timestamp']);
		//echo $this->db->last_query();exit;
        $data['page_name'] = 'show_appointment';
        $data['page_title'] = get_phrase('appointment');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }
	
    function appointment_list($task = "", $doctor_id = 'all', $start_timestamp = "", $end_timestamp = "") {
        if ($this->session->userdata('receptionist_login') != 1 && $this->session->userdata('nurse_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == 'filter') {
            $doctor_id = $this->input->post('doctor_id');
            $start_timestamp = strtotime($this->input->post('start_timestamp'));
            $end_timestamp = strtotime($this->input->post('end_timestamp'));
            redirect(base_url() . 'index.php?'.$this->session->userdata('login_type').'/appointment_list/search/' . $doctor_id . '/' . $start_timestamp . '/' . $end_timestamp);
        }

        if ($task == "create") {
            $this->crud_model->save_appointment_info();
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?'.$this->session->userdata('login_type').'/appointment_list');
        }

        if ($task == "update_receptionist") {
                $this->crud_model->update_appointment_info($doctor_id);
                $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
                redirect(base_url() . 'index.php?receptionist/appointment_list');
        }

        $data['doctor_id'] = $doctor_id;
        if ($start_timestamp == '')
            $data['start_timestamp'] = strtotime('today - 30 days');
        else
            $data['start_timestamp'] = $start_timestamp;
        if ($end_timestamp == '')
            $data['end_timestamp'] = strtotime('today + 3 days');
        else
            $data['end_timestamp'] = $end_timestamp;

        $data['appointment_info'] = $this->crud_model->select_appointments_for_nurse($doctor_id, $data['start_timestamp'], $data['end_timestamp']);
		//echo $this->db->last_query();exit;
        $data['page_name'] = 'show_appointment';
        $data['page_title'] = get_phrase('appointment');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }
	
    function medication_history($patient_id = '0') 
	{
        $data['appointment_info'] = $this->crud_model->select_appointments_patient($patient_id);
		//echo $this->db->last_query();exit;
        $data['page_name'] = 'medication_history';
        $data['page_title'] = ('Medication History');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }
	
    function consulatation_history($appointment_id = '0') 
	{
		 $data['items']		= $this->db->query('SELECT consultion_diagnosis.remarks,consultion_diagnosis.apt_id,diagnostics.name,diagnostics.code FROM `consultion_diagnosis` JOIN diagnostics ON diagnostics.diagnostics_id = consultion_diagnosis.diagnosis_id WHERE consultion_diagnosis.apt_id = '.$appointment_id.' ORDER BY id DESC')->result_array();
		 $data['consultion']= $this->db->query('SELECT * FROM consultion WHERE apt_id = '.$appointment_id.'')->result();
		//$this->pre_print($data['items']);
		$data['apt_id']		= $appointment_id;
		//echo $this->db->last_query();exit;
        $data['page_name'] 	= 'consulatation_history';
        $data['page_title']	= ('Consultation Details');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }
	
    function view_consultation($appointment_id = 0, $patient_id = '0') 
	{
       $data['items']		= $this->db->query('SELECT consultion_items.*,ospos_items.name FROM `consultion_items` JOIN ospos_items ON ospos_items.item_id = consultion_items.item_id WHERE ospos_items.doctor_id = 0 AND apt_id = '.$appointment_id.' GROUP BY consultion_items.item_id')->result_array();
		//$this->pre_print($data['items']);
		$data['apt_id']		= $appointment_id;
		//echo $this->db->last_query();exit;
        $data['page_name'] = 'view_consultation';
        $data['page_title'] = ('View Consultation');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }

    function appointment_requested($task = "", $appointment_id = "") {
        if ($this->session->userdata('receptionist_login') != 1 && $this->session->userdata('nurse_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "approve") {
            $this->crud_model->approve_appointment_info($appointment_id);
            $this->session->set_flashdata('message', get_phrase('appointment_info_approved'));
            redirect(base_url() . 'index.php?receptionist/appointment_requested');
        }

        $data['requested_appointment_info'] = $this->crud_model->select_requested_appointment_info();
        $data['page_name'] = 'manage_requested_appointment';
        $data['page_title'] = get_phrase('requested_appointment');
        $this->load->view('backend/index', $data);
    }

    function profile($task = "") {
        if ($this->session->userdata('receptionist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $receptionist_id = $this->session->userdata('login_user_id');
        if ($task == "update") {
                $this->crud_model->update_receptionist_info($receptionist_id);
                $this->session->set_flashdata('message', get_phrase('profile_info_updated_successfuly'));
                redirect(base_url() . 'index.php?receptionist/profile');
        }

        if ($task == "change_password") {
            $password = $this->db->get_where('receptionist', array('receptionist_id' => $receptionist_id))->row()->password;
            $old_password = sha1($this->input->post('old_password'));
            $new_password = $this->input->post('new_password');
            $confirm_new_password = $this->input->post('confirm_new_password');

            if ($password == $old_password && $new_password == $confirm_new_password) {
                $data['password'] = sha1($new_password);

                $this->db->where('receptionist_id', $receptionist_id);
                $this->db->update('receptionist', $data);

                $this->session->set_flashdata('message', get_phrase('password_info_updated_successfuly'));
                redirect(base_url() . 'index.php?receptionist/profile');
            } else {
                $this->session->set_flashdata('message', get_phrase('password_update_failed'));
                redirect(base_url() . 'index.php?receptionist/profile');
            }
        }

        $data['page_name'] = 'edit_profile';
        $data['page_title'] = get_phrase('profile');
        $this->load->view('backend/index', $data);
    }

    function history($patient_id, $appointment_id = 0) 
	{
        $this->load->model('common_model');
		$where = 'patient_id = '.$patient_id;
		if($appointment_id != '0')
		{
			$where .= ' AND appointment_id = '.$appointment_id;
		}
        $data['appointments']= $this->common_model->getTableData('patient_history', '*', $where, 'id', 'DESC');
        $data['page_name']	 = 'history';
        $data['page_title']  = 'Patient History';
        $this->load->view('backend/index', $data);
    }

	function take_history()
	{
		$info = $_POST;
		$info['testing'] 	= (isset($_POST['testing'])) ? 1 : 0;
		$info['added_on'] 	= date('Y-m-d H:i:s');
		$info['added_by'] 	= $this->session->userdata('login_user_id');
		$info['added_by_type'] 	= ($this->session->userdata('receptionist_login') != 1) ? 2 : 1;
        $this->db->insert('patient_history', $info);
		redirect(base_url() . 'index.php?receptionist/history/'.$info['patient_id']);
	}

	function update_history()
	{
		$info = $_POST;
		$info['testing'] 	= (isset($_POST['testing'])) ? 1 : 0;
		$info['updated_on'] 	= date('Y-m-d H:i:s');
		$info['updated_by'] 	= $this->session->userdata('login_user_id');
		$info['updated_by_type']= ($this->session->userdata('receptionist_login') != 1) ? 2 : 1;
		unset($info['history_id']);
		$this->db->where('id', $_POST['history_id']);
		$this->db->update('patient_history', $info);
		redirect(base_url().'index.php?'.$this->session->userdata('login_type').'/appointment_list/'.$info['patient_id']);
	}
	
	function load_patients()
	{
		$customer_id = trim($_POST['customer_id']);
		$where = '';
		if($customer_id != 0){
			$where = 'WHERE customer_id = '.$customer_id;
		}
        $patients 	= $this->db->query('SELECT given_name,patient_id,surname FROM `patient` '.$where)->result_array();
		$html = '';
		foreach($patients as $row)
		{
			$html .= '<option value="'.$row['patient_id'].'">'.$row['given_name'].' '.$row['surname'].'</option>';
		}
		$res['html'] = $html;
		$res['patients'] = $patients;
		echo json_encode($res);
	}
	
	function load_apt_patients()
	{
		$customer_id = trim($_POST['customer_id']);
		$where = '';
		if($customer_id != 0){
			$where = 'WHERE customer_id = '.$customer_id.' AND patient_id IN (SELECT customer_id FROM ospos_sales WHERE is_lab_test = 1 AND processed = 0)';
		}
        $patients 	= $this->db->query('SELECT given_name,patient_id,surname FROM `patient` '.$where)->result_array();
		$html = '';
		foreach($patients as $row)
		{
			$html .= '<option value="'.$row['patient_id'].'">'.$row['given_name'].' '.$row['surname'].'</option>';
		}
		$res['html'] = $html;
		$res['patients'] = $patients;
		echo json_encode($res);
	}
	
	function chk_existing_apt()
	{
		$patient_id = trim($_POST['patient_id']);
		$this->db->where('patient_id = '.$patient_id.' AND (status != "visit-complete" AND status != "cancelled")');
		$apt_info = $this->db->get('appointment')->row();
		
		$res['success'] = !empty($apt_info) ? false : true;
		$res['message'] = !empty($apt_info) ? 'Appointment already exist for this patient on '.date('d M, Y', strtotime($apt_info->from_time)) : '';
		echo json_encode($res);
	}
}
