<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Laboratorist extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
    }

    function index() {
        if ($this->session->userdata('laboratorist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $data['page_name'] = 'dashboard';
        $data['page_title'] = get_phrase('laboratorist_dashboard');
        $this->load->view('backend/index', $data);
    }

    function micro($task = "", $form_id = "") 
	{
		$this->load->model('common_model');
	
		if(isset($_POST['id']))
		{
			$info['patient_id']	= $_POST['patient_id'];
			$info['apt_id']		= $_POST['apt_id'];
			$info['customer_id']= $_POST['customer_id'];
			$info['lab_form_id']= $_POST['lab_form_id'];
			$info['result_val']	= json_encode($_POST);
			$info['status']		= 2;
			$info['price']		= 40;
			$info['updated_by']	= $this->session->userdata('login_user_id');
			$info['updated_on']	= date('Y-m-d H:i:s');
			$info['updated_by_type'] = $this->session->userdata('login_type');
			$this->common_model->update_data($info,'form_data','id = '.trim($_POST['id']));
			
			$apt_id = $info['apt_id'];
			$record = $this->db->get_where('ospos_sales', array('is_lab_test' => 1, 'customer_id' => trim($_POST['patient_id']), 'apt_id' => $apt_id))->row();
			if(empty($record))
			{
				unset($info);
				$info['sale_time']	= date('Y-m-d H:i:s');
				$info['customer_id']= trim($_POST['patient_id']);
				$info['employee_id']= 1;
				$info['is_lab_test']= 1;
				$info['comment']	= 'Appointment No. '.trim($apt_id);
				$info['apt_id']		= trim($apt_id);
				$sale_id = $this->common_model->insert_data($info,'ospos_sales');
				unset($info);					

				$fees = $this->db->get_where('ospos_items', array('item_id' => trim($_POST['lab_form_id'])))->result_array();
				
				$info['item_id']	= !empty($fees) ? $fees[0]['item_id'] : 0;
				$info['sale_id']	= $sale_id;
				$info['quantity_purchased']	= 1;
				$info['item_unit_price']	= !empty($fees) ? $fees[0]['standard_cost'] : 0;;
				$info['item_cost_price']	= !empty($fees) ? $fees[0]['standard_cost'] : 0;;
				$info['item_location']		= 1;
				$this->common_model->insert_data($info,'ospos_sales_items');
				unset($info);
				
				$info['sale_id'] = $sale_id;
				$info['payment_amount']	= !empty($fees) ? $fees[0]['standard_cost'] : 0;;
				$info['payment_type']	= 'Cash';
				$this->common_model->insert_data($info,'ospos_sales_payments');
				unset($info);
				
				$info['status'] = 'visit-complete';
				$this->common_model->update_data($info,'appointment','appointment_id = '.trim($_POST['apt_id']));
				unset($info);
			}
			
			$this->session->set_flashdata('message', 'Updated successfully');  
		}
		else
		{	
			$info['patient_id']	= $_POST['patient_id'];
			$info['apt_id']		= $_POST['apt_id'];
			$info['customer_id']= $_POST['customer_id'];
			$info['lab_form_id']= $_POST['lab_form_id'];
			$info['result_val']	= json_encode($_POST);
			$info['status']		= 2;
			$info['price']		= 40;
			$info['added_by']	= $this->session->userdata('login_user_id');
			$info['added_on']	= date('Y-m-d H:i:s');
			$info['added_by_type']	= $this->session->userdata('login_type');
			$this->common_model->insert_data($info,'form_data');
			
			
			
			$this->session->set_flashdata('message', 'Added successfully');  
		}
		//echo '<pre>';print_r($_POST);exit;   
		redirect(base_url() . 'index.php?laboratorist/tests/');
	}

    function tests($task = "", $blood_group_id = "") 
	{
		$this->load->model('common_model');
        if ($this->session->userdata('laboratorist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "update") {
            $this->crud_model->update_blood_bank_info($blood_group_id);
            $this->session->set_flashdata('message', get_phrase('blood_bank_info_updated_successfuly'));
            redirect(base_url() . 'index.php?laboratorist/blood_bank');
        }

        $data['page_name'] = 'tests';
        $data['page_title'] = 'Laboratory Tests';
        $this->load->view('backend/index', $data);
    }

    function blood_bank($task = "", $blood_group_id = "") {
        if ($this->session->userdata('laboratorist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "update") {
            $this->crud_model->update_blood_bank_info($blood_group_id);
            $this->session->set_flashdata('message', get_phrase('blood_bank_info_updated_successfuly'));
            redirect(base_url() . 'index.php?laboratorist/blood_bank');
        }

        $data['blood_bank_info'] = $this->crud_model->select_blood_bank_info();
        $data['page_name'] = 'manage_blood_bank';
        $data['page_title'] = get_phrase('blood_bank');
        $this->load->view('backend/index', $data);
    }

    function blood_donor($task = "", $blood_donor_id = "") {
        if ($this->session->userdata('laboratorist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $email = $_POST['email'];
            $blood_donor = $this->db->get_where('blood_donor', array('email' => $email))->row()->name;
            if ($blood_donor == null) {
                $this->crud_model->save_blood_donor_info();
                $this->session->set_flashdata('message', get_phrase('blood_donor_info_saved_successfuly'));
            } else {
                $this->session->set_flashdata('message', get_phrase('duplicate_email'));
            }
            redirect(base_url() . 'index.php?laboratorist/blood_donor');
        }

        if ($task == "update") {
                $this->crud_model->update_blood_donor_info($blood_donor_id);
                $this->session->set_flashdata('message', get_phrase('blood_donor_info_updated_successfuly'));
                redirect(base_url() . 'index.php?laboratorist/blood_donor');
        }

        if ($task == "delete") {
            $this->crud_model->delete_blood_donor_info($blood_donor_id);
            redirect(base_url() . 'index.php?laboratorist/blood_donor');
        }

        $data['blood_donor_info'] = $this->crud_model->select_blood_donor_info();
        $data['page_name'] = 'manage_blood_donor';
        $data['page_title'] = get_phrase('blood_donor');
        $this->load->view('backend/index', $data);
    }

    function profile($task = "") {
        if ($this->session->userdata('laboratorist_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $laboratorist_id = $this->session->userdata('login_user_id');
        if ($task == "update") {
            $this->crud_model->update_laboratorist_info($laboratorist_id);
            $this->session->set_flashdata('message', get_phrase('profile_info_updated_successfuly'));
            redirect(base_url() . 'index.php?laboratorist/profile');
        }

        if ($task == "change_password") {
            $password = $this->db->get_where('laboratorist', array('laboratorist_id' => $laboratorist_id))->row()->password;
            $old_password = sha1($this->input->post('old_password'));
            $new_password = $this->input->post('new_password');
            $confirm_new_password = $this->input->post('confirm_new_password');

            if ($password == $old_password && $new_password == $confirm_new_password) {
                $data['password'] = sha1($new_password);

                $this->db->where('laboratorist_id', $laboratorist_id);
                $this->db->update('laboratorist', $data);

                $this->session->set_flashdata('message', get_phrase('password_info_updated_successfuly'));
                redirect(base_url() . 'index.php?laboratorist/profile');
            } else {
                $this->session->set_flashdata('message', get_phrase('password_update_failed'));
                redirect(base_url() . 'index.php?laboratorist/profile');
            }
        }

        $data['page_name'] = 'edit_profile';
        $data['page_title'] = get_phrase('profile');
        $this->load->view('backend/index', $data);
    }

}
