<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Doctor extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
    }

    function index() {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $data['page_name'] = 'dashboard';
        $data['page_title'] = get_phrase('doctor_dashboard');
        $this->load->view('backend/index', $data);
    }

    function micro($task = "", $form_id = "") 
	{
		$this->load->model('common_model');
	
		if(isset($_POST['id']))
		{
			$info['patient_id']	= $_POST['patient_id'];
			$info['apt_id']		= $_POST['apt_id'];
			$info['customer_id']= $_POST['customer_id'];
			$info['lab_form_id']= $_POST['lab_form_id'];
			$info['status']		= $_POST['sent_to'];
			$info['form_values']= json_encode($_POST);
			$this->common_model->update_data($info,'form_data','id = '.trim($_POST['id']));
			$this->session->set_flashdata('message', 'Updated successfully');  
		}
		else
		{	$info['patient_id']	= $_POST['patient_id'];
			$info['apt_id']		= $_POST['apt_id'];
			$info['customer_id']= $_POST['customer_id'];
			$info['lab_form_id']= $_POST['lab_form_id'];
			$info['status']		= $_POST['sent_to'];
			$info['form_values']= json_encode($_POST);
			$info['added_by']	= $this->session->userdata('login_user_id');
			$info['added_on']	= date('Y-m-d H:i:s');
			$info['added_by_type']	= $this->session->userdata('login_type');
			$this->common_model->insert_data($info,'form_data');
			$this->session->set_flashdata('message', 'Added successfully');  
		}
		//echo '<pre>';print_r($_POST);exit;   
		redirect(base_url() . 'index.php?doctor/consultation/'.$info['apt_id'].'/'.$info['patient_id']);
	}

    function tests($task = "", $blood_group_id = "") 
	{
		$this->load->model('common_model');

        $data['page_name'] = 'tests';
        $data['page_title'] = 'Laboratory Tests';
        $this->load->view('backend/index', $data);
    }
	
	function letters($task = "", $letter_id = "") 
	{
		$this->load->model('common_model');
        if ($task == "create") 
		{
			if(isset($_POST['id']))
			{
				$info['title']		= $_POST['title'];
				$info['details']	= $_POST['details'];
				$info['doctor_id']	= $this->session->userdata('login_user_id');
				$info['updated_by']	= $this->session->userdata('login_user_id');
				$info['updated_on']	= date('Y-m-d H:i:s');
				$info['updated_by_type']	= $this->session->userdata('login_type');
				$this->common_model->update_data($info,'letters','id = '.trim($_POST['id']));
				$this->session->set_flashdata('message', 'Letter updated successfully');  
			}
			else
			{	$info['title']		= $_POST['title'];
				$info['details']	= $_POST['details'];
				$info['doctor_id']	= $this->session->userdata('login_user_id');
				$info['added_by']	= $this->session->userdata('login_user_id');
				$info['added_on']	= date('Y-m-d H:i:s');
				$info['added_by_type']	= $this->session->userdata('login_type');
				$this->common_model->insert_data($info,'letters');
 				$this->session->set_flashdata('message', 'Letter created successfully');        
				unset($info);
			}
			//echo '<pre>';print_r($_POST);exit;   
            redirect(base_url() . 'index.php?doctor/letters');
        }
		else if ($task == "delete") 
		{
			$this->common_model->delete_data('letters', 'id = '.$letter_id);
            redirect(base_url() . 'index.php?doctor/letters');
		}
		
        $data['letters'] = $this->common_model->getTableData('letters','letters.*,doctor.name','','title','ASC','doctor','doctor.doctor_id = letters.doctor_id');
        $data['page_name'] = 'letters';
        $data['page_title'] = 'Letters';
        $this->load->view('backend/index', $data);
	}
	
	function pharmacy_request($task = "", $request_id = "") 
	{
		$this->load->model('common_model');
        if ($task == "create") 
		{
			if(!empty($_POST))
			{
				$i = 0;
				$info['status']		= 'pending';
				$info['user_id']	= $this->session->userdata('login_user_id');
				$info['user_type']	= $this->session->userdata('login_type');
				$info['added_on']	= date('Y-m-d H:i:s');
				$request_id = $this->common_model->insert_data($info,'order_requests');
				unset($info);
				
				foreach($_POST['item_name'] as $post)
				{
					if(trim($_POST['item_id'][$i]) != '' || trim($_POST['item_name'][$i]) != '')
					{
						$info['request_id'] = $request_id;
						$info['item_id']	= $_POST['item_id'][$i] == '' ? 0 : $_POST['item_id'][$i];
						$info['item_name']	= $_POST['item_name'][$i];
						$info['desired_qty']= $_POST['qty'][$i];
						$info['is_new']		= $_POST['new_field'][$i];
						$info['units']		= $_POST['units'][$i];
						$info['user_id']	= $this->session->userdata('login_user_id');
						$info['user_type']	= $this->session->userdata('login_type');
						$info['added_on']	= date('Y-m-d H:i:s');
						$this->common_model->insert_data($info,'order_request_items');
						unset($info);
					}
					$i++;
				}
			}
			//echo '<pre>';print_r($_POST);exit;
 			$this->session->set_flashdata('message', 'Order created successfully');           
            redirect(base_url() . 'index.php?doctor/pharmacy_request');
        }

        if ($task == "update") 
		{			
			$this->session->set_flashdata('message', get_phrase('patient_info_updated_successfuly'));
			redirect(base_url() . 'index.php?doctor/pharmacy_request');
        }

        if ($task == "delete") 
		{
			$this->common_model->delete_data('order_requests', 'id = '.$request_id);
			$this->common_model->delete_data('order_request_items', 'request_id = '.$request_id);
 			$this->session->set_flashdata('message', 'Order deleted successfully');
            redirect(base_url() . 'index.php?doctor/pharmacy_request');
        }

        $data['order_requests'] = $this->common_model->getTableData('order_requests', '*', '', 'id', 'DESC');
		//echo '<pre>';print_r($data);exit;
        $data['page_name'] = 'pharmacy_request';
        $data['page_title'] = 'Order Pharmacy';
        $this->load->view('backend/index', $data);
    }

    function patient($task = "", $patient_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $email = $_POST['email'];
            $patient = $this->db->get_where('patient', array('email' => $email))->row()->name;
            if ($patient == null) {
                $this->crud_model->save_patient_info();
                $this->session->set_flashdata('message', get_phrase('patient_info_saved_successfuly'));
            } else {
                $this->session->set_flashdata('message', get_phrase('duplicate_email'));
            }
            redirect(base_url() . 'index.php?doctor/patient');
        }

        if ($task == "update") {
                $this->crud_model->update_patient_info($patient_id);
                $this->session->set_flashdata('message', get_phrase('patient_info_updated_successfuly'));
                redirect(base_url() . 'index.php?doctor/patient');
        }

        if ($task == "delete") {
            $this->crud_model->delete_patient_info($patient_id);
            redirect(base_url() . 'index.php?doctor/patient');
        }

        $data['patients'] = $this->crud_model->select_patient_info_by_doctor_id();
        $data['page_name'] = 'manage_patient';
        $data['page_title'] = get_phrase('patient');
        $this->load->view('backend/index', $data);
    }

    function medication_history($param1 = "", $prescription_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $patient_name = $this->db->get_where('patient', array('patient_id' => $param1))->row()->name; // $param1 = $patient_id
        $data['prescription_info'] = $this->crud_model->select_medication_history($param1); // $param1 = $patient_id
        $data['menu_check'] = 'from_patient';
        $data['page_name'] = 'manage_prescription';
        $data['page_title'] = get_phrase('medication_history_of_:_') . $patient_name;
        $this->load->view('backend/index', $data);
    }

    function bed_allotment($task = "", $bed_allotment_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $this->crud_model->save_bed_allotment_info();
            $this->session->set_flashdata('message', get_phrase('bed_allotment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/bed_allotment');
        }

        if ($task == "update") {
            $this->crud_model->update_bed_allotment_info($bed_allotment_id);
            $this->session->set_flashdata('message', get_phrase('bed_allotment_info_updated_successfuly'));
            redirect(base_url() . 'index.php?doctor/bed_allotment');
        }

        if ($task == "delete") {
            $this->crud_model->delete_bed_allotment_info($bed_allotment_id);
            redirect(base_url() . 'index.php?doctor/bed_allotment');
        }

        $data['bed_allotment_info'] = $this->crud_model->select_bed_allotment_info();
        $data['page_name'] = 'manage_bed_allotment';
        $data['page_title'] = get_phrase('bed_allotment');
        $this->load->view('backend/index', $data);
    }

    function blood_bank($task = "", $blood_bank_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $data['blood_bank_info'] = $this->crud_model->select_blood_bank_info();
        $data['blood_donor_info'] = $this->crud_model->select_blood_donor_info();
        $data['page_name'] = 'show_blood_bank';
        $data['page_title'] = get_phrase('blood_bank');
        $this->load->view('backend/index', $data);
    }

    function report($task = "", $report_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $this->crud_model->save_report_info();
            $this->session->set_flashdata('message', get_phrase('report_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/report');
        }

        if ($task == "update") {
            $this->crud_model->update_report_info($report_id);
            $this->session->set_flashdata('message', get_phrase('report_info_updated_successfuly'));
            redirect(base_url() . 'index.php?doctor/report');
        }

        if ($task == "delete") {
            $this->crud_model->delete_report_info($report_id);
            redirect(base_url() . 'index.php?doctor/report');
        }

        $data['page_name'] = 'manage_report';
        $data['page_title'] = get_phrase('report');
        $this->load->view('backend/index', $data);
    }

    function profile($task = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        $doctor_id = $this->session->userdata('login_user_id');
        if ($task == "update") {
                $this->crud_model->update_doctor_info($doctor_id);
                redirect(base_url() . 'index.php?doctor/profile');
        }

        if ($task == "change_password") {
            $password = $this->db->get_where('doctor', array('doctor_id' => $doctor_id))->row()->password;
            $old_password = sha1($this->input->post('old_password'));
            $new_password = $this->input->post('new_password');
            $confirm_new_password = $this->input->post('confirm_new_password');

            if ($password == $old_password && $new_password == $confirm_new_password) {
                $data['password'] = sha1($new_password);

                $this->db->where('doctor_id', $doctor_id);
                $this->db->update('doctor', $data);

                $this->session->set_flashdata('message', get_phrase('password_info_updated_successfuly'));
                redirect(base_url() . 'index.php?doctor/profile');
            } else {
                $this->session->set_flashdata('message', get_phrase('password_update_failed'));
                redirect(base_url() . 'index.php?doctor/profile');
            }
        }
		
        if ($task == "consultation_fees") 
		{
			$fees = $this->db->get_where('ospos_items', array('doctor_id' => $doctor_id))->row();
			if(empty($fees))
			{
				$info['doctor_id'] 	= $doctor_id;
				$info['active'] 	= 1;
				$info['unit_price']	= $info['cost_price'] = $info['standard_cost'] = trim($this->input->post('amount'));
				$info['name'] 		= $info['generic_name'] = $info['category'] = 'Consultation Fees';		
				$this->db->insert('ospos_items',$info);
			}
			else
			{
				$info['unit_price']	= $info['cost_price'] = $info['standard_cost'] = trim($this->input->post('amount'));
				$this->db->where('doctor_id',$doctor_id);
				$this->db->update('ospos_items',$info);
			}
			redirect(base_url() . 'index.php?doctor/profile');
        }

        $data['page_name'] = 'edit_profile';
        $data['page_title'] = get_phrase('profile');
        $this->load->view('backend/index', $data);
    }
	
	function confirm_apt($apt_id) 
	{
		$data['status'] = trim($this->input->post('status'));
		$this->db->where('appointment_id', $apt_id);
		$this->db->update('appointment', $data);
		redirect(base_url() . 'index.php?doctor/appointment');
	}
	
	function appointment($task = "", $doctor_id = 'all', $start_timestamp = "", $end_timestamp = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == 'filter') {
            $doctor_id = $this->input->post('doctor_id');
            $start_timestamp = strtotime($this->input->post('start_timestamp'));
            $end_timestamp = strtotime($this->input->post('end_timestamp'));
            redirect(base_url() . 'index.php?doctor/appointment/search/' . $doctor_id . '/' . $start_timestamp . '/' . $end_timestamp);
        }

        if ($task == "create") {
            $this->crud_model->save_appointment_info();
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/appointment_list');
        }

        if ($task == "update") {
            $this->crud_model->update_appointment_info($doctor_id);
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/appointment');
        }
		
		$doctor_id = $this->session->userdata('login_user_id');
        $data['doctor_id'] = $doctor_id;
        if ($start_timestamp == '')
            $data['start_timestamp'] = strtotime('today - 30 days');
        else
            $data['start_timestamp'] = $start_timestamp;
        if ($end_timestamp == '')
            $data['end_timestamp'] = strtotime('today + 3 days');
        else
            $data['end_timestamp'] = $end_timestamp;

        $data['appointment_info'] = $this->crud_model->select_appointment_info_by_doctor_id($doctor_id, $data['start_timestamp'], $data['end_timestamp']);
        // echo "<pre>"; print_r($data['appointment_info']); die;
		//echo $this->db->last_query();exit;
        $data['page_name'] = 'manage_appointment';
        $data['page_title'] = get_phrase('appointment');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }
	
	function appointment_list($task = "", $doctor_id = 'all', $start_timestamp = "", $end_timestamp = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == 'filter') {
            $doctor_id = $this->input->post('doctor_id');
            $start_timestamp = strtotime($this->input->post('start_timestamp'));
            $end_timestamp = strtotime($this->input->post('end_timestamp'));
            redirect(base_url() . 'index.php?doctor/appointment_list/search/' . $doctor_id . '/' . $start_timestamp . '/' . $end_timestamp);
        }

        if ($task == "create") {
            $this->crud_model->save_appointment_info();
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/appointment_list');
        }
		
		$doctor_id = $this->session->userdata('login_user_id');
        $data['doctor_id'] = $doctor_id;
        if ($start_timestamp == '')
            $data['start_timestamp'] = strtotime('today - 30 days');
        else
            $data['start_timestamp'] = $start_timestamp;
        if ($end_timestamp == '')
            $data['end_timestamp'] = strtotime('today + 3 days');
        else
            $data['end_timestamp'] = $end_timestamp;

        $data['appointment_info'] = $this->crud_model->select_appointments_by_doctor_id($doctor_id, $data['start_timestamp'], $data['end_timestamp']);
		//echo $this->db->last_query();exit;
        $data['page_name'] = 'manage_appointment';
        $data['page_title'] = get_phrase('appointment');
		//echo '<pre>';print_r($data);exit;
        $this->load->view('backend/index', $data);
    }
	
	function consultation($appointment_id, $patient_id) 
	{
        if ($this->session->userdata('doctor_login') != 1 && $this->session->userdata('admin_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $this->crud_model->save_appointment_info();
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/appointment');
        }
		
		$doctor_id = $this->session->userdata('login_user_id');
        $data['doctor_id'] 		= $doctor_id;
        $data['patient_id'] 	= $patient_id;
        $data['appointment_id'] = $appointment_id;
		//echo $this->db->last_query();exit;
        $data['page_name'] 	= 'prescription';
        $data['page_title'] = 'Consultation';
		$this->load->view('backend/index', $data);
    }
	
	function add_consultation($task = 'draft') 
	{
        $this->load->model('common_model');
        if ($task == "draft") 
		{
			$this->form_validation->set_rules('tpl_title', 'Template Title', 'trim|required');
			$apt_id = -1;
			$info['title'] = trim($this->input->post('tpl_title'));
        }
		else
		{
			$apt_id = trim($_POST['appointment_id']);
		}
				
		$this->form_validation->set_rules('symptoms', 'Symptoms', 'trim|required');
		$this->form_validation->set_rules('observations', 'Observations', 'trim|required');
		$this->form_validation->set_rules('assessment', 'Assessment', 'trim|required');
		$this->form_validation->set_rules('plan', 'Plan', 'trim|required');
		
		if ($this->form_validation->run())
		{
			$info['observations']	= trim($this->input->post('observations'));
			$info['assessment']		= trim($this->input->post('assessment'));
			$info['symptoms']		= trim($this->input->post('symptoms'));
			$info['plan']			= trim($this->input->post('plan'));
			$info['patient_id']		= trim($_POST['patient_id']);
			$info['apt_id']			= trim($apt_id);
			//echo '<pre>';print_r($_POST);exit;
			$doctor_id = $this->session->userdata('login_user_id');
			if(isset($_POST['consultion_id']))
			{
				$info['updated_on'] 	= date('Y-m-d H:i:s');
				$info['updated_by'] 	= $doctor_id;
				$info['updated_by_type']= $this->session->userdata('login_type');
				$this->common_model->update_data($info,'consultion','id = "'.trim($_POST['consultion_id']).'"');	
				$data['message']		= 'Updated Successfully';
				$consultation_id = trim($_POST['consultion_id']);
				unset($info);
			}
			else
			{
				$info['added_by']		= $doctor_id;
				$info['added_by_type']	= $this->session->userdata('login_type');
				$info['added_on']		= date('Y-m-d H:i:s');
				$consultation_id = $this->common_model->insert_data($info,'consultion');
				unset($info);
			}
			
			$this->common_model->delete_data('consultion_diagnosis','consultation_id = '.$consultation_id);
			$i = 0;
			foreach($_POST['diagnosis'] as $_diagnosis)
			{
				if(trim($_diagnosis) != '')
				{
					$info['diagnosis_id']	= $_diagnosis;
					$info['consultation_id']= $consultation_id;
					$info['apt_id']		= trim($apt_id);
					$info['remarks']	= trim($_POST['remarks'][$i]);
					$info['patient_id']	= trim($_POST['patient_id']);
					$this->common_model->insert_data($info,'consultion_diagnosis');
					unset($info);
				}
				$i++;
			}
			
			$i = $sale_id = 0;
			if($apt_id != -1)
			{
				$pos_sales_suspended = $this->db->get_where('ospos_sales_suspended', array('apt_id' => $apt_id))->row();
				$this->common_model->delete_data('ospos_sales_suspended','apt_id = '.$apt_id);
			
				$info['sale_time']	= date('Y-m-d H:i:s');
				$info['customer_id']= trim($_POST['patient_id']);
				$info['employee_id']= 1;
				$info['comment']	= 'Appointment No. '.trim($apt_id);
				$info['reason']		= 'Appointment No. '.trim($apt_id);
				$info['apt_id']		= trim($apt_id);
				$sale_id = $this->common_model->insert_data($info,'ospos_sales_suspended');
				unset($info);					

				$consultation_fee = $this->db->get_where('ospos_items', array('doctor_id' => $doctor_id))->result_array();
				
				$this->common_model->delete_data('consultion_items','consultation_id = '.$consultation_id);
				
				$info['apt_id']	= trim($apt_id);
				$info['item_id']= !empty($consultation_fee) ? $consultation_fee[0]['item_id'] : 0;
				$info['days']	= '';
				$info['qty']	= '-1';
				$info['advisory']	= '';
				$info['unit_price']	= !empty($consultation_fee) ? $consultation_fee[0]['standard_cost'] : 0;
				$info['patient_id']	= trim($_POST['patient_id']);
				$info['consultation_id']	= $consultation_id;
				$this->common_model->insert_data($info,'consultion_items');
				unset($info);
				
				
				$pos_sales_suspended_id = !empty($pos_sales_suspended) ? $pos_sales_suspended->sale_id : 0;
				$this->common_model->delete_data('ospos_sales_suspended_items','sale_id = '.$pos_sales_suspended_id);

				$info['item_id']= !empty($consultation_fee) ? $consultation_fee[0]['item_id'] : 0;
				$info['sale_id']= $sale_id;
				$info['quantity_purchased']	= 1;
				$info['item_unit_price']	= !empty($consultation_fee) ? $consultation_fee[0]['standard_cost'] : 0;;
				$info['item_cost_price']	= !empty($consultation_fee) ? $consultation_fee[0]['standard_cost'] : 0;;
				$info['item_location']		= 1;
				$this->common_model->insert_data($info,'ospos_sales_suspended_items');
				unset($info);
				
				
				if(!empty($_FILES))
				{
					$f = 0;
					foreach($_FILES['file']['name'] as $file)
					{
						$sourcePath 	= $_FILES['file']['tmp_name'][$f];
						$ext			= (explode('.',$_FILES['file']['name'][$f]));
						$ext			= $ext[count($ext)-1];
						$fileName 		= preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext,'',$_FILES['file']['name'][$f])).date('ymdhis').'.'.$ext;
						
						if(in_array(strtolower($ext),array('jpg','jpeg','png')))
						{
							$targetPath 	= $_SERVER['DOCUMENT_ROOT']."/consultion_images/";
							$targetPath 	= $targetPath.$fileName;
							
							if(move_uploaded_file($sourcePath,$targetPath)) 
							{
								$info['filename'] = $fileName;
								$info['orig_filename'] = $_FILES['file']['name'][$f];
								$info['consultation_id'] = $consultation_id;
								$info['added_on'] = date('Y-m-d H:i:s');
								$this->common_model->insert_data($info,'consultion_images');
								unset($info);				
							}
						}
						$f++;						
					}
				}
			}
			
			foreach($_POST['item'] as $item)
			{
				if(trim($item) != '')
				{
					$info['apt_id']	= trim($apt_id);
					$info['item_id']= $item;
					$info['days']	= trim($_POST['days'][$i]);
					$info['qty']	= trim($_POST['qty'][$i]);
					$info['advisory']	 = trim($_POST['advisory'][$i]);
					$info['unit_price']	 = trim($_POST['unit_price'][$i]);
					$info['dosage']		 = trim($_POST['qt'][$i]);
					$info['units']		 = trim($_POST['unit'][$i]);
					$info['frequency']	 = trim($_POST['td'][$i]);
					$info['remarks']	 = trim($_POST['my_remarks'][$i]);
					$info['patient_id']	 = trim($_POST['patient_id']);
					$info['instructions']= trim($_POST['my_instructions'][$i]);
					$info['consultation_id']	= $consultation_id;
					$this->common_model->insert_data($info,'consultion_items');
					unset($info);
					
					if($apt_id != -1)
					{
						$info['item_id']= $item;
						$info['sale_id']= $sale_id;
						$info['quantity_purchased']	= trim($_POST['qty'][$i]);
						$info['item_unit_price']	= trim($_POST['unit_price'][$i]);
						$info['item_cost_price']	= trim($_POST['standard_cost'][$i]);
						$info['item_location']		= 1;
						$this->common_model->insert_data($info,'ospos_sales_suspended_items');
						unset($info);
					}
				}
				$i++;
			}
			
			if($apt_id != -1)
			{
				$info['status'] = 'visit-complete';
				$this->common_model->update_data($info,'appointment','appointment_id = "'.trim($apt_id).'"');	
			}
			$data['message']	= 'Saved Successfully';
			$data['success']	= true;
			$this->output->set_output(json_encode($data));	
		}
		else
		{
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$data['success']			= false;
			$this->output->set_output(json_encode($data));	
		}
    }
	
	function consultation_info($id = 0)
	{
		$this->load->model('common_model');
		$data['consultion_tmps'] = $this->db->get_where('consultion',array('id' => $id))->result_array();
		
		$diagnosis = $this->db->get('diagnostics')->result_array();	
		$consultion_diagnosis = $this->db->get_where('consultion_diagnosis',array('consultation_id' => $id))->result_array();
		$html = '';
		foreach($consultion_diagnosis as $consultion_diagnos)
		{
			$html .= '<tr><td width="10%"><a href="javascript:;" class="btn btn-xs btn-danger" onclick="tr_remove($(this))"><i class="entypo-minus"></i></a></td>';
			$html .= '<td width="45%"><select class="form-control" name="diagnosis[]"><option value="">Please Select</option>';
			foreach($diagnosis as $dia){
				$html .= '<option value="'.$dia['diagnostics_id'].'" '.($dia['diagnostics_id'] == $consultion_diagnos['diagnosis_id'] ? 'selected' : '').'>'.$dia['code'].' '.$dia['name'].'</option>';
			}
			$html .= '</select></td>';
			$html .= '<td width="45%"><input type="text" class="form-control" placeholder="Remarks..." value="'.$consultion_diagnos['remarks'].'" name="remarks[]"></td></tr>';
		}
		$data['consultion_diagnosis'] = $html;
		
		$items = $this->db->get_where('ospos_items',array('doctor_id' => 0))->result_array();
		$consultion_items = $this->db->get_where('consultion_items',array('consultation_id' => $id))->result_array();
		$html = '';
		foreach($consultion_items as $consultion_item)
		{
			if($consultion_item['qty'] < 0) continue;
			$html .= '<tr><td><a href="javascript:;" class="btn btn-xs btn-danger" onclick="item_remove($(this))"><i class="entypo-minus"></i></a></td>';
           	$html .= '<td><select name="item[]" onchange="get_item_info($(this));" class="form-control"><option value="">Prescribe Medicine</option>';
			$rec   = array();
			foreach($items as $item)
			{
				$html .= '<option value="'.$item['item_id'].'" '.($item['item_id'] == $consultion_item['item_id'] ? 'selected' : '').'>'.$item['name'].'</option>';
				if($item['item_id'] == $consultion_item['item_id'])
				{
					$rec = $item;
				}
			}
             
			 $html .= '</select></td><td class="qt"><input type="text" class="form-control" placeholder="Advisory..." value="'.($consultion_item['dosage']).'" name="qt[]"></td><td class="unit"><input type="text" class="form-control" placeholder="Units..." value="'.($consultion_item['units']).'" name="unit[]"></td>';
			 $html .= '<td class="td"><input type="text" class="form-control" placeholder="T/D..." value="'.($consultion_item['frequency']).'" name="td[]"></td>';
			 $html .= '<td class="days"><input type="text" class="form-control" placeholder="Days..." value="'.$consultion_item['days'].'" name="days[]"></td>';
			 $html .= '<td class="qty"><input type="text" class="form-control qty_field" onchange="total_amount($(this))" value="'.($consultion_item['qty']).'" name="qty[]"></td>';
			 $html .= '<td class="instructions"><input type="text" class="form-control" placeholder="Instructions..." value="'.($consultion_item['instructions']).'" name="my_instructions[]"></td>';
			 $html .= '<td><input type="text" class="form-control" placeholder="Advisory..." value="'.$consultion_item['advisory'].'" name="advisory[]"></td>';
			 $html .= '<td class="remarks"><input type="text" class="form-control" placeholder="Remarks..." value="'.($consultion_item['remarks']).'" name="my_remarks[]"></td>';
			 $html .= '<td class=""><input type="text" class="form-control unit_price" readonly value="'.$consultion_item['unit_price'].'" name="unit_price[]"><input type="hidden" name="standard_cost[]" class="standard_cost" value="'.(!empty($rec) ? $rec['standard_cost'] : 0).'"></td>';
			 $html .= '<td class="amount">'.($consultion_item['unit_price'] * $consultion_item['qty']).'</td></tr>';
		}
		$data['consultion_items'] = $html;
		$this->output->set_output(json_encode($data));		 
	}
	
    function appointment_bk($task = "", $appointment_id = "") 
	{
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $this->crud_model->save_appointment_info();
            $this->session->set_flashdata('message', get_phrase('appointment_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/appointment');
        }

        if ($task == "update") {
            $this->crud_model->update_appointment_info($appointment_id);
            $this->session->set_flashdata('message', get_phrase('appointment_info_updated_successfuly'));
            redirect(base_url() . 'index.php?doctor/appointment');
        }

        if ($task == "delete") {
            $this->crud_model->delete_appointment_info($appointment_id);
            redirect(base_url() . 'index.php?doctor/appointment');
        }

        $data['appointment_info'] = $this->crud_model->select_appointment_info_by_doctor_id();
        $data['page_name'] = 'manage_appointment';
        $data['page_title'] = get_phrase('appointment');
        $this->load->view('backend/index', $data);
    }

    function appointment_requested($task = "", $appointment_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "approve") {
            $this->crud_model->approve_appointment_info($appointment_id);
            $this->session->set_flashdata('message', get_phrase('appointment_info_approved'));
            redirect(base_url() . 'index.php?doctor/appointment_requested');
        }

        if ($task == "delete") {
            $this->crud_model->delete_appointment_info($appointment_id);
            redirect(base_url() . 'index.php?doctor/appointment_requested');
        }

        $data['requested_appointment_info'] = $this->crud_model->select_requested_appointment_info_by_doctor_id();
        $data['page_name'] = 'manage_requested_appointment';
        $data['page_title'] = get_phrase('requested_appointment');
        $this->load->view('backend/index', $data);
    }

    function prescription($task = "", $prescription_id = "", $menu_check = '', $patient_id = '') {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $this->crud_model->save_prescription_info();
            $this->session->set_flashdata('message', get_phrase('prescription_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/prescription');
        }

        if ($task == "update") {
            $this->crud_model->update_prescription_info($prescription_id);
            $this->session->set_flashdata('message', get_phrase('prescription_info_updated_successfuly'));
            if ($menu_check == 'from_prescription')
                redirect(base_url() . 'index.php?doctor/prescription');
            else
                redirect(base_url() . 'index.php?doctor/medication_history/' . $patient_id);
        }

        if ($task == "delete") {
            $this->crud_model->delete_prescription_info($prescription_id);
            if ($menu_check == 'from_prescription')
                redirect(base_url() . 'index.php?doctor/prescription');
            else
                redirect(base_url() . 'index.php?doctor/medication_history/' . $patient_id);
        }

        $data['prescription_info'] = $this->crud_model->select_prescription_info_by_doctor_id();
        $data['menu_check'] = 'from_prescription';
        $data['page_name'] = 'manage_prescription';
        $data['page_title'] = get_phrase('prescription');
        $this->load->view('backend/index', $data);
    }

    function diagnosis_report($task = "", $diagnosis_report_id = "") {
        if ($this->session->userdata('doctor_login') != 1) {
            $this->session->set_userdata('last_page', current_url());
            redirect(base_url(), 'refresh');
        }

        if ($task == "create") {
            $this->crud_model->save_diagnosis_report_info();
            $this->session->set_flashdata('message', get_phrase('diagnosis_report_info_saved_successfuly'));
            redirect(base_url() . 'index.php?doctor/prescription');
        }

        if ($task == "delete") {
            $this->crud_model->delete_diagnosis_report_info($diagnosis_report_id);
            $this->session->set_flashdata('message', get_phrase('diagnosis_report_info_deleted_successfuly'));
            redirect(base_url() . 'index.php?doctor/prescription');
        }
    }

    /* private messaging */

    function message($param1 = 'message_home', $param2 = '', $param3 = '') {
        if ($this->session->userdata('doctor_login') != 1)
            redirect(base_url(), 'refresh');

        if ($param1 == 'send_new') {
            $message_thread_code = $this->crud_model->send_new_private_message();
            $this->session->set_flashdata('message', get_phrase('message_sent!'));
            redirect(base_url() . 'index.php?doctor/message/message_read/' . $message_thread_code, 'refresh');
        }

        if ($param1 == 'send_reply') {
            $this->crud_model->send_reply_message($param2);  //$param2 = message_thread_code
            $this->session->set_flashdata('message', get_phrase('message_sent!'));
            redirect(base_url() . 'index.php?doctor/message/message_read/' . $param2, 'refresh');
        }

        if ($param1 == 'message_read') {
            $page_data['current_message_thread_code'] = $param2;  // $param2 = message_thread_code
            $this->crud_model->mark_thread_messages_read($param2);
        }

        $page_data['message_inner_page_name'] = $param1;
        $page_data['page_name'] = 'message';
        $page_data['page_title'] = get_phrase('private_messaging');
        $this->load->view('backend/index', $page_data);
    }

}
