<?php

namespace App\Exports;

use App\Repositories\CustomFieldsRepository;

use App\Repositories\LeadRepository;
// use Maatwebsite\Excel\Concerns\FromCollection;

use Maatwebsite\Excel\Concerns\WithCustomChunkSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithTitle;

class LeadsExport implements FromQuery , WithCustomChunkSize ,WithTitle, WithHeadings, WithMapping
{

    /**
     * The expense repo repository
     */
    protected $leadesepo;

    /**
     * The custom repo repository
     */
    protected $customrepo;

    public function __construct(LeadRepository $leadesepo, CustomFieldsRepository $customrepo)
    {

        $this->leadesepo = $leadesepo;
        $this->customrepo = $customrepo;
    }

    //get the expenses
    public function query()
    {
        //search
        $leads = $this->leadesepo->search('', ['no_pagination' => true] , false );
        // echo "<pre>"; var_dump($expenses); die();

        //return
        return $leads;
    }

    public function title(): string  { 
        return 'Leads';
    }
    public function chunkSize(): int {
        return 1000;
    }

    //map the columns that we want
    public function map($leads): array
    {
        $map = [];

        //standard fields - loop thorugh all post data
        // if (is_array(request('standard_field'))) {
        //     foreach (request('standard_field') as $key => $value) {
        //         if ($value == 'on') {
        //             switch ($key) {
        //             case 'lead_id':
        //                 $map[] = runtimeDate($leads->lead_id);
        //                 break;
        //             case 'expenses_user':
        //                 $map[] = runtimeUser($leads->first_name, $leads->last_name);
        //                 break;
        //             case 'lead_created':
        //                 $map[] = $leads->lead_created;
        //                 break;
        //             case 'expense_amount':
        //                 $map[] = runtimeMoneyFormat($leads->expense_amount);
        //                 break;
        //             case 'expenses_client':
        //                 $map[] = $leads->client_company_name;
        //                 break;
        //             case 'expenses_client_id':
        //                 $map[] = $leads->client_id;
        //                 break;
        //             case 'expenses_project':
        //                 $map[] = $leads->project_title;
        //                 break;
        //             case 'expenses_project_id':
        //                 $map[] = $leads->project_id;
        //                 break;
        //             case 'expenses_invoiced':
        //                 $map[] = ($leads->expense_billing_status == 'invoiced') ? __('lang.yes') : __('lang.no');
        //                 break;
        //             case 'expenses_invoice_id':
        //                 $map[] = runtimeInvoiceIdFormat($leads->expense_billable_invoiceid);
        //                 break;
        //             default:
        //                 $map[] = $leads->{$key};
        //                 break;
        //             }
        //         }
        //     }
        // }
        /*$map[] = runtimeDate($leads->lead_id);
        $map[] = runtimeUser($leads->first_name, $leads->last_name);
        $map[] = $leads->lead_created;
        $map[] = runtimeMoneyFormat($leads->expense_amount);
        $map[] = $leads->client_company_name;
        $map[] = $leads->client_id;
        $map[] = $leads->project_title;
        $map[] = $leads->project_id;
        $map[] = ($leads->expense_billing_status == 'invoiced') ? __('lang.yes') : __('lang.no');
        $map[] = runtimeInvoiceIdFormat($leads->expense_billable_invoiceid); */
        // $map[] = $leads->{$key};

        //custom fields - loop thorugh all post data
        // if (is_array(request('custom_field'))) {
        //     foreach (request('custom_field') as $key => $value) {
        //         if ($value == 'on') {
        //             if ($field = \App\Models\CustomField::Where('customfields_name', $key)->first()) {
        //                 switch ($field->customfields_datatype) {
        //                 case 'date':
        //                     $map[] = runtimeDate($leads->{$key});
        //                     break;
        //                 case 'checkbox':
        //                     $map[] = ($leads->{$key} == 'on') ? __('lang.checked_custom_fields') : '---';
        //                     break;
        //                 default:
        //                     $map[] = $leads->{$key};
        //                     break;
        //                 }
        //             } else {
        //                 $map[] = '';
        //             }
        //         }
        //     }
        // }

        $assignedNames='';
        $map[] = $leads->lead_id;
        $map[] = $leads->full_name ? $leads->full_name : '---';
        $map[] = $leads->lead_title ? $leads->lead_title : '---';
        $map[] = $leads->lead_created ? $leads->lead_created : '---';
        foreach ($leads->assigned as  $assigned) {
            $assignedNames.= $assigned->first_name . ' ' . $assigned->last_name.' ';
        }
        $map[]=$assignedNames;
        $map[] = $leads->leadstatus ? $leads->leadstatus->leadstatus_title : '---';
        $map[] = $leads->lead_company_name ? $leads->lead_company_name : '---';
        $map[] = $leads->lead_phone ? $leads->lead_phone : '---';
        $map[] = $leads->lead_state ? $leads->lead_state : '---';
        $map[] = $leads->lead_last_contacted ? $leads->lead_last_contacted : '---';

        return $map;
    }

    //create heading
    public function headings(): array
    {

        //headings
        $heading = [];
        $heading = ['id', 'Contact', 'Title', 'Created', 'Assigned', 'Status', 'Company', 'Phone', 'State', 'Last Contact'];

        //lang - standard fields (map each field here)
        // $standard_lang = [
        //     'expense_date' => __('lang.date'),
        //     'expenses_user' => __('lang.user'),
        //     'expense_description' => __('lang.description'),
        //     'expense_amount' => __('lang.amount'),
        //     'expenses_client' => __('lang.client'),
        //     'expenses_client_id' => __('lang.client_id'),
        //     'expenses_project' => __('lang.project'),
        //     'expenses_project_id' => __('lang.project_id'),
        //     'expenses_invoiced' => __('lang.invoiced'),
        //     'expenses_invoice_id' => __('lang.invoice_id'),
        // ];

        // //lang - custom fields (i.e. field titles)
        // $custom_lang = $this->customrepo->fieldTitles();

        // //standard fields - loop thorugh all post data
        // if (is_array(request('standard_field'))) {
        //     foreach (request('standard_field') as $key => $value) {
        //         if ($value == 'on') {
        //             $heading[] = (isset($standard_lang[$key])) ? $standard_lang[$key] : $key;
        //         }
        //     }
        // }

        // //custom fields - loop thorugh all post data
        // if (is_array(request('custom_field'))) {
        //     foreach (request('custom_field') as $key => $value) {
        //         if ($value == 'on') {
        //             $heading[] = (isset($custom_lang[$key])) ? $custom_lang[$key] : $key;
        //         }
        //     }
        // }

        //return full headings
        return $heading;
    }
}
