@extends('layout.wrapper') 
@section('content')
<!-- main content -->
<div class="container-fluid">

    <!--page heading-->
    <div class="row page-titles">
        <div class="col-md-12 col-lg-5 align-self-center list-pages-crumbs" id="breadcrumbs">
            <h3 class="text-themecolor">Leads</h3>
            <!--crumbs-->
            <ol class="breadcrumb">
                <li class="breadcrumb-item">App</li>
                <li class="breadcrumb-item active active-bread-crumb">Leads Logs</li>
            </ol>
            <!--crumbs-->
        </div>
    </div>
    <!--page heading-->

    <!-- page content -->
    <div class="row">
        <div class="col-12">
            <!-- Bootstrap table -->
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="thead-dark">
                        <tr>
                            <th>Action</th>
                            <th>Lead ID</th>
                            <th>Status</th>
                            <th>User</th>
                            <th>Timestamp</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($logs as $log)
                            <tr>
                                <td>{{ $log->msg }}</td>
                                <td>{{ $log->lead_id }}</td>
                                <td>{{ $log->lead->leadstatus->leadstatus_title }}</td>
                                <td>{{ $log->user->first_name }} {{ $log->user->last_name }}</td>
                                <td>{{ $log->created_at->format('Y-m-d H:i:s') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!--page content -->

</div>
@endsection
