<div class="row">
    @include('pages.home.admin.widgets.first-row.status-count')

    <!--PAYMENTS TODAY-->
    @include('pages.home.admin.widgets.first-row.payments-today')

    <!--PAYMENTS THIS MONTH-->
    @include('pages.home.admin.widgets.first-row.payments-this-month')

    <!--INVOICES DUE-->
    @include('pages.home.admin.widgets.first-row.invoices-due')

    <!--INVOICES OVERDUE-->
    @include('pages.home.admin.widgets.first-row.invoices-overdue')

    <div class="col-md-12 mt-2 mb-2">

        <select id="userSelect" class="form-control col-md-4 float-right mt-2 mb-2">
            <option value="">Select User</option>
            @foreach ($payload['users'] as $user)
                <option value="{{ $user->id }}">{{ $user->first_name }} {{ $user->last_name }}</option>
            @endforeach
        </select>
        
    </div>
    
    

    <div id="leadsStatusContainer" class="row mt-2 mb-2">
        <!-- Leads status cards will load here -->
    </div>
    
    <script>
    
    $(document).ready(function () {
        $('#userSelect').change(function () {
            var userId = $(this).val();
            
            $.ajax({
        url: "{{ route('leads.user.wise') }}",
        type: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            user_id: userId
        },
        success: function (response) {
            if (response.success) {
                let leadsStatusHtml = '';
                
                // Loop through the data
                $.each(response.data, function (index, item) {
                    leadsStatusHtml += `
                       <div class="col-lg-3 col-md-6 click-url cursor-pointer"
                        data-url="{{ url('leads') }}">
                        <div class="card">
                            <div class="card-body p-l-15 p-r-15">
                                <div class="d-flex p-10 no-block">
                                    <span class="align-slef-center">
                                       <h2 class="text-muted m-b-0">${item.status_count}</h2>
                                        <h6 class="m-b-0">${item.leadstatus_title}</h6>
                                    </span>
                                    <div class="align-self-center display-6 ml-auto"><i class="text-success icon-Credit-Card2"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-success w-100 h-px-3" role="progressbar" aria-valuenow="100" aria-valuemin="0"
                                    aria-valuemax="100"></div>
                            </div>
                        </div>
                    </div>
                    `;
                });
    
                $('#leadsStatusContainer').html(leadsStatusHtml);
            }
        },
        error: function (xhr, status, error) {
            console.error(error);
        }
        });
    
    
        });
    });
    </script>

</div>