<?php
	$CI = get_instance();
	$CI->load->database();
	$CI->load->dbforge();

	// create folders on uploads
	mkdir('./uploads/frontend', 0777);
	mkdir('./uploads/frontend/gallery_cover', 0777);
	mkdir('./uploads/frontend/gallery_images', 0777);
	mkdir('./uploads/frontend/noticeboard', 0777);
	mkdir('./uploads/frontend/slider', 0777);

	// copy the install.sql and placeholder.png
	copy('./update_pack/install.sql', './uploads/install.sql');
	copy('./update_pack/placeholder.png', './uploads/placeholder.png');

	// add purchase code on settings
    $data = array(
    	'type' 		  => 'purchase_code',
    	'description' => ''
    );
    $CI->db->insert('settings', $data);

		// add fields on noticeboard table
		$notice_fields = array(
			'show_on_website' => array(
				'type' => 'INT',
				'default' => 0,
			),
			'image' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
		);
		$CI->dbforge->add_column('noticeboard', $notice_fields);

		// add fields on teacher table
		$teacher_fields = array(
			'designation' => array(
				'type' => 'VARCHAR',
				'constraint' => '255',
				'null' => TRUE,
			),
			'social_links' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
			'show_on_website' => array(
				'type' => 'INT',
				'default' => 0,
			),
		);
		$CI->dbforge->add_column('teacher', $teacher_fields);

		// create frontend_events table
		$events_fields = array(
			'frontend_events_id' => array(
				'type' => 'INT',
				'auto_increment' => TRUE,
			),
			'title' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
			'timestamp' => array(
				'type' => 'INT',
				'null' => TRUE,
			),
			'status' => array(
				'type' => 'INT',
				'default' => 0,
			),
		);
		$CI->dbforge->add_key('frontend_events_id', TRUE);
		$CI->dbforge->add_field($events_fields);
		$CI->dbforge->create_table('frontend_events');

		// create frontend_gallery table
		$gallery_fields = array(
			'frontend_gallery_id' => array(
				'type' => 'INT',
				'auto_increment' => TRUE,
			),
			'title' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
			'description' => array(
				'type' => 'LONGTEXT',
				'null' => TRUE,
			),
			'date_added' => array(
				'type' => 'INT',
				'null' => TRUE,
			),
			'image' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
			'show_on_website' => array(
				'type' => 'INT',
				'default' => 0,
			),
		);
		$CI->dbforge->add_key('frontend_gallery_id', TRUE);
		$CI->dbforge->add_field($gallery_fields);
		$CI->dbforge->create_table('frontend_gallery');

		// create frontend_gallery_iamge table
		$gallery_image_fields = array(
			'frontend_gallery_iamge_id' => array(
				'type' => 'INT',
				'auto_increment' => TRUE,
			),
			'frontend_gallery_id' => array(
				'type' => 'INT',
				'null' => TRUE,
			),
			'title' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
			'image' => array(
				'type' => 'TEXT',
				'null' => TRUE,
			),
		);
		$CI->dbforge->add_key('frontend_gallery_iamge_id', TRUE);
		$CI->dbforge->add_field($gallery_image_fields);
		$CI->dbforge->create_table('frontend_gallery_image');

		// create frontend_general_settings table
		$settings_fields = array(
			'frontend_general_settings_id' => array(
				'type' => 'INT',
				'auto_increment' => TRUE,
			),
			'type' => array(
				'type' => 'VARCHAR',
				'constraint' => '255',
				'null' => TRUE,
			),
			'description' => array(
				'type' => 'LONGTEXT',
				'null' => TRUE,
			),
		);
		$CI->dbforge->add_key('frontend_general_settings_id', TRUE);
		$CI->dbforge->add_field($settings_fields);
		$CI->dbforge->create_table('frontend_general_settings');

		// insert data into frontend_general_settings table
		$types = ['about_us', 'terms_conditions', 'privacy_policy', 'social_links', 'school_title', 'school_logo', 'school_location',
		'address', 'phone', 'email', 'fax', 'header_logo', 'footer_logo', 'copyright_text', 'about_us_iamge', 'slider_images', 'theme',
		'homepage_note_title', 'homepage_note_description','recaptcha_site_key'];
		$descriptions = ['','','','[{"facebook":"http://facebook.com","twitter":"http://twitter.com","linkedin":"http://linkedin.com","google":"http://google.com","youtube":"http://youtube.com","instagram":"http://instagram.com"}]',
		'','','51.7548164,-1.2565555','','','','','','','','','[{"title":"We rock the big stage","description":"There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected ","image":"1.jpg"},{"title":"Making this the first true generator on the Internet","description":"There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected ","image":"4.jpg"},{"title":"There are many variations of passages of Lorem Ipsum","description":"There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected ","image":"3.jpg"}]',
		'default','','',''];
		for ($i=0; $i < count($types); $i++) {
			$info = array(
				'type' => $types[$i],
				'description' => $descriptions[$i]
			);
			$CI->db->insert('frontend_general_settings', $info);
		}
?>
