<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class User_model extends CI_Model  
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
	}
	
	public function listFields($tableName=''){  
		return $this->db->list_fields($tableName); 
	}
	
	public function getSingleRecord($tableName,$column,$where) // check column data if alrady exists
	{
		$this->db->select($column);
		$this->db->where($where);//$where = "name='Joe' AND status='boss' OR status='active'";
		$query = $this->db->get($tableName);
		return $query->row();
	}
	
	public function getTableData($table, $cols, $where = '', $orderby = '', $direction = 'DESC', $joinTable = '', $joinValues = '', $join_type = '',$group_by = '', $limit = 0, $offset = 0)
	{
		$this->db->select($cols, false);
		
		if($joinTable != '' && $joinValues != '')
		{
			if($join_type == '')
			{
				$this->db->join($joinTable,$joinValues);
			}
			else
			{
				$this->db->join($joinTable,$joinValues,$join_type);
			}
		}
		
		if($orderby != '')
		{
			$this->db->order_by($orderby, $direction); 
		}
		
		if($limit != 0 && $offset == 0)
		{
			$this->db->limit($limit);
			if($group_by != '')
			{
				$this->db->group_by($group_by); 
			}
		}
		else if($limit != 0 && $offset != 0)
		{
			$this->db->limit($limit, $offset);
			if($group_by != '')
			{
				$this->db->group_by($group_by); 
			}
		}
		
		if($where!='')
		{
			$this->db->where($where);
		}
		
		$query=$this->db->get($table);	
		return $query->result();
	}
	
	public function insert_data($info,$table) // add single admin info 
	{
		if ($this->db->insert($table,$info))
		{
			return $this->db->insert_id(); //insertion success
		}
		else
		{
			return 0; // fail
		}		
	}
	
	public function update_data($info,$table,$where) // update single user info 
	{
		$this->db->trans_start();
		$this->db->where($where);//$where = "name='Joe' AND status='boss' OR status='active'";
		$this->db->update($table,$info);		
		$this->db->trans_complete(); 
		
		if ($this->db->trans_status() === FALSE)
		{
			return 0; //insertion failed
		}
		else
		{
			return 1; // success
		}		
	}
	
	public function delete($tablename,$col_name,$id)
	{
		$this->db->where($col_name,$id);
		if($this->db->delete($tablename))
		{
			//echo $this->db->last_query();exit;
			return true;
		}
		
		return false; 
	}
	
	public function exec_query($qry)
	{
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}
	
	public function getSubjects($where)
	{
		$qry = "SELECT subject.*, teacher.name as teacher_name,class.name as class_name
				FROM `subject`
				JOIN `teacher` ON `teacher`.`teacher_id` = `subject`.`teacher_id`
				JOIN `class` ON `class`.`class_id` = `subject`.`class_id`
				WHERE ".$where."
				ORDER BY subject.`class_id` DESC";
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}
	
	public function book_request($where)
	{
		$qry = 'SELECT book_request.book_request_id, book_request.student_id, book.`name` book_name, book.book_id,
					student.`name` student_name,from_unixtime(issue_start_date, "%M %d, %Y") issue_start_date,
					from_unixtime(issue_end_date, "%M %d, %Y") issue_end_date,
					CASE WHEN book_request.`status` = 1 THEN "Issued" WHEN book_request.`status` = 0 THEN "Pending" ELSE "Rejected" END `status`
					FROM `book_request`
					JOIN book ON book.book_id = book_request.book_id
					JOIN student ON student.student_id = book_request.student_id
					WHERE '.$where.'
					ORDER BY book_request_id DESC';
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}
	
	public function students($where)
	{
		$qry = 'SELECT enroll.*, class.`name` as class_name,section.`name` AS section_name, student.`name` AS student_name, 
				student.email, student.address, student.phone 
				FROM `enroll`
				JOIN student ON student.student_id = enroll.student_id
				JOIN class ON class.class_id = enroll.class_id
				JOIN section ON section.section_id = enroll.section_id
				WHERE '.$where.'
				ORDER BY enroll.enroll_id DESC';
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}
	
	public function student_profile($where)
	{
		$qry = 'SELECT student.`name`,student.email, student.phone, student.address, student.sex AS gender, student.birthday,
					parent.`name` AS parent_name, parent.email AS parent_email, parent.address as parent_address, parent.profession,
					dormitory.`name` as dormitory_namem, transport.route_name, transport.number_of_vehicle, transport.route_fare
				FROM `student`
				JOIN parent ON parent.parent_id = student.parent_id
				LEFT JOIN dormitory ON dormitory.dormitory_id = student.dormitory_id
				LEFT JOIN transport ON transport.transport_id = student.transport_id
				WHERE '.$where;
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}	
	
	public function attendance($where)
	{
		$qry = 'SELECT attendance.*,from_unixtime(attendance.`timestamp`, "%M %d, %Y") AS date,
					student.`name` AS student_name, section.`name` AS section_name, class.`name` AS class_name
				FROM `attendance`
				JOIN student ON attendance.student_id = student.student_id
				JOIN class ON class.class_id = attendance.class_id
				JOIN section ON section.section_id = attendance.section_id
				WHERE '.$where.' ORDER BY attendance.attendance_id ASC';
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}		
	
	public function section_attendance($where)
	{
		$qry = "SELECT attendance.*, CASE WHEN `status` = 1 THEN 'Present' WHEN `status` = 2 THEN 'Absent' ELSE '--' END AS att_status,
					student.`name` AS student_name,enroll.roll, from_unixtime(attendance.`timestamp`, '%M %d, %Y') att_date
					FROM `attendance`
					JOIN student ON student.student_id = attendance.student_id
					JOIN enroll ON enroll.student_id = student.student_id
					WHERE ".$where."
					GROUP BY attendance_id
					ORDER BY student.`name` ASC";
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}	
	
	public function question_papers($where)
	{
		$qry = "SELECT question_paper.*,class.`name` as class_name,teacher.`name` as teacher_name,exam.`name` as exam_name
					FROM `question_paper`
					JOIN class ON class.class_id = question_paper.class_id
					JOIN exam ON exam.exam_id = question_paper.exam_id
					JOIN teacher ON teacher.teacher_id = question_paper.teacher_id
					WHERE ".$where."
					ORDER BY question_paper_id DESC";
		$query 	= $this->db->query ( $qry );
		return $query->result ();
	}	
}
?>