<?php
require $_SERVER['DOCUMENT_ROOT'].'/application/libraries/REST_Controller.php';
class Api extends REST_Controller 
{
	public $data;
	private $offset		= '0';
	private $limit		= '20';
	private $hrc		= 'HTTP_response_code';
	public function __construct()
	{
		parent::__construct();		
		$this->load->model('user_model');	
		$this->load->model('crud_model');	
		$this->load->helper('common');	
		$this->load->library('form_validation');
		//access();
		$this->data['data']	= (object) array();
	}
	
	public function signin_post()
	{
		$this->form_validation->set_rules('email', 'email', 'trim|required');
		$this->form_validation->set_rules('password', 'password', 'trim|required');
		$this->form_validation->set_rules('user_type', 'user type', 'trim|required');
		//admin, teacher, student, parent, librarian, accountant
		if ($this->form_validation->run())
		{	
			$user = $this->user_model->getTableData(trim($this->post('user_type')), '*', 'email = "'.trim($this->post('email')).'" AND password = "'.sha1(trim($this->post ( 'password' ))).'"');
			if(count($user) == 1)
			{
				$index_id	= trim($this->post('user_type')).'_id';
				$user[0]->user_type		= trim($this->post('user_type'));
				$user[0]->photo			= base_url().'uploads/'.$user[0]->user_type.'_image/'.$user[0]->$index_id.'.jpg';
				$this->data['data']		= $user[0];
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Logged In Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['success']	= FALSE;
				$this->data['message']	= 'Invalid email or password!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function teacher_list_post()
	{	
		$where = '';
		if(isset($_POST['teacher_name']) && trim($_POST['teacher_name']) != '')
		{
			$where = ' `name` LIKE "%'.trim($_POST['teacher_name']).'%"';
		}		
		$teachers = $this->user_model->getTableData('teacher', '*', $where, 'teacher_id', 'DESC');
		if(!empty($teachers))
		{
			foreach($teachers as $teacher)
			{
				if (file_exists('uploads/teacher_image/'.$teacher->teacher_id.'.jpg'))
				{
					$teacher->image_url = base_url().'uploads/teacher_image/'.$teacher->teacher_id.'.jpg';
				}else{
					$teacher->image_url = base_url().'uploads/user.jpg';
				}
			}
		}
		if(count($teachers) > 0)
		{
			$this->data['data']		= $teachers;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{
			$this->data['data']		= array();
			$this->data['data'][]	= (object) array();
			$this->data['success']	= FALSE;
			$this->data['message']	= 'No records found!!!';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
	
		$this->set_response($this->data);
	}
	
	public function teacher_details_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$teachers = $this->user_model->getTableData('teacher', '*', 'teacher_id = '.trim($this->post('teacher_id')), 'teacher_id', 'DESC');
			if(!empty($teachers))
			{
				foreach($teachers as $teacher)
				{
					if (file_exists('uploads/teacher_image/'.$teacher->teacher_id.'.jpg'))
					{
						$teacher->image_url = base_url().'uploads/teacher_image/'.$teacher->teacher_id.'.jpg';
					}else{
						$teacher->image_url = base_url().'uploads/user.jpg';
					}
				}
			}
			if(count($teachers) > 0)
			{
				$this->data['data']		= $teachers[0];
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function subject_list_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{			
			$running_yr	= $this->user_model->getTableData('settings', 'description', 'type = "running_year"');
			$running_yr	= (!empty($running_yr)) ? $running_yr[0]->description : '0';
			
			$_where 	= 'student_id = '.trim($this->post('student_id')).' AND year = "'.$running_yr.'"';
			$std_class	= $this->user_model->getTableData('enroll', 'class_id', $_where);
			$class_id	= (!empty($std_class)) ? $std_class[0]->class_id : 0;
			
			$where  = 'subject.class_id = "'.$class_id.'"';
			$where .= ' AND year = "'.trim($running_yr).'"';
			if(isset($_POST['subject_name']) && trim($_POST['subject_name']) != '')
			{
				$where .= ' AND `subject`.`name` LIKE "%'.trim($_POST['subject_name']).'%"';
			}
			$subject = $this->user_model->getSubjects($where);
			//$this->last_query(); 
			if(count($subject) > 0)
			{
				$this->data['data']		= $subject;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Records Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No records found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function study_material_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{			
			$running_yr	= $this->user_model->getTableData('settings', 'description', 'type = "running_year"');
			$running_yr	= (!empty($running_yr)) ? $running_yr[0]->description : '0';
			
			$_where 	= 'student_id = '.trim($this->post('student_id')).' AND year = "'.$running_yr.'"';
        	$std_class	= $this->user_model->getTableData('enroll', 'class_id', $_where);
			$class_id	= (!empty($std_class)) ? $std_class[0]->class_id : 0;
			$where		= 'document.class_id = "'.$class_id.'"';
			if(isset($_POST['subject_name']) && trim($_POST['subject_name']) != '')
			{
				$where .= ' AND `subject`.`name` LIKE "%'.trim($_POST['subject_name']).'%"';
			}
			$qry = "SELECT document.*, class.name as class_name,subject.name as subject_name
						FROM `document`
						JOIN `subject` ON `subject`.`subject_id` = `document`.`subject_id`
						JOIN `class` ON `class`.`class_id` = `document`.`class_id`
						WHERE ".$where."
						ORDER BY document.`timestamp` DESC";
			$study_material	= $this->user_model->exec_query($qry);
			if(count($study_material) > 0)
			{
				$i = 0;
				foreach($study_material as $std_material)
				{
					$study_material[$i]->description	= html_entity_decode(preg_replace('/\s\s+/','',strip_tags($std_material->description)));
					$study_material[$i]->file_url		= base_url().'uploads/document/'.$std_material->file_name;
					$study_material[$i]->file_name		= $std_material->file_name;
					$i++;
				}
				$this->data['data']		= $study_material;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Records Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No records found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function teacher_study_material_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim|required');
		if ($this->form_validation->run())
		{			
			$running_yr	= $this->user_model->getTableData('settings', 'description', 'type = "running_year"');
			$running_yr	= (!empty($running_yr)) ? $running_yr[0]->description : '0';
			
			$qry = "SELECT document.*, class.name as class_name,subject.name as subject_name
						FROM `document`
						JOIN `subject` ON `subject`.`subject_id` = `document`.`subject_id`
						JOIN `class` ON `class`.`class_id` = `document`.`class_id`
						ORDER BY document.`timestamp` DESC";
			$study_material	= $this->user_model->exec_query($qry);
			if(count($study_material) > 0)
			{
				$i = 0;
				foreach($study_material as $std_material)
				{
					$study_material[$i]->description	= html_entity_decode(preg_replace('/\s\s+/','',strip_tags($std_material->description)));
					$study_material[$i]->file_url		= base_url().'uploads/document/'.$std_material->file_name;
					$study_material[$i]->file_name		= $std_material->file_name;
					$i++;
				}
				$this->data['data']		= $study_material;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Records Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No records found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function academic_syllabus_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['class_id'] = $this->db->get_where('enroll', array('student_id' => trim($this->post('student_id')), 'year' => $this->data['year']))->row();
			$this->data['class_id']	= (!empty($this->data['class_id'])) ? $this->data['class_id']->class_id : '0';
			$where					= 'acs.class_id = '.$this->data['class_id'].' AND acs.year = "'.$this->data['year'].'"';
			if(isset($_POST['subject_name']) && trim($_POST['subject_name']) != '')
			{
				$where .= ' AND `subject`.`name` LIKE "%'.trim($_POST['subject_name']).'%"';
			}
			$this->data['data'] 	= $this->user_model->getTableData('academic_syllabus AS acs','acs.*,subject.name as subject_name', $where, 'academic_syllabus_id', 'DESC', 'subject', 'subject.subject_id = acs.subject_id');
			if(!empty($this->data['data']))
			{
				$i = 0;
				foreach($this->data['data'] as $rec)
				{
					$this->data['data'][$i]->file_url	= base_url().'uploads/syllabus/'.$rec->file_name;
					$this->data['data'][$i]->file_name	= $rec->file_name;
					$i++;
				}
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
			}
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function student_marksheet_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{			
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['class_id']	= $this->db->get_where('enroll' , array('student_id' => trim($this->post('student_id')), 'year' => $this->data['year']))->row();
			$this->data['class_id']	= !empty($this->data['class_id']) ? $this->data['class_id']->class_id : 0;
			
        	$this->data['student_name']	= $this->db->get_where('student' , array('student_id' => trim($this->post('student_id'))))->row();
        	$this->data['student_name']	= !empty($this->data['student_name']) ? $this->data['student_name']->name : '';
			
			$this->data['class_name']  	= $this->db->get_where('class' , array('class_id' => $this->data['class_id']))->row();
        	$this->data['class_name']	= !empty($this->data['class_name']) ? $this->data['class_name']->name : '';
			
			$total_grade_point = 0;
			$total_marks = 0;
			$info	= array();
			$exams	= $this->db->get_where('exam', array('year' => $this->data['year']))->result_array();
			$i = 0;
			foreach ($exams as $row2)
			{
				$i = 0;
				/***/
				$total_marks 		= 0;
				$sum_total_marks 	= 0;
				$total_grade_point 	= 0;
				$subjects = $this->db->get_where('subject', array('class_id' => $this->data['class_id'], 'year' => $this->data['year']))->result();
				foreach ($subjects as $row3)
				{
					$row3 = (array) $row3;
					$_where	= 'exam_id = '.$row2['exam_id'].' AND class_id = '.$this->data['class_id'].' AND subject_id = '.$row3['subject_id'];
					$highest_mark 		= $this->user_model->getTableData('mark','MAX(mark_obtained) as highest_mark', $_where);
					
					$om_where  = 'subject_id = '.$row3['subject_id'].' AND exam_id = '.$row2['exam_id'].' AND class_id = '.$this->data['class_id'];
                    $om_where .= ' AND student_id = '.trim($this->post('student_id')).' AND year = "'.$this->data['year'].'"';
					
					$marks 	   = $this->user_model->getTableData('mark', '*', $om_where, 'exam_id', 'DESC');
					if (!empty($marks)) 
					{
						foreach ($marks as $row4) 
						{
							$row4 = (array) $row4;
							if ($row4['mark_obtained'] >= 0 || trim($row4['mark_obtained']) != '') 
							{
								$grade 	= $this->crud_model->get_grade($row4['mark_obtained']);
								$total_grade_point += $grade['grade_point'];
							}
							
							$info[$i]['mark_obtained']	= $row4['mark_obtained'];
							$info[$i]['grade_name']		= $grade['name'];
							$info[$i]['highest_mark']	= !empty($highest_mark) ? $highest_mark[0]->highest_mark : 0;
							$info[$i]['mark_total']		= $row4['mark_total'];
							$info[$i]['comment']		= $row4['comment'];
							$info[$i]['subject_name'] 	= $row3['name'];
							$info[$i]['exam_name'] 		= $row2['name'];
							$total_marks += $row4['mark_obtained'];
							$i++;
						}
					}
				}
			}
			
			
			//$this->db->where('class_id' , $this->data['class_id']);
			//$this->db->where('year' , $this->data['year']);
			//$this->db->from('subject');
			$number_of_subjects = isset($subjects) ? count($subjects) : 0 ;//$this->db->count_all_results();
			$avg_grade_point 	= $number_of_subjects != 0 ? ($total_grade_point / $number_of_subjects) : 0;
									
			$this->data['data']			= $info;
			$this->data['success']		= TRUE;
			$this->data['total_marks']	= $total_marks;
			$this->data['mark_url']		= base_url().'marks_sheet/marks-sheet-'.trim($this->post('student_id')).".pdf";
			$this->data['avg_grade_point']	= round($avg_grade_point,2);
			
			/** pdf create**/
			$this->load->library('classes/Html2pdf');
			$file_name 	= "marks-sheet-".trim($this->post('student_id')).".pdf";
			$pdf_path	= 'marks_sheet/'.$file_name;
			$pdf_html 	= $this->load->view('marksheet_print', $this->data, true);
			//echo $pdf_html;exit;
			$html2pdf 	= new HTML2PDF('P', 'A4', 'en');
			$html2pdf->writeHTML("<style></style>".$pdf_html);
	
			$html2pdf->Output($pdf_path,'F');
			/** pdf create ends **/
			
			if(empty($info))
			{
				$this->data['data'][]	= (object) array();
			}
			$this->data['message']		= 'Records Fetched Successfully';
			$this->data[$this->hrc]		= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function class_routine_days_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		$this->data['data']	= (array) $this->data['data'];
		if ($this->form_validation->run())
		{
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['class_id']	= $this->db->get_where('enroll' , array('student_id' => trim($this->post('student_id')),'year' => $this->data['year']))->row();		
			$this->data['class_id']	= (!empty($this->data['class_id'])) ? $this->data['class_id']->class_id : '0';
			
			$this->data['section']	= $this->db->get_where('enroll' , array('student_id' => trim($this->post('student_id')), 'class_id' => $this->data['class_id'], 'year' => $this->data['year']))->row();
			$this->data['section']	= (!empty($this->data['section'])) ? $this->data['section']->section_id : '0';
			
			$where  = 'class_routine.class_id = '.trim($this->data['class_id']).'';
			$where .= ' AND class_routine.year = "'.trim($this->data['year']).'"';
			$where .= ' AND class_routine.section_id = "'.trim($this->data['section']).'"';				
			$routines = $this->user_model->getTableData('class_routine', 'DISTINCT `day`,', $where, 'time_start', 'ASC');
			$idx = 0;
			foreach($routines as $rec)
			{
				$this->data['data'][$idx]['day_name'] 	= $rec->day;
				$this->data['data'][$idx]['class_id'] 	= $this->data['class_id'];
				$this->data['data'][$idx]['section_id'] = $this->data['section'];
				$idx++;				
			}
			
			unset($this->data['class_id']);
			unset($this->data['section']);
			if(empty($this->data['data']))
			{
				$this->data['data'][]	= (object) array();
			}
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function class_routine_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		$this->form_validation->set_rules('day', 'Day Name', 'trim|required');
		$this->data['data']	= (array) $this->data['data'];
		if ($this->form_validation->run())
		{
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['class_id']	= $this->db->get_where('enroll' , array('student_id' => trim($this->post('student_id')),'year' => $this->data['year']))->row();
			if(empty($this->data['class_id']))
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success'] 	= FALSE;
				$this->data['message']	= 'Post values are not properly recieved.';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['class_id']	= $this->data['class_id']->class_id;
				$this->data['section']	= $this->db->get_where('enroll' , array('student_id' => trim($this->post('student_id')), 'class_id' => $this->data['class_id'], 'year' => $this->data['year']))->row();
				if(empty($this->data['section']))
				{
					$this->data['success'] 	= FALSE;
					$this->data['message']	= 'Post values are not properly recieved.';
					$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
				}
				else
				{
					$this->data['section']	= $this->data['section']->section_id;
					$this->data['day']		= trim($this->post('day'));
					
					for($d = 1; $d <= 1; $d++)
					{
						$where  = 'class_routine.class_id = '.trim($this->data['class_id']).'';
						$where .= ' AND class_routine.year = "'.trim($this->data['year']).'"';
						$where .= ' AND class_routine.day = "'.trim($this->data['day']).'"';
						$where .= ' AND class_routine.section_id = "'.trim($this->data['section']).'"';
						
						$routines = $this->user_model->getTableData('class_routine', 'class_routine.*, `subject`.`name` as subject_name,', $where, 'time_start', 'ASC', 'subject', 'subject.subject_id = class_routine.subject_id');
						//$this->last_query();
						$i = 0;
						foreach($routines as $rec)
						{
							$this->data['data'][$i]['subject'] = $rec->subject_name;
							if ($rec->time_start_min == 0 && $rec->time_end_min == 0)
							{ 
								$this->data['data'][$i]['ctime'] = $rec->time_start.' - '.$rec->time_end;
							}
							else if($rec->time_start_min != 0 || $rec->time_end_min != 0)
							{
								$this->data['data'][$i]['ctime'] = $rec->time_start.':'.$rec->time_start_min.'-'.$rec->time_end.':'.$rec->time_end_min;
							}
							$i++;
						}
					}
					
					unset($this->data['class_id']);
					unset($this->data['section']);
					unset($this->data['day']);
					if(empty($this->data['data']))
					{
						$this->data['data']		= array();
						$this->data['data'][]	= (object) array();
					}
					$this->data['success']	= TRUE;
					$this->data['message']	= 'Records Fetched Successfully';
					$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
				}
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function invoice_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$student_id	= $this->post('student_id');
       	 	$invoices   = $this->db->get_where('invoice', array('student_id' => $student_id))->result_array();
			if(count($invoices) > 0)
			{
				$this->data['data']		= $invoices;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function transport_post()
	{
		//$this->form_validation->set_rules('student_id', 'Student ID', 'trim');
		if (1 == 1)//$this->form_validation->run())
		{	
			//$student_id	= $this->post('student_id');
       	 	$transport	= $this->db->get('transport')->result_array();
			if(count($transport) > 0)
			{
				$this->data['data']		= $transport;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function booklist_post()
	{
		$where = '';
		if(isset($_POST['book_name']) && trim($_POST['book_name']) != '')
		{
			$where = ' `book`.`name` LIKE "%'.trim($_POST['book_name']).'%"';
		}
		$booklist	= $this->user_model->getTableData('book', 'book.*,class.name as class_name', $where, 'name', 'ASC','class', 'class.class_id = book.class_id');		
		if(count($booklist) > 0)
		{
			$this->data['data']		= $booklist;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Record Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{
			$this->data['data']		= array();
			$this->data['data'][]	= (object) array();
			$this->data['success']	= FALSE;
			$this->data['message']	= 'No record found!!!';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function book_request_form_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		$this->form_validation->set_rules('book_id', 'Book ID', 'trim|required');
		$this->form_validation->set_rules('issue_start_date', 'Issue Start Date', 'trim|required');
		$this->form_validation->set_rules('issue_end_date', 'Issue End Date', 'trim|required');
		if ($this->form_validation->run())
		{
			$data['book_id']			= $this->input->post('book_id');
			$data['student_id']         = $this->post('student_id');
			$data['issue_start_date']   = strtotime($this->input->post('issue_start_date'));
			$data['issue_end_date']     = strtotime($this->input->post('issue_end_date'));
	
			if($this->db->insert('book_request', $data))
			{
				$this->data['data']		= (array) $this->data['data'];
				$this->data['data'][]	= $data;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Added Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'Error Occurred!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			$this->data['data']		= array();
			$this->data['data'][]	= (object) array();
		}
		
		$this->set_response($this->data);
	}
	
	public function all_book_request_post()
	{
		$where	= 'book_request.book_request_id != 0';
		if(isset($_POST['book_name']) && trim($_POST['book_name']) != '')
		{
			$where = ' `book`.`name` LIKE "%'.trim($_POST['book_name']).'%"';
		}	
		$booklist	= $this->user_model->book_request($where);
		if(count($booklist) > 0)
		{
			$this->data['data']		= $booklist;
			$this->data['status']	= (object) array(0 => 'Pending', 1 => 'Issued', 2 => 'Rejected');
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Record Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{
			$this->data['data']		= array();
			$this->data['data'][]	= (object) array();
			$this->data['success']	= FALSE;
			$this->data['message']	= 'No record found!!!';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		$this->set_response($this->data);
	}
	
	public function book_request_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$student_id	= $this->post('student_id');
			$where 		= 'book_request.student_id = '.$student_id;
			if(isset($_POST['book_name']) && trim($_POST['book_name']) != '')
			{
				$where .= ' AND `book`.`name` LIKE "%'.trim($_POST['book_name']).'%"';
			}
       	 	$booklist	= $this->user_model->book_request($where);
			if(count($booklist) > 0)
			{
				$this->data['data']		= $booklist;
				$this->data['status']	= (object) array(0 => 'Pending', 1 => 'Issued', 2 => 'Rejected');
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	/*** student section ends here ***/
	
	public function classes_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$teacher_id	= $this->post('teacher_id');
       	 	$classes	= $this->user_model->getTableData('class', '*', 'teacher_id = '.$teacher_id, 'name', 'ASC');
			if(count($classes) > 0)
			{
				$this->data['data']		= $classes;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['success']	= FALSE;
				$this->data['data']		= (array) $this->data['data'];
				$this->data['data'][]	= (object) array();
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function sections_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim|required');
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$teacher_id	= $this->post('teacher_id');
			$class_id	= $this->post('class_id');
       	 	$sections	= $this->user_model->getTableData('section', 'section.*, class.name AS class_name', 'section.class_id = '.$class_id.' AND section.teacher_id = '.$teacher_id, 'section.name', 'ASC', 'class', 'class.class_id = section.class_id');
			if(count($sections) > 0)
			{
				$this->data['data']		= $sections;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function students_post()
	{
		$this->form_validation->set_rules('section_id', 'Section ID', 'trim|required');
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$section_id	= $this->post('section_id');
			$class_id	= $this->post('class_id');			
			$running_yr	= $this->user_model->getTableData('settings', 'description', 'type = "running_year"');
			$running_yr	= (!empty($running_yr)) ? $running_yr[0]->description : '0';
			
       	 	$students	= $this->user_model->students("enroll.class_id = ".$class_id." AND enroll.section_id = ".$section_id." AND enroll.`year` = '".$running_yr."'");
			foreach($students as $student)
			{
				$student->img = (file_exists('uploads/student_image/'.$student->student_id.'.jpg')) ? 'uploads/student_image/'.$student->student_id.'.jpg' : 'uploads/user.jpg';
				$student->img = base_url().$student->img;
			}
			
			if(count($students) > 0)
			{
				$this->data['data']		= $students;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function student_profile_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$student_id	= $this->post('student_id');
       	 	$students	= $this->user_model->student_profile("student.student_id = ".$student_id."");
			
			if(count($students) > 0)
			{
				$year	= $this->user_model->getTableData('settings', 'description', 'type = "running_year"');
				$year	= $year[0]->description;
				
				$_where = 'student_id = '.trim($this->post('student_id')).' AND year = "'.$year.'"';
				$class	= $this->user_model->getTableData('enroll', 'class_id', $_where);
				$c_id	= $class[0]->class_id;
				
				$where  = 'subject.class_id = "'.$c_id.'" AND year = "'.trim($year).'"';				
				$subject= $this->user_model->getSubjects($where);
				$info	= array();
				$total_grade_point = $total_marks = 0;
				$exams	= $this->db->get_where('exam', array('year' => trim($year)))->result_array();
				$total_marks 		= 0;
				$sum_total_marks 	= 0;
				$total_grade_point 	= 0;
				foreach ($exams as $row2)
				{
					$i = 0;
					/****/
					$total_marks 		= 0;
					$sum_total_marks 	= 0;
					$total_grade_point 	= 0;
					$subjects = $this->db->get_where('subject', array('class_id' => $c_id, 'year' => $year))->result();
					foreach ($subjects as $row3)
					{
						$row3 = (array) $row3;
						$_where	= 'exam_id = '.$row2['exam_id'].' AND class_id = '.$c_id.' AND subject_id = '.$row3['subject_id'];
						$highest_mark 		= $this->user_model->getTableData('mark','MAX(mark_obtained) as highest_mark', $_where);
						
						$om_where  = 'subject_id = '.$row3['subject_id'].' AND exam_id = '.$row2['exam_id'].' AND class_id = '.$c_id;
						$om_where .= ' AND student_id = '.trim($student_id).' AND year = "'.$year.'"';
						
						$marks 	   = $this->user_model->getTableData('mark', '*', $om_where, 'exam_id', 'DESC');
						if (!empty($marks)) 
						{
							foreach ($marks as $row4) 
							{
								$row4 = (array) $row4;
								if ($row4['mark_obtained'] >= 0 || trim($row4['mark_obtained']) != '') 
								{
									$grade 	= $this->crud_model->get_grade($row4['mark_obtained']);
									$total_grade_point += $grade['grade_point'];
								}
								
								$info[$i]['mark_obtained']	= $row4['mark_obtained'];
								$info[$i]['grade_name']		= $grade['name'];
								$info[$i]['highest_mark']	= !empty($highest_mark) ? $highest_mark[0]->highest_mark : 0;
								$info[$i]['mark_total']		= $row4['mark_total'];
								$info[$i]['comment']		= $row4['comment'];
								$info[$i]['subject_name'] 	= $row3['name'];
								$info[$i]['exam_name'] 		= $row2['name'];
								$total_marks += $row4['mark_obtained'];
								$i++;
							}
						}
					}
				}
				
				
				//$this->db->where('class_id' , $c_id);
				//$this->db->where('year' , trim($year));
				//$this->db->from('subject');
				$number_of_subjects = isset($subjects) ? count($subjects) : 0;//$this->db->count_all_results();
				$avg_grade_point 	= $number_of_subjects != 0 ? ($total_grade_point / $number_of_subjects) : 0;
				$invoices = $this->db->get_where('invoice', array('student_id' => $student_id))->result_array();
										
				$this->data['marks_sheet']		= $info;
				$this->data['data']				= $info;
				$this->data['total_marks']		= $total_marks;
				$this->data['sum_total_marks']	= $sum_total_marks;
				$this->data['avg_grade_point']	= round($avg_grade_point,2);
				$this->data['student_name']		= $students[0]->name;
				
				$this->data['class_name']	= $this->db->get_where('class' , array('class_id' => $c_id))->row();
				$this->data['class_name']	= !empty($this->data['class_name']) ? $this->data['class_name']->name : '';
			
				/** pdf create**/
				$this->load->library('classes/Html2pdf');
				$file_name 	= "marks-sheet-".trim($student_id).".pdf";
				$pdf_path	= 'marks_sheet/'.$file_name;
				$pdf_html 	= $this->load->view('marksheet_print', $this->data, true);
				//echo $pdf_html;exit;
				$html2pdf 	= new HTML2PDF('P', 'A4', 'en');
				$html2pdf->writeHTML("<style></style>".$pdf_html);
		
				$html2pdf->Output($pdf_path,'F');
				/** pdf create ends **/
			
				$this->data['data']		= $students;
				$this->data['invoices']	= $invoices;
				$this->data['subjects']	= $subject;
				$this->data['success']	= TRUE;				
				$this->data['mark_url']	= base_url().'marks_sheet/marks-sheet-'.trim($student_id).".pdf";
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function subjects_post()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		if ($this->form_validation->run())
		{			
			$year	= $this->user_model->getTableData('settings', 'description', 'type = "running_year"');
			$year	= (!empty($year)) ? $year[0]->description : '0';
						
			$where  = 'subject.class_id = "'.trim($this->post('class_id')).'" AND year = "'.trim($year).'"';	
			if(isset($_POST['subject_name']) && trim($_POST['subject_name']) != '')
			{
				$where  .= ' AND subject.name LIKE "%'.trim($_POST['subject_name']).'%"'; 
			}
			$subject= $this->user_model->getSubjects($where);
			//$this->last_query(); 
			if(count($subject) > 0)
			{
				$this->data['data']		= $subject;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Records Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No records found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['data']		= array();
			$this->data['data'][]	= (object) array();
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function section_routine_days_post()
	{
		$this->form_validation->set_rules('section_id', 'Section ID', 'trim|required');
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		$this->data['data']	= (array) $this->data['data'];
		if ($this->form_validation->run())
		{
			$this->data['year']	= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']	= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			
			$where  = 'class_routine.class_id = '.trim($this->post('class_id')).'';
			$where .= ' AND class_routine.year = "'.trim($this->data['year']).'"';
			$where .= ' AND class_routine.section_id = "'.trim($this->post('section_id')).'"';				
			$routines = $this->user_model->getTableData('class_routine', 'DISTINCT `day`,', $where, 'time_start', 'ASC');
			$idx = 0;
			foreach($routines as $rec)
			{
				$this->data['data'][$idx]['day_name'] 	= $rec->day;
				$this->data['data'][$idx]['class_id'] 	= $this->post('class_id');
				$this->data['data'][$idx]['section_id'] = $this->post('section_id');
				$idx++;				
			}
			
			unset($this->data['class_id']);
			unset($this->data['section']);
			if(empty($this->data['data']))
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
			}
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function section_routine_post()
	{
		$this->form_validation->set_rules('day', 'Day Name', 'trim|required');
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		$this->form_validation->set_rules('section_id', 'Section ID', 'trim|required');
		$this->data['data']	= (array) $this->data['data'];
		if ($this->form_validation->run())
		{
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['class_id']	= trim($this->post('class_id'));			
			$this->data['section']	= trim($this->post('section_id'));
			$this->data['day']		= trim($this->post('day'));
			for($d = 1; $d <= 1; $d++)
			{
				$where  = 'class_routine.class_id = '.trim($this->data['class_id']).'';
				$where .= ' AND class_routine.year = "'.trim($this->data['year']).'"';
				$where .= ' AND class_routine.day = "'.trim($this->data['day']).'"';
				$where .= ' AND class_routine.section_id = "'.trim($this->data['section']).'"';
				
				$routines = $this->user_model->getTableData('class_routine', 'class_routine.*, `subject`.`name` as subject_name,', $where, 'time_start', 'ASC', 'subject', 'subject.subject_id = class_routine.subject_id');
				$i = 0;
				foreach($routines as $rec)
				{
					$this->data['data'][$i]['subject'] = $rec->subject_name;
					if ($rec->time_start_min == 0 && $rec->time_end_min == 0)
					{ 
						$this->data['data'][$i]['ctime'] = $rec->time_start.' - '.$rec->time_end;
					}
					else if($rec->time_start_min != 0 || $rec->time_end_min != 0)
					{
						$this->data['data'][$i]['ctime'] = $rec->time_start.':'.$rec->time_start_min.'-'.$rec->time_end.':'.$rec->time_end_min;
					}
					$i++;
				}
			}
			
			unset($this->data['class_id']);
			unset($this->data['section']);
			unset($this->data['day']);
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function class_syllabus_post()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		if ($this->form_validation->run())
		{
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			
			$where		= 'acs.class_id = '.trim($this->post('class_id')).' AND acs.year = "'.$this->data['year'].'"';
			if(isset($_POST['subject_name']) && trim($_POST['subject_name']) != '')
			{
				$where  .= ' AND `subject`.`name` LIKE "%'.trim($_POST['subject_name']).'%"';
			}
			$this->data['data'] 	= $this->user_model->getTableData('academic_syllabus AS acs','acs.*,subject.name as subject_name', $where, 'academic_syllabus_id', 'DESC', 'subject', 'subject.subject_id = acs.subject_id');
			if(!empty($this->data['data']))
			{
				$i = 0;
				foreach($this->data['data'] as $rec)
				{
					$this->data['data'][$i]->file_url	= base_url().'uploads/syllabus/'.$rec->file_name;
					$this->data['data'][$i]->file_name	= $rec->file_name;
					$i++;
				}
			}
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function attendance_post()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		$this->form_validation->set_rules('section_id', 'Section ID', 'trim|required');
		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		if ($this->form_validation->run())
		{			
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['data']		= $this->user_model->attendance('attendance.class_id = '.trim($this->input->post('class_id')).' AND attendance.section_id = '.$this->input->post('section_id').' AND attendance.`year` = "'.$this->data['year'].'" AND attendance.`timestamp` = "'.strtotime($this->input->post('date')).'"');
			if(empty($this->data['data']))
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
			}
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function monthly_attendance_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{
			$month = date('m');	
			if(isset($_POST['month']) && trim($_POST['month']) != '')
			{
				$month = trim($_POST['month']);
			}
			
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$number_of_days			= cal_days_in_month(CAL_GREGORIAN,date('m'),date('Y'));
			$monthly_attendance 	= array();
			$class_name		= '';
			$class_id		= '';
			$section_id 	= '';
			$section_name 	= '';
			$student_id 	= '';
			$student_name 	= '';
			
			for($i = 1; $i <= $number_of_days; $i++)
			{
				$i = $i < 10 ? '0'.$i : $i;
				$date 	= date('Y-').$month.'-'.$i;
				$year	= $this->data['year'];
				$attendance = $this->user_model->attendance('attendance.student_id = '.trim($this->input->post('student_id')).' AND attendance.`year` = "'.$this->data['year'].'" AND from_unixtime(attendance.`timestamp`, "%Y-%m-%d") = "'.$date.'"');
				if(empty($attendance))
				{
					$attendance[0]	= array("attendance_id" => "", "timestamp" => strtotime($date), "year" => $year, "class_id" => $class_id,
											"section_id" => $section_id, "student_id" => $student_id, "class_routine_id" => null,
											"status" => null, "date" => $date, "student_name" => $student_name,
											"section_name" => $section_name, "class_name" => $class_name);
					$attendance[0]	= (object) $attendance[0];						
				}
				else
				{
					$class_name		= $attendance[0]->class_name;
					$class_id		= $attendance[0]->class_id;
					$section_id 	= $attendance[0]->section_id;
					$section_name 	= $attendance[0]->section_name;
					$student_id 	= $attendance[0]->student_id;
					$student_name 	= $attendance[0]->student_name;
				}
				
				$attendance[0]->date	= date('D M d, Y', strtotime($attendance[0]->date));
				$monthly_attendance[]	= $attendance[0];
				unset($attendance);
			}
			$this->data['data']		= $monthly_attendance;
			if(empty($this->data['data']))
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
			}
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function exams_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim');
		if ($this->form_validation->run())
		{
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$this->data['year']		= (!empty($this->data['year'])) ? $this->data['year']->description : '0';
			$this->data['data']		= $this->user_model->getTableData('exam', 'exam.*', 'year = "'.$this->data['year'].'"', 'exam_id', 'DESC');
			if(empty($this->data['data']))
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
			}
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function exam_classes_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim');
		if ($this->form_validation->run())
		{
			$this->data['data']	= $this->user_model->getTableData('class','*', '', 'class_id', 'DESC');
			if(empty($this->data['data']))
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
			}
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function exam_sections_post()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$class_id	= $this->post('class_id');
       	 	$sections	= $this->user_model->getTableData('section', 'section.*, class.name AS class_name', 'section.class_id = '.$class_id.'', 'section.name', 'ASC', 'class', 'class.class_id = section.class_id');
			if(count($sections) > 0)
			{
				$this->data['data']		= $sections;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function class_subjects_post()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		if ($this->form_validation->run())
		{	
			$class_id	= $this->post('class_id');
       	 	$sections	= $this->db->get_where('subject' , array('class_id' => $class_id , 'year' => $this->db->get_where('settings' , array('type' => 'running_year'))->row()->description))->result_array();
			if(count($sections) > 0)
			{
				$this->data['data']		= $sections;
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No record found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function exam_details_post()
	{
		$this->form_validation->set_rules('exam_id', 'Exam ID', 'trim|required');
		$this->form_validation->set_rules('subject_id', 'Subject ID', 'trim|required');
		if ($this->form_validation->run())
		{		
			$exam_id	= $this->post('exam_id');	
			$subject_id	= $this->post('subject_id');	
					
			$exams		= $this->user_model->getTableData('mark', 'mark.exam_id,mark.student_id,student.`name` AS student_name, mark_obtained, mark.mark_total', 'mark.exam_id = '.$exam_id.' AND mark.subject_id = '.$subject_id, 'mark.student_id', 'DESC', 'student', 'student.student_id = mark.student_id');
									
			$this->data['data']		= $exams;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function section_attendance_post()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		$this->form_validation->set_rules('section_id', 'Section ID', 'trim|required');
		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		if ($this->form_validation->run())
		{		
			$class_id	= $this->post('class_id');
			$section_id	= $this->post('section_id');
			$timestamp	= strtotime($this->post('date'));
			$year 		= $this->db->get_where('settings' , array('type' => 'running_year'))->row();
			$year		= (!empty($year)) ? $year->description : '0';
			
			$attendance = $this->user_model->section_attendance("attendance.`class_id` = '".$class_id."'
																	AND attendance.`section_id` = '".$section_id."'
																	AND attendance.`year` = '".$year."'
																	AND attendance.`timestamp` = '".$timestamp."'");
									
			$this->data['data']		= $attendance;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function question_papers_post()
	{
		$this->form_validation->set_rules('teacher_id', 'Teacher ID', 'trim|required');
		if ($this->form_validation->run())
		{		
			$teacher_id	= $this->post('teacher_id');
			$q_papers 	= $this->user_model->question_papers('question_paper.teacher_id = '.$teacher_id);
			if(empty($q_papers))
			{
				$q_papers	= array();
				$q_papers[]	= (object) array();
			}						
			$this->data['data']		= $q_papers;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function question_paper_detail_post()
	{
		$this->form_validation->set_rules('question_paper_id', 'Question Paper ID', 'trim|required');
		if ($this->form_validation->run())
		{		
			$question_paper_id	= $this->post('question_paper_id');
			$question_paper 	= $this->user_model->question_papers('question_paper.question_paper_id = '.$question_paper_id);
			if(empty($question_paper))
			{
				$question_paper		= array();
				$question_paper[]	= (object) array();
			}						
			$this->data['data']		= $question_paper;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function parent_childs_post()
	{
		$this->form_validation->set_rules('parent_id', 'Parent ID', 'trim|required');
		if ($this->form_validation->run())
		{		
			$parent_id	= $this->post('parent_id');	
			
			$childs		= $this->user_model->getTableData('student', 'student_id,`name`','parent_id = '.$parent_id, '`name`', 'DESC');
			if(empty($childs))
			{
				$childs		= array();
				$childs[]	= (object) array();
			}						
			$this->data['data']		= $childs;
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function update_account_post()
	{
		$this->form_validation->set_rules('name', 'name', 'trim|required');
		$this->form_validation->set_rules('email', 'email', 'trim|required|valid_email|callback_IsEmailIsUnique');
		$this->form_validation->set_rules('user_id', 'user id', 'trim|required');
		$this->form_validation->set_rules('user_type', 'user type', 'trim|required');
		//$post_data = $this->post(); 
		//echo '<pre>';print_r($_FILES);exit;
		//$this->form_validation->set_data($post_data);
		
		if ($this->form_validation->run())
		{
			$user_type		= trim($this->post ( 'user_type' ));
			$column_name	= $user_type.'_id';
			$info['name']	= trim($this->post ( 'name' ));
			$info['email']	= trim($this->post ( 'email' ));
			$this->user_model->update_data($info,$user_type, $column_name.' = '.trim($this->post ( 'user_id' )));
			
			/*if(!empty($_FILES))
			{				
				$file 	= $_FILES['file'];
				if(is_uploaded_file($file['tmp_name'])) 
				{	
					$sourcePath 	= $file['tmp_name'];
					$ext			= explode('.',$file['name']);
					$ext			= $ext[count($ext)-1];
					//$fileName 	= preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext,'',$file['name'])).date('ymdhis').'.'.$ext;
					$fileName 		= trim($this->post ( 'user_id' )).'.jpg';//.$ext;
					
					if(in_array(strtolower($ext),array('jpg','jpeg','png')))
					{
						$targetPath 	= 'uploads/'.$user_type.'_image/';
						if(!file_exists($targetPath))
						{
							mkdir($targetPath);
							chmod($targetPath, 755);
						}
						$targetPath 	= $targetPath.$fileName;
						move_uploaded_file($sourcePath,$targetPath);
					}
				}						
			}*/
			
			if(trim($this->post ( 'file' )) != '')
			{				
				$file_data 	= trim($this->post ( 'file' )) ;
				$targetPath = 'uploads/'.$user_type.'_image/';
				if(!file_exists($targetPath))
				{
					mkdir($targetPath);
					chmod($targetPath, 755);
				}
				$fileName	= trim($this->post ( 'user_id' )).'.jpg';
				$targetPath	= $targetPath.$fileName;
				$fileName 	= fopen( trim($targetPath), 'wb' ); 
				fwrite( $fileName, base64_decode( $file_data ) );
				fclose( $fileName ); 										
			}
			
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Updated Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function change_password_post()
	{
		$this->form_validation->set_rules('current_password', 'Current Password', 'trim|required');
		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[6]');
		$this->form_validation->set_rules('re_password', 'Confirm Password', 'trim|required|min_length[6]|matches[new_password]');
		$this->form_validation->set_rules('user_id', 'user id', 'trim|required');
		$this->form_validation->set_rules('user_type', 'user type', 'trim|required');
		
		if ($this->form_validation->run())
		{
			$column_name	= trim($_POST['user_type']).'_id';
			$table_name		= trim($_POST['user_type']);
			$user_info 		= $this->user_model->getTableData($table_name, $column_name.',password', $column_name.' = '.trim($_POST['user_id']));
			if(!empty($user_info))
			{
				if($user_info[0]->password != sha1(trim($this->input->post('current_password'))))
				{
					$this->data['success']	= FALSE;
					$this->data['message']	= 'Old Password doesn\'t seem correct.';
					$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;//HTTP_NOT_FOUND;
				}
				else
				{
					$info['password']		= sha1(trim($this->input->post('new_password')));
					$this->user_model->update_data($info,$table_name,$column_name.' = '.trim($_POST['user_id']));
					
					$this->data['success']	= TRUE;
					$this->data['message']	= 'Password Changed Successfully.';
					$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
				}
			}
			else
			{
				$this->data['success']	= FALSE;
				$this->data['message']	= 'Error occured, Try again later.';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;//HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function profile_info_post()
	{
		$this->form_validation->set_rules('user_id', 'user id', 'trim|required');
		$this->form_validation->set_rules('user_type', 'user type', 'trim|required');
		
		if ($this->form_validation->run())
		{
			$column_name	= trim($_POST['user_type']).'_id';
			$table_name		= trim($_POST['user_type']);
			$user_info 		= $this->user_model->getTableData($table_name, '*', $column_name.' = '.trim($_POST['user_id']));
			if(!empty($user_info))
			{
				$user_info[0]->photo	= base_url().'uploads/'.$table_name.'_image/'.$user_info[0]->$column_name.'.jpg';
				$this->data['data']		= $user_info[0];
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Record Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['data']		= array();
				$this->data['data'][]	= (object) array();
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No data found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;//HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
		
	public function IsEmailIsUnique($str)
	{
		$this->form_validation->set_message('IsEmailIsUnique', 'Email ID already exists, Try another one.');
		$_where					= 'email = "'.trim($_POST['email']).'"';
		$_cols					= trim($_POST['user_type']).'_id';
		if(isset($_POST['user_id']) && trim($_POST['user_id']) != '0')
		{
			$_where					.= ' AND '.$_cols.' != '.trim($_POST['user_id']).'';
		}
		$user 	= $this->user_model->getTableData($_POST['user_type'],$_cols,$_where, '','');
		return (empty($user)) ? TRUE : FALSE;		
	}

	private function last_query ()
	{
		echo $this->db->last_query();
		exit;
	}	
	
	public function class_routine_bkup_post()
	{
		$this->form_validation->set_rules('student_id', 'Student ID', 'trim|required');
		if ($this->form_validation->run())
		{
			$this->data['profile']	= $this->db->get_where('student', array('student_id' => trim($this->post('student_id'))))->row();
			$this->data['year']		= $this->db->get_where('settings' , array('type' => 'running_year'))->row()->description;
			$this->data['class_id']	= $this->db->get_where('enroll' , array('student_id' => $this->data['profile']->student_id,'year' => $this->data['year']))->row()->class_id;
			$this->data['stdnt_id'] = $this->data['profile']->student_id;
			
			$this->data['section']	= $this->db->get_where('enroll' , array('student_id' => $this->data['stdnt_id'], 'class_id' => $this->data['class_id'], 'year' => $this->data['year']))->row()->section_id;
			$obj = $this->data['class_id'].' - '.$this->data['section'];
			for($d = 1; $d <= 7; $d++)
			{
				if($d == 1) $day = 'sunday';
				else if($d == 2) $day = 'monday';
				else if($d == 3) $day = 'tuesday';
				else if($d == 4) $day = 'wednesday';
				else if($d == 5) $day = 'thursday';
				else if($d == 6) $day = 'friday';
				else if($d == 7) $day = 'saturday';
				
				$where  = 'class_routine.class_id = '.trim($this->data['class_id']).'';
				$where .= ' AND class_routine.year = "'.trim($this->data['year']).'"';
				$where .= ' AND class_routine.day = "'.trim($day).'"';
				$where .= ' AND class_routine.section_id = "'.trim($this->data['section']).'"';
				
				//$this->data['data']->$obj->$day	= '';
				//$this->data['data']->$obj->$day	= (object) $this->data['data']->$obj->$day;
				$routines = $this->user_model->getTableData('class_routine', 'class_routine.*, subject.name as subject_name,', $where, 'time_start', 'ASC', 'subject', 'subject.subject_id = class_routine.subject_id');
				foreach($routines as $row2)
				{
					$this->data['data']->$obj->$day->subject = $row2->subject_name;
					if ($row2->time_start_min == 0 && $row2->time_end_min == 0)
					{ 
						$this->data['data']->$obj->$day->ctime = '('.$row2->time_start.' - '.$row2->time_end.')';
					}
					else if($row2->time_start_min != 0 || $row2->time_end_min != 0)
					{
						$this->data['data']->$obj->$day->ctime = '('.$row2->time_start.':'.$row2->time_start_min.'-'.$row2->time_end.':'.$row2->time_end_min.')';
					}
				}
			}
			
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Records Fetched Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function class_routine_backup()
	{
		$this->form_validation->set_rules('class_id', 'Class ID', 'trim|required');
		$this->form_validation->set_rules('year', 'Year', 'trim|required');
		if ($this->form_validation->run())
		{			
			$sections = $this->user_model->getTableData('section', '*', 'class_id = '.trim($this->post('class_id')), 'section_id', 'DESC');
			if(!empty($sections))
			{
				foreach($sections as $row)
				{	
					$obj = $row->class_id.' - '.$row->name;
					$this->data['data']->$obj = (object) array();
					for($d = 1; $d <= 7; $d++)
					{
						if($d == 1) $day = 'sunday';
						else if($d == 2) $day = 'monday';
						else if($d == 3) $day = 'tuesday';
						else if($d == 4) $day = 'wednesday';
						else if($d == 5) $day = 'thursday';
						else if($d == 6) $day = 'friday';
						else if($d == 7) $day = 'saturday';
						
						$where  = 'class_routine.class_id = '.trim($this->post('class_id')).'';
						$where .= ' AND class_routine.year = "'.trim($this->post('year')).'"';
						$where .= ' AND class_routine.day = "'.trim($day).'"';
						$where .= ' AND class_routine.section_id = "'.trim($row->section_id).'"';
						
						$this->data['data']->$obj->$day = '';//$this->data['data'];
						$this->data['data']->$obj->$day	= (object) $this->data['data']->$obj->$day;
						$routines = $this->user_model->getTableData('class_routine', 'class_routine.*, subject.name as subject_name,', $where, 'time_start', 'ASC', 'subject', 'subject.subject_id = class_routine.subject_id');
						foreach($routines as $row2)
						{
							$this->data['data']->$obj->$day->subject = $row2->subject_name;
							if ($row2->time_start_min == 0 && $row2->time_end_min == 0)
							{ 
								$this->data['data']->$obj->$day->ctime = '('.$row2->time_start.' - '.$row2->time_end.')';
							}
							else if($row2->time_start_min != 0 || $row2->time_end_min != 0)
							{
								$this->data['data']->$obj->$day->ctime = '('.$row2->time_start.':'.$row2->time_start_min.'-'.$row2->time_end.':'.$row2->time_end_min.')';
							}
						}
					}			
				}
			}			
			
			if(1)
			{
				$this->data['success']	= TRUE;
				$this->data['message']	= 'Records Fetched Successfully';
				$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
			}
			else
			{
				$this->data['success']	= FALSE;
				$this->data['message']	= 'No records found!!!';
				$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
			}
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
	
	public function signup_post()
	{
		$this->form_validation->set_rules('first_name', 'first name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'last name', 'trim|required');
		$this->form_validation->set_rules('email', 'email', 'trim|required|valid_email|callback_emailIsUnique');
		$this->form_validation->set_rules('mobile_number', 'mobile number', 'trim|required');
		$this->form_validation->set_rules('address', 'address', 'trim|required');
		$this->form_validation->set_rules('dob', 'date of birth', 'trim|required');
		$this->form_validation->set_rules('password', 'password', 'trim|required');
		
		if ($this->form_validation->run())
		{	
			$info['mobile_number']	= trim($this->post ( 'mobile_number' ));
			$info['first_name']		= trim($this->post ( 'first_name' ));
			$info['last_name']	= trim($this->post ( 'last_name' ));
			$info['email']		= trim($this->post ( 'email' ));
			$info['address']	= trim($this->post ( 'address' ));
			$info['dob']	= trim($this->post ( 'dob' ));
			$info['password']	= trim($this->post ( 'password' ));
			
			$this->user_model->insert_data($info, 'demo_users');
			$this->data['success']	= TRUE;
			$this->data['message']	= 'Registered Sent Successfully';
			$this->data[$this->hrc]	= REST_Controller::HTTP_OK;//HTTP_NOT_FOUND;
		}
		else
		{			
			if(!empty($_POST))
			{
				$i = 0;
				foreach($_POST as $key=>$value)
				{
					$data['errors'][$i]['error'] = strip_tags(form_error($key));
					$data['errors'][$i]['field'] = $key;
					$i++;
				}
			}
			
			$this->data['errors']	= !empty($data['errors']) ? $data['errors'] : array();
			$this->data['success'] 	= FALSE;
			$this->data['message']	= 'Post values are not properly recieved.';
			$this->data[$this->hrc]	= REST_Controller::HTTP_NOT_FOUND;
		}
		
		$this->set_response($this->data);
	}
}
?>