<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_expense'); ?></h4>
        </div>
        <?php $attrib = array('data-toggle' => 'validator', 'role' => 'form');
        echo admin_form_open_multipart("purchases/edit_expense/" . $expense->id, $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <?php if ($Owner || $Admin) { ?>

                <div class="form-group">
                    <?= lang("date", "date"); ?>
                    <?= form_input('date', (isset($_POST['date']) ? $_POST['date'] : $this->sma->hrld($expense->date)), 'class="form-control datetime" id="date" required="required"'); ?>
                </div>
            <?php } ?>

            <div class="form-group">
                <?= lang("reference", "reference"); ?>
                <?= form_input('reference', (isset($_POST['reference']) ? $_POST['reference'] : $expense->reference), 'class="form-control tip" id="reference" required="required"'); ?>
            </div>

            <div class="form-group">
                <?= lang('category', 'category'); ?>
                <?php
                $ct[''] = lang('select').' '.lang('category');
                foreach ($categories as $category) {
                    $ct[$category->id] = $category->name;
                }
                ?>
                <?= form_dropdown('category', $ct, set_value('category', $expense->category_id), 'class="form-control tip" id="category"'); ?>
            </div>

            <div class="form-group">
                <?= lang("warehouse", "warehouse"); ?>
                <?php
                $wh[''] = lang("select") . ' ' . lang("warehouse");
                foreach ($warehouses as $warehouse) {
                    $wh[$warehouse->id] = $warehouse->name;
                }
                echo form_dropdown('warehouse', $wh, set_value('warehouse', $expense->warehouse_id), 'id="warehouse" class="form-control input-tip select" style="width:100%;" ');
                ?>
            </div>

            <div class="form-group">
                <?= lang("amount", "amount"); ?>
                <input name="amount" type="text" id="amount" value="<?= $this->sma->formatDecimal($expense->amount); ?>"
                       class="pa form-control kb-pad amount" required="required"/>
            </div>

			<div class="form-group"> 
				<?= lang("Deducted From", "deducted_from"); ?>
				<div class="controls">
					<select name="deducted_from" id="deducted_from" class="form-control">
						<option value="1" <?php echo ($transaction->bank_id != 0) ? 'selected' : '';?>>Bank Account</option>
						<option value="2" <?php echo ($transaction->store_id != 0 || $transaction->type_id != 0) ? 'selected' : '';?>>WareHouse / Store</option>
					</select>
				</div>
			</div>
			
			<div class="form-group account" <?php echo ($transaction->store_id != 0 || $transaction->type_id != 0) ? 'style="display:none;"' : '';?>> 
				<?= lang("Bank Account", "account"); ?>
				<div class="controls">
					<select name="account" id="account" class="form-control">
						<?php if(!empty($accounts)){
								foreach($accounts as $account){?>
						<option value="<?php echo $account->id;?>" <?php echo $transaction->bank_id == $account->id ? 'selected' : '';?>><?php echo $account->account_title.' - '.$account->account_number;?></option>
						<?php }}else{?>								
						<option value="">Add Bank Account</option>
						<?php }?>
					</select>
				</div>
			</div>
			
			<div class="form-group warehouse_id" <?php echo ($transaction->bank_id != 0) ? 'style="display:none;"' : '';?>> 
				<?= lang("Warehouse", "warehouse_id"); ?>
				<div class="controls">
					<select name="warehouse_id" id="warehouse_id" class="form-control">
						<?php if(!empty($warehouses)){
								foreach($warehouses as $warehouse){?>
						<option value="<?php echo $warehouse->id;?>" <?php echo $transaction->type_id == $warehouse->id ? 'selected' : '';?>><?php echo $warehouse->name;?></option>
						<?php }}?>
					</select>
				</div>
			</div>
			<div class="form-group store_id" <?php echo ($transaction->bank_id != 0) ? 'style="display:none;"' : '';?>> 
				<?= lang("Store", "store_id"); ?>
				<div class="controls">
					<select name="store_id" id="store_id" class="form-control">
						<option value="">Select Store</option>
						<?php if(!empty($stores)){
								foreach($stores as $store){?>
						<option value="<?php echo $store->id;?>" <?php echo $transaction->store_id == $store->id ? 'selected' : '';?>><?php echo $store->name;?></option>
						<?php }}?>
					</select>
				</div>
			</div>

            <div class="form-group">
                <?= lang("attachment", "attachment") ?>
                <input id="attachment" type="file" data-browse-label="<?= lang('browse'); ?>" name="userfile" data-show-upload="false" data-show-preview="false"
                       class="form-control file">
            </div>

            <div class="form-group">
                <?= lang("note", "note"); ?>
                <?php echo form_textarea('note', (isset($_POST['note']) ? $_POST['note'] : $expense->note), 'class="form-control" id="note"'); ?>
            </div>

        </div>
        <div class="modal-footer">
            <?php echo form_submit('edit_expense', lang('edit_expense'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>
<script type="text/javascript" charset="UTF-8">
    $.fn.datetimepicker.dates['sma'] = <?=$dp_lang?>;
</script>
<?= $modal_js ?>
<script type="text/javascript" charset="UTF-8">
    $(document).ready(function () {
        $.fn.datetimepicker.dates['sma'] = <?=$dp_lang?>;
    });

	$(document).ready(function () {	
		$('#deducted_from').change(function () {
			var v = $(this).val();
			if(v == 1)
			{
				$('.warehouse_id,.store_id').slideUp(150);
				$('.account').slideDown(150);
			}
			else
			{
				$('.account').slideUp(150);
				$('.warehouse_id').slideDown(150);
				$('#warehouse_id').trigger('change');
			}
		});
		
		$('#warehouse_id').change(function () {
			var v = $(this).val();
			getStoresNew(v);
		});
	});
	
	function getStoresNew(v)	
	{
		$('#modal-loading').show();
		if (v) 
		{
			$.ajax({
				type: "get",
				async: false,
				url: "<?= admin_url('products/getStores') ?>/" + v,
				dataType: "json",
				success: function (scdata) {
					$('.store_id').slideDown(150);
					if (scdata != null) 
					{					
						$("#store_id").select2("destroy").empty().attr("placeholder", "Select Store");
						var html = '<option value="">Select Store</option>';
						for(var i = 0; i < scdata.length; i++)
						{
							html += '<option value="'+scdata[i].id+'">'+scdata[i].text+'</option>';
						}
						$("#store_id").html(html);
						$("#store_id").select2({placeholder: "Select Store"});	
					} 
					else 
					{
						var html = '<option value="">Select Store</option>';
						$("#store_id").html(html);
						$("#store_id").select2({placeholder: "Select Store"});	
					}
				},
				error: function () {
					bootbox.alert('<?= lang('ajax_error') ?>');
					$('#modal-loading').hide();
				}
			});
		}
		
		$('#modal-loading').hide();
	}
</script>
