<?php defined('BASEPATH') OR exit('No direct script access allowed');  ?>
<script>
    $(document).ready(function () {
        oTable = $('#NTTable').dataTable({
            "aaSorting": [[1, "asc"], [2, "asc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
            "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= admin_url('Employee/getEmpSalary/'.$employee->id) ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
          "aoColumns": [ null, null, null, null, null, null]
        });
    });
</script>

<div class="box">
	<div class="box-header">
		<h2 class="blue"><i class="fa-fw fa fa-info-circle"></i><?php echo $employee->e_name."(Iqma ID-".$employee->id_card.")";?> - Salary Summary</h2>
		<div class="box-icon">
			<ul class="btn-tasks">
				<li class="dropdown"><a href="<?= admin_url('Employee/add_salary/'.$employee->id); ?>" data-toggle="modal" data-target="#myModal"><i class="icon fa fa-plus"></i></a></li>
			</ul>
		</div>
	</div>
	<div class="box-content">
		<div class="row">
			<div class="col-lg-12">
				<p class="introtext">
					<? //lang('list_results'); ?>
				</p>
				<div class="table-responsive">
					<table id="NTTable" cellpadding="0" cellspacing="0" border="0"
                           class="table table-bordered table-hover table-striped">
						<thead>
							<tr>
								<th width="16%"><?php echo $this->lang->line("Salary Amount"); ?></th>
								<th width="16%"><?php echo $this->lang->line("Total Unpaid Leaves"); ?></th>
								<th width="16%"><?php echo $this->lang->line("Salary Month"); ?></th>
								<th width="16%"><?php echo $this->lang->line("Note"); ?></th>
								<th width="20%"><?php echo $this->lang->line("Date"); ?></th>
								<th width="16%"><?php echo $this->lang->line("actions"); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td colspan="6" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
