<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<script>
    $(document).ready(function () {
        oTable = $('#NTTable').dataTable({
            "aaSorting": [[1, "asc"], [2, "asc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
            "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= admin_url('Employee/getNotifications') ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
			'fnRowCallback': function (nRow, aData, iDisplayIndex) {
                var oSettings = oTable.fnSettings();
                nRow.id = aData[0];
                nRow.className = "no_emp_link1";
                return nRow;
            },
          "aoColumns": [null, null, null, null, null, null, null, null, null, {"bSortable": false}]
        });
    });
</script>

<div class="box">
	<div class="box-header">
		<h2 class="blue"><i class="fa-fw fa fa-info-circle"></i>
			<?= lang('Employees'); ?>
		</h2>
		<div class="box-icon">
			<ul class="btn-tasks">
				<li class="dropdown"><a href="<?= admin_url('Employee/add'); ?>" data-toggle="modal" data-target="#myModal"><i class="icon fa fa-plus"></i></a></li>
			</ul>
		</div>
	</div>
	<div class="box-content">
		<div class="row">
			<div class="col-lg-12">
				<p class="introtext">
					<?= lang('list_results'); ?>
				</p>
				<div class="table-responsive">
					<table id="NTTable" cellpadding="0" cellspacing="0" border="0"
                           class="table table-bordered table-hover table-striped">
						<thead>
							<tr>
								<th style="display:none;">&nbsp;</th>
								<th><?php echo 'Name'; //echo $this->lang->line("name"); ?></th>
								<th><?php echo 'Mobile'; //echo $this->lang->line("mobile"); ?></th>
								<th><?php echo 'Iqama';?></th>
								<th><?php echo 'Iqama Expire Date'; //echo $this->lang->line("name"); ?></th>
								<th><?php echo 'Vehicle insurance if available:'; //echo $this->lang->line("mobile"); ?></th>
								<th><?php echo 'Health Insurance Expire Date:'; //echo $this->lang->line("name"); ?></th>
								<th><?php echo 'E-mail:'; //echo $this->lang->line("mobile"); ?></th>
								<th><?php echo 'Salary (Monthly)'; //echo $this->lang->line("mobile"); ?></th>
								<th style="width:80px;"><?php echo $this->lang->line("actions"); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td colspan="10" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<style>
	.table-hover td:first-child{ display:none;}
</style>
