<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-folder-open"></i><?= lang('VAT_Submit_Reports'); ?></h2> 

        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                        <i class="icon fa fa-tasks tip" data-placement="left" title="<?= lang("actions") ?>"></i>
                    </a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu" aria-labelledby="dLabel">
                        <li>
                            <a href="<?php echo admin_url('system_settings/deduct_vat'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> <?= lang('Deduct_VAT') ?>
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><? lang('list_results'); ?></p>
                <div class="table-responsive">
					<div class="row" style="margin-bottom:18px;">
						<form action="<?php echo base_url().'admin/system_settings/vat_reports';?>" method="get" name="search_form" id="search_form">
							<div class="col-md-3 text-left">
								<div class="dataTables_filter">
									<input type="text" name="date_from" value="<?php echo $from_date;?>" class="input-xs date" placeholder="From Date">
								</div>
							</div>
							<div class="col-md-3 text-left"> 	
								<div class="dataTables_filter">
									<input type="text" name="date_to" value="<?php echo $to_date;?>" class="input-xs date" placeholder="To Date">
								</div>
							</div>
							<div class="col-md-3 text-left"> 	
								<div class="dataTables_filter">
										<input type="submit" name="submit" class="btn btn-info btn-sm" value="Search">
										<a href="<?php echo base_url().'admin/system_settings/vat_reports';?>" class="btn btn-success btn-sm">Reset</a>
								</div>
							</div>
						</form>
					</div>
					<p class="introtext"><? //lang('list_results'); ?></p>
                    <table class="table table-hover table-striped reports-table">
                        <thead>
                            <tr>
                                <th><?= lang("User"); ?></th>
                                <th style="text-align:center;"><?= lang("bank_name"); ?></th>
                                <th style="text-align:center;"><?= lang("Amount"); ?></th>
                                <th style="text-align:center;"><?= ucwords(lang("Added_On")); ?></th>
                                <th style="text-align:center;"><?= lang("Type"); ?></th>
                                <th style="text-align:center;"><?= lang("Note"); ?></th>
                            </tr>
                        </thead>
                        <tbody>
						<?php if(!empty($transactions)){
                                $type = array('vat'=>'VAT Deducted from Bank');
                                $url = base_url().'admin/system_settings/vat_report_view/';
								foreach($transactions as $transaction){?>
                            <tr style="cursor:pointer;">
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>"><?php echo $transaction->username;?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo ($transaction->bank_name != '') ? $transaction->bank_name : '--';?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo date('F d, Y',strtotime($transaction->added_on));?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo ($transaction->type == 's') ? $type[$transaction->type.$transaction->trasaction_type] : $type[$transaction->type];?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo $transaction->note;?></td>
                            </tr>
						<?php }}else{?>	
							<tr>
								<td colspan="7">No record found!!!</td>
							</tr>
						<?php }?>
                        </tbody>
						<?php if(isset($links)){?>
						<tfoot>
							<tr>
								<td colspan="7" align="center"><div id="page-nation"><?php echo $links;?></div></td>    
							</tr>
						</tfoot>
						<?php }?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<style type="text/css">
#page-nation a{
	padding: 7px 10px;
	color: #fff;
    background-color: #428bca;
    border: #fff 1px solid;
}
#page-nation strong{
    color: #777;
	padding: 6px 9px;
    cursor: not-allowed;
    background-color: #fff;
    border: #428bca 1px solid;
}
</style>
<script language="javascript">
    $(document).ready(function () {

        $('#excel').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#action-form-submit').trigger('click');
        });

        $('#pdf').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#action-form-submit').trigger('click');
        });

    });
</script>

