<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>
<?= $this->lang->line('sale'); ?>
</title>
<link href="<?= $assets ?>styles/pdf/bootstrap.min.css" rel="stylesheet">
<link href="<?= $assets ?>styles/pdf/pdf.css" rel="stylesheet">
</head>

<body>
<div id="wrap">
	<div class="row">
		<div class="col-lg-12">
			<?php //if ($logo) {
                $path = base_url() . 'assets/uploads/logos/' . $this->Settings->logo;
                $type = pathinfo($path, PATHINFO_EXTENSION);
                $data = file_get_contents($path);
                $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                ?>
			<div class="text-center" style="margin-bottom:20px;"> <img src="<?= $base64; ?>" alt="<?= $biller->company != '-' ? $biller->company : $biller->name; ?>"> </div>
			<?php //}?>
			<div class="clearfix"></div>
			<div class="col-xs-12" style="margin-top: 15px;">
				<div class="table-responsive">
					<table class="table table-bordered table-hover table-striped">
						<thead>
							<tr>
								<th><?= lang("User"); ?></th>
                                <th><?= lang("warehouse"); ?> / <?= lang("Store"); ?></th>
                                <th><?= lang("bank_name"); ?></th>
                                <th><?= lang("Amount"); ?></th>
                                <th><?= ucwords(lang("Added_On")); ?></th>
                                <th><?= lang("Type"); ?></th>
                                <th><?= lang("Note"); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php if(!empty($transactions)){
								$type = array('sminus'=>'Store to Sale Register', 'splus'=>'Sale Register to Store','stb'=>'Store to Bank', 'bts'=>'Bank to Store', 'b' => 'Bank Deposit', 'bw' => 'Bank Withdraw', 'wts' => 'Warehouse to Store', 'stw' => 'Store to Warehouse', 'wtb' => 'Warehouse to Bank', 'btw' => 'Bank to Warehouse', 'purchase' => 'Purchase Payment', 'expense' => 'Expense', 'vat'=>'VAT Deducted from Bank');
								foreach($transactions as $transaction){?>
                            <tr>
                                <td style="vertical-align:middle;"><?php echo $transaction->username;?></td>
                                <td style="vertical-align:middle;"><?php echo ($transaction->name != '') ? $transaction->name : ($transaction->warehouse != '' ? $transaction->warehouse : '--');?></td>
                                <td style="vertical-align:middle;"><?php echo ($transaction->bank_name != '') ? $transaction->bank_name : '--';?></td>
                                <td style="vertical-align:middle;"><?php echo $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;?></td>
                                <td style="vertical-align:middle;"><?php echo date('F d, Y',strtotime($transaction->added_on));?></td>
                                <td style="vertical-align:middle;"><?php echo ($transaction->type == 's') ? ($transaction->note == 'Sales' ? 'Sales Amount to Store' : ($transaction->note == 'Sales Return' ? 'Amount Deducted from Store' : $type[$transaction->type.$transaction->trasaction_type])) : $type[$transaction->type];?></td>
                                <td style="vertical-align:middle;"><?php echo $transaction->note;?></td>
                            </tr>
							<?php }}?>	
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
</body>
</html>
