<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('add_brand'); ?></h4>
        </div>
        <?php $attrib = array('data-toggle' => 'validator', 'role' => 'form');
        echo admin_form_open_multipart("system_settings/add_brand", $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="form-group">
                <?= lang('code', 'code'); ?>
                <?= form_input('code', '', 'class="form-control" id="code"'); ?>
            </div>

            <div class="form-group">
                <?= lang('name', 'name'); ?>
                <?= form_input('name', '', 'class="form-control gen_slug" id="name" required="required"'); ?>
            </div>

            <div class="form-group all">
                <?= lang('slug', 'slug'); ?>
                <?= form_input('slug', set_value('slug'), 'class="form-control tip" id="slug" required="required"'); ?>
            </div>

            <div class="form-group">
                <?= lang("image", "image") ?>
                <input id="image" type="file" data-browse-label="<?= lang('browse'); ?>" name="userfile" data-show-upload="false" data-show-preview="false" class="form-control file">
            </div>
            <div class="form-group">
                
                <input id="promotion" type="checkbox"  name="promo" data-show-upload="false" data-show-preview="false" class="form-control promotion">
                <?= lang("Promotion", "promotion") ?>
            </div>
            <div id="promo" style="display:none;">
                <div class="well well-sm">
                    <div class="form-group">
                        <?= lang('Promo_Percent', 'Promo Percent'); ?>
                        <?= form_input('promo_price', set_value('promo_price'), 'class="form-control tip" id="promo_price"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('start_date', 'start_date'); ?>
                        <?= form_input('start_date', set_value('start_date'), 'class="form-control tip date" id="start_date"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('end_date', 'end_date'); ?>
                        <?= form_input('end_date', set_value('end_date'), 'class="form-control tip date" id="end_date"'); ?>
                    </div>
                </div>
             </div>

        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_brand', lang('add_brand'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>

<?= $modal_js ?>

<script>

    $(document).ready(function() {
        
        $('.gen_slug').change(function(e) {
            getSlug($(this).val(), 'brand');
        });

        $('#promotion').on('ifChecked', function (e) {
            $('#promo').slideDown();
        });

        $('#promotion').on('ifUnchecked', function (e) {
            $('#promo').slideUp();
        });

    });

</script>