<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
function row_status($x)
{
    if ($x == null) {
        return '';
    } elseif ($x == 'pending') {
        return '<div class="text-center"><span class="label label-warning">' . lang($x) . '</span></div>';
    } elseif ($x == 'completed' || $x == 'paid' || $x == 'sent' || $x == 'received') {
        return '<div class="text-center"><span class="label label-success">' . lang($x) . '</span></div>';
    } elseif ($x == 'partial' || $x == 'transferring') {
        return '<div class="text-center"><span class="label label-info">' . lang($x) . '</span></div>';
    } elseif ($x == 'due') {
        return '<div class="text-center"><span class="label label-danger">' . lang($x) . '</span></div>';
    } else {
        return '<div class="text-center"><span class="label label-default">' . lang($x) . '</span></div>';
    }
}
?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-heart"></i><?= lang('delayed_invoices_report'); ?></h2>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><?= lang('customize_report'); ?></p>
                <div class="clearfix"></div>
                <div class="table-responsive">
                    <table id="SlRData"
                           class="table table-bordered table-hover table-striped table-condensed reports-table">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th><?= lang("date"); ?></th>
                            <th><?= lang("reference_no"); ?></th>
                            <th><?= lang("customer"); ?></th>
                            <th><?= lang("status"); ?></th>
                            <th><?= lang("total"); ?></th>
                            <th><?= lang("payment_status"); ?></th>
                            <th><?= lang("paid"); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($invoices)) {
                                $r = 1;
                                foreach ($invoices as $orders) {
                                    echo '<tr id="' . $orders->id . '" class="' . ($orders->pos ? "receipt_link" : "invoice_link") . '"><td>' . $r . '</td>
                                        <td>' . $this->sma->hrld($orders->date) . '</td>
                                        <td>' . $orders->reference_no . '</td>
                                        <td>' . $orders->customer . '</td>
                                        <td>' . row_status($orders->sale_status) . '</td>
                                        <td class="text-right">' . $this->sma->formatMoney($orders->grand_total) . '</td>
                                        <td>' . row_status($orders->payment_status) . '</td>
                                        <td class="text-right">' . $this->sma->formatMoney($orders->paid) . '</td>
                                    </tr>';
                                    $r++;
                                }
                            } else { ?>
                                <tr>
                                    <td colspan="7" class="dataTables_empty"><?= lang('no_data_available') ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                        <tfoot class="dtFilter">
                        <tr class="active">
                            <th>#</th>
                            <th><?= lang("date"); ?></th>
                            <th><?= lang("reference_no"); ?></th>
                            <th><?= lang("customer"); ?></th>
                            <th><?= lang("status"); ?></th>
                            <th><?= lang("total"); ?></th>
                            <th><?= lang("payment_status"); ?></th>
                            <th><?= lang("paid"); ?></th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript" src="<?= $assets ?>js/html2canvas.min.js"></script>