<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('add_discount'); ?></h4>
        </div>
        <?php $attrib = array('data-toggle' => 'validator', 'role' => 'form');
        echo admin_form_open("promotions/addDiscount", $attrib); ?>
        <div class="modal-body">
             <p><?= lang('enter_info'); ?></p>
           
             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo lang('start_amount', 'start_amount'); ?>
                        <div class="controls">
                            <?php echo form_input('start_amount', '', 'class="form-control" id="start_amount" required="required"'); ?>
                        </div>
                    </div>
                    
                </div>
                    
                    
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo lang('end_amount', 'end_amount'); ?>
                        <div class="controls">
                            <?php echo form_input('end_amount', '', 'class="form-control" id="end_amount" required="required"'); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo lang('discount_type', 'discount_type'); ?>
                        <div class="controls">
                            <select name="discount_type" id="discount_type" class="form-control">
                                <option value="overall">Overall</option>
                                <option value="specific">Specific</option>
                            </select>
                        </div>
                    </div>
                    
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo lang('customer_price_group', 'customer_price_group'); ?>
                        <div class="controls">
                            <select name="customer_price_group" id="customer_price_group" class="form-control">
                                <option value="default">Default</option>
                                <option value="family">Family</option>
                                <option value="friends">Friends</option>
                            </select>
                        </div>
                    </div>
                    
                </div>
            </div>

           <div class="row" id="categoryDiv" style="display:none;"> 
            
                <div class="col-md-12">
                    <div class="form-group">
                        <?php echo lang('category', 'category'); ?>
                        <div class="controls">
                            <select name="category[]" id="category[]" class="form-control" multiple style="height: auto;">

                                <option value="">Select Category</option>
                                <?php foreach($categories as $value){ ?>
                                
                                    <option value="<?php echo $value->id;?>"><?php echo $value->name;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    
                </div>
               
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo lang('type', 'type'); ?>
                        <div class="controls">
                            <select name="type" id="type" class="form-control">
                                <option value="flat">Flat</option>
                                <option value="percentage">Percentage</option>
                            </select>
                        </div>
                    </div>
                    
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo lang('discount', 'discount'); ?>
                        <div class="controls">
                            <?php echo form_input('discount', '', 'class="form-control" id="discount" required="required"'); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                   
                    <div class="form-group">
                        <?php echo lang('account', 'account'); ?>
                        <div class="controls">
                            <select name="account" id="account" class="form-control">
                                <option value="Store Locknow">Store Locknow</option>
                                <option value="Store Delhi">Store Delhi</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            

            

        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_discount', lang('add_discount'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<?= $modal_js ?>

<script>  
$(document).ready(function(){
    $('#discount_type').on('change', function() {

      if ( this.value == 'specific')
      {
        $("#categoryDiv").show();
      }
      else
      {
        $("#categoryDiv").hide();
      }
    });
});
</script>

