<?php defined('BASEPATH') OR exit('No direct script access allowed');
$v = "";
if ($this->input->post('start_date')) {
    $v .= "&start_date=" . $this->input->post('start_date');
}
if ($this->input->post('end_date')) {
    $v .= "&end_date=" . $this->input->post('end_date');
}
if ($this->input->post('employee')) {
    $v .= "&empid=" . $this->input->post('employee');
}
 ?>
<script>
    $(document).ready(function () {
        oTable = $('#NTTable').dataTable({
            "aaSorting": [[1, "asc"], [2, "asc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
            "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= admin_url('Employee/getLoanReport/?v=1' . $v) ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
			'fnRowCallback': function (nRow, aData, iDisplayIndex) {
                var oSettings = oTable.fnSettings();
                nRow.id = aData[0];
                nRow.className = "emp_link1";
                return nRow;
            },
          "aoColumns": [null, null, null, null, null, null, {"bSortable": false}],
		  "fnFooterCallback": function (nRow, aaData, iStart, iEnd, aiDisplay) {
                var total_amt = 0, total_retamt = 0, total_remamt = 0;
                for (var i = 0; i < aaData.length; i++) {
                    total_amt += parseFloat(aaData[aiDisplay[i]][3]);
					total_retamt += parseFloat(aaData[aiDisplay[i]][4]);
                    total_remamt += parseFloat(aaData[aiDisplay[i]][5]);
                }
                var nCells = nRow.getElementsByTagName('th');
                nCells[3].innerHTML = currencyFormat(parseFloat(total_amt));
				nCells[4].innerHTML = currencyFormat(parseFloat(total_retamt));
                nCells[5].innerHTML = currencyFormat(parseFloat(total_remamt));
            }
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#form').hide();
        $('.toggle_down').click(function () {
            $("#form").slideDown();
            return false;
        });
        $('.toggle_up').click(function () {
            $("#form").slideUp();
            return false;
        });
    });
</script>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-info-circle"></i><?= lang('Loan Reports'); ?></h2>
        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a href="#" class="toggle_up tip" title="<?= lang('hide_form') ?>">
                        <i class="icon fa fa-toggle-up"></i>
                    </a>
                </li>
                <li class="dropdown">
                    <a href="#" class="toggle_down tip" title="<?= lang('show_form') ?>">
                        <i class="icon fa fa-toggle-down"></i>
                    </a>
                </li>
            </ul>
        </div>
        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a href="#" id="xls" class="tip" title="<?= lang('download_xls') ?>">
                        <i class="icon fa fa-file-excel-o"></i>
                    </a>
                </li>
                
            </ul>
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><?= lang('Please customize the report below'); ?></p>
                <div id="form">
                    <?php echo admin_form_open("employee/loanreport"); ?>
                    <div class="row">                     
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang("start_date", "start_date"); ?>
                                <?php echo form_input('start_date', (isset($_POST['start_date']) ? $_POST['start_date'] : ""), 'class="form-control datetime" id="start_date"'); ?>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang("end_date", "end_date"); ?>
                                <?php echo form_input('end_date', (isset($_POST['end_date']) ? $_POST['end_date'] : ""), 'class="form-control datetime" id="end_date"'); ?>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang("Employee", "Employee"); ?>
                                <?php $emp[""] = lang('select').' '.lang('Employee');
									foreach ($employees as $employee) {
                                        $emp[$employee->id] = $employee->id_card." - ".$employee->e_name;
                                    }									
									echo form_dropdown('employee', $emp, (isset($_POST['employee']) ? $_POST['employee'] : ""), 'class="form-control" id="employee" data-placeholder="' . $this->lang->line("select") . " " . $this->lang->line("employee") . '"');?>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="controls"> <?php echo form_submit('submit_report', $this->lang->line("submit"), 'class="btn btn-primary"'); ?> </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <div class="clearfix"></div>
                <div class="table-responsive">
                    <table id="NTTable" cellpadding="0" cellspacing="0" border="0" class="table table-bordered table-hover table-striped">
                        <thead>
							<tr>
								<th style="display:none;">&nbsp;</th>
								<th width="16%"><?php echo $this->lang->line("Name"); //echo $this->lang->line("name"); ?></th>                           
								<th width="16%"><?php echo $this->lang->line("Iqama");?></th>                           
								<th width="16%"><?php echo $this->lang->line("Loan Amount"); //echo $this->lang->line("mobile"); ?></th>
								<th width="16%"><?php echo $this->lang->line("Return Amount"); //echo $this->lang->line("mobile"); ?></th>
								<th width="16%"><?php echo $this->lang->line("Remaining Amount"); //echo $this->lang->line("mobile"); ?></th>                            
								<th width="20%"><?php echo $this->lang->line("Date"); ?></th>
							</tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td colspan="6" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
                        </tr>
                        </tbody>
                        <tfoot class="dtFilter">
							<tr class="active">
								<th style="display:none;"></th>
								<th></th>
							 	<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
							</tr>
                        </tfoot>
                    </table>
                </div>
                <!--<p><a href="<?php echo admin_url('notifications/add'); ?>" class="btn btn-primary" data-toggle="modal" data-target="#myModal"><?php echo $this->lang->line("add_notification"); ?></a></p>-->
            </div>
        </div>
    </div>
</div>
<style>
.table-hover td:first-child{ display:none;}
.text-right { text-align:left;}
.pagination{ float:right;}
</style>
<script type="text/javascript" src="<?= $assets ?>js/html2canvas.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#pdf').click(function (event) {
            event.preventDefault();
            window.location.href = "<?=admin_url('Employee/getLoanReport/pdf/?v=1'.$v)?>";
            return false;
        });
        $('#xls').click(function (event) {
            event.preventDefault();
            window.location.href = "<?=admin_url('Employee/getLoanReport/0/xls/?v=1'.$v)?>";
            return false;
        });
    });
</script>