<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('employee'); ?></h4>
        </div>
        <?php $attrib = array('data-toggle' => 'validator', 'role' => 'form');
        echo admin_form_open("Employee/add", $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo $this->lang->line("Name"); ?>
                        <div class="controls">
                            <?php echo form_input('e_name', '', 'class="form-control" id="e_name" required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Iqama") . "(id card)"; ?>
                        <div class="controls">
                            <?php echo form_input('id_card', '', 'class="form-control" id="id_card" required="required"'); ?>
                        </div>
                    </div>
                </div>
            </div>
			
			<div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo $this->lang->line("Iqama Expire Date"); ?>
                        <div class="controls">
                            <?php echo form_input('id_card_expire', '', 'class="form-control" id="id_card_expire" required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Vehicle insurance if available"); ?>
                        <div class="controls">
                        <?php
                            $tr["no"] = "No";
							$tr["yes"] = "Yes";
                            echo form_dropdown('Vehicle_insurance', $tr, '', 'class="form-control select" id="Vehicle_insurance" placeholder="' . lang("select") . ' ' . lang("select") . '" style="width:30%"')
                            ?>
                            
                            <?php echo form_input('Vehicle_insurance_expire', '', 'class="form-control input-tip datetime" id="Vehicle_insurance_expire" placeholder="Insurance Expire" style="width:65%; float:right; display:none;"'); ?>
                            
                        </div>
                    </div>
                </div>
            </div>
			
			<div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo $this->lang->line("Health Insurance Expire Date") .":"; ?>
                        <div class="controls">
                            <?php echo form_input('Health_Insurance', '', 'class="form-control input-tip datetime" id="Health_Insurance" required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Mobile"); ?>
                        <div class="controls">
                            <?php echo form_input('mobile', '', 'class="form-control" id="mobile" required="required"'); ?>
                        </div>
                    </div>
                </div>
            </div>
			
			<div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo $this->lang->line("E-mail"); ?>
                        <div class="controls">
                            <?php echo form_input('email', '', 'class="form-control" id="email" required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo  $this->lang->line("Address"); ?>
                        <div class="controls">
                            <?php echo form_input('address', '', 'class="form-control" id="address" required="required"'); ?>
                        </div>
                    </div>
                </div>
            </div>
			
			
			<div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo  $this->lang->line("Gosi Fee (Monthly)"); ?>
                        <div class="controls">
                            <?php echo form_input('Calculation_Finance', '', 'class="form-control" id="Calculation_Finance" required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Salary (Monthly)"); ?>
                        <div class="controls">
                            <?php echo form_input('salary', '', 'class="form-control" id="salary" required="required"'); ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-sm-12">
                    <div class="form-group">
                        <h3><strong><?php echo $this->lang->line("Bank Details"); ?></strong></h3>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Account Holder Name"); ?>
                        <div class="controls">
                            <?php echo form_input('account_holder', '', 'class="form-control" id="account_holder"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo $this->lang->line("Bank Name"); ?>
                        <div class="controls">
                            <?php echo form_input('bank_name', '', 'class="form-control" id="bank_name"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Account Number"); ?>
                        <div class="controls">
                            <?php echo form_input('account_number', '', 'class="form-control" id="account_number"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("IBAN Number"); ?>
                        <div class="controls">
                            <?php echo form_input('iban_number', '', 'class="form-control" id="iban_number"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <h3><strong><?php  echo $this->lang->line("Finance Information (Yearly)"); ?></strong></h3>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Id Card Renewal Fee"); ?>
                        <div class="controls">
                            <?php echo form_input('id_card_renewal_fee', '', 'class="form-control" id="salary"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Ministry of Labor Fee"); ?>
                        <div class="controls">
                            <?php echo form_input('ministry_of_labor_fee', '', 'class="form-control" id="salary"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Insurance Renewal Fee"); ?>
                        <div class="controls">
                            <?php echo form_input('insurance_renewal_fee', '', 'class="form-control" id="salary"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Vehicle Insurance Fee"); ?>
                        <div class="controls">
                            <?php echo form_input('vehicle_insurance_fee', '', 'class="form-control" id="salary"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php  echo $this->lang->line("Health Insurance Fee"); ?>
                        <div class="controls">
                            <?php echo form_input('health_insurance_fee', '', 'class="form-control" id="salary"'); ?>
                        </div>
                    </div>
                </div>
                
            </div>
			
			
        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_notification', lang('Add Employee'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<?= $modal_js ?>
<script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>
<script type="text/javascript" charset="UTF-8">
    $.fn.datetimepicker.dates['sma'] = <?=$dp_lang?>;
	 $(document).ready(function () {
	if (!localStorage.getItem('Health_Insurance')) {
            $("#Health_Insurance").datetimepicker({
                format: site.dateFormats.js_ldate,
                fontAwesome: true,
                language: 'sma',
                weekStart: 1,
                todayBtn: 1,
                autoclose: 1,
                todayHighlight: 1,
                startView: 2,
                forceParse: 0
            }).datetimepicker('update', new Date());
        }
		if (!localStorage.getItem('id_card_expire')) {
            $("#id_card_expire").datetimepicker({
                format: site.dateFormats.js_ldate,
                fontAwesome: true,
                language: 'sma',
                weekStart: 1,
                todayBtn: 1,
                autoclose: 1,
                todayHighlight: 1,
                startView: 2,
                forceParse: 0
            }).datetimepicker('update', new Date());
        }
		if (!localStorage.getItem('Vehicle_insurance_expire')) {
            $("#Vehicle_insurance_expire").datetimepicker({
                format: site.dateFormats.js_ldate,
                fontAwesome: true,
                language: 'sma',
                weekStart: 1,
                todayBtn: 1,
                autoclose: 1,
                todayHighlight: 1,
                startView: 2,
                forceParse: 0
            }).datetimepicker();
        }
		$('#Vehicle_insurance').change(function(){
			if(this.value=="yes"){
				$('#Vehicle_insurance_expire').show();
			}
			else{
				$('#Vehicle_insurance_expire').hide();
				$('#Vehicle_insurance_expire').val('');
			}
		});
	 });
</script>